/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.editor;

import com.balugaq.jeg.api.objects.annotations.CallTimeSensitive;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.utils.Debug;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.groups.NestedItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.groups.SubItemGroup;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class GroupResorter {
    public static final Map<ItemGroup, Integer> oldTiers = new ConcurrentHashMap<ItemGroup, Integer>();
    public static final Set<Player> selectingPlayers = ConcurrentHashMap.newKeySet();
    public static final Map<Player, ItemGroup> selectedGroup = new ConcurrentHashMap<Player, ItemGroup>();
    public static final Map<ItemGroup, Integer> jegGroupTier = new ConcurrentHashMap<ItemGroup, Integer>();
    public static final File tiersFile = new File(JustEnoughGuide.getInstance().getDataFolder(), "tiers.yml");
    @Nullable
    public static FileConfiguration config = null;

    public static void load() {
        GroupResorter.loadInternal();
    }

    @CallTimeSensitive(value="After Slimefun loaded")
    @ApiStatus.Internal
    private static void loadInternal() {
        JustEnoughGuide.runLater(() -> {
            if (GroupResorter.hasCfg()) {
                int offset = 0;
                ItemGroup lastItemGroup = null;
                for (ItemGroup itemGroup : Slimefun.getRegistry().getAllItemGroups()) {
                    oldTiers.put(itemGroup, itemGroup.getTier());
                    Integer cfg = GroupResorter.getTierCfg(GroupResorter.getKey(itemGroup));
                    if (cfg != null) {
                        GroupResorter.setTier(itemGroup, cfg + offset);
                    } else if (lastItemGroup != null) {
                        GroupResorter.setTier(itemGroup, GroupResorter.getTier(lastItemGroup) + 1);
                        GroupResorter.setNameCfg(GroupResorter.getKey(itemGroup), GroupResorter.getDisplayName(itemGroup));
                        ++offset;
                    } else {
                        GroupResorter.setTier(itemGroup, itemGroup.getTier());
                    }
                    lastItemGroup = itemGroup;
                }
            } else {
                int i = 0;
                for (ItemGroup itemGroup : Slimefun.getRegistry().getAllItemGroups()) {
                    GroupResorter.setTier(itemGroup, i++);
                    GroupResorter.setNameCfg(GroupResorter.getKey(itemGroup), GroupResorter.getDisplayName(itemGroup));
                }
            }
        }, 1L);
    }

    public static boolean isSelecting(@NotNull Player player) {
        return selectingPlayers.contains(player);
    }

    @Nullable
    public static ItemGroup getSelectedGroup(@NotNull Player player) {
        return selectedGroup.get(player);
    }

    public static void setSelectedGroup(@NotNull Player player, @Nullable ItemGroup itemGroup) {
        if (itemGroup == null) {
            selectedGroup.remove(player);
        } else {
            selectedGroup.put(player, itemGroup);
        }
    }

    public static void exitSelecting(@NotNull Player player) {
        selectedGroup.remove(player);
        selectingPlayers.remove(player);
    }

    public static void enterSelecting(@NotNull Player player) {
        selectingPlayers.add(player);
    }

    @NotNull
    public static String getDisplayName(@NotNull ItemGroup itemGroup) {
        return itemGroup.getUnlocalizedName();
    }

    public static int getTier(@NotNull ItemGroup itemGroup) {
        return jegGroupTier.getOrDefault(itemGroup, itemGroup.getTier());
    }

    public static void setTier(ItemGroup itemGroup, @Range(from=-2147483648L, to=0x7FFFFFFFL) int tier) {
        jegGroupTier.put(itemGroup, tier);
        GroupResorter.setTierCfg(GroupResorter.getKey(itemGroup), tier);
    }

    @CallTimeSensitive(value="After Slimefun loaded")
    public static void resort() {
        ArrayList copy = new ArrayList(Slimefun.getRegistry().getAllItemGroups());
        for (ItemGroup itemGroup : copy) {
            itemGroup.setTier(GroupResorter.getTier(itemGroup));
        }
        Slimefun.getRegistry().getAllItemGroups().sort(Comparator.comparingInt(ItemGroup::getTier));
    }

    public static void swap(@NotNull ItemGroup itemGroup1, @NotNull ItemGroup itemGroup2) {
        int tier1 = GroupResorter.getTier(itemGroup1);
        int tier2 = GroupResorter.getTier(itemGroup2);
        itemGroup1.setTier(tier2);
        GroupResorter.setTier(itemGroup2, tier1);
        GroupResorter.setTier(itemGroup1, tier2);
        GroupResorter.resort();
    }

    @NotNull
    public static FileConfiguration getOrCreateConfig() {
        if (config != null) {
            return config;
        }
        if (!tiersFile.exists()) {
            try {
                JustEnoughGuide.getInstance().saveResource("tiers.yml", false);
            }
            catch (Exception e) {
                Debug.trace(e);
            }
        }
        config = YamlConfiguration.loadConfiguration((File)tiersFile);
        return config;
    }

    public static void setTierCfg(@NotNull String key, @Range(from=-2147483648L, to=0x7FFFFFFFL) int tier) {
        GroupResorter.getOrCreateConfig().set(key + ".tier", (Object)tier);
        GroupResorter.saveCfg();
    }

    @Nullable
    public static Integer getTierCfg(@NotNull String key) {
        return (Integer)GroupResorter.getOrCreateConfig().getObject(key + ".tier", Integer.class, null);
    }

    public static void setNameCfg(@NotNull String key, @NotNull String name) {
        GroupResorter.getOrCreateConfig().set(key + ".name", (Object)name);
    }

    @Nullable
    public static String getNameCfg(@NotNull String key) {
        return GroupResorter.getOrCreateConfig().getString(key + ".name");
    }

    @NotNull
    public static String getKey(@NotNull ItemGroup itemGroup) {
        if (itemGroup instanceof NestedItemGroup) {
            NestedItemGroup n = (NestedItemGroup)itemGroup;
            return n.getKey().getNamespace() + "-" + n.getKey().getKey() + ".nested";
        }
        if (itemGroup instanceof SubItemGroup) {
            SubItemGroup s = (SubItemGroup)itemGroup;
            NestedItemGroup n = s.getParent();
            return n.getKey().getNamespace() + "-" + n.getKey().getKey() + ".sub." + s.getKey().getNamespace() + "-" + n.getKey().getKey();
        }
        if (itemGroup.getClass() == ItemGroup.class) {
            return itemGroup.getKey().getNamespace() + "-" + itemGroup.getKey().getKey();
        }
        return itemGroup.getKey().getNamespace() + "-" + itemGroup.getKey().getKey();
    }

    public static boolean hasCfg() {
        return config != null;
    }

    public static void saveCfg() {
        if (config == null) {
            return;
        }
        config.save(tiersFile);
    }

    public static void rollback() {
        for (Map.Entry<ItemGroup, Integer> entry : oldTiers.entrySet()) {
            entry.getKey().setTier(entry.getValue().intValue());
        }
    }

    public static void sort(@NotNull List<ItemGroup> list) {
        list.sort(Comparator.comparingInt(GroupResorter::getTier));
    }
}

