/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.core.commands;

import com.balugaq.jeg.api.groups.SearchGroup;
import com.balugaq.jeg.api.interfaces.JEGCommand;
import com.balugaq.jeg.utils.Lang;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class CacheCommand
implements JEGCommand {
    @NotNull
    private final Plugin plugin;

    public CacheCommand(@NotNull Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public List<String> onTabCompleteRaw(@NotNull CommandSender sender, @NotNull @NotNull String @NotNull [] args) {
        switch (args.length) {
            case 1: {
                return List.of("cache");
            }
            case 2: {
                return List.of("1", "2");
            }
            case 3: {
                switch (args[1]) {
                    case "1": {
                        ArrayList<String> result = new ArrayList<String>(SearchGroup.EN_CACHE.keySet().stream().sorted().map(String::valueOf).toList());
                        result.add("clear");
                        return result;
                    }
                    case "2": {
                        ArrayList<String> result = new ArrayList<String>(SearchGroup.EN_CACHE2.keySet().stream().sorted().map(String::valueOf).toList());
                        result.add("clear");
                        return result;
                    }
                }
                return List.of();
            }
        }
        return List.of();
    }

    @Override
    public boolean canCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        if (sender.isOp() && args.length >= 1) {
            return "cache".equalsIgnoreCase(args[0]);
        }
        return false;
    }

    @Override
    public void onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        this.onCheck(sender, args);
    }

    private void onCheck(@NotNull CommandSender sender, @NotNull @NotNull String @NotNull [] args) {
        Object2ObjectOpenHashMap<String, Reference<Set<SlimefunItem>>> cache;
        if (args.length < 3) {
            sender.sendMessage(Lang.getCommandMessage("cache", "wrong-usage"));
            return;
        }
        String section = args[1];
        String command = args[2];
        switch (section) {
            case "1": {
                cache = SearchGroup.EN_CACHE;
                break;
            }
            case "2": {
                cache = SearchGroup.EN_CACHE2;
                break;
            }
            default: {
                sender.sendMessage(Lang.getCommandMessage("cache", "wrong-cache-section"));
                return;
            }
        }
        if (cache != null) {
            if ("clear".equalsIgnoreCase(command)) {
                cache.clear();
                sender.sendMessage(Lang.getCommandMessage("cache", "cache-cleared", "section", section));
                return;
            }
            String key = command;
            sender.sendMessage(Lang.getCommandMessage("cache", "checking-cache", "section", section, "key", key));
            if (cache.containsKey(key)) {
                Set set;
                Integer size = null;
                Reference ref = (Reference)cache.get(key);
                if (ref != null && (set = (Set)ref.get()) != null) {
                    size = set.size();
                    sender.sendMessage(Lang.getCommandMessage("cache", "items-header"));
                    for (SlimefunItem item : set) {
                        sender.sendMessage(Lang.getCommandMessage("cache", "items-format", "item_name", item.getItemName()));
                    }
                }
                sender.sendMessage(Lang.getCommandMessage("cache", "valid-cache-key", "key", key));
                sender.sendMessage(Lang.getCommandMessage("cache", "cache-size", "size", size));
                if (size != null) {
                    sender.sendMessage(Lang.getCommandMessage("cache", "word-set-size", "size", size));
                }
            } else {
                sender.sendMessage(Lang.getCommandMessage("cache", "invalid-cache-key", "key", key));
            }
        } else {
            sender.sendMessage(Lang.getCommandMessage("cache", "wrong-cache-section"));
        }
    }

    @NotNull
    @Generated
    public Plugin getPlugin() {
        return this.plugin;
    }
}

