/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.objects.enums;

import com.balugaq.jeg.api.groups.SearchGroup;
import com.balugaq.jeg.utils.Debug;
import com.balugaq.jeg.utils.LocalHelper;
import com.balugaq.jeg.utils.SpecialMenuProvider;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import java.lang.ref.Reference;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public enum FilterType {
    BY_RECIPE_ITEM_NAME("#", (player, item, lowerFilterValue, pinyin) -> {
        ItemStack[] recipe = item.getRecipe();
        if (recipe == null) {
            return false;
        }
        for (ItemStack itemStack : recipe) {
            if (!SearchGroup.isSearchFilterApplicable(player, itemStack, lowerFilterValue, false)) continue;
            return true;
        }
        return false;
    }),
    BY_RECIPE_TYPE_NAME("$", (player, item, lowerFilterValue, pinyin) -> {
        ItemStack recipeTypeIcon = item.getRecipeType().getItem(player);
        if (recipeTypeIcon == null) {
            return false;
        }
        return SearchGroup.isSearchFilterApplicable(player, recipeTypeIcon, lowerFilterValue, false);
    }),
    BY_DISPLAY_ITEM_NAME("%", (player, item, lowerFilterValue, pinyin) -> {
        Set cache;
        String id;
        Reference ref;
        List display = null;
        if (item instanceof AContainer) {
            AContainer ac = (AContainer)item;
            try {
                display = ac.getDisplayRecipes();
            }
            catch (Exception exception) {}
        } else if (item instanceof MultiBlockMachine) {
            MultiBlockMachine mb = (MultiBlockMachine)item;
            try {
                display = mb.getDisplayRecipes();
            }
            catch (Exception exception) {}
        } else {
            try {
                if (SpecialMenuProvider.ENABLED_LogiTech && SpecialMenuProvider.classLogiTech_CustomSlimefunItem != null && SpecialMenuProvider.classLogiTech_CustomSlimefunItem.isInstance(item) && item instanceof RecipeDisplayItem) {
                    RecipeDisplayItem rdi = (RecipeDisplayItem)item;
                    display = rdi.getDisplayRecipes();
                }
            }
            catch (Exception e) {
                Debug.trace(e, "searching");
                return false;
            }
        }
        if (display != null) {
            try {
                for (ItemStack itemStack : display) {
                    if (!SearchGroup.isSearchFilterApplicable(player, itemStack, lowerFilterValue, false)) continue;
                    return true;
                }
            }
            catch (Exception ignored) {
                return false;
            }
        }
        if ((ref = (Reference)SearchGroup.SPECIAL_CACHE.get((Object)(id = item.getId()))) != null && (cache = (Set)ref.get()) != null) {
            for (String s : cache) {
                if (!SearchGroup.isSearchFilterApplicable(s, lowerFilterValue, false)) continue;
                return true;
            }
        }
        return false;
    }),
    BY_ADDON_NAME("@", (player, item, lowerFilterValue, pinyin) -> {
        SlimefunAddon addon = item.getAddon();
        String localAddonName = LocalHelper.getAddonName(addon, item.getId()).toLowerCase();
        String originModName = (addon == null ? "Slimefun" : addon.getName()).toLowerCase();
        if (localAddonName.contains((CharSequence)lowerFilterValue) || originModName.contains((CharSequence)lowerFilterValue)) {
            return true;
        }
        return false;
    }),
    BY_ITEM_NAME("!", SearchGroup::isSearchFilterApplicable),
    BY_ITEM_LORE("^", (player, item, lowerFilterValue, pinyin) -> {
        ItemMeta meta = item.getItem().getItemMeta();
        if (meta == null) {
            return false;
        }
        List s = meta.getLore();
        if (s == null) {
            return false;
        }
        for (String lore : s) {
            if (!SearchGroup.isSearchFilterApplicable(lore, lowerFilterValue, pinyin)) continue;
            return true;
        }
        return false;
    }),
    BY_MATERIAL_NAME("~", (player, item, lowerFilterValue, pinyin) -> item.getItem().getType().name().toLowerCase().contains((CharSequence)lowerFilterValue));

    @NotNull
    private final String symbol;
    @NotNull
    private final DiFunction<Player, SlimefunItem, String, Boolean, Boolean> filter;

    private FilterType(String symbol, DiFunction<Player, SlimefunItem, String, Boolean, Boolean> filter) {
        this.symbol = symbol;
        this.filter = filter;
    }

    @Deprecated
    @NotNull
    public String getFlag() {
        return this.symbol;
    }

    @NotNull
    @Generated
    public String getSymbol() {
        return this.symbol;
    }

    @NotNull
    @Generated
    public DiFunction<Player, SlimefunItem, String, Boolean, Boolean> getFilter() {
        return this.filter;
    }

    public static interface DiFunction<A, B, C, D, R> {
        public R apply(A var1, B var2, C var3, D var4);
    }
}

