/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.clickhandler;

import com.balugaq.jeg.api.clickhandler.GuideClickHandler;
import com.balugaq.jeg.api.clickhandler.Processor;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public interface JEGClickHandler
extends ChestMenu.AdvancedMenuClickHandler,
GuideClickHandler {
    @ParametersAreNonnullByDefault
    @NotNull
    public static JEGClickHandler of(final SlimefunGuideImplementation guide, final ChestMenu menu, @Range(from=0L, to=53L) int slot) {
        final ChestMenu.MenuClickHandler current = menu.getMenuClickHandler(slot);
        if (current instanceof JEGClickHandler) {
            JEGClickHandler ech = (JEGClickHandler)current;
            return ech;
        }
        return new JEGClickHandler(){
            private final Map<Class<? extends Processor>, Processor> processors = new HashMap<Class<? extends Processor>, Processor>();

            @Override
            @NotNull
            public ChestMenu.MenuClickHandler getOrigin() {
                return Optional.ofNullable(current).orElse(ChestMenuUtils.getEmptyClickHandler());
            }

            @Override
            @NotNull
            public SlimefunGuideImplementation getGuide() {
                return guide;
            }

            @Override
            @NotNull
            public ChestMenu getMenu() {
                return menu;
            }

            @Override
            @NotNull
            public Map<Class<? extends Processor>, Processor> getProcessors() {
                return this.processors;
            }
        };
    }

    @NotNull
    default public ChestMenu.MenuClickHandler getOrigin() {
        return ChestMenuUtils.getEmptyClickHandler();
    }

    @NotNull
    public SlimefunGuideImplementation getGuide();

    @NotNull
    public ChestMenu getMenu();

    @NotNull
    public Map<Class<? extends Processor>, Processor> getProcessors();

    @NotNull
    default public JEGClickHandler addProcessor(@NotNull Processor processor) {
        this.getProcessors().put(processor.getClass(), processor);
        return this;
    }

    @NotNull
    default public Collection<Processor> getProcessor(@NotNull Processor.Strategy strategy) {
        return this.getProcessors().values().stream().filter(processor -> processor.getStrategy() == strategy).toList();
    }

    default public boolean onClick(@NotNull InventoryClickEvent event, @NotNull Player player, @Range(from=0L, to=53L) int clickedSlot, ItemStack cursor, @NotNull ClickAction clickAction) {
        ItemStack itemStack = this.getMenu().getItemInSlot(clickedSlot);
        for (Processor processor : this.getProcessor(Processor.Strategy.HEAD)) {
            if (processor.process(this.getGuide(), this.getMenu(), event, player, clickedSlot, itemStack, clickAction, null)) continue;
            return false;
        }
        ChestMenu.MenuClickHandler origin = this.getOrigin();
        if (origin instanceof ChestMenu.AdvancedMenuClickHandler) {
            ChestMenu.AdvancedMenuClickHandler amch = (ChestMenu.AdvancedMenuClickHandler)origin;
            return amch.onClick(event, player, clickedSlot, itemStack, clickAction);
        }
        boolean result = origin.onClick(player, clickedSlot, itemStack, clickAction);
        for (Processor processor : this.getProcessor(Processor.Strategy.TAIL)) {
            if (processor.process(this.getGuide(), this.getMenu(), event, player, clickedSlot, itemStack, clickAction, result)) continue;
            return false;
        }
        return result;
    }

    default public boolean onClick(Player player, @Range(from=0L, to=53L) int clickedSlot, ItemStack itemStack, ClickAction clickAction) {
        return this.getOrigin().onClick(player, clickedSlot, itemStack, clickAction);
    }
}

