/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.implementation.items;

import com.balugaq.jeg.api.groups.ClassicGuideGroup;
import com.balugaq.jeg.api.interfaces.JEGSlimefunGuideImplementation;
import com.balugaq.jeg.api.interfaces.NotDisplayInCheatMode;
import com.balugaq.jeg.api.objects.enums.FilterType;
import com.balugaq.jeg.api.objects.exceptions.ArgumentMissingException;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.implementation.option.BeginnersGuideOption;
import com.balugaq.jeg.utils.Debug;
import com.balugaq.jeg.utils.GuideUtil;
import com.balugaq.jeg.utils.Lang;
import com.balugaq.jeg.utils.SlimefunOfficialSupporter;
import com.balugaq.jeg.utils.formatter.Formats;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@NotDisplayInCheatMode
public class JEGGuideGroup
extends ClassicGuideGroup {
    public static final int[] GUIDE_SLOTS = Formats.helper.getChars('h').stream().mapToInt(i -> i).toArray();
    public static final int[] BORDER_SLOTS = Formats.helper.getChars('B').stream().mapToInt(i -> i).toArray();
    private static final ItemStack HEADER = Lang.getGuideGroupIcon("header", Material.BEACON);

    protected JEGGuideGroup(@NotNull NamespacedKey key, @NotNull ItemStack icon) {
        super(key, icon, Integer.MAX_VALUE);
        for (int slot : BORDER_SLOTS) {
            this.addGuide(slot, ChestMenuUtils.getBackground());
        }
        boolean loaded = false;
        for (int s2 : Formats.helper.getChars('A')) {
            this.addGuide(s2, HEADER);
            loaded = true;
        }
        if (!loaded) {
            throw new ArgumentMissingException("You're not supposed to remove symbol 'A'... Which means Author Information. format=" + String.valueOf(Formats.helper));
        }
        AtomicInteger index = new AtomicInteger(0);
        this.addGuide(GUIDE_SLOTS[index.getAndIncrement()], Lang.getGuideGroupIcon("feature-search-paging", Material.NAME_TAG), (p, s, i, a) -> {
            try {
                p.performCommand("sf search a");
            }
            catch (Exception e) {
                p.sendMessage("\u00a7cAn error occurred when clicked in JEGGuideGroup");
                Debug.trace(e);
            }
            return false;
        });
        JEGGuideGroup.doIf(JustEnoughGuide.getConfigManager().isBookmark(), () -> this.addGuide(GUIDE_SLOTS[index.getAndIncrement()], Lang.getGuideGroupIcon("feature-bookmark-item", Material.BOOK), (p, s, i, a) -> {
            try {
                SlimefunGuideImplementation guide;
                if (Slimefun.instance() == null) {
                    p.sendMessage("\u00a7cSlimefun disabled. (impossible!)");
                }
                if ((guide = GuideUtil.getGuide(p, SlimefunGuideMode.SURVIVAL_MODE)) == null) {
                    p.sendMessage("\u00a7cNo SlimefunGuideImplementation found! (impossible!)");
                    return false;
                }
                if (!(guide instanceof JEGSlimefunGuideImplementation)) {
                    p.sendMessage("\u00a7cFeature disabled.");
                    return false;
                }
                JEGSlimefunGuideImplementation jegGuide = (JEGSlimefunGuideImplementation)guide;
                PlayerProfile profile = PlayerProfile.find((OfflinePlayer)p).orElse(null);
                if (profile == null) {
                    p.sendMessage("\u00a7cNo PlayerProfile found!");
                    return false;
                }
                for (ItemGroup itemGroup : Slimefun.getRegistry().getAllItemGroups()) {
                    if (!itemGroup.getKey().equals((Object)new NamespacedKey((Plugin)Slimefun.instance(), "basic_machines"))) continue;
                    jegGuide.openItemMarkGroup(itemGroup, p, profile);
                    return false;
                }
            }
            catch (Throwable e) {
                p.sendMessage("\u00a7cAn error occured when clicked in JEGGuideGroup");
                Debug.trace(e);
            }
            return false;
        }));
        JEGGuideGroup.doIf(JustEnoughGuide.getConfigManager().isBookmark(), () -> this.addGuide(GUIDE_SLOTS[index.getAndIncrement()], Lang.getGuideGroupIcon("feature-view-bookmarked-items", Material.NETHER_STAR), (p, s, i, a) -> {
            try {
                SlimefunGuideImplementation guide;
                if (Slimefun.instance() == null) {
                    p.sendMessage("\u00a7cSlimefun disabled. (impossible!)");
                }
                if ((guide = GuideUtil.getGuide(p, SlimefunGuideMode.SURVIVAL_MODE)) == null) {
                    p.sendMessage("\u00a7cNo SlimefunGuideImplementation found! (impossible!)");
                    return false;
                }
                if (!(guide instanceof JEGSlimefunGuideImplementation)) {
                    p.sendMessage("\u00a7cFeature disabled.");
                    return false;
                }
                JEGSlimefunGuideImplementation jegGuide = (JEGSlimefunGuideImplementation)guide;
                PlayerProfile profile = PlayerProfile.find((OfflinePlayer)p).orElse(null);
                if (profile == null) {
                    p.sendMessage("\u00a7cNo PlayerProfile found!");
                    return false;
                }
                jegGuide.openBookMarkGroup(p, profile);
            }
            catch (Throwable e) {
                p.sendMessage("\u00a7cAn error occured when clicked in JEGGuideGroup");
                Debug.trace(e);
            }
            return false;
        }));
        this.addGuide(GUIDE_SLOTS[index.getAndIncrement()], Lang.getGuideGroupIcon("feature-jump-category", Material.CRAFTING_TABLE), (p, s, i, a) -> {
            try {
                if (Slimefun.instance() == null) {
                    p.sendMessage("\u00a7cSlimefun disabled. (impossible!)");
                    return false;
                }
                SlimefunGuideImplementation guide = GuideUtil.getGuide(p, SlimefunGuideMode.SURVIVAL_MODE);
                if (guide == null) {
                    p.sendMessage("\u00a7cNo SlimefunGuideImplementation found! (impossible!)");
                    return false;
                }
                PlayerProfile profile = PlayerProfile.find((OfflinePlayer)p).orElse(null);
                if (profile == null) {
                    p.sendMessage("\u00a7cNo PlayerProfile found!");
                    return false;
                }
                SlimefunItem exampleItem = SlimefunItems.ELECTRIC_DUST_WASHER_3.getItem();
                if (exampleItem == null) {
                    p.sendMessage("\u00a7cExample item not found! (weird)");
                    return false;
                }
                if (exampleItem.isDisabledIn(p.getWorld())) {
                    p.sendMessage("\u00a7cThe example item has been disabled, unable to display.");
                    return false;
                }
                guide.displayItem(profile, exampleItem, true);
            }
            catch (Exception e) {
                p.sendMessage("\u00a7cAn error occured when clicked in JEGGuideGroup");
                Debug.trace(e);
            }
            return false;
        });
        this.addGuide(GUIDE_SLOTS[index.getAndIncrement()], Lang.getGuideGroupIcon("feature-quick-search", Material.NAME_TAG), (p, s, i, a) -> {
            try {
                if (Slimefun.instance() == null) {
                    p.sendMessage("\u00a7cSlimefun disabled. (impossible!)");
                    return false;
                }
                SlimefunGuideImplementation guide = GuideUtil.getGuide(p, SlimefunGuideMode.SURVIVAL_MODE);
                if (!(guide instanceof JEGSlimefunGuideImplementation)) {
                    p.sendMessage("\u00a7cFeature disabled.");
                    return false;
                }
                JEGSlimefunGuideImplementation jegGuide = (JEGSlimefunGuideImplementation)guide;
                PlayerProfile profile = PlayerProfile.find((OfflinePlayer)p).orElse(null);
                if (profile == null) {
                    p.sendMessage("\u00a7cNo PlayerProfile found!");
                    return false;
                }
                if (!BeginnersGuideOption.isEnabled(p)) {
                    p.sendMessage("\u00a7cYou should enable Beginners Guide in guide settings!");
                    return false;
                }
                SlimefunItem exampleItem = SlimefunItems.ELECTRIC_DUST_WASHER_3.getItem();
                if (exampleItem == null) {
                    p.sendMessage("\u00a7cExample item not found! (weird)");
                    return false;
                }
                if (exampleItem.isDisabledIn(p.getWorld())) {
                    p.sendMessage("\u00a7cThe example item has been disabled, unable to display.");
                    return false;
                }
                jegGuide.displayItem(profile, exampleItem, true);
            }
            catch (Exception e) {
                p.sendMessage("\u00a7cAn error occured when clicked in JEGGuideGroup");
                Debug.trace(e);
            }
            return false;
        });
        JEGGuideGroup.doIf(SlimefunOfficialSupporter.isEnableResearching(), () -> this.addGuide(GUIDE_SLOTS[index.getAndIncrement()], Lang.getGuideGroupIcon("feature-quick-research", Material.ENCHANTED_BOOK), (p, s, i, a) -> {
            try {
                if (Slimefun.instance() == null) {
                    p.sendMessage("\u00a7cSlimefun disabled. (impossible!)");
                    return false;
                }
                SlimefunGuideImplementation guide = GuideUtil.getGuide(p, SlimefunGuideMode.SURVIVAL_MODE);
                if (guide == null) {
                    p.sendMessage("\u00a7cNo SlimefunGuideImplementation found! (impossible!)");
                    return false;
                }
                if (!(guide instanceof JEGSlimefunGuideImplementation)) {
                    p.sendMessage("\u00a7cFeature disabled.");
                    return false;
                }
                JEGSlimefunGuideImplementation jegGuide = (JEGSlimefunGuideImplementation)guide;
                PlayerProfile profile = PlayerProfile.find((OfflinePlayer)p).orElse(null);
                if (profile == null) {
                    p.sendMessage("\u00a7cNo PlayerProfile found!");
                    return false;
                }
                SlimefunItem exampleItem = SlimefunItems.ELECTRIC_DUST_WASHER_3.getItem();
                if (exampleItem == null) {
                    p.sendMessage("\u00a7cExample item not found! (weird)");
                    return false;
                }
                if (exampleItem.isDisabledIn(p.getWorld())) {
                    p.sendMessage("\u00a7cThe example item has been disabled, unable to display.");
                    return false;
                }
                guide.displayItem(profile, exampleItem, true);
            }
            catch (Exception e) {
                p.sendMessage("\u00a7cAn error occured when clicked in JEGGuideGroup");
                Debug.trace(e);
            }
            return false;
        }));
        this.addGuide(GUIDE_SLOTS[index.getAndIncrement()], Lang.getGuideGroupIcon("feature-smart-search", Material.COMPARATOR), (p, s, i, a) -> {
            try {
                p.performCommand("sf search sulfate");
            }
            catch (Exception e) {
                p.sendMessage("\u00a7cAn error occured when clicked in JEGGuideGroup");
                Debug.trace(e);
            }
            return false;
        });
        String flag_recipe_item_name = FilterType.BY_RECIPE_ITEM_NAME.getSymbol();
        this.addGuide(GUIDE_SLOTS[index.getAndIncrement()], Lang.getGuideGroupIcon("feature-search-expansion-by-recipe-item-name", Material.LODESTONE, "flag", flag_recipe_item_name), (p, s, i, a) -> {
            try {
                p.performCommand("sf search " + flag_recipe_item_name + "battery");
            }
            catch (Exception e) {
                p.sendMessage("\u00a7cAn error occured when clicked in JEGGuideGroup");
                Debug.trace(e);
            }
            return false;
        });
        String flag_recipe_type_name = FilterType.BY_RECIPE_TYPE_NAME.getSymbol();
        this.addGuide(GUIDE_SLOTS[index.getAndIncrement()], Lang.getGuideGroupIcon("feature-search-expansion-by-recipe-type-name", Material.LODESTONE, "flag", flag_recipe_type_name), (p, s, i, a) -> {
            try {
                p.performCommand("sf search " + flag_recipe_type_name + "crafting table");
            }
            catch (Exception e) {
                p.sendMessage("\u00a7cAn error occured when clicked in JEGGuideGroup");
                Debug.trace(e);
            }
            return false;
        });
        String flag_display_item_name = FilterType.BY_DISPLAY_ITEM_NAME.getSymbol();
        this.addGuide(GUIDE_SLOTS[index.getAndIncrement()], Lang.getGuideGroupIcon("feature-search-expansion-by-display-item-name", Material.LODESTONE, "flag", flag_display_item_name), (p, s, i, a) -> {
            try {
                p.performCommand("sf search " + flag_display_item_name + "copper.dust");
            }
            catch (Exception e) {
                p.sendMessage("\u00a7cAn error occured when clicked in JEGGuideGroup");
                Debug.trace(e);
            }
            return false;
        });
        String flag_addon_name = FilterType.BY_ADDON_NAME.getSymbol();
        this.addGuide(GUIDE_SLOTS[index.getAndIncrement()], Lang.getGuideGroupIcon("feature-search-expansion-by-addon-name", Material.LODESTONE, "flag", flag_addon_name), (p, s, i, a) -> {
            try {
                p.performCommand("sf search " + flag_addon_name + "Slimefun");
            }
            catch (Throwable e) {
                p.sendMessage("\u00a7cAn error occured when clicked in JEGGuideGroup");
                Debug.trace(e);
            }
            return false;
        });
        String flag_item_name = FilterType.BY_ITEM_NAME.getSymbol();
        this.addGuide(GUIDE_SLOTS[index.getAndIncrement()], Lang.getGuideGroupIcon("feature-search-expansion-by-item-name", Material.LODESTONE, "flag", flag_item_name), (p, s, i, a) -> {
            try {
                p.performCommand("sf search " + flag_item_name + "Battery");
            }
            catch (Exception e) {
                p.sendMessage("\u00a7cAn error occured when clicked in JEGGuideGroup");
                Debug.trace(e);
            }
            return false;
        });
        String flag_item_lore = FilterType.BY_ITEM_LORE.getSymbol();
        this.addGuide(GUIDE_SLOTS[index.getAndIncrement()], Lang.getGuideGroupIcon("feature-search-expansion-by-item-lore", Material.LODESTONE, "flag", flag_item_lore), (p, s, i, a) -> {
            try {
                p.performCommand("sf search " + flag_item_lore + "carrot");
            }
            catch (Exception e) {
                p.sendMessage("\u00a7cAn error occured when clicked in JEGGuideGroup");
                Debug.trace(e);
            }
            return false;
        });
        String flag_material_name = FilterType.BY_MATERIAL_NAME.getSymbol();
        this.addGuide(GUIDE_SLOTS[index.getAndIncrement()], Lang.getGuideGroupIcon("feature-search-expansion-by-material-name", Material.LODESTONE, "flag", flag_material_name), (p, s, i, a) -> {
            try {
                p.performCommand("sf search " + flag_material_name + "iron");
            }
            catch (Exception e) {
                p.sendMessage("\u00a7cAn error occured when clicked in JEGGuideGroup");
                Debug.trace(e);
            }
            return false;
        });
        this.addGuide(GUIDE_SLOTS[index.getAndIncrement()], Lang.getGuideGroupIcon("feature-name-printing", Material.STONE_PICKAXE), (p, s, i, a) -> {
            try {
                if (Slimefun.instance() == null) {
                    p.sendMessage("\u00a7cSlimefun disabled. (impossible!)");
                    return false;
                }
                SlimefunGuideImplementation guide = GuideUtil.getGuide(p, SlimefunGuideMode.SURVIVAL_MODE);
                if (!(guide instanceof JEGSlimefunGuideImplementation)) {
                    p.sendMessage("\u00a7cFeature disabled.");
                    return false;
                }
                JEGSlimefunGuideImplementation jegGuide = (JEGSlimefunGuideImplementation)guide;
                PlayerProfile profile = PlayerProfile.find((OfflinePlayer)p).orElse(null);
                if (profile == null) {
                    p.sendMessage("\u00a7cNo PlayerProfile found!");
                    return false;
                }
                if (!BeginnersGuideOption.isEnabled(p)) {
                    p.sendMessage("\u00a7cYou have to enable BeginnersGuideOption in Guide Settings to use this feature!");
                    return false;
                }
                SlimefunItem exampleItem = SlimefunItems.ELECTRIC_DUST_WASHER_3.getItem();
                if (exampleItem == null) {
                    p.sendMessage("\u00a7cExample item not found! (weird)");
                    return false;
                }
                if (exampleItem.isDisabledIn(p.getWorld())) {
                    p.sendMessage("\u00a7cThe example item has been disabled, unable to display.");
                    return false;
                }
                guide.displayItem(profile, exampleItem, true);
            }
            catch (Exception e) {
                p.sendMessage("\u00a7cAn error occured when clicked in JEGGuideGroup");
                Debug.trace(e);
            }
            return false;
        });
        Formats.helper.renderCustom(this);
    }

    public static void doIf(boolean expression, @NotNull Runnable runnable) {
        if (expression) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                Debug.trace(e, "loading guide group");
            }
        }
    }
}

