/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.objects.collection.cooldown;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public class CooldownPool<Key> {
    private final Map<Key, Long> pool = new ConcurrentHashMap<Key, Long>();
    private final long cooldownMillis;

    public CooldownPool(long cooldownMillis) {
        this.cooldownMillis = cooldownMillis;
    }

    public boolean checkCooldown(Key key) {
        Long lastTime = this.pool.get(key);
        if (lastTime == null) {
            this.pool.put(key, System.currentTimeMillis());
            return true;
        }
        long now = System.currentTimeMillis();
        if (now - lastTime >= this.cooldownMillis) {
            this.pool.put(key, now);
            return true;
        }
        return false;
    }

    @Generated
    public Map<Key, Long> getPool() {
        return this.pool;
    }

    @Generated
    public long getCooldownMillis() {
        return this.cooldownMillis;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CooldownPool)) {
            return false;
        }
        CooldownPool other = (CooldownPool)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCooldownMillis() != other.getCooldownMillis()) {
            return false;
        }
        Map<Key, Long> this$pool = this.getPool();
        Map<Key, Long> other$pool = other.getPool();
        return !(this$pool == null ? other$pool != null : !((Object)this$pool).equals(other$pool));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CooldownPool;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $cooldownMillis = this.getCooldownMillis();
        result = result * 59 + (int)($cooldownMillis >>> 32 ^ $cooldownMillis);
        Map<Key, Long> $pool = this.getPool();
        result = result * 59 + ($pool == null ? 43 : ((Object)$pool).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CooldownPool(pool=" + String.valueOf(this.getPool()) + ", cooldownMillis=" + this.getCooldownMillis() + ")";
    }
}

