/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.implementation;

import com.balugaq.jeg.api.CustomGroupConfigurations;
import com.balugaq.jeg.api.cost.CERCalculator;
import com.balugaq.jeg.api.editor.GroupResorter;
import com.balugaq.jeg.api.groups.SearchGroup;
import com.balugaq.jeg.api.groups.VanillaItemsGroup;
import com.balugaq.jeg.api.interfaces.JEGSlimefunGuideImplementation;
import com.balugaq.jeg.api.patches.JEGGuideSettings;
import com.balugaq.jeg.api.recipe_complete.source.base.RecipeCompleteProvider;
import com.balugaq.jeg.core.integrations.finaltechs.finalTECHCommon.FinalTECHValueDisplayOption;
import com.balugaq.jeg.core.managers.BookmarkManager;
import com.balugaq.jeg.core.managers.CommandManager;
import com.balugaq.jeg.core.managers.ConfigManager;
import com.balugaq.jeg.core.managers.IntegrationManager;
import com.balugaq.jeg.core.managers.ListenerManager;
import com.balugaq.jeg.core.managers.RTSBackpackManager;
import com.balugaq.jeg.core.services.LocalizationService;
import com.balugaq.jeg.implementation.ThirdPartyWarnings;
import com.balugaq.jeg.implementation.guide.CheatGuideImplementation;
import com.balugaq.jeg.implementation.guide.SurvivalGuideImplementation;
import com.balugaq.jeg.implementation.items.GroupSetup;
import com.balugaq.jeg.implementation.items.ItemsSetup;
import com.balugaq.jeg.implementation.option.BeginnersGuideOption;
import com.balugaq.jeg.implementation.option.CerPatchGuideOption;
import com.balugaq.jeg.implementation.option.NoticeMissingMaterialGuideOption;
import com.balugaq.jeg.implementation.option.RecursiveRecipeFillingGuideOption;
import com.balugaq.jeg.implementation.option.ShareInGuideOption;
import com.balugaq.jeg.implementation.option.ShareOutGuideOption;
import com.balugaq.jeg.utils.Debug;
import com.balugaq.jeg.utils.GuideUtil;
import com.balugaq.jeg.utils.Lang;
import com.balugaq.jeg.utils.MinecraftVersion;
import com.balugaq.jeg.utils.ReflectionUtil;
import com.balugaq.jeg.utils.SlimefunOfficialSupporter;
import com.balugaq.jeg.utils.SlimefunRegistryUtil;
import com.balugaq.jeg.utils.SpecialMenuProvider;
import com.balugaq.jeg.utils.UUIDUtils;
import com.balugaq.jeg.utils.platform.PlatformUtil;
import com.balugaq.jeg.utils.platform.scheduler.TaskScheduler;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.core.guide.options.SlimefunGuideOption;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.guide.CheatSheetSlimefunGuide;
import io.github.thebusybiscuit.slimefun4.implementation.guide.SurvivalSlimefunGuide;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.BlobBuildUpdater;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JustEnoughGuide
extends JavaPlugin
implements SlimefunAddon {
    public static final int RECOMMENDED_JAVA_VERSION = 17;
    public static final MinecraftVersion RECOMMENDED_MC_VERSION = MinecraftVersion.MINECRAFT_1_16;
    private static JustEnoughGuide instance = null;
    private static UUID serverUUID = null;
    @NotNull
    private final String username;
    @NotNull
    private final String repo;
    @NotNull
    private final String branch;
    private BookmarkManager bookmarkManager = null;
    private CommandManager commandManager = null;
    private ConfigManager configManager = null;
    private IntegrationManager integrationManager = null;
    private ListenerManager listenerManager = null;
    private RTSBackpackManager rtsBackpackManager = null;
    private LocalizationService localizationService;
    private MinecraftVersion minecraftVersion = null;
    private TaskScheduler scheduler;
    private int javaVersion = 0;

    public JustEnoughGuide() {
        this.username = "balugaq";
        this.repo = "JustEnoughGuide";
        this.branch = "en-master";
    }

    public static BookmarkManager getBookmarkManager() {
        return JustEnoughGuide.getInstance().bookmarkManager;
    }

    public static CommandManager getCommandManager() {
        return JustEnoughGuide.getInstance().commandManager;
    }

    public static ConfigManager getConfigManager() {
        return JustEnoughGuide.getInstance().configManager;
    }

    public static IntegrationManager getIntegrationManager() {
        return JustEnoughGuide.getInstance().integrationManager;
    }

    public static ListenerManager getListenerManager() {
        return JustEnoughGuide.getInstance().listenerManager;
    }

    @Deprecated
    public static MinecraftVersion getMCVersion() {
        return JustEnoughGuide.getInstance().minecraftVersion;
    }

    public static MinecraftVersion getMinecraftVersion() {
        return JustEnoughGuide.getInstance().minecraftVersion;
    }

    public static TaskScheduler getScheduler() {
        return JustEnoughGuide.getInstance().scheduler;
    }

    @NotNull
    public static JustEnoughGuide getInstance() {
        return instance;
    }

    @Deprecated
    public static void vanillaItemsGroupDisplayableFor(@NotNull Player player, boolean displayable) {
        VanillaItemsGroup.displayableFor(player, displayable);
    }

    @Deprecated
    public static boolean vanillaItemsGroupIsDisplayableFor(@NotNull Player player) {
        return VanillaItemsGroup.isDisplayableFor(player);
    }

    public static void postServerStartup(@NotNull Runnable runnable) {
        JustEnoughGuide.runNextTick(runnable);
    }

    public static void postServerStartupAsynchronously(Runnable runnable) {
        JustEnoughGuide.runLaterAsync(runnable, 1L);
    }

    public static boolean disableAutomaticallyLoadItems() {
        boolean before = Slimefun.getRegistry().isAutoLoadingEnabled();
        Slimefun.getRegistry().setAutoLoadingMode(false);
        return before;
    }

    public static void setAutomaticallyLoadItems(boolean value) {
        Slimefun.getRegistry().setAutoLoadingMode(value);
    }

    public static void runNextTick(@NotNull Runnable runnable) {
        JustEnoughGuide.getScheduler().runNextTick(runnable);
    }

    public static void runLater(@NotNull Runnable runnable, long delay) {
        JustEnoughGuide.getScheduler().runLater(runnable, delay);
    }

    public static void runLaterAsync(@NotNull Runnable runnable, long delay) {
        JustEnoughGuide.getScheduler().runLaterAsync(runnable, delay);
    }

    public static void runTimer(@NotNull Runnable runnable, long delay, long period) {
        JustEnoughGuide.getScheduler().runTimer(runnable, delay, period);
    }

    public static void runTimerAsync(@NotNull Runnable runnable, long delay, long period) {
        JustEnoughGuide.getScheduler().runTimerAsync(runnable, delay, period);
    }

    public void onEnable() {
        instance = this;
        this.getLogger().info("Loading configuration...");
        this.saveDefaultConfig();
        this.configManager = new ConfigManager(this);
        this.configManager.load();
        this.getLogger().info("Loading localization...");
        this.localizationService = new LocalizationService(this);
        String language = JustEnoughGuide.getConfigManager().getLanguage();
        this.localizationService.addLanguage(language);
        this.localizationService.addLanguage("en-US");
        boolean isCompatible = this.environmentCheck();
        if (!isCompatible) {
            this.getLogger().severe(Lang.getStartup("environment-check-failed"));
            this.onDisable();
            return;
        }
        PlatformUtil.initialize();
        this.scheduler = TaskScheduler.create();
        this.getLogger().info(Lang.getStartup("integrating-other-plugins"));
        this.integrationManager = new IntegrationManager(this);
        this.integrationManager.load();
        this.getLogger().info(Lang.getStartup("register-listeners"));
        this.listenerManager = new ListenerManager(this);
        this.listenerManager.load();
        if (JustEnoughGuide.getConfigManager().isAutoUpdate() && this.getDescription().getVersion().startsWith("DEV - ")) {
            new BlobBuildUpdater((Plugin)this, this.getFile(), "JustEnoughGuide", "Dev").start();
        }
        this.getLogger().info(Lang.getStartup("register-commands"));
        this.commandManager = new CommandManager(this);
        this.commandManager.load();
        if (!this.commandManager.registerCommands()) {
            this.getLogger().warning(Lang.getStartup("register-commands-failed"));
        }
        boolean survivalOverride = JustEnoughGuide.getConfigManager().isSurvivalImprovement();
        boolean cheatOverride = JustEnoughGuide.getConfigManager().isCheatImprovement();
        if (survivalOverride || cheatOverride) {
            this.getLogger().info(Lang.getStartup("enabled-guide-override"));
            this.getLogger().info(Lang.getStartup("override-guide"));
            EnumMap<SlimefunGuideMode, JEGSlimefunGuideImplementation> newGuides = new EnumMap<SlimefunGuideMode, JEGSlimefunGuideImplementation>(SlimefunGuideMode.class);
            newGuides.put(SlimefunGuideMode.SURVIVAL_MODE, survivalOverride ? new SurvivalGuideImplementation() : new SurvivalSlimefunGuide(SlimefunOfficialSupporter.isShowVanillaRecipes(), SlimefunOfficialSupporter.isShowHiddenItemGroups()));
            newGuides.put(SlimefunGuideMode.CHEAT_MODE, cheatOverride ? new CheatGuideImplementation() : new CheatSheetSlimefunGuide());
            try {
                ReflectionUtil.setValue(Slimefun.getRegistry(), "guides", newGuides);
            }
            catch (Exception e) {
                Debug.trace(e);
            }
            this.getLogger().info(survivalOverride ? Lang.getStartup("replaced-survival-guide") : Lang.getStartup("not-replaced-survival-guide"));
            this.getLogger().info(cheatOverride ? Lang.getStartup("replaced-cheat-guide") : Lang.getStartup("not-replaced-cheat-guide"));
            this.getLogger().info(Lang.getStartup("loading-bookmark"));
            this.bookmarkManager = new BookmarkManager((Plugin)this);
            this.bookmarkManager.load();
            this.getLogger().info(Lang.getStartup("loading-guide-group"));
            GroupSetup.setup();
            if (survivalOverride) {
                JustEnoughGuide.runLaterAsync(CustomGroupConfigurations::load, 1L);
            }
            this.getLogger().info(Lang.getStartup("loaded-guide-group"));
            if (JustEnoughGuide.getConfigManager().isBeginnerOption()) {
                this.getLogger().info(Lang.getStartup("loading-guide-option"));
                JEGGuideSettings.patchSlimefun();
                JEGGuideSettings.addOption(BeginnersGuideOption.instance());
                JEGGuideSettings.addOption(CerPatchGuideOption.instance());
                JEGGuideSettings.addOption(ShareInGuideOption.instance());
                JEGGuideSettings.addOption(ShareOutGuideOption.instance());
                JEGGuideSettings.addOption(RecursiveRecipeFillingGuideOption.instance());
                JEGGuideSettings.addOption(NoticeMissingMaterialGuideOption.instance());
                this.getLogger().info(Lang.getStartup("loaded-guide-option"));
            }
            CERCalculator.load();
            this.getLogger().info(Lang.getStartup("loaded-guide-group"));
        }
        ItemsSetup.setup(this);
        this.rtsBackpackManager = new RTSBackpackManager((Plugin)this);
        this.rtsBackpackManager.load();
        File uuidFile = new File(this.getDataFolder(), "server-uuid");
        if (uuidFile.exists()) {
            try {
                serverUUID = UUID.nameUUIDFromBytes(Files.readAllBytes(Path.of(uuidFile.getPath(), new String[0])));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        serverUUID = UUID.randomUUID();
        try {
            this.getDataFolder().mkdirs();
            uuidFile.createNewFile();
            Files.write(Path.of(uuidFile.getPath(), new String[0]), UUIDUtils.toByteArray(serverUUID), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        SearchGroup.init();
        GroupResorter.load();
        SpecialMenuProvider.loadConfiguration();
        ThirdPartyWarnings.check();
        this.getLogger().info(Lang.getStartup("enabled-jeg"));
    }

    public void onDisable() {
        CustomGroupConfigurations.unload();
        GroupResorter.rollback();
        JustEnoughGuide.getIntegrationManager().shutdownIntegrations();
        GroupSetup.shutdown();
        RecipeCompleteProvider.shutdown();
        GuideUtil.shutdown();
        SlimefunRegistryUtil.unregisterItems(JustEnoughGuide.getInstance());
        try {
            List<SlimefunGuideOption<?>> l = JEGGuideSettings.getOptions();
            ArrayList copy = new ArrayList(l);
            for (SlimefunGuideOption slimefunGuideOption : copy) {
                if (!(slimefunGuideOption.getAddon() instanceof JustEnoughGuide)) continue;
                l.remove(slimefunGuideOption);
            }
            JEGGuideSettings.unpatchSlimefun();
            FinalTECHValueDisplayOption.unboot();
        }
        catch (Exception l) {
            // empty catch block
        }
        try {
            EnumMap<SlimefunGuideMode, Object> newGuides = new EnumMap<SlimefunGuideMode, Object>(SlimefunGuideMode.class);
            newGuides.put(SlimefunGuideMode.SURVIVAL_MODE, (Object)new SurvivalSlimefunGuide(SlimefunOfficialSupporter.isShowVanillaRecipes(), SlimefunOfficialSupporter.isShowHiddenItemGroups()));
            newGuides.put(SlimefunGuideMode.CHEAT_MODE, (Object)new CheatSheetSlimefunGuide());
            ReflectionUtil.setValue(Slimefun.getRegistry(), "guides", newGuides);
        }
        catch (Exception e) {
            Debug.trace(e);
        }
        if (this.bookmarkManager != null) {
            this.bookmarkManager.unload();
        }
        if (this.integrationManager != null) {
            this.integrationManager.unload();
        }
        if (this.commandManager != null) {
            this.commandManager.unload();
        }
        if (this.listenerManager != null) {
            this.listenerManager.unload();
        }
        if (this.rtsBackpackManager != null) {
            this.rtsBackpackManager.unload();
        }
        if (this.configManager != null) {
            this.configManager.unload();
        }
        this.bookmarkManager = null;
        this.integrationManager = null;
        this.commandManager = null;
        this.listenerManager = null;
        this.rtsBackpackManager = null;
        this.localizationService = null;
        this.configManager = null;
        this.minecraftVersion = null;
        this.javaVersion = 0;
        instance = null;
        this.getLogger().info("Disabled JustEnoughGuide");
    }

    @NotNull
    public JavaPlugin getJavaPlugin() {
        return this;
    }

    @Nullable
    public String getBugTrackerURL() {
        return MessageFormat.format("https://github.com/{0}/{1}/issues/", this.username, this.repo);
    }

    public void debug(String message) {
        if (JustEnoughGuide.getConfigManager().isDebug()) {
            this.getLogger().warning("[DEBUG] " + message);
        }
    }

    @NotNull
    public String getVersion() {
        return this.getDescription().getVersion();
    }

    private boolean environmentCheck() {
        this.minecraftVersion = MinecraftVersion.getCurrentVersion();
        this.javaVersion = NumberUtils.getJavaVersion();
        if (this.minecraftVersion == null) {
            this.getLogger().warning(Lang.getStartup("null-mc-version"));
            return false;
        }
        if (this.minecraftVersion == MinecraftVersion.UNKNOWN) {
            this.getLogger().warning(Lang.getStartup("unknown-mc-version"));
        }
        if (!this.minecraftVersion.isAtLeast(RECOMMENDED_MC_VERSION)) {
            this.getLogger().warning(Lang.getStartup("mc-version-too-old", "recommended_major", RECOMMENDED_MC_VERSION.getMajor(), "recommended_minor", RECOMMENDED_MC_VERSION.getMinor()));
        }
        if (this.javaVersion < 17) {
            this.getLogger().warning(Lang.getStartup("java-version-too-old", "recommended_version", 17));
        }
        return true;
    }

    public boolean isDebug() {
        return JustEnoughGuide.getConfigManager().isDebug();
    }

    @Generated
    public static UUID getServerUUID() {
        return serverUUID;
    }

    @NotNull
    @Generated
    public String getUsername() {
        return this.username;
    }

    @NotNull
    @Generated
    public String getRepo() {
        return this.repo;
    }

    @NotNull
    @Generated
    public String getBranch() {
        return this.branch;
    }

    @Generated
    public RTSBackpackManager getRtsBackpackManager() {
        return this.rtsBackpackManager;
    }

    @Generated
    public LocalizationService getLocalizationService() {
        return this.localizationService;
    }

    @Generated
    public int getJavaVersion() {
        return this.javaVersion;
    }
}

