/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.core.listeners;

import com.balugaq.jeg.api.cost.CERCalculator;
import com.balugaq.jeg.api.groups.CERRecipeGroup;
import com.balugaq.jeg.api.groups.SearchGroup;
import com.balugaq.jeg.api.objects.enums.PatchScope;
import com.balugaq.jeg.api.objects.events.PatchEvent;
import com.balugaq.jeg.implementation.option.CerPatchGuideOption;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import java.util.ArrayList;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CerPatchListener
implements Listener {
    @EventHandler
    public void onSearch(PatchEvent event) {
        if (event.getPatchScope() != PatchScope.SearchItem) {
            return;
        }
        Player player = event.getPlayer();
        if (!CerPatchGuideOption.isEnabled(player)) {
            return;
        }
        ItemStack is = event.getItemStack();
        SlimefunItem sf = SlimefunItem.getByItem((ItemStack)is);
        if (sf == null) {
            return;
        }
        double cer = CERCalculator.getCER(sf, SearchGroup.searchTerms.get(player.getUniqueId()));
        if (cer > 0.0) {
            ItemMeta meta = is.getItemMeta();
            ArrayList<String> lore = meta.getLore();
            if (lore == null) {
                lore = new ArrayList<String>();
            }
            lore.add("");
            lore.add(ChatColors.color((String)("&aCER Value: " + CERRecipeGroup.format.format(cer))));
            meta.setLore(lore);
            is.setItemMeta(meta);
        }
        event.setItemStack(is);
    }
}

