/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.groups;

import com.balugaq.jeg.api.editor.GroupResorter;
import com.balugaq.jeg.api.interfaces.JEGSlimefunGuideImplementation;
import com.balugaq.jeg.api.objects.CustomGroupConfiguration;
import com.balugaq.jeg.api.objects.enums.PatchScope;
import com.balugaq.jeg.api.objects.events.GuideEvents;
import com.balugaq.jeg.core.listeners.GuideListener;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.utils.EventUtil;
import com.balugaq.jeg.utils.GuideUtil;
import com.balugaq.jeg.utils.ItemStackUtil;
import com.balugaq.jeg.utils.Lang;
import com.balugaq.jeg.utils.compatibility.Converter;
import com.balugaq.jeg.utils.compatibility.Sounds;
import com.balugaq.jeg.utils.formatter.Formats;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.groups.FlexItemGroup;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.api.researches.Research;
import io.github.thebusybiscuit.slimefun4.core.guide.GuideHistory;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuide;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.chat.ChatInput;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class CustomGroup
extends FlexItemGroup {
    @NotNull
    public final CustomGroupConfiguration configuration;
    public final List<Object> objects;
    private final int page;
    private Map<Integer, CustomGroup> pageMap = new LinkedHashMap<Integer, CustomGroup>();

    @ParametersAreNonnullByDefault
    public CustomGroup(CustomGroupConfiguration configuration) {
        super(configuration.key(), configuration.item(), configuration.tier());
        this.configuration = configuration;
        ArrayList<ItemGroup> itemGroups = new ArrayList<ItemGroup>();
        ArrayList<SlimefunItem> slimefunItems = new ArrayList<SlimefunItem>();
        for (Object obj : configuration.objects()) {
            if (obj instanceof ItemGroup) {
                ItemGroup group = (ItemGroup)obj;
                if (configuration.mode() == CustomGroupConfiguration.Mode.TRANSFER) {
                    GuideUtil.setForceHiddens(group, true);
                }
                itemGroups.add(group);
                continue;
            }
            if (!(obj instanceof SlimefunItem)) continue;
            SlimefunItem sf = (SlimefunItem)obj;
            slimefunItems.add(sf);
            sf.getItemGroup().remove(sf);
            sf.setItemGroup((ItemGroup)this);
        }
        GroupResorter.sort(itemGroups);
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.addAll(itemGroups);
        objects.addAll(slimefunItems);
        this.objects = objects;
        this.page = 1;
        this.pageMap.put(1, this);
    }

    @ParametersAreNonnullByDefault
    public CustomGroup(CustomGroup customGroup, int page) {
        super(customGroup.configuration.key(), customGroup.configuration.item(), customGroup.configuration.tier());
        this.configuration = customGroup.configuration;
        this.objects = customGroup.objects;
        this.page = page;
        this.pageMap.put(page, this);
    }

    @ParametersAreNonnullByDefault
    public boolean isVisible(Player player, PlayerProfile playerProfile, SlimefunGuideMode slimefunGuideMode) {
        return true;
    }

    public void open(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        playerProfile.getGuideHistory().add((ItemGroup)this, this.page);
        this.generateMenu(player, playerProfile, slimefunGuideMode).open(new Player[]{player});
    }

    @NotNull
    private ChestMenu generateMenu(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        ChestMenu chestMenu = new ChestMenu(ItemUtils.getItemName((ItemStack)this.configuration.item()));
        chestMenu.setEmptySlotsClickable(false);
        chestMenu.addMenuOpeningHandler(pl -> pl.playSound(pl.getLocation(), Sounds.GUIDE_BUTTON_CLICK_SOUND, 1.0f, 1.0f));
        SlimefunGuideImplementation implementation = Slimefun.getRegistry().getSlimefunGuide(slimefunGuideMode);
        for (int ss : Formats.sub.getChars('b')) {
            chestMenu.addItem(ss, PatchScope.Back.patch(player, ChestMenuUtils.getBackButton((Player)player, (String[])new String[0])));
            chestMenu.addMenuClickHandler(ss, (pl, s, is, action) -> EventUtil.callEvent(new GuideEvents.BackButtonClickEvent(pl, is, s, action, chestMenu, implementation)).ifSuccess(() -> {
                GuideHistory guideHistory = playerProfile.getGuideHistory();
                if (action.isShiftClicked()) {
                    SlimefunGuide.openMainMenu((PlayerProfile)playerProfile, (SlimefunGuideMode)slimefunGuideMode, (int)guideHistory.getMainMenuPage());
                } else {
                    guideHistory.goBack(Slimefun.getRegistry().getSlimefunGuide(slimefunGuideMode));
                }
                return false;
            }));
        }
        for (int ss : Formats.sub.getChars('S')) {
            chestMenu.addItem(ss, PatchScope.Search.patch(player, ChestMenuUtils.getSearchButton((Player)player)));
            chestMenu.addMenuClickHandler(ss, (pl, slot, item, action) -> EventUtil.callEvent(new GuideEvents.SearchButtonClickEvent(pl, item, slot, action, chestMenu, implementation)).ifSuccess(() -> {
                pl.closeInventory();
                Slimefun.getLocalization().sendMessage((CommandSender)pl, "guide.search.message");
                ChatInput.waitForPlayer((Plugin)JustEnoughGuide.getInstance(), (Player)pl, msg -> implementation.openSearch(playerProfile, msg, implementation.getMode() == SlimefunGuideMode.SURVIVAL_MODE));
                return false;
            }));
        }
        for (int ss : Formats.sub.getChars('P')) {
            chestMenu.addItem(ss, PatchScope.PreviousPage.patch(player, ChestMenuUtils.getPreviousButton((Player)player, (int)this.page, (int)((this.objects.size() - 1) / Formats.sub.getChars('i').size() + 1))));
            chestMenu.addMenuClickHandler(ss, (p, slot, item, action) -> EventUtil.callEvent(new GuideEvents.PreviousButtonClickEvent(p, item, slot, action, chestMenu, implementation)).ifSuccess(() -> {
                GuideUtil.removeLastEntry(playerProfile.getGuideHistory());
                CustomGroup customGroup = this.getByPage(Math.max(this.page - 1, 1));
                customGroup.open(player, playerProfile, slimefunGuideMode);
                return false;
            }));
        }
        for (int ss : Formats.sub.getChars('N')) {
            chestMenu.addItem(ss, PatchScope.NextPage.patch(player, ChestMenuUtils.getNextButton((Player)player, (int)this.page, (int)((this.objects.size() - 1) / Formats.sub.getChars('i').size() + 1))));
            chestMenu.addMenuClickHandler(ss, (p, slot, item, action) -> EventUtil.callEvent(new GuideEvents.NextButtonClickEvent(p, item, slot, action, chestMenu, implementation)).ifSuccess(() -> {
                GuideUtil.removeLastEntry(playerProfile.getGuideHistory());
                CustomGroup customGroup = this.getByPage(Math.min(this.page + 1, (this.objects.size() - 1) / Formats.sub.getChars('i').size() + 1));
                customGroup.open(player, playerProfile, slimefunGuideMode);
                return false;
            }));
        }
        for (int ss : Formats.sub.getChars('B')) {
            chestMenu.addItem(ss, PatchScope.Background.patch(player, ChestMenuUtils.getBackground()));
            chestMenu.addMenuClickHandler(ss, ChestMenuUtils.getEmptyClickHandler());
        }
        List<Integer> contentSlots = Formats.sub.getChars('i');
        for (int i = 0; i < contentSlots.size(); ++i) {
            int index = i + this.page * contentSlots.size() - contentSlots.size();
            if (index >= this.objects.size()) continue;
            Object o = this.objects.get(index);
            if (o instanceof SlimefunItem) {
                ChestMenu.MenuClickHandler handler;
                ItemStack itemstack;
                SlimefunItem slimefunItem = (SlimefunItem)o;
                Research research = slimefunItem.getResearch();
                if (implementation.getMode() == SlimefunGuideMode.SURVIVAL_MODE && research != null && !playerProfile.hasUnlocked(research)) {
                    itemstack = ItemStackUtil.getCleanItem(Converter.getItem(ChestMenuUtils.getNoPermissionItem(), "&f" + ItemUtils.getItemName((ItemStack)slimefunItem.getItem()), "&7" + slimefunItem.getId(), "&4&l" + Slimefun.getLocalization().getMessage(player, "guide.locked"), "", Lang.getGuideMessage("click-to-unlock"), "", Lang.getGuideMessage("cost", "cost", research.getCost())));
                    handler = (pl, slot, item, action) -> EventUtil.callEvent(new GuideEvents.ResearchItemEvent(pl, item, slot, action, chestMenu, implementation)).ifSuccess(() -> {
                        research.unlockFromGuide(implementation, pl, playerProfile, slimefunItem, slimefunItem.getItemGroup(), this.page);
                        return false;
                    });
                } else {
                    itemstack = Converter.getItem(slimefunItem.getItem());
                    handler = (pl, slot, itm, action) -> EventUtil.callEvent(new GuideEvents.ItemButtonClickEvent(pl, itm, slot, action, chestMenu, implementation)).ifSuccess(() -> {
                        try {
                            if (implementation.getMode() != SlimefunGuideMode.SURVIVAL_MODE && (pl.isOp() || pl.hasPermission("slimefun.cheat.items"))) {
                                pl.getInventory().addItem(new ItemStack[]{slimefunItem.getItem().clone()});
                            } else {
                                implementation.displayItem(playerProfile, slimefunItem, true);
                            }
                        }
                        catch (Exception | LinkageError x) {
                            this.printErrorMessage(pl, slimefunItem, x);
                        }
                        return false;
                    });
                }
                chestMenu.addItem(contentSlots.get(i).intValue(), PatchScope.SlimefunItem.patch(player, itemstack), handler);
                continue;
            }
            if (!(o instanceof ItemGroup)) continue;
            ItemGroup itemGroup = (ItemGroup)o;
            SlimefunGuideImplementation slimefunGuideImplementation = GuideUtil.getGuide(player, GuideListener.guideModeMap.getOrDefault(player, SlimefunGuideMode.SURVIVAL_MODE));
            if (!(slimefunGuideImplementation instanceof JEGSlimefunGuideImplementation)) continue;
            JEGSlimefunGuideImplementation guide = (JEGSlimefunGuideImplementation)slimefunGuideImplementation;
            guide.showItemGroup0(chestMenu, player, playerProfile, itemGroup, contentSlots.get(i));
        }
        GuideUtil.addRTSButton(chestMenu, player, playerProfile, Formats.sub, slimefunGuideMode, implementation);
        if (implementation instanceof JEGSlimefunGuideImplementation) {
            JEGSlimefunGuideImplementation jeg = (JEGSlimefunGuideImplementation)implementation;
            GuideUtil.addBookMarkButton(chestMenu, player, playerProfile, Formats.sub, jeg, (ItemGroup)this);
            GuideUtil.addItemMarkButton(chestMenu, player, playerProfile, Formats.sub, jeg, (ItemGroup)this);
        }
        Formats.sub.renderCustom(chestMenu);
        return chestMenu;
    }

    public void ifig(Object object, @NotNull Consumer<ItemGroup> consumer) {
        if (object instanceof ItemGroup) {
            ItemGroup ig = (ItemGroup)object;
            consumer.accept(ig);
        }
    }

    public void ifsf(Object object, @NotNull Consumer<SlimefunItem> consumer) {
        if (object instanceof SlimefunItem) {
            SlimefunItem si = (SlimefunItem)object;
            consumer.accept(si);
        }
    }

    @ParametersAreNonnullByDefault
    private void printErrorMessage(@NotNull Player p, @NotNull SlimefunItem item, @NotNull Throwable x) {
        p.sendMessage(String.valueOf(ChatColor.DARK_RED) + "An internal server error has occurred. Please inform an admin, check the console for further info.");
        item.error("This item has caused an error message to be thrown while viewing it in the Slimefun guide.", x);
    }

    public boolean isCrossAddonItemGroup() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private CustomGroup getByPage(int page) {
        if (this.pageMap.containsKey(page)) {
            return this.pageMap.get(page);
        }
        CustomGroup customGroup = this.pageMap.get(1);
        synchronized (customGroup) {
            if (this.pageMap.containsKey(page)) {
                return this.pageMap.get(page);
            }
            CustomGroup customGroup2 = new CustomGroup(this, page);
            customGroup2.pageMap = this.pageMap;
            this.pageMap.put(page, customGroup2);
            return customGroup2;
        }
    }

    @Generated
    public String toString() {
        return "CustomGroup(configuration=" + String.valueOf(this.getConfiguration()) + ", objects=" + String.valueOf(this.getObjects()) + ", page=" + this.getPage() + ", pageMap=" + String.valueOf(this.getPageMap()) + ")";
    }

    @NotNull
    @Generated
    public CustomGroupConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public List<Object> getObjects() {
        return this.objects;
    }

    @Generated
    public int getPage() {
        return this.page;
    }

    @Generated
    public Map<Integer, CustomGroup> getPageMap() {
        return this.pageMap;
    }
}

