/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.groups;

import com.balugaq.jeg.api.cost.CERCalculator;
import com.balugaq.jeg.api.cost.ValueTable;
import com.balugaq.jeg.api.interfaces.JEGSlimefunGuideImplementation;
import com.balugaq.jeg.api.interfaces.NotDisplayInCheatMode;
import com.balugaq.jeg.api.interfaces.NotDisplayInSurvivalMode;
import com.balugaq.jeg.api.objects.collection.Pair;
import com.balugaq.jeg.api.objects.enums.PatchScope;
import com.balugaq.jeg.api.objects.events.GuideEvents;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.utils.EventUtil;
import com.balugaq.jeg.utils.GuideUtil;
import com.balugaq.jeg.utils.ItemStackUtil;
import com.balugaq.jeg.utils.Lang;
import com.balugaq.jeg.utils.SlimefunOfficialSupporter;
import com.balugaq.jeg.utils.compatibility.Converter;
import com.balugaq.jeg.utils.compatibility.Sounds;
import com.balugaq.jeg.utils.formatter.Formats;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.groups.FlexItemGroup;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.GuideHistory;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuide;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.chat.ChatInput;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import net.guizhanss.guizhanlib.minecraft.helper.inventory.ItemStackHelper;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NotDisplayInSurvivalMode
@NotDisplayInCheatMode
public class CERRecipeGroup
extends FlexItemGroup {
    public static final DecimalFormat format = new DecimalFormat("#.###");
    public static final ChestMenu.MenuClickHandler subMenuOpen = (p, s, i, a) -> false;
    private static final JavaPlugin JAVA_PLUGIN = JustEnoughGuide.getInstance();
    private final SlimefunGuideImplementation implementation;
    private final Player player;
    private final int page;
    private final SlimefunItem machine;
    private final List<RecipeWrapper> recipes;
    private final List<Pair<ItemStack, ChestMenu.MenuClickHandler>> icons;
    private Map<Integer, CERRecipeGroup> pageMap = new LinkedHashMap<Integer, CERRecipeGroup>();

    @ParametersAreNonnullByDefault
    public CERRecipeGroup(@NotNull SlimefunGuideImplementation implementation, @NotNull Player player, @NotNull SlimefunItem machine, @NotNull List<RecipeWrapper> recipes) {
        super(new NamespacedKey((Plugin)JAVA_PLUGIN, "jeg_cer_recipe_group_" + String.valueOf(UUID.randomUUID())), new ItemStack(Material.BARRIER));
        this.page = 1;
        this.player = player;
        this.implementation = implementation;
        this.recipes = recipes;
        this.pageMap.put(1, this);
        this.machine = machine;
        this.icons = CERRecipeGroup.getDisplayIcons(player, machine, recipes);
    }

    protected CERRecipeGroup(@NotNull CERRecipeGroup cer, int page) {
        super(cer.key, new ItemStack(Material.BARRIER));
        this.page = page;
        this.player = cer.player;
        this.implementation = cer.implementation;
        this.recipes = cer.recipes;
        this.icons = cer.icons;
        this.machine = cer.machine;
        this.pageMap.put(page, this);
    }

    public static List<Pair<ItemStack, ChestMenu.MenuClickHandler>> getDisplayIcons(Player p, SlimefunItem machine, List<RecipeWrapper> wrappers) {
        ArrayList<Pair<ItemStack, ChestMenu.MenuClickHandler>> list = new ArrayList<Pair<ItemStack, ChestMenu.MenuClickHandler>>();
        String lk = "icon.cer-recipe-group.";
        for (int i = 0; i < wrappers.size(); ++i) {
            RecipeWrapper recipe = wrappers.get(i);
            ItemStack[] in = recipe.getInput();
            ItemStack[] out = recipe.getOutput();
            long e = recipe.getTotalEnergyCost();
            list.add(new Pair<ItemStack, ChestMenu.MenuClickHandler>(PatchScope.CerRecipe.patch(p, Converter.getItem(Material.GREEN_STAINED_GLASS_PANE, Lang.getString(lk + "recipe-item-name").replace("{number}", String.valueOf(i + 1)), Lang.getString(lk + "making-difficulty").replace("{value}", String.valueOf(ValueTable.getValue(machine))), Lang.getString(lk + "time").replace("{ticks}", String.valueOf(recipe.getTicks())), Lang.getString(lk + (e == 0L ? "no-energy" : (e > 0L ? "cost-energy" : "produce-energy"))).replace("{energy}", String.valueOf(Math.abs(e))))), ChestMenuUtils.getEmptyClickHandler()));
            if (in != null && in.length > 0) {
                list.add(new Pair<ItemStack, ChestMenu.MenuClickHandler>(PatchScope.CerRecipeBorderInput.patch(p, Converter.getItem(Material.BLUE_STAINED_GLASS_PANE, Lang.getString(lk + "input-title"), new String[0])), ChestMenuUtils.getEmptyClickHandler()));
                for (ItemStack input : in) {
                    list.add(new Pair<ItemStack, ChestMenu.MenuClickHandler>(PatchScope.CerRecipeInput.patch(p, Converter.getItem(ItemStackUtil.getCleanItem(input))), subMenuOpen));
                }
                if (out != null && out.length > 0) {
                    list.add(new Pair<ItemStack, ChestMenu.MenuClickHandler>(PatchScope.CerRecipeBorderInputOutput.patch(p, Converter.getItem(Material.ORANGE_STAINED_GLASS_PANE, Lang.getString(lk + "input-output-title-1"), Lang.getString(lk + "input-output-title-2"))), ChestMenuUtils.getEmptyClickHandler()));
                }
            } else if (out != null && out.length > 0) {
                list.add(new Pair<ItemStack, ChestMenu.MenuClickHandler>(PatchScope.CerRecipeBorderOutput.patch(p, Converter.getItem(Material.ORANGE_STAINED_GLASS_PANE, Lang.getString(lk + "output-title"), new String[0])), ChestMenuUtils.getEmptyClickHandler()));
            }
            if (out == null) continue;
            for (ItemStack output : out) {
                ItemStack display = output.clone();
                ItemMeta meta = display.getItemMeta();
                ArrayList<String> lore = new ArrayList<String>();
                List o = meta.getLore();
                if (o != null) {
                    lore.addAll(o);
                }
                double cer = CERCalculator.getCER(machine, ItemStackHelper.getDisplayName((ItemStack)output));
                lore.add(" ");
                lore.add(ChatColors.color((String)Lang.getString(lk + "cer-value").replace("{value}", format.format(cer))));
                meta.setLore(lore);
                display.setItemMeta(meta);
                list.add(new Pair<ItemStack, ChestMenu.MenuClickHandler>(PatchScope.CerRecipeOutput.patch(p, display), subMenuOpen));
            }
        }
        return list;
    }

    public boolean isVisible(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        return false;
    }

    public void open(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        playerProfile.getGuideHistory().add((ItemGroup)this, this.page);
        this.generateMenu(player, playerProfile, slimefunGuideMode).open(new Player[]{player});
    }

    public void refresh(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        GuideUtil.removeLastEntry(playerProfile.getGuideHistory());
        this.open(player, playerProfile, slimefunGuideMode);
    }

    @NotNull
    private ChestMenu generateMenu(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        ChestMenu chestMenu = new ChestMenu(Lang.getString("icon.cer-recipe-group.title"));
        chestMenu.setEmptySlotsClickable(false);
        chestMenu.addMenuOpeningHandler(pl -> pl.playSound(pl.getLocation(), Sounds.GUIDE_BUTTON_CLICK_SOUND, 1.0f, 1.0f));
        for (int ss : Formats.sub.getChars('b')) {
            chestMenu.addItem(ss, PatchScope.Back.patch(playerProfile, ChestMenuUtils.getBackButton((Player)player, (String[])new String[0])));
            chestMenu.addMenuClickHandler(ss, (pl, s, is, action) -> EventUtil.callEvent(new GuideEvents.BackButtonClickEvent(pl, is, s, action, chestMenu, this.implementation)).ifSuccess(() -> {
                GuideHistory guideHistory = playerProfile.getGuideHistory();
                if (action.isShiftClicked()) {
                    SlimefunGuide.openMainMenu((PlayerProfile)playerProfile, (SlimefunGuideMode)slimefunGuideMode, (int)guideHistory.getMainMenuPage());
                } else {
                    guideHistory.goBack(Slimefun.getRegistry().getSlimefunGuide(slimefunGuideMode));
                }
                return false;
            }));
        }
        for (int ss : Formats.sub.getChars('P')) {
            chestMenu.addItem(ss, PatchScope.PreviousPage.patch(playerProfile, ChestMenuUtils.getPreviousButton((Player)player, (int)this.page, (int)((this.iconsLength() - 1) / Formats.sub.getChars('i').size() + 1))));
            chestMenu.addMenuClickHandler(ss, (p, slot, item, action) -> EventUtil.callEvent(new GuideEvents.PreviousButtonClickEvent(p, item, slot, action, chestMenu, this.implementation)).ifSuccess(() -> {
                GuideUtil.removeLastEntry(playerProfile.getGuideHistory());
                CERRecipeGroup CERRecipeGroup2 = this.getByPage(Math.max(this.page - 1, 1));
                CERRecipeGroup2.open(player, playerProfile, slimefunGuideMode);
                return false;
            }));
        }
        for (int ss : Formats.sub.getChars('S')) {
            chestMenu.addItem(ss, PatchScope.Search.patch(playerProfile, ChestMenuUtils.getSearchButton((Player)player)));
            chestMenu.addMenuClickHandler(ss, (pl, slot, item, action) -> EventUtil.callEvent(new GuideEvents.SearchButtonClickEvent(pl, item, slot, action, chestMenu, this.implementation)).ifSuccess(() -> {
                pl.closeInventory();
                Slimefun.getLocalization().sendMessage((CommandSender)pl, Lang.getString("icon.cer-recipe-group.search-message"));
                ChatInput.waitForPlayer((Plugin)JAVA_PLUGIN, (Player)pl, msg -> this.implementation.openSearch(playerProfile, msg, this.implementation.getMode() == SlimefunGuideMode.SURVIVAL_MODE));
                return false;
            }));
        }
        for (int ss : Formats.sub.getChars('N')) {
            chestMenu.addItem(ss, PatchScope.NextPage.patch(playerProfile, ChestMenuUtils.getNextButton((Player)player, (int)this.page, (int)((this.iconsLength() - 1) / Formats.sub.getChars('i').size() + 1))));
            chestMenu.addMenuClickHandler(ss, (p, slot, item, action) -> EventUtil.callEvent(new GuideEvents.NextButtonClickEvent(p, item, slot, action, chestMenu, this.implementation)).ifSuccess(() -> {
                GuideUtil.removeLastEntry(playerProfile.getGuideHistory());
                CERRecipeGroup CERRecipeGroup2 = this.getByPage(Math.min(this.page + 1, (this.iconsLength() - 1) / Formats.sub.getChars('i').size() + 1));
                CERRecipeGroup2.open(player, playerProfile, slimefunGuideMode);
                return false;
            }));
        }
        for (int ss : Formats.sub.getChars('B')) {
            chestMenu.addItem(ss, PatchScope.Background.patch(playerProfile, ChestMenuUtils.getBackground()));
            chestMenu.addMenuClickHandler(ss, ChestMenuUtils.getEmptyClickHandler());
        }
        List<Integer> contentSlots = Formats.sub.getChars('i');
        for (int i = 0; i < contentSlots.size(); ++i) {
            int m = (this.page - 1) * contentSlots.size() + i;
            if (m >= this.iconsLength()) continue;
            chestMenu.addItem(contentSlots.get(i).intValue(), this.icons.get(m).getFirst(), this.icons.get(m).getSecond());
        }
        GuideUtil.addRTSButton(chestMenu, player, playerProfile, Formats.sub, slimefunGuideMode, this.implementation);
        SlimefunGuideImplementation slimefunGuideImplementation = this.implementation;
        if (slimefunGuideImplementation instanceof JEGSlimefunGuideImplementation) {
            JEGSlimefunGuideImplementation jeg = (JEGSlimefunGuideImplementation)slimefunGuideImplementation;
            GuideUtil.addBookMarkButton(chestMenu, player, playerProfile, Formats.sub, jeg, (ItemGroup)this);
            GuideUtil.addItemMarkButton(chestMenu, player, playerProfile, Formats.sub, jeg, (ItemGroup)this);
        }
        Formats.sub.renderCustom(chestMenu);
        return chestMenu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private CERRecipeGroup getByPage(int page) {
        if (this.pageMap.containsKey(page)) {
            return this.pageMap.get(page);
        }
        CERRecipeGroup cERRecipeGroup = this.pageMap.get(1);
        synchronized (cERRecipeGroup) {
            if (this.pageMap.containsKey(page)) {
                return this.pageMap.get(page);
            }
            CERRecipeGroup cer = new CERRecipeGroup(this, page);
            cer.pageMap = this.pageMap;
            this.pageMap.put(page, cer);
            return cer;
        }
    }

    @ParametersAreNonnullByDefault
    private boolean isItemGroupAccessible(@NotNull Player p, @NotNull SlimefunItem slimefunItem) {
        return SlimefunOfficialSupporter.isShowHiddenItemGroups() || slimefunItem.getItemGroup().isAccessible(p);
    }

    @ParametersAreNonnullByDefault
    private void printErrorMessage(@NotNull Player p, @NotNull SlimefunItem item, @NotNull Throwable x) {
        p.sendMessage(String.valueOf(ChatColor.DARK_RED) + "An internal server error has occurred. Please inform an admin, check the console for further info.");
        item.error("This item has caused an error message to be thrown while viewing it in the Slimefun guide.", x);
    }

    public int iconsLength() {
        return this.icons.size();
    }

    public static class RecipeWrapper {
        @Nullable
        private final ItemStack[] input;
        private final ItemStack[] output;
        private final long ticks;
        private final long totalEnergyCost;

        @Generated
        public RecipeWrapper(@Nullable ItemStack[] input, ItemStack[] output, long ticks, long totalEnergyCost) {
            this.input = input;
            this.output = output;
            this.ticks = ticks;
            this.totalEnergyCost = totalEnergyCost;
        }

        @Nullable
        @Generated
        public ItemStack[] getInput() {
            return this.input;
        }

        @Generated
        public ItemStack[] getOutput() {
            return this.output;
        }

        @Generated
        public long getTicks() {
            return this.ticks;
        }

        @Generated
        public long getTotalEnergyCost() {
            return this.totalEnergyCost;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RecipeWrapper)) {
                return false;
            }
            RecipeWrapper other = (RecipeWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTicks() != other.getTicks()) {
                return false;
            }
            if (this.getTotalEnergyCost() != other.getTotalEnergyCost()) {
                return false;
            }
            if (!Arrays.deepEquals(this.getInput(), other.getInput())) {
                return false;
            }
            return Arrays.deepEquals(this.getOutput(), other.getOutput());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RecipeWrapper;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $ticks = this.getTicks();
            result = result * 59 + (int)($ticks >>> 32 ^ $ticks);
            long $totalEnergyCost = this.getTotalEnergyCost();
            result = result * 59 + (int)($totalEnergyCost >>> 32 ^ $totalEnergyCost);
            result = result * 59 + Arrays.deepHashCode(this.getInput());
            result = result * 59 + Arrays.deepHashCode(this.getOutput());
            return result;
        }

        @Generated
        public String toString() {
            return "CERRecipeGroup.RecipeWrapper(input=" + Arrays.deepToString(this.getInput()) + ", output=" + Arrays.deepToString(this.getOutput()) + ", ticks=" + this.getTicks() + ", totalEnergyCost=" + this.getTotalEnergyCost() + ")";
        }
    }
}

