/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.utils.clickhandler;

import com.balugaq.jeg.api.clickhandler.JEGClickHandler;
import com.balugaq.jeg.api.clickhandler.Processor;
import com.balugaq.jeg.api.objects.events.GuideEvents;
import com.balugaq.jeg.utils.EventUtil;
import com.balugaq.jeg.utils.GuideUtil;
import com.balugaq.jeg.utils.clickhandler.Applier;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class GroupLinker
implements Applier {
    private static final GroupLinker instance = new GroupLinker();

    private GroupLinker() {
    }

    public static void applyWith(@NotNull SlimefunGuideImplementation guide, @NotNull ChestMenu menu, int slot) {
        instance.apply(guide, menu, slot);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(SlimefunGuideImplementation guide, ChestMenu menu, int slot) {
        menu.addMenuClickHandler(slot, (ChestMenu.MenuClickHandler)JEGClickHandler.of(guide, menu, slot).addProcessor(GroupLinkProcessor.getInstance()));
    }

    public static class GroupLinkProcessor
    extends Processor {
        private static final GroupLinkProcessor instance = new GroupLinkProcessor();

        public GroupLinkProcessor() {
            super(Processor.Strategy.HEAD);
        }

        @Override
        public boolean process(@NotNull SlimefunGuideImplementation guide, @NotNull ChestMenu menu, @NotNull InventoryClickEvent event, @NotNull Player player, @Range(from=0L, to=53L) int clickedSlot, @Nullable ItemStack clickedItemStack, @NotNull ClickAction clickAction, @Nullable Boolean processedResult) {
            ItemGroup itemGroup;
            SlimefunItem sfItem;
            if (!clickAction.isRightClicked() && clickAction.isShiftClicked() && (sfItem = SlimefunItem.getByItem((ItemStack)clickedItemStack)) != null && (itemGroup = sfItem.getItemGroup()) != null) {
                AtomicInteger page = new AtomicInteger(1);
                if (GuideUtil.isTaggedGroupType(itemGroup)) {
                    page.set(itemGroup.getItems().indexOf(sfItem) / 36 + 1);
                }
                return EventUtil.callEvent(new GuideEvents.GroupLinkButtonClickEvent(player, clickedItemStack, clickedSlot, clickAction, menu, guide)).ifSuccess(() -> {
                    PlayerProfile.get((OfflinePlayer)player, profile -> guide.openItemGroup(profile, itemGroup, page.get()));
                    return false;
                });
            }
            return true;
        }

        @Generated
        public static GroupLinkProcessor getInstance() {
            return instance;
        }
    }
}

