/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.core.managers;

import com.balugaq.jeg.api.managers.AbstractManager;
import com.balugaq.jeg.api.objects.annotations.Warn;
import com.balugaq.jeg.utils.Debug;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ConfigManager
extends AbstractManager {
    private final boolean AUTO_UPDATE;
    private final boolean DEBUG;
    private final boolean SURVIVAL_IMPROVEMENTS;
    private final boolean CHEAT_IMPROVEMENTS;
    private final boolean RECIPE_COMPLETE;
    private final boolean PINYIN_SEARCH;
    private final boolean BOOKMARK;
    private final boolean RTS_SEARCH;
    private final boolean BEGINNER_OPTION;
    @NotNull
    private final String SURVIVAL_GUIDE_TITLE;
    @NotNull
    private final String CHEAT_GUIDE_TITLE;
    @NotNull
    private final String SETTINGS_GUIDE_TITLE;
    @NotNull
    private final String CREDITS_GUIDE_TITLE;
    @Warn(reason="No longer using it in EN version")
    @NotNull
    private final List<String> SHARED_CHARS;
    @NotNull
    private final List<String> SHARED_WORDS;
    @NotNull
    private final List<String> BLACKLIST;
    @NotNull
    private final List<String> MAIN_FORMAT;
    @NotNull
    private final List<String> NESTED_GROUP_FORMAT;
    @NotNull
    private final List<String> SUB_GROUP_FORMAT;
    @NotNull
    private final List<String> RECIPE_FORMAT;
    @NotNull
    private final List<String> HELPER_FORMAT;
    @NotNull
    private final List<String> RECIPE_VANILLA_FORMAT;
    @NotNull
    private final List<String> RECIPE_DISPLAY_FORMAT;
    @NotNull
    private final List<String> SETTINGS_FORMAT;
    @NotNull
    private final List<String> CONTRIBUTORS_FORMAT;
    @NotNull
    private final Map<String, String> LOCAL_TRANSLATE;
    @NotNull
    private final List<String> BANLIST;
    @NotNull
    private final String LANGUAGE;
    @NotNull
    private final JavaPlugin plugin;
    private final boolean EMC_VALUE_DISPLAY;
    private final boolean FinalTech_VALUE_DISPLAY;
    private final boolean FinalTECH_VALUE_DISPLAY;
    private final boolean ITEM_SHAREABLE;

    public ConfigManager(@NotNull JavaPlugin plugin) {
        this.plugin = plugin;
        this.setupDefaultConfig();
        FileConfiguration cfg = plugin.getConfig();
        this.AUTO_UPDATE = cfg.getBoolean("auto-update", false);
        this.DEBUG = cfg.getBoolean("debug", false);
        this.SURVIVAL_IMPROVEMENTS = cfg.getBoolean("guide.survival-improvements", true);
        this.CHEAT_IMPROVEMENTS = cfg.getBoolean("guide.cheat-improvements", true);
        this.RECIPE_COMPLETE = cfg.getBoolean("guide.recipe-complete", true);
        this.PINYIN_SEARCH = cfg.getBoolean("improvements.pinyin-search", false);
        this.BOOKMARK = cfg.getBoolean("improvements.bookmark", true);
        this.SURVIVAL_GUIDE_TITLE = cfg.getString("guide.survival-guide-title", "&2&lSlimefun Guide &7(Chest GUI) &8Advanced");
        this.CHEAT_GUIDE_TITLE = cfg.getString("guide.cheat-guide-title", "&c&l&cSlimefun Guide &4(Cheat Sheet) &8Advanced");
        this.SETTINGS_GUIDE_TITLE = cfg.getString("guide.settings-guide-title", "Settings & Info");
        this.CREDITS_GUIDE_TITLE = cfg.getString("guide.credits-guide-title", "Slimefun4 Contributors");
        this.RTS_SEARCH = cfg.getBoolean("improvements.rts-search", true);
        this.BEGINNER_OPTION = cfg.getBoolean("improvements.beginner-option", true);
        List rawBlacklist = cfg.getStringList("blacklist");
        if (rawBlacklist == null || rawBlacklist.isEmpty()) {
            this.BLACKLIST = new ArrayList<String>();
            this.BLACKLIST.add("Fast Machines");
        } else {
            this.BLACKLIST = rawBlacklist;
        }
        List rawSharedChars = cfg.getStringList("shared-chars");
        this.SHARED_CHARS = rawSharedChars == null || rawSharedChars.isEmpty() ? new ArrayList<String>() : rawSharedChars;
        List rawSharedWords = cfg.getStringList("shared-words");
        if (rawSharedWords == null || rawSharedWords.isEmpty()) {
            this.SHARED_WORDS = new ArrayList<String>();
            this.SHARED_WORDS.add("barrel storage");
        } else {
            this.SHARED_WORDS = rawSharedWords;
        }
        List rawMainFormat = cfg.getStringList("custom-format.main");
        if (rawMainFormat == null || rawMainFormat.isEmpty()) {
            this.MAIN_FORMAT = new ArrayList<String>();
            this.MAIN_FORMAT.add("BTBBBBRSB");
            this.MAIN_FORMAT.add("GGGGGGGGG");
            this.MAIN_FORMAT.add("GGGGGGGGG");
            this.MAIN_FORMAT.add("GGGGGGGGG");
            this.MAIN_FORMAT.add("GGGGGGGGG");
            this.MAIN_FORMAT.add("BPBBCBBNB");
        } else {
            this.MAIN_FORMAT = rawMainFormat;
        }
        List rawNestedGroupFormat = cfg.getStringList("custom-format.nested-group");
        if (rawNestedGroupFormat == null || rawNestedGroupFormat.isEmpty()) {
            this.NESTED_GROUP_FORMAT = new ArrayList<String>();
            this.NESTED_GROUP_FORMAT.add("BbBBBBRSB");
            this.NESTED_GROUP_FORMAT.add("GGGGGGGGG");
            this.NESTED_GROUP_FORMAT.add("GGGGGGGGG");
            this.NESTED_GROUP_FORMAT.add("GGGGGGGGG");
            this.NESTED_GROUP_FORMAT.add("GGGGGGGGG");
            this.NESTED_GROUP_FORMAT.add("BPBBCBBNB");
        } else {
            this.NESTED_GROUP_FORMAT = rawNestedGroupFormat;
        }
        List rawSubGroupFormat = cfg.getStringList("custom-format.sub-group");
        if (rawSubGroupFormat == null || rawSubGroupFormat.isEmpty()) {
            this.SUB_GROUP_FORMAT = new ArrayList<String>();
            this.SUB_GROUP_FORMAT.add("BbBBBBRSB");
            this.SUB_GROUP_FORMAT.add("iiiiiiiii");
            this.SUB_GROUP_FORMAT.add("iiiiiiiii");
            this.SUB_GROUP_FORMAT.add("iiiiiiiii");
            this.SUB_GROUP_FORMAT.add("iiiiiiiii");
            this.SUB_GROUP_FORMAT.add("BPBcCBBNB");
        } else {
            this.SUB_GROUP_FORMAT = rawSubGroupFormat;
        }
        List rawRecipeFormat = cfg.getStringList("custom-format.recipe");
        if (rawRecipeFormat == null || rawRecipeFormat.isEmpty()) {
            this.RECIPE_FORMAT = new ArrayList<String>();
            this.RECIPE_FORMAT.add("b  rrr  w");
            this.RECIPE_FORMAT.add(" t rrr i ");
            this.RECIPE_FORMAT.add("m  rrr  E");
        } else {
            ArrayList<String> old = new ArrayList<String>();
            old.add("b  rrr  w");
            old.add(" t rrr i ");
            old.add("   rrr  E");
            ArrayList<String> n = new ArrayList<String>();
            n.add("b  rrr  w");
            n.add(" t rrr i ");
            n.add("m  rrr  E");
            if (rawRecipeFormat.equals(old)) {
                cfg.set("custom-format.recipe", n);
                this.RECIPE_FORMAT = n;
            } else {
                this.RECIPE_FORMAT = rawRecipeFormat;
            }
        }
        List rawHelperFormat = cfg.getStringList("custom-format.helper");
        if (rawHelperFormat == null || rawHelperFormat.isEmpty()) {
            this.HELPER_FORMAT = new ArrayList<String>();
            this.HELPER_FORMAT.add("BbBBBBRSB");
            this.HELPER_FORMAT.add("B   A   B");
            this.HELPER_FORMAT.add("BhhhhhhhB");
            this.HELPER_FORMAT.add("BhhhhhhhB");
            this.HELPER_FORMAT.add("BhhhhhhhB");
            this.HELPER_FORMAT.add("BPBBCBBNB");
        } else {
            this.HELPER_FORMAT = rawHelperFormat;
        }
        List rawRecipeVanillaFormat = cfg.getStringList("custom-format.recipe-vanilla");
        if (rawRecipeVanillaFormat == null || rawRecipeVanillaFormat.isEmpty()) {
            this.RECIPE_VANILLA_FORMAT = new ArrayList<String>();
            this.RECIPE_VANILLA_FORMAT.add("b  rrr  w");
            this.RECIPE_VANILLA_FORMAT.add(" t rrr i ");
            this.RECIPE_VANILLA_FORMAT.add("   rrr   ");
            this.RECIPE_VANILLA_FORMAT.add("BPBBBBBNB");
        } else {
            this.RECIPE_VANILLA_FORMAT = rawRecipeVanillaFormat;
        }
        List rawRecipeDisplayFormat = cfg.getStringList("custom-format.recipe-display");
        if (rawRecipeDisplayFormat == null || rawRecipeDisplayFormat.isEmpty()) {
            this.RECIPE_DISPLAY_FORMAT = new ArrayList<String>();
            this.RECIPE_DISPLAY_FORMAT.add("b  rrr  w");
            this.RECIPE_DISPLAY_FORMAT.add(" t rrr i ");
            this.RECIPE_DISPLAY_FORMAT.add("m  rrr  E");
            this.RECIPE_DISPLAY_FORMAT.add("BPBBBBBNB");
            this.RECIPE_DISPLAY_FORMAT.add("ddddddddd");
            this.RECIPE_DISPLAY_FORMAT.add("ddddddddd");
        } else {
            ArrayList<String> old = new ArrayList<String>();
            old.add("b  rrr  w");
            old.add(" t rrr i ");
            old.add("   rrr  E");
            old.add("BPBBBBBNB");
            old.add("ddddddddd");
            old.add("ddddddddd");
            ArrayList<String> n = new ArrayList<String>();
            n.add("b  rrr  w");
            n.add(" t rrr i ");
            n.add("m  rrr  E");
            n.add("BPBBBBBNB");
            n.add("ddddddddd");
            n.add("ddddddddd");
            if (rawRecipeDisplayFormat.equals(old)) {
                cfg.set("custom-format.recipe-display", n);
                this.RECIPE_DISPLAY_FORMAT = n;
            } else {
                this.RECIPE_DISPLAY_FORMAT = rawRecipeDisplayFormat;
            }
        }
        List rawSettingsFormat = cfg.getStringList("custom-format.settings");
        if (rawSettingsFormat == null || rawSettingsFormat.isEmpty()) {
            this.SETTINGS_FORMAT = new ArrayList<String>();
            this.SETTINGS_FORMAT.add("bBsBvBuBW");
            this.SETTINGS_FORMAT.add("BBBBBBBBB");
            this.SETTINGS_FORMAT.add("BoooooooB");
            this.SETTINGS_FORMAT.add("BoooooooB");
            this.SETTINGS_FORMAT.add("BPBBBBBNB");
            this.SETTINGS_FORMAT.add("BBlBBBUBB");
        } else {
            this.SETTINGS_FORMAT = rawSettingsFormat;
        }
        List rawContributorsFormat = cfg.getStringList("custom-format.contributors");
        if (rawContributorsFormat == null || rawContributorsFormat.isEmpty()) {
            this.CONTRIBUTORS_FORMAT = new ArrayList<String>();
            this.CONTRIBUTORS_FORMAT.add("BbBBBBBBB");
            this.CONTRIBUTORS_FORMAT.add("ppppppppp");
            this.CONTRIBUTORS_FORMAT.add("ppppppppp");
            this.CONTRIBUTORS_FORMAT.add("ppppppppp");
            this.CONTRIBUTORS_FORMAT.add("ppppppppp");
            this.CONTRIBUTORS_FORMAT.add("BPBBBBBNB");
        } else {
            this.CONTRIBUTORS_FORMAT = rawContributorsFormat;
        }
        this.LOCAL_TRANSLATE = new HashMap<String, String>();
        ConfigurationSection c = cfg.getConfigurationSection("local-translate");
        if (c != null) {
            for (String k : c.getKeys(false)) {
                this.LOCAL_TRANSLATE.put(k, c.getString(k));
            }
        }
        this.BANLIST = cfg.getStringList("banlist");
        this.EMC_VALUE_DISPLAY = cfg.getBoolean("improvements.emc-display-option", true);
        this.FinalTech_VALUE_DISPLAY = cfg.getBoolean("improvements.finaltech-emc-display-option", true);
        this.FinalTECH_VALUE_DISPLAY = cfg.getBoolean("improvements.finalTECH-emc-display-option", true);
        this.LANGUAGE = cfg.getString("language", "en-US");
        this.ITEM_SHAREABLE = cfg.getBoolean("improvements.item-shareable", true);
    }

    @ParametersAreNonnullByDefault
    public static void checkKey(FileConfiguration existingConfig, FileConfiguration resourceConfig, String key) {
        Object currentValue = existingConfig.get(key);
        Object newValue = resourceConfig.get(key);
        if (newValue instanceof ConfigurationSection) {
            ConfigurationSection section = (ConfigurationSection)newValue;
            for (String sectionKey : section.getKeys(false)) {
                ConfigManager.checkKey(existingConfig, resourceConfig, key + "." + sectionKey);
            }
        } else if (currentValue == null) {
            existingConfig.set(key, newValue);
        }
    }

    private void setupDefaultConfig() {
        InputStream inputStream = this.plugin.getResource("config.yml");
        File existingFile = new File(this.plugin.getDataFolder(), "config.yml");
        if (inputStream == null) {
            return;
        }
        InputStreamReader reader = new InputStreamReader(inputStream);
        YamlConfiguration resourceConfig = YamlConfiguration.loadConfiguration((Reader)reader);
        YamlConfiguration existingConfig = YamlConfiguration.loadConfiguration((File)existingFile);
        for (String key : resourceConfig.getKeys(false)) {
            ConfigManager.checkKey((FileConfiguration)existingConfig, (FileConfiguration)resourceConfig, key);
        }
        try {
            existingConfig.save(existingFile);
        }
        catch (IOException e) {
            Debug.trace(e);
        }
    }

    public boolean isAutoUpdate() {
        return this.AUTO_UPDATE;
    }

    public boolean isDebug() {
        return this.DEBUG;
    }

    public boolean isSurvivalImprovement() {
        return this.SURVIVAL_IMPROVEMENTS;
    }

    public boolean isCheatImprovement() {
        return this.CHEAT_IMPROVEMENTS;
    }

    public boolean isPinyinSearch() {
        return this.PINYIN_SEARCH;
    }

    public boolean isBookmark() {
        return this.BOOKMARK;
    }

    public boolean isBeginnerOption() {
        return this.BEGINNER_OPTION;
    }

    @NotNull
    public String getSurvivalGuideTitle() {
        return this.SURVIVAL_GUIDE_TITLE;
    }

    @NotNull
    public String getCheatGuideTitle() {
        return this.CHEAT_GUIDE_TITLE;
    }

    @NotNull
    public String getSettingsGuideTitle() {
        return this.SETTINGS_GUIDE_TITLE;
    }

    @NotNull
    public String getCreditsGuideTitle() {
        return this.CREDITS_GUIDE_TITLE;
    }

    public boolean isRTSSearch() {
        return this.RTS_SEARCH;
    }

    @Warn(reason="No longer using it in EN version")
    @NotNull
    public List<String> getSharedChars() {
        return this.SHARED_CHARS;
    }

    @NotNull
    public List<String> getSharedWords() {
        return this.SHARED_WORDS;
    }

    @NotNull
    public List<String> getBlacklist() {
        return this.BLACKLIST;
    }

    @NotNull
    public List<String> getMainFormat() {
        return this.MAIN_FORMAT;
    }

    @NotNull
    public List<String> getNestedGroupFormat() {
        return this.NESTED_GROUP_FORMAT;
    }

    @NotNull
    public List<String> getSubGroupFormat() {
        return this.SUB_GROUP_FORMAT;
    }

    @NotNull
    public List<String> getRecipeFormat() {
        return this.RECIPE_FORMAT;
    }

    @NotNull
    public List<String> getHelperFormat() {
        return this.HELPER_FORMAT;
    }

    @NotNull
    public List<String> getRecipeVanillaFormat() {
        return this.RECIPE_VANILLA_FORMAT;
    }

    @NotNull
    public List<String> getRecipeDisplayFormat() {
        return this.RECIPE_DISPLAY_FORMAT;
    }

    @NotNull
    public List<String> getSettingsFormat() {
        return this.SETTINGS_FORMAT;
    }

    @NotNull
    public List<String> getContributorsFormat() {
        return this.CONTRIBUTORS_FORMAT;
    }

    @NotNull
    public Map<String, String> getLocalTranslate() {
        return this.LOCAL_TRANSLATE;
    }

    @NotNull
    public List<String> getBanlist() {
        return this.BANLIST;
    }

    public boolean isRecipeComplete() {
        return this.RECIPE_COMPLETE;
    }

    public boolean isEMCValueDisplay() {
        return this.EMC_VALUE_DISPLAY;
    }

    public boolean isFinalTechValueDisplay() {
        return this.FinalTech_VALUE_DISPLAY;
    }

    public boolean isFinalTECHValueDisplay() {
        return this.FinalTECH_VALUE_DISPLAY;
    }

    @NotNull
    public String getLanguage() {
        return this.LANGUAGE;
    }

    public boolean isItemShareable() {
        return this.ITEM_SHAREABLE;
    }
}

