/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.utils.clickhandler;

import com.balugaq.jeg.api.clickhandler.JEGClickHandler;
import com.balugaq.jeg.api.clickhandler.Processor;
import com.balugaq.jeg.api.objects.events.GuideEvents;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.implementation.option.BeginnersGuideOption;
import com.balugaq.jeg.utils.EventUtil;
import com.balugaq.jeg.utils.clickhandler.Applier;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class BeginnerUtils
implements Applier {
    private static final BeginnerUtils instance = new BeginnerUtils();

    private BeginnerUtils() {
    }

    public static void applyWith(@NotNull SlimefunGuideImplementation guide, @NotNull ChestMenu menu, int slot) {
        instance.apply(guide, menu, slot);
    }

    public static boolean isNew(Player player) {
        return BeginnersGuideOption.isEnabled(player);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void apply(SlimefunGuideImplementation guide, ChestMenu menu, int slot) {
        if (!JustEnoughGuide.getConfigManager().isBeginnerOption()) {
            return;
        }
        menu.addMenuClickHandler(slot, (ChestMenu.MenuClickHandler)JEGClickHandler.of(guide, menu, slot).addProcessor(BeginnerProcessor.getInstance()));
    }

    public static class BeginnerProcessor
    extends Processor {
        private static final BeginnerProcessor instance = new BeginnerProcessor();

        public BeginnerProcessor() {
            super(Processor.Strategy.HEAD);
        }

        @Override
        public boolean process(@NotNull SlimefunGuideImplementation guide, @NotNull ChestMenu menu, @NotNull InventoryClickEvent event, @NotNull Player player, @Range(from=0L, to=53L) int clickedSlot, @Nullable ItemStack clickedItemStack, @NotNull ClickAction clickAction, @Nullable Boolean processedResult) {
            if (BeginnerUtils.isNew(player) && clickAction.isShiftClicked() && clickAction.isRightClicked() && clickedItemStack != null && clickedItemStack.getType() != Material.AIR) {
                return EventUtil.callEvent(new GuideEvents.BeginnerButtonClickEvent(player, clickedItemStack, clickedSlot, clickAction, menu, guide)).ifSuccess(() -> {
                    PlayerProfile.get((OfflinePlayer)player, profile -> guide.openSearch(profile, ChatColor.stripColor((String)ItemUtils.getItemName((ItemStack)clickedItemStack)), true));
                    return false;
                });
            }
            return true;
        }

        @Generated
        public static BeginnerProcessor getInstance() {
            return instance;
        }
    }
}

