/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.implementation.option.delegate;

import com.balugaq.jeg.api.patches.JEGGuideSettings;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuide;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.core.guide.options.SlimefunGuideOption;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class GuideModeOption
implements SlimefunGuideOption<SlimefunGuideMode> {
    @NotNull
    public SlimefunAddon getAddon() {
        return JustEnoughGuide.getInstance();
    }

    @NotNull
    public NamespacedKey getKey() {
        return new NamespacedKey((Plugin)Slimefun.instance(), "guide_mode");
    }

    @NotNull
    public Optional<ItemStack> getDisplayItem(Player p, ItemStack guide) {
        if (!p.hasPermission("slimefun.cheat.items")) {
            return Optional.empty();
        }
        Optional<SlimefunGuideMode> current = this.getSelectedOption(p, guide);
        if (current.isPresent()) {
            SlimefunGuideMode selectedMode = current.get();
            ItemStack item = new ItemStack(Material.AIR);
            if (selectedMode == SlimefunGuideMode.SURVIVAL_MODE) {
                item.setType(Material.CHEST);
            } else {
                item.setType(Material.COMMAND_BLOCK);
            }
            ItemMeta meta = item.getItemMeta();
            ChatColor var10001 = ChatColor.GRAY;
            meta.setDisplayName(String.valueOf(var10001) + "Slimefun Guide Type: " + String.valueOf(ChatColor.YELLOW) + ChatUtils.humanize((String)selectedMode.name()));
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add("");
            var10001 = selectedMode == SlimefunGuideMode.SURVIVAL_MODE ? ChatColor.GREEN : ChatColor.GRAY;
            lore.add(String.valueOf(var10001) + "Survival Mode");
            lore.add(String.valueOf(selectedMode == SlimefunGuideMode.CHEAT_MODE ? ChatColor.GREEN : ChatColor.GRAY) + "Cheat Sheet");
            lore.add("");
            lore.add(String.valueOf(ChatColor.GRAY) + "\u21e8 " + String.valueOf(ChatColor.YELLOW) + "Click to change the type");
            meta.setLore(lore);
            item.setItemMeta(meta);
            return Optional.of(item);
        }
        return Optional.empty();
    }

    public void onClick(@NotNull Player p, @NotNull ItemStack guide) {
        Optional<SlimefunGuideMode> current = this.getSelectedOption(p, guide);
        if (current.isPresent()) {
            SlimefunGuideMode next = this.getNextMode(p, current.get());
            this.setSelectedOption(p, guide, next);
        }
        JEGGuideSettings.openSettings(p, guide);
    }

    @NotNull
    private SlimefunGuideMode getNextMode(@NotNull Player p, @NotNull SlimefunGuideMode mode) {
        if (p.hasPermission("slimefun.cheat.items")) {
            return mode == SlimefunGuideMode.SURVIVAL_MODE ? SlimefunGuideMode.CHEAT_MODE : SlimefunGuideMode.SURVIVAL_MODE;
        }
        return SlimefunGuideMode.SURVIVAL_MODE;
    }

    @NotNull
    public Optional<SlimefunGuideMode> getSelectedOption(@NotNull Player p, @NotNull ItemStack guide) {
        return SlimefunUtils.isItemSimilar((ItemStack)guide, (ItemStack)SlimefunGuide.getItem((SlimefunGuideMode)SlimefunGuideMode.CHEAT_MODE), (boolean)true, (boolean)false) ? Optional.of(SlimefunGuideMode.CHEAT_MODE) : Optional.of(SlimefunGuideMode.SURVIVAL_MODE);
    }

    @ParametersAreNonnullByDefault
    public void setSelectedOption(Player p, ItemStack guide, SlimefunGuideMode value) {
        guide.setItemMeta(SlimefunGuide.getItem((SlimefunGuideMode)value).getItemMeta());
    }
}

