/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.recipe_complete.source.base;

import com.balugaq.jeg.api.objects.events.GuideEvents;
import com.balugaq.jeg.api.recipe_complete.source.base.Source;
import com.balugaq.jeg.core.listeners.RecipeCompletableListener;
import com.balugaq.jeg.utils.GuideUtil;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public interface SlimefunSource
extends Source {
    public boolean handleable(@NotNull BlockMenu var1, @NotNull Player var2, @NotNull ClickAction var3, @Range(from=0L, to=53L) int @NotNull [] var4, boolean var5, int var6);

    @CanIgnoreReturnValue
    default public boolean openGuide(@NotNull BlockMenu blockMenu, @NotNull Player player, @NotNull ClickAction clickAction, @Range(from=0L, to=53L) int @NotNull [] ingredientSlots, boolean unordered, int recipeDepth) {
        return this.openGuide(blockMenu, player, clickAction, ingredientSlots, unordered, recipeDepth, null);
    }

    default public boolean openGuide(@NotNull BlockMenu blockMenu, @NotNull Player player, @NotNull ClickAction clickAction, int @NotNull [] ingredientSlots, boolean unordered, int recipeDepth, @Nullable Runnable callback) {
        GuideEvents.ItemButtonClickEvent lastEvent = RecipeCompletableListener.getLastEvent(player.getUniqueId());
        if (clickAction.isRightClicked() && lastEvent != null) {
            BlockMenu actualMenu;
            int times = 1;
            if (clickAction.isShiftClicked()) {
                times = 64;
            }
            if ((actualMenu = BlockStorage.getInventory((Location)blockMenu.getLocation())) == null) {
                if (callback != null) {
                    callback.run();
                }
                return false;
            }
            if (!actualMenu.getPreset().getID().equals(blockMenu.getPreset().getID())) {
                if (callback != null) {
                    callback.run();
                }
                return false;
            }
            for (int i = 0; i < times; ++i) {
                this.completeRecipeWithGuide(actualMenu, lastEvent, ingredientSlots, unordered, recipeDepth);
            }
            if (callback != null) {
                callback.run();
            }
            return true;
        }
        GuideUtil.openMainMenuAsync(player, SlimefunGuideMode.SURVIVAL_MODE, 1);
        RecipeCompletableListener.addCallback(player.getUniqueId(), (event, profile) -> {
            BlockMenu actualMenu = BlockStorage.getInventory((Location)blockMenu.getLocation());
            if (actualMenu == null) {
                if (callback != null) {
                    callback.run();
                }
                return;
            }
            if (!actualMenu.getPreset().getID().equals(blockMenu.getPreset().getID())) {
                if (callback != null) {
                    callback.run();
                }
                return;
            }
            int times = 1;
            if (event.getClickAction().isRightClicked()) {
                times = 64;
            }
            for (int i = 0; i < times; ++i) {
                this.completeRecipeWithGuide(actualMenu, (GuideEvents.ItemButtonClickEvent)((Object)event), ingredientSlots, unordered, recipeDepth);
            }
            player.updateInventory();
            actualMenu.open(new Player[]{player});
            if (callback != null) {
                callback.run();
            }
        });
        RecipeCompletableListener.tagGuideOpen(player);
        return true;
    }

    @CanIgnoreReturnValue
    public boolean completeRecipeWithGuide(@NotNull BlockMenu var1, @NotNull GuideEvents.ItemButtonClickEvent var2, @Range(from=0L, to=53L) int @NotNull [] var3, boolean var4, int var5);
}

