/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.utils.formatter;

import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.utils.ItemStackUtil;
import com.balugaq.jeg.utils.formatter.ContributorsFormat;
import com.balugaq.jeg.utils.formatter.Format;
import com.balugaq.jeg.utils.formatter.HelperFormat;
import com.balugaq.jeg.utils.formatter.MainFormat;
import com.balugaq.jeg.utils.formatter.NestedGroupFormat;
import com.balugaq.jeg.utils.formatter.RecipeDisplayFormat;
import com.balugaq.jeg.utils.formatter.RecipeFormat;
import com.balugaq.jeg.utils.formatter.RecipeVanillaFormat;
import com.balugaq.jeg.utils.formatter.SettingsFormat;
import com.balugaq.jeg.utils.formatter.SubGroupFormat;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class Formats {
    public static final String FILE_NAME = "custom-icons.yml";
    public static final File fileCustomIcons = new File(JustEnoughGuide.getInstance().getDataFolder(), "custom-icons.yml");
    public static final Map<String, Format> customFormats = new HashMap<String, Format>();
    public static final MainFormat main = new MainFormat();
    public static final NestedGroupFormat nested = new NestedGroupFormat();
    public static final SubGroupFormat sub = new SubGroupFormat();
    public static final RecipeFormat recipe = new RecipeFormat();
    public static final HelperFormat helper = new HelperFormat();
    public static final RecipeVanillaFormat recipe_vanilla = new RecipeVanillaFormat();
    public static final RecipeDisplayFormat recipe_display = new RecipeDisplayFormat();
    public static final SettingsFormat settings = new SettingsFormat();
    public static final ContributorsFormat contributors = new ContributorsFormat();

    public static void loadCustomIcon() {
        if (!fileCustomIcons.exists()) {
            JustEnoughGuide.getInstance().saveResource(FILE_NAME, false);
            JustEnoughGuide.getInstance().getLogger().info("Created custom-icons.yml");
        }
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)fileCustomIcons);
        Set keys = configuration.getKeys(false);
        for (String key : keys) {
            if (key.length() > 1) {
                JustEnoughGuide.getInstance().getLogger().warning("custom-icons.yml: Invalid Icon Character: " + key);
                continue;
            }
            char c = key.charAt(0);
            ItemStack read = ItemStackUtil.readItem(c, configuration.getConfigurationSection(key));
            if (read == null) continue;
            Format.customMapping.put(Character.valueOf(c), read);
        }
    }

    public static void addCustomFormat(String id, Format format) {
        customFormats.put(id, format);
    }

    public static void unload() {
        customFormats.clear();
        Format.customMapping.clear();
    }

    static {
        main.loadMapping();
        nested.loadMapping();
        sub.loadMapping();
        recipe.loadMapping();
        helper.loadMapping();
        recipe_vanilla.loadMapping();
        recipe_display.loadMapping();
        settings.loadMapping();
        contributors.loadMapping();
        Formats.loadCustomIcon();
    }
}

