/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.utils;

import com.balugaq.jeg.utils.Debug;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class EventUtil {
    @NotNull
    public static <T extends Event> EventBuilder<T> callEvent(@NotNull T event) {
        return new EventBuilder<T>(event);
    }

    public static class EventBuilder<T extends Event> {
        @NotNull
        private final T event;

        public EventBuilder(@NotNull T event) {
            this.event = event;
            try {
                Bukkit.getPluginManager().callEvent(event);
            }
            catch (Exception e) {
                Debug.trace(e);
            }
        }

        public boolean ifSuccess(@NotNull Runnable runnable) {
            T t = this.event;
            if (t instanceof Cancellable) {
                Cancellable cancellable = (Cancellable)t;
                if (cancellable.isCancelled()) {
                    return true;
                }
                runnable.run();
                return false;
            }
            return true;
        }

        public boolean ifCancelled(@NotNull Runnable runnable) {
            T t = this.event;
            if (t instanceof Cancellable) {
                Cancellable cancellable = (Cancellable)t;
                if (cancellable.isCancelled()) {
                    runnable.run();
                    return true;
                }
                return false;
            }
            return true;
        }

        public boolean thenRun(@NotNull Runnable runnable) {
            runnable.run();
            return true;
        }

        public boolean ifSuccess(@NotNull Consumer<T> consumer) {
            T t = this.event;
            if (t instanceof Cancellable) {
                Cancellable cancellable = (Cancellable)t;
                if (cancellable.isCancelled()) {
                    return true;
                }
                consumer.accept(this.event);
                return false;
            }
            return true;
        }

        public boolean ifCancelled(@NotNull Consumer<T> consumer) {
            T t = this.event;
            if (t instanceof Cancellable) {
                Cancellable cancellable = (Cancellable)t;
                if (cancellable.isCancelled()) {
                    consumer.accept(this.event);
                    return true;
                }
                return false;
            }
            return true;
        }

        public boolean thenRun(@NotNull Consumer<T> consumer) {
            consumer.accept(this.event);
            return true;
        }

        public boolean thenRun(@NotNull Function<T, Boolean> function) {
            return function.apply(this.event);
        }

        public boolean ifSuccess(@NotNull Function<T, Boolean> function) {
            T t = this.event;
            if (t instanceof Cancellable) {
                Cancellable cancellable = (Cancellable)t;
                if (cancellable.isCancelled()) {
                    return false;
                }
                return function.apply(this.event);
            }
            return function.apply(this.event);
        }

        public boolean ifCancelled(@NotNull Function<T, Boolean> function) {
            T t = this.event;
            if (t instanceof Cancellable) {
                Cancellable cancellable = (Cancellable)t;
                if (cancellable.isCancelled()) {
                    return function.apply(this.event);
                }
                return false;
            }
            return false;
        }

        public boolean ifSuccess(@NotNull Supplier<Boolean> callable) {
            T t = this.event;
            if (t instanceof Cancellable) {
                Cancellable cancellable = (Cancellable)t;
                if (cancellable.isCancelled()) {
                    return false;
                }
                return callable.get();
            }
            return callable.get();
        }

        public boolean ifCancelled(@NotNull Supplier<Boolean> callable) {
            T t = this.event;
            if (t instanceof Cancellable) {
                Cancellable cancellable = (Cancellable)t;
                if (cancellable.isCancelled()) {
                    return callable.get();
                }
                return false;
            }
            return false;
        }

        public boolean ifSuccess(boolean result) {
            T t = this.event;
            if (t instanceof Cancellable) {
                Cancellable cancellable = (Cancellable)t;
                if (cancellable.isCancelled()) {
                    return false;
                }
                return result;
            }
            return result;
        }

        public boolean ifCancelled(boolean result) {
            T t = this.event;
            if (t instanceof Cancellable) {
                Cancellable cancellable = (Cancellable)t;
                if (cancellable.isCancelled()) {
                    return result;
                }
                return false;
            }
            return false;
        }

        @NotNull
        @Generated
        public T getEvent() {
            return this.event;
        }
    }
}

