/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.core.listeners;

import com.balugaq.jeg.api.objects.annotations.PatchCode;
import com.balugaq.jeg.api.patches.JEGGuideSettings;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.utils.Debug;
import com.balugaq.jeg.utils.GuideUtil;
import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.api.events.SlimefunGuideOpenEvent;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuide;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class GuideListener
implements Listener {
    public static final int OPEN_GUIDE_DEFAULT_FATAL_ERROR_CODE = 12208;
    public static final int OPEN_GUIDE_ASYNC_FATAL_ERROR_CODE = 12209;
    public static final int OPEN_GUIDE_SYNC_FATAL_ERROR_CODE = 12210;
    public static final Map<Player, SlimefunGuideMode> guideModeMap = new ConcurrentHashMap<Player, SlimefunGuideMode>();
    public final boolean giveOnFirstJoin = Slimefun.getCfg().getBoolean("guide.receive-on-first-join");

    @PatchCode(value="io.github.thebusybiscuit.slimefun4.implementation.listeners.SlimefunGuideListener.tryOpenGuide(Player, PlayerRightClickEvent, SlimefunGuideMode)")
    @ParametersAreNonnullByDefault
    @NotNull
    @ApiStatus.Internal
    public static Event.Result tryOpenGuide(Player p, PlayerRightClickEvent e, SlimefunGuideMode layout) {
        ItemStack item = e.getItem();
        if (SlimefunUtils.isItemSimilar((ItemStack)item, (ItemStack)SlimefunGuide.getItem((SlimefunGuideMode)layout), (boolean)false, (boolean)false)) {
            if (!Slimefun.getWorldSettingsService().isWorldEnabled(p.getWorld())) {
                Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.disabled-item", true);
                return Event.Result.DENY;
            }
            return Event.Result.ALLOW;
        }
        return Event.Result.DEFAULT;
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onGuideOpen(@NotNull SlimefunGuideOpenEvent e) {
        if (!e.isCancelled()) {
            e.setCancelled(true);
            Player p = e.getPlayer();
            SlimefunGuideMode mode = e.getGuideLayout();
            try {
                this.openGuide(p, mode);
            }
            catch (Throwable ex) {
                try {
                    this.openGuideAsync(p, mode);
                }
                catch (Throwable ex2) {
                    try {
                        this.openGuideSync(p, mode);
                    }
                    catch (Throwable ex3) {
                        Debug.traceExactly(ex, "opening guide", 12208);
                        Debug.traceExactly(ex2, "opening guide asynchronously", 12209);
                        Debug.traceExactly(ex3, "opening guide synchronously", 12210);
                        PlayerProfile.find((OfflinePlayer)e.getPlayer()).ifPresent(profile -> GuideUtil.removeLastEntry(profile.getGuideHistory()));
                    }
                }
            }
        }
    }

    @ApiStatus.Internal
    public void openGuide(@NotNull Player player, @NotNull SlimefunGuideMode mode) {
        Optional optional = PlayerProfile.find((OfflinePlayer)player);
        if (optional.isPresent()) {
            PlayerProfile profile = (PlayerProfile)optional.get();
            SlimefunGuideImplementation guide = GuideUtil.getGuide(player, mode);
            SlimefunGuideMode lastMode = guideModeMap.get(player);
            guideModeMap.put(player, mode);
            if (lastMode != mode) {
                GuideUtil.openMainMenu(player, profile, mode, 1);
            } else {
                profile.getGuideHistory().openLastEntry(guide);
            }
        } else {
            GuideUtil.openMainMenuAsync(player, mode, 1);
        }
    }

    @ApiStatus.Internal
    public void openGuideAsync(@NotNull Player player, @NotNull SlimefunGuideMode mode) {
        JustEnoughGuide.runLaterAsync(() -> {
            Optional optional = PlayerProfile.find((OfflinePlayer)player);
            if (optional.isPresent()) {
                PlayerProfile profile = (PlayerProfile)optional.get();
                SlimefunGuideImplementation guide = GuideUtil.getGuide(player, mode);
                SlimefunGuideMode lastMode = guideModeMap.get(player);
                guideModeMap.put(player, mode);
                if (lastMode != mode) {
                    GuideUtil.openMainMenu(player, profile, mode, 1);
                } else {
                    profile.getGuideHistory().openLastEntry(guide);
                }
            } else {
                GuideUtil.openMainMenuAsync(player, mode, 1);
            }
        }, 1L);
    }

    @ApiStatus.Internal
    public void openGuideSync(@NotNull Player player, @NotNull SlimefunGuideMode mode) {
        JustEnoughGuide.runLater(() -> {
            Optional optional = PlayerProfile.find((OfflinePlayer)player);
            if (optional.isPresent()) {
                PlayerProfile profile = (PlayerProfile)optional.get();
                SlimefunGuideImplementation guide = GuideUtil.getGuide(player, mode);
                SlimefunGuideMode lastMode = guideModeMap.get(player);
                guideModeMap.put(player, mode);
                if (lastMode != mode) {
                    GuideUtil.openMainMenu(player, profile, mode, 1);
                } else {
                    profile.getGuideHistory().openLastEntry(guide);
                }
            } else {
                GuideUtil.openMainMenuAsync(player, mode, 1);
            }
        }, 1L);
    }

    @PatchCode(value="io.github.thebusybiscuit.slimefun4.implementation.listeners.SlimefunGuideListener.onInteract(PlayerRightClickEvent)")
    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onInteract(@NotNull PlayerRightClickEvent e) {
        Player p = e.getPlayer();
        if (GuideListener.tryOpenGuide(p, e, SlimefunGuideMode.SURVIVAL_MODE) == Event.Result.ALLOW) {
            if (p.isSneaking()) {
                JEGGuideSettings.openSettings(p, e.getItem());
            } else {
                SlimefunGuideOpenEvent event = new SlimefunGuideOpenEvent(p, e.getItem(), SlimefunGuideMode.SURVIVAL_MODE);
                Bukkit.getPluginManager().callEvent((Event)event);
            }
        } else if (GuideListener.tryOpenGuide(p, e, SlimefunGuideMode.CHEAT_MODE) == Event.Result.ALLOW) {
            if (p.isSneaking()) {
                JEGGuideSettings.openSettings(p, p.hasPermission("slimefun.cheat.items") ? e.getItem() : SlimefunGuide.getItem((SlimefunGuideMode)SlimefunGuideMode.SURVIVAL_MODE));
            } else {
                p.chat("/sf cheat");
            }
        }
    }

    @PatchCode(value="io.github.thebusybiscuit.slimefun4.implementation.listeners.SlimefunGuideListener.onJoin(PlayerJoinEvent)")
    @EventHandler
    public void onJoin(@NotNull PlayerJoinEvent e) {
        if (this.giveOnFirstJoin && !e.getPlayer().hasPlayedBefore()) {
            Player p = e.getPlayer();
            if (!Slimefun.getWorldSettingsService().isWorldEnabled(p.getWorld())) {
                return;
            }
            SlimefunGuideMode type = SlimefunGuide.getDefaultMode();
            p.getInventory().addItem(new ItemStack[]{SlimefunGuide.getItem((SlimefunGuideMode)type).clone()});
        }
    }

    @Generated
    public boolean isGiveOnFirstJoin() {
        return this.giveOnFirstJoin;
    }
}

