/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.core.integrations.finaltechs.finalTECHCommon;

import com.balugaq.jeg.api.objects.enums.PatchScope;
import com.balugaq.jeg.api.objects.events.PatchEvent;
import com.balugaq.jeg.core.integrations.finaltechs.finalTECHCommon.FinalTECHValueDisplayOption;
import com.balugaq.jeg.utils.Debug;
import com.balugaq.jeg.utils.ReflectionUtil;
import com.balugaq.jeg.utils.StackUtils;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import java.util.ArrayList;
import java.util.EnumSet;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FinalTECHItemPatchListener
implements Listener {
    public static final EnumSet<PatchScope> VALID_SCOPES = EnumSet.of(PatchScope.SlimefunItem, PatchScope.ItemMarkItem, PatchScope.BookMarkItem, PatchScope.SearchItem, PatchScope.ItemRecipeIngredient);
    public static final String DEFAULT_INPUT_VALUE = "0";
    public static final String DEFAULT_OUTPUT_VALUE = "INFINITY";
    public static Class<?> class_ItemValueTable = null;
    public static Object ItemValueTableInstance = null;

    public static boolean initValueTable() {
        if (class_ItemValueTable == null) {
            try {
                class_ItemValueTable = Class.forName("io.taraxacum.libs.slimefun.dto.ItemValueTable");
            }
            catch (ClassNotFoundException e) {
                Debug.trace(e);
                return false;
            }
        }
        if (ItemValueTableInstance == null) {
            ItemValueTableInstance = ReflectionUtil.invokeStaticMethod(class_ItemValueTable, "getInstance", new Object[0]);
        }
        return ItemValueTableInstance != null;
    }

    public static String getOrCalItemInputValue(@Nullable ItemStack itemStack) {
        if (!FinalTECHItemPatchListener.initValueTable()) {
            return DEFAULT_INPUT_VALUE;
        }
        if (itemStack == null) {
            return DEFAULT_INPUT_VALUE;
        }
        return (String)ReflectionUtil.invokeMethod(ItemValueTableInstance, "getOrCalItemInputValue", itemStack);
    }

    public static String getOrCalItemOutputValue(@Nullable ItemStack itemStack) {
        if (!FinalTECHItemPatchListener.initValueTable()) {
            return DEFAULT_OUTPUT_VALUE;
        }
        if (itemStack == null) {
            return DEFAULT_OUTPUT_VALUE;
        }
        return (String)ReflectionUtil.invokeMethod(ItemValueTableInstance, "getOrCalItemOutputValue", itemStack);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void patchItem(@NotNull PatchEvent event) {
        PatchScope scope = event.getPatchScope();
        if (this.notValid(scope)) {
            return;
        }
        Player player = event.getPlayer();
        if (this.disabledOption(player)) {
            return;
        }
        this.patchItem(event.getItemStack(), scope);
    }

    public boolean notValid(@NotNull PatchScope patchScope) {
        return !VALID_SCOPES.contains((Object)patchScope);
    }

    public boolean disabledOption(@NotNull Player player) {
        return !FinalTECHValueDisplayOption.isEnabled(player);
    }

    public void patchItem(@Nullable ItemStack itemStack, @NotNull PatchScope scope) {
        if (itemStack == null) {
            return;
        }
        if (scope == PatchScope.ItemRecipeIngredient && StackUtils.itemsMatch(itemStack, new ItemStack(itemStack.getType()))) {
            return;
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return;
        }
        String inputEmc = FinalTECHItemPatchListener.getOrCalItemInputValue(itemStack);
        String outputEmc = FinalTECHItemPatchListener.getOrCalItemOutputValue(itemStack);
        ArrayList<String> lore = meta.getLore();
        if (lore == null) {
            lore = new ArrayList<String>();
        }
        lore.add(ChatColors.color((String)("&7FinalTECH Input EMC: &6" + inputEmc)));
        lore.add(ChatColors.color((String)("&7FinalTECH Output EMC: &6" + outputEmc)));
        meta.setLore(lore);
        itemStack.setItemMeta(meta);
    }
}

