/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.implementation;

import com.balugaq.jeg.api.interfaces.JEGSlimefunGuideImplementation;
import com.balugaq.jeg.core.managers.BookmarkManager;
import com.balugaq.jeg.core.managers.CommandManager;
import com.balugaq.jeg.core.managers.ConfigManager;
import com.balugaq.jeg.core.managers.IntegrationManager;
import com.balugaq.jeg.core.managers.ListenerManager;
import com.balugaq.jeg.core.managers.RTSBackpackManager;
import com.balugaq.jeg.implementation.guide.CheatGuideImplementation;
import com.balugaq.jeg.implementation.guide.SurvivalGuideImplementation;
import com.balugaq.jeg.implementation.items.GroupSetup;
import com.balugaq.jeg.utils.MinecraftVersion;
import com.balugaq.jeg.utils.ReflectionUtil;
import com.balugaq.jeg.utils.SlimefunOfficialSupporter;
import com.balugaq.jeg.utils.UUIDUtils;
import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.guide.CheatSheetSlimefunGuide;
import io.github.thebusybiscuit.slimefun4.implementation.guide.SurvivalSlimefunGuide;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.BlobBuildUpdater;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.EnumMap;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JustEnoughGuide
extends JavaPlugin
implements SlimefunAddon {
    public static final int RECOMMENDED_JAVA_VERSION = 17;
    public static final MinecraftVersion RECOMMENDED_MC_VERSION = MinecraftVersion.MINECRAFT_1_16;
    @Nullable
    private static JustEnoughGuide instance;
    @Nullable
    private static UUID serverUUID;
    @NotNull
    private final String username;
    @NotNull
    private final String repo;
    @NotNull
    private final String branch;
    @Nullable
    private BookmarkManager bookmarkManager;
    @Nullable
    private CommandManager commandManager;
    @Nullable
    private ConfigManager configManager;
    @Nullable
    private IntegrationManager integrationManager;
    @Nullable
    private ListenerManager listenerManager;
    @Nullable
    private RTSBackpackManager rtsBackpackManager;
    @Nullable
    private MinecraftVersion minecraftVersion;
    private int javaVersion;

    public JustEnoughGuide() {
        this.username = "balugaq";
        this.repo = "JustEnoughGuide";
        this.branch = "master";
    }

    public static BookmarkManager getBookmarkManager() {
        return JustEnoughGuide.getInstance().bookmarkManager;
    }

    public static CommandManager getCommandManager() {
        return JustEnoughGuide.getInstance().commandManager;
    }

    public static ConfigManager getConfigManager() {
        return JustEnoughGuide.getInstance().configManager;
    }

    public static IntegrationManager getIntegrationManager() {
        return JustEnoughGuide.getInstance().integrationManager;
    }

    public static ListenerManager getListenerManager() {
        return JustEnoughGuide.getInstance().listenerManager;
    }

    public static MinecraftVersion getMCVersion() {
        return JustEnoughGuide.getInstance().minecraftVersion;
    }

    @NotNull
    public static JustEnoughGuide getInstance() {
        Preconditions.checkArgument((instance != null ? 1 : 0) != 0, (Object)"JustEnoughGuide has not been enabled yet\uff01");
        return instance;
    }

    public void onEnable() {
        Preconditions.checkArgument((instance == null ? 1 : 0) != 0, (Object)"JustEnoughGuide has already been enabled!");
        instance = this;
        this.getLogger().info("Loading configuration...");
        this.saveDefaultConfig();
        this.configManager = new ConfigManager(this);
        this.configManager.onLoad();
        boolean isCompatible = this.environmentCheck();
        if (!isCompatible) {
            this.getLogger().warning("Environment check failed!");
            this.onDisable();
            return;
        }
        this.getLogger().info("Integrating with other plugins...");
        this.integrationManager = new IntegrationManager(this);
        this.integrationManager.onLoad();
        this.getLogger().info("Registering listeners...");
        this.listenerManager = new ListenerManager(this);
        this.listenerManager.onLoad();
        if (JustEnoughGuide.getConfigManager().isAutoUpdate() && this.getDescription().getVersion().startsWith("DEV - ")) {
            new BlobBuildUpdater((Plugin)this, this.getFile(), "JustEnoughGuide", "Dev").start();
        }
        this.getLogger().info("Registering commands...");
        this.commandManager = new CommandManager(this);
        this.commandManager.onLoad();
        if (!this.commandManager.registerCommands()) {
            this.getLogger().warning("Registering commands failed\uff01");
        }
        boolean survivalOverride = JustEnoughGuide.getConfigManager().isSurvivalImprovement();
        boolean cheatOverride = JustEnoughGuide.getConfigManager().isCheatImprovement();
        if (survivalOverride || cheatOverride) {
            this.getLogger().info("Enabled guide override!");
            this.getLogger().info("Overriding guide...");
            Field field = ReflectionUtil.getField(Slimefun.getRegistry().getClass(), "guides");
            if (field != null) {
                field.setAccessible(true);
                EnumMap<SlimefunGuideMode, JEGSlimefunGuideImplementation> newGuides = new EnumMap<SlimefunGuideMode, JEGSlimefunGuideImplementation>(SlimefunGuideMode.class);
                newGuides.put(SlimefunGuideMode.SURVIVAL_MODE, survivalOverride ? new SurvivalGuideImplementation() : new SurvivalSlimefunGuide(SlimefunOfficialSupporter.isShowVanillaRecipes(), SlimefunOfficialSupporter.isShowHiddenItemGroups()));
                newGuides.put(SlimefunGuideMode.CHEAT_MODE, cheatOverride ? new CheatGuideImplementation() : new CheatSheetSlimefunGuide());
                try {
                    field.set(Slimefun.getRegistry(), newGuides);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            this.getLogger().info(survivalOverride ? "Replaced survival guide!" : "Not replacing survival guide!");
            this.getLogger().info(cheatOverride ? "Replaced cheat guide!" : "Not replacing cheat guide!");
            this.getLogger().info("Loading collect groups...");
            this.bookmarkManager = new BookmarkManager((Plugin)this);
            this.bookmarkManager.onLoad();
            this.getLogger().info("Loading guide group...");
            GroupSetup.setup();
            this.getLogger().info("Loaded guide group!");
        }
        this.rtsBackpackManager = new RTSBackpackManager((Plugin)this);
        this.rtsBackpackManager.onLoad();
        File uuidFile = new File(this.getDataFolder(), "server-uuid");
        if (uuidFile.exists()) {
            try {
                serverUUID = UUID.nameUUIDFromBytes(Files.readAllBytes(Path.of(uuidFile.getPath(), new String[0])));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        serverUUID = UUID.randomUUID();
        try {
            this.getDataFolder().mkdirs();
            uuidFile.createNewFile();
            Files.write(Path.of(uuidFile.getPath(), new String[0]), UUIDUtils.toByteArray(serverUUID), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.getLogger().info("Enabled JustEnoughGuide");
    }

    public void onDisable() {
        Preconditions.checkArgument((instance != null ? 1 : 0) != 0, (Object)"JustEnoughGuide has not been enabled yet!");
        GroupSetup.shutdown();
        Field field = ReflectionUtil.getField(Slimefun.getRegistry().getClass(), "guides");
        if (field != null) {
            field.setAccessible(true);
            EnumMap<SlimefunGuideMode, Object> newGuides = new EnumMap<SlimefunGuideMode, Object>(SlimefunGuideMode.class);
            newGuides.put(SlimefunGuideMode.SURVIVAL_MODE, (Object)new SurvivalSlimefunGuide(SlimefunOfficialSupporter.isShowVanillaRecipes(), SlimefunOfficialSupporter.isShowHiddenItemGroups()));
            newGuides.put(SlimefunGuideMode.CHEAT_MODE, (Object)new CheatSheetSlimefunGuide());
            try {
                field.set(Slimefun.getRegistry(), newGuides);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (this.bookmarkManager != null) {
            this.bookmarkManager.onUnload();
        }
        if (this.integrationManager != null) {
            this.integrationManager.onUnload();
        }
        if (this.commandManager != null) {
            this.commandManager.onUnload();
        }
        if (this.listenerManager != null) {
            this.listenerManager.onUnload();
        }
        if (this.rtsBackpackManager != null) {
            this.rtsBackpackManager.onUnload();
        }
        if (this.configManager != null) {
            this.configManager.onUnload();
        }
        this.bookmarkManager = null;
        this.integrationManager = null;
        this.commandManager = null;
        this.listenerManager = null;
        this.configManager = null;
        this.minecraftVersion = null;
        this.javaVersion = 0;
        instance = null;
        this.getLogger().info("Disabled JustEnoughGuide");
    }

    @NotNull
    public JavaPlugin getJavaPlugin() {
        return this;
    }

    @Nullable
    public String getBugTrackerURL() {
        return MessageFormat.format("https://github.com/{0}/{1}/issues/", this.username, this.repo);
    }

    public void debug(String message) {
        if (JustEnoughGuide.getConfigManager().isDebug()) {
            this.getLogger().warning("[DEBUG] " + message);
        }
    }

    @NotNull
    public String getVersion() {
        return this.getDescription().getVersion();
    }

    private boolean environmentCheck() {
        this.minecraftVersion = MinecraftVersion.getCurrentVersion();
        this.javaVersion = NumberUtils.getJavaVersion();
        if (this.minecraftVersion == null) {
            this.getLogger().warning("Cannot recognize Minecraft version!");
            return false;
        }
        if (this.minecraftVersion == MinecraftVersion.UNKNOWN) {
            this.getLogger().warning("Cannot recognize Minecraft version!");
        }
        if (!this.minecraftVersion.isAtLeast(RECOMMENDED_MC_VERSION)) {
            this.getLogger().warning("Minecraft too old! Please use Minecraft 1." + RECOMMENDED_MC_VERSION.getMajor() + "." + RECOMMENDED_MC_VERSION.getMinor() + " or above!");
        }
        if (this.javaVersion < 17) {
            this.getLogger().warning("Java too old! Please use Java 17 or above!");
        }
        return true;
    }

    public boolean isDebug() {
        return JustEnoughGuide.getConfigManager().isDebug();
    }

    @Nullable
    @Generated
    public static UUID getServerUUID() {
        return serverUUID;
    }

    @NotNull
    @Generated
    public String getUsername() {
        return this.username;
    }

    @NotNull
    @Generated
    public String getRepo() {
        return this.repo;
    }

    @NotNull
    @Generated
    public String getBranch() {
        return this.branch;
    }

    @Nullable
    @Generated
    public RTSBackpackManager getRtsBackpackManager() {
        return this.rtsBackpackManager;
    }

    @Nullable
    @Generated
    public MinecraftVersion getMinecraftVersion() {
        return this.minecraftVersion;
    }

    @Generated
    public int getJavaVersion() {
        return this.javaVersion;
    }
}

