/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.utils;

import com.balugaq.jeg.api.cost.CERCalculator;
import com.balugaq.jeg.api.groups.CERRecipeGroup;
import com.balugaq.jeg.api.groups.RTSSearchGroup;
import com.balugaq.jeg.api.groups.SearchGroup;
import com.balugaq.jeg.api.interfaces.BookmarkRelocation;
import com.balugaq.jeg.api.interfaces.JEGSlimefunGuideImplementation;
import com.balugaq.jeg.api.objects.annotations.CallTimeSensitive;
import com.balugaq.jeg.api.objects.collection.data.MachineData;
import com.balugaq.jeg.api.objects.enums.PatchScope;
import com.balugaq.jeg.api.objects.events.GuideEvents;
import com.balugaq.jeg.api.objects.events.RTSEvents;
import com.balugaq.jeg.core.listeners.RTSListener;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.utils.Debug;
import com.balugaq.jeg.utils.EventUtil;
import com.balugaq.jeg.utils.Lang;
import com.balugaq.jeg.utils.formatter.Format;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.groups.FlexItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.groups.LockedItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.groups.SeasonalItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.groups.SubItemGroup;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.GuideHistory;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GuideUtil {
    private static final List<ItemGroup> forceHiddens = new ArrayList<ItemGroup>();
    private static final ItemStack BOOK_MARK_MENU_BUTTON = Lang.getIcon("book-mark-button", Material.NETHER_STAR);
    private static final ItemStack ITEM_MARK_MENU_BUTTON = Lang.getIcon("item-mark-button", Material.WRITABLE_BOOK);
    private static final ItemStack CER_MENU_BUTTON = Lang.getIcon("cer-menu-button", Material.EMERALD);

    @ParametersAreNonnullByDefault
    public static void openMainMenuAsync(Player player, SlimefunGuideMode mode, int selectedPage) {
        if (!PlayerProfile.get((OfflinePlayer)player, profile -> Slimefun.runSync(() -> GuideUtil.openMainMenu(player, profile, mode, selectedPage)))) {
            Slimefun.getLocalization().sendMessage((CommandSender)player, "messages.opening-guide");
        }
    }

    @ParametersAreNonnullByDefault
    public static void openMainMenu(Player player, PlayerProfile profile, SlimefunGuideMode mode, int selectedPage) {
        GuideUtil.getGuide(player, mode).openMainMenu(profile, selectedPage);
    }

    @NotNull
    public static SlimefunGuideImplementation getGuide(@NotNull Player player, SlimefunGuideMode mode) {
        if (mode == SlimefunGuideMode.SURVIVAL_MODE) {
            return Slimefun.getRegistry().getSlimefunGuide(SlimefunGuideMode.SURVIVAL_MODE);
        }
        if ((player.isOp() || player.hasPermission("slimefun.cheat.items")) && mode == SlimefunGuideMode.CHEAT_MODE) {
            return Slimefun.getRegistry().getSlimefunGuide(SlimefunGuideMode.CHEAT_MODE);
        }
        return Slimefun.getRegistry().getSlimefunGuide(SlimefunGuideMode.SURVIVAL_MODE);
    }

    public static void removeLastEntry(@NotNull GuideHistory guideHistory) {
        try {
            Method getLastEntry = guideHistory.getClass().getDeclaredMethod("getLastEntry", Boolean.TYPE);
            getLastEntry.setAccessible(true);
            getLastEntry.invoke((Object)guideHistory, true);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Debug.trace(e);
        }
    }

    @NotNull
    public static ItemStack getBookMarkMenuButton() {
        return BOOK_MARK_MENU_BUTTON;
    }

    @NotNull
    public static ItemStack getItemMarkMenuButton() {
        return ITEM_MARK_MENU_BUTTON;
    }

    public static boolean isTaggedGroupType(@NotNull ItemGroup itemGroup) {
        Class<?> clazz = itemGroup.getClass();
        return !(itemGroup instanceof FlexItemGroup) && (clazz == ItemGroup.class || clazz == SubItemGroup.class || clazz == LockedItemGroup.class || clazz == SeasonalItemGroup.class || itemGroup instanceof BookmarkRelocation || clazz.getName().equalsIgnoreCase("me.voper.slimeframe.implementation.groups.ChildGroup") || clazz.getName().endsWith("DummyItemGroup") || clazz.getName().endsWith("SubGroup"));
    }

    public static void addRTSButton(@NotNull ChestMenu menu, @NotNull Player p, @NotNull PlayerProfile profile, @NotNull Format format, SlimefunGuideMode mode, @NotNull SlimefunGuideImplementation implementation) {
        if (JustEnoughGuide.getConfigManager().isRTSSearch()) {
            for (int ss : format.getChars('R')) {
                menu.addItem(ss, PatchScope.RealTimeSearch.patch(p, Lang.RTS_ITEM), (pl, slot, itemstack, action) -> EventUtil.callEvent(new GuideEvents.RTSButtonClickEvent(pl, itemstack, slot, action, menu, implementation)).ifSuccess(() -> {
                    try {
                        RTSSearchGroup.newRTSInventoryFor(pl, mode, (s, stateSnapshot) -> {
                            SearchGroup rts;
                            if (s == 0) {
                                GuideHistory history = profile.getGuideHistory();
                                if (action.isShiftClicked()) {
                                    implementation.openMainMenu(profile, profile.getGuideHistory().getMainMenuPage());
                                } else {
                                    history.goBack(implementation);
                                }
                            } else if (s == 1) {
                                SearchGroup rts2 = RTSSearchGroup.RTS_SEARCH_GROUPS.get(pl);
                                if (rts2 != null) {
                                    int oldPage = RTSSearchGroup.RTS_PAGES.getOrDefault(pl, 1);
                                    int newPage = Math.max(1, oldPage - 1);
                                    RTSEvents.PageChangeEvent event = new RTSEvents.PageChangeEvent(pl, RTSSearchGroup.RTS_PLAYERS.get(pl), oldPage, newPage, mode);
                                    Bukkit.getPluginManager().callEvent((Event)event);
                                    if (!event.isCancelled()) {
                                        Map<Player, Integer> map = RTSSearchGroup.RTS_PAGES;
                                        synchronized (map) {
                                            RTSSearchGroup.RTS_PAGES.put(pl, newPage);
                                        }
                                    }
                                }
                            } else if (s == 2 && (rts = RTSSearchGroup.RTS_SEARCH_GROUPS.get(pl)) != null) {
                                int oldPage = RTSSearchGroup.RTS_PAGES.getOrDefault(pl, 1);
                                int newPage = Math.min((rts.slimefunItemList.size() - 1) / RTSListener.FILL_ORDER.length + 1, oldPage + 1);
                                RTSEvents.PageChangeEvent event = new RTSEvents.PageChangeEvent(pl, RTSSearchGroup.RTS_PLAYERS.get(pl), oldPage, newPage, mode);
                                Bukkit.getPluginManager().callEvent((Event)event);
                                if (!event.isCancelled()) {
                                    Map<Player, Integer> map = RTSSearchGroup.RTS_PAGES;
                                    synchronized (map) {
                                        RTSSearchGroup.RTS_PAGES.put(pl, newPage);
                                    }
                                }
                            }
                        }, new int[]{0, 1, 2}, null);
                    }
                    catch (Exception ignored) {
                        p.sendMessage(String.valueOf(ChatColor.RED) + "Unable to use RTS caused by unadapted Minecraft version.");
                    }
                    return false;
                }));
            }
        } else {
            for (int ss : format.getChars('R')) {
                menu.addItem(ss, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
            }
        }
    }

    public static void addBookMarkButton(@NotNull ChestMenu menu, @NotNull Player p, @NotNull PlayerProfile profile, @NotNull Format format, @NotNull JEGSlimefunGuideImplementation implementation, ItemGroup itemGroup) {
        if (JustEnoughGuide.getConfigManager().isBookmark()) {
            BookmarkRelocation bookmarkRelocation;
            Object bookmarkRelocation2;
            if (itemGroup instanceof BookmarkRelocation) {
                bookmarkRelocation2 = (BookmarkRelocation)itemGroup;
                bookmarkRelocation = bookmarkRelocation2;
            } else {
                bookmarkRelocation = null;
            }
            BookmarkRelocation b = bookmarkRelocation;
            bookmarkRelocation2 = (b != null ? b.getBookMark(implementation, p) : format.getChars('C')).iterator();
            while (bookmarkRelocation2.hasNext()) {
                int s = (Integer)bookmarkRelocation2.next();
                menu.addItem(s, PatchScope.BookMark.patch(p, GuideUtil.getBookMarkMenuButton()), (pl, slot, itemstack, action) -> EventUtil.callEvent(new GuideEvents.BookMarkButtonClickEvent(pl, itemstack, slot, action, menu, implementation)).ifSuccess(() -> {
                    implementation.openBookMarkGroup(pl, profile);
                    return false;
                }));
            }
        } else {
            for (int s : format.getChars('C')) {
                menu.addItem(s, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
            }
        }
    }

    public static void addItemMarkButton(@NotNull ChestMenu menu, @NotNull Player p, @NotNull PlayerProfile profile, @NotNull Format format, @NotNull JEGSlimefunGuideImplementation implementation, @Nullable ItemGroup itemGroup) {
        if (itemGroup != null && JustEnoughGuide.getConfigManager().isBookmark() && GuideUtil.isTaggedGroupType(itemGroup)) {
            BookmarkRelocation bookmarkRelocation;
            Object relocation;
            if (itemGroup instanceof BookmarkRelocation) {
                relocation = (BookmarkRelocation)itemGroup;
                bookmarkRelocation = relocation;
            } else {
                bookmarkRelocation = null;
            }
            BookmarkRelocation b = bookmarkRelocation;
            relocation = (b != null ? b.getItemMark(implementation, p) : format.getChars('c')).iterator();
            while (relocation.hasNext()) {
                int ss = (Integer)relocation.next();
                menu.addItem(ss, PatchScope.ItemMark.patch(p, GuideUtil.getItemMarkMenuButton()), (pl, slot, itemstack, action) -> EventUtil.callEvent(new GuideEvents.ItemMarkButtonClickEvent(pl, itemstack, slot, action, menu, implementation)).ifSuccess(() -> {
                    implementation.openItemMarkGroup(itemGroup, pl, profile);
                    return false;
                }));
            }
        } else {
            for (int ss : format.getChars('c')) {
                menu.addItem(ss, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
            }
        }
    }

    @CallTimeSensitive(value="After Integrations loaded")
    public static void addCerButton(ChestMenu menu, Player p, PlayerProfile profile, SlimefunItem machine, SlimefunGuideImplementation implementation, Format format) {
        for (int ss : format.getChars('m')) {
            if (!CERCalculator.cerable(machine)) continue;
            menu.addItem(ss, PatchScope.Cer.patch(p, GuideUtil.getCerMenuButton()), (pl, slot, itemstack, action) -> EventUtil.callEvent(new GuideEvents.CerButtonClickEvent(pl, itemstack, slot, action, menu, implementation)).ifSuccess(() -> new CERRecipeGroup(implementation, pl, machine, MachineData.get(machine).wrap()).open(pl, profile, implementation.getMode())));
        }
    }

    public static ItemStack getCerMenuButton() {
        return CER_MENU_BUTTON;
    }

    public static void setForceHiddens(@NotNull ItemGroup itemGroup, boolean forceHidden) {
        if (forceHidden) {
            forceHiddens.add(itemGroup);
        } else {
            forceHiddens.remove(itemGroup);
        }
    }

    @NotNull
    public static List<ItemGroup> getForceHiddens() {
        return new ArrayList<ItemGroup>(forceHiddens);
    }

    public static boolean isForceHidden(@NotNull ItemGroup group) {
        return forceHiddens.contains(group);
    }

    public static void shutdown() {
        forceHiddens.clear();
    }

    @Generated
    private GuideUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

