/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.utils;

import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.utils.Lang;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Debug {
    public static final File errorsFolder = new File(JustEnoughGuide.getInstance().getDataFolder(), "error-reports");
    private static final String debugPrefix = Lang.getDebug("debug-prefix");
    @Nullable
    private static JavaPlugin plugin = null;

    @NotNull
    public static JavaPlugin getPlugin() {
        if (plugin == null) {
            plugin = JustEnoughGuide.getInstance();
        }
        return plugin;
    }

    public static void severe(Object ... objects) {
        StringBuilder sb = new StringBuilder();
        for (Object obj : objects) {
            if (obj == null) {
                sb.append("null");
            } else {
                sb.append(obj);
            }
            sb.append(" ");
        }
        Debug.warn(sb.toString());
    }

    public static void severe(@NotNull Throwable e) {
        Debug.warn(e.getMessage());
        Debug.trace(e);
    }

    public static void severe(@Nullable Object object) {
        Debug.warn(object == null ? "null" : object.toString());
    }

    public static void severe(String ... messages) {
        for (String message : messages) {
            Debug.warn(message);
        }
    }

    public static void severe(String message) {
        Debug.log("&e[ERROR] " + message);
    }

    public static void warn(Object ... objects) {
        StringBuilder sb = new StringBuilder();
        for (Object obj : objects) {
            if (obj == null) {
                sb.append("null");
            } else {
                sb.append(obj);
            }
            sb.append(" ");
        }
        Debug.warn(sb.toString());
    }

    public static void warn(@NotNull Throwable e) {
        Debug.warn(e.getMessage());
        Debug.trace(e);
    }

    public static void warn(@Nullable Object object) {
        Debug.warn(object == null ? "null" : object.toString());
    }

    public static void warn(String ... messages) {
        for (String message : messages) {
            Debug.warn(message);
        }
    }

    public static void warn(String message) {
        Debug.log("&e[WARN] " + message);
    }

    public static void debug(Object ... objects) {
        StringBuilder sb = new StringBuilder();
        for (Object obj : objects) {
            if (obj == null) {
                sb.append("null");
            } else {
                sb.append(obj);
            }
            sb.append(" ");
        }
        Debug.debug(sb.toString());
    }

    public static void debug(@NotNull Throwable e) {
        Debug.debug(e.getMessage());
        Debug.trace(e);
    }

    public static void debug(@Nullable Object object) {
        Debug.debug(object == null ? "null" : object.toString());
    }

    public static void debug(String ... messages) {
        for (String message : messages) {
            Debug.debug(message);
        }
    }

    public static void debug(String message) {
        if (JustEnoughGuide.getConfigManager().isDebug()) {
            Debug.log(debugPrefix + message);
        }
    }

    public static void sendMessage(@NotNull Player player, Object ... objects) {
        StringBuilder sb = new StringBuilder();
        for (Object obj : objects) {
            if (obj == null) {
                sb.append("null");
            } else {
                sb.append(obj);
            }
            sb.append(" ");
        }
        Debug.sendMessage(player, sb.toString());
    }

    public static void sendMessage(@NotNull Player player, @Nullable Object object) {
        if (object == null) {
            Debug.sendMessage(player, "null");
            return;
        }
        Debug.sendMessage(player, object.toString());
    }

    public static void sendMessages(@NotNull Player player, String ... messages) {
        for (String message : messages) {
            Debug.sendMessage(player, message);
        }
    }

    public static void sendMessage(@NotNull Player player, String message) {
        player.sendMessage("[" + Debug.getPlugin().getName() + "]" + message);
    }

    public static void dumpStack() {
        Thread.dumpStack();
    }

    public static void log(Object ... object) {
        StringBuilder sb = new StringBuilder();
        for (Object obj : object) {
            if (obj == null) {
                sb.append("null");
            } else {
                sb.append(obj);
            }
            sb.append(" ");
        }
        Debug.log(sb.toString());
    }

    public static void log(@Nullable Object object) {
        Debug.log(object == null ? "null" : object.toString());
    }

    public static void log(String ... messages) {
        for (String message : messages) {
            Debug.log(message);
        }
    }

    public static void log(@NotNull String message) {
        Bukkit.getServer().getConsoleSender().sendMessage("[" + JustEnoughGuide.getInstance().getName() + "] " + ChatColors.color((String)message));
    }

    public static void log(@NotNull Throwable e) {
        Debug.trace(e);
    }

    public static void log() {
        Debug.log("");
    }

    public static void trace(@NotNull Throwable e) {
        Debug.trace(e, null);
    }

    public static void trace(@NotNull Throwable e, @Nullable String doing) {
        Debug.trace(e, doing, null);
    }

    public static void trace(@NotNull Throwable e, @Nullable String doing, @Nullable Integer code) {
        try {
            Debug.getPlugin().getLogger().severe("DO NOT REPORT THIS ERROR TO JustEnoughGuide DEVELOPERS!!! THIS IS NOT A JustEnoughGuide BUG!");
            if (code != null) {
                Debug.getPlugin().getLogger().severe("Error code: " + code);
            }
            Debug.getPlugin().getLogger().severe("If you are sure that this is a JustEnoughGuide bug, please report to " + JustEnoughGuide.getInstance().getBugTrackerURL());
            if (doing != null) {
                Debug.getPlugin().getLogger().severe("An unexpected error occurred while " + doing);
            } else {
                Debug.getPlugin().getLogger().severe("An unexpected error occurred.");
            }
            e.printStackTrace();
            Debug.dumpToFile(e, code);
        }
        catch (Throwable e2) {
            throw new RuntimeException(e2);
        }
    }

    public static void traceExactly(@NotNull Throwable e, @Nullable String doing, @Nullable Integer code) {
        try {
            Debug.getPlugin().getLogger().severe("====================AN FATAL OCCURRED" + (String)(doing != null ? " WHEN " + doing.toUpperCase() : "") + "====================");
            Debug.getPlugin().getLogger().severe("DO NOT REPORT THIS ERROR TO JustEnoughGuide DEVELOPERS!!! THIS IS NOT A JustEnoughGuide BUG!");
            if (code != null) {
                Debug.getPlugin().getLogger().severe("Error code: " + code);
            }
            Debug.getPlugin().getLogger().severe("If you are sure that this is a JustEnoughGuide bug, please report to " + JustEnoughGuide.getInstance().getBugTrackerURL());
            if (doing != null) {
                Debug.getPlugin().getLogger().severe("An unexpected error occurred while " + doing);
            } else {
                Debug.getPlugin().getLogger().severe("An unexpected error occurred.");
            }
            e.printStackTrace();
            Debug.getPlugin().getLogger().severe("ALL EXCEPTION INFORMATION IS BELOW:");
            Debug.getPlugin().getLogger().severe("message: " + e.getMessage());
            Debug.getPlugin().getLogger().severe("localizedMessage: " + e.getLocalizedMessage());
            Debug.getPlugin().getLogger().severe("cause: " + String.valueOf(e.getCause()));
            Debug.getPlugin().getLogger().severe("stackTrace: " + Arrays.toString(e.getStackTrace()));
            Debug.getPlugin().getLogger().severe("suppressed: " + Arrays.toString(e.getSuppressed()));
            Debug.dumpToFile(e, code);
        }
        catch (Throwable e2) {
            throw new RuntimeException(e2);
        }
    }

    public static void dumpToFile(@NotNull Throwable e, @Nullable Integer code) {
        String fileName = "error-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss")) + "-" + e.getClass().getSimpleName() + "-" + String.valueOf(UUID.randomUUID()) + ".txt";
        File file = new File(errorsFolder, fileName);
        try {
            file.createNewFile();
            try (PrintStream stream = new PrintStream(file, StandardCharsets.UTF_8);){
                stream.println("====================AN FATAL OCCURRED====================");
                stream.println("DO NOT REPORT THIS ERROR TO JustEnoughGuide DEVELOPERS!!! THIS IS NOT A JustEnoughGuide BUG!");
                stream.println("If you are sure that this is a JustEnoughGuide bug, please report to " + JustEnoughGuide.getInstance().getBugTrackerURL());
                stream.println("An unexpected error occurred.");
                stream.println("JustEnoughGuide version: " + JustEnoughGuide.getInstance().getDescription().getVersion());
                stream.println("Java version: " + System.getProperty("java.version"));
                stream.println("OS: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch"));
                stream.println("Minecraft version: " + String.valueOf((Object)JustEnoughGuide.getMinecraftVersion()));
                stream.println("Slimefun version: " + Slimefun.getVersion());
                if (code != null) {
                    stream.println("Error code: " + code);
                }
                stream.println("Error: " + String.valueOf(e));
                stream.println("Stack trace:");
                e.printStackTrace(stream);
                Debug.warn("");
                Debug.warn("An Error occurred! It has been saved as: ");
                Debug.warn("/plugins/JustEnoughGuide/error-reports/" + file.getName());
                Debug.warn("Please put this file on https://pastebin.com/ and report this to the developer(s).");
                Debug.warn("Please DO NOT send screenshots of these logs to the developer(s).");
                Debug.warn("");
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        if (!errorsFolder.exists()) {
            errorsFolder.mkdirs();
        }
    }
}

