/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.implementation.guide;

import com.balugaq.jeg.api.editor.GroupResorter;
import com.balugaq.jeg.api.groups.SearchGroup;
import com.balugaq.jeg.api.interfaces.BookmarkRelocation;
import com.balugaq.jeg.api.interfaces.CustomIconDisplay;
import com.balugaq.jeg.api.interfaces.DisplayInCheatMode;
import com.balugaq.jeg.api.interfaces.JEGSlimefunGuideImplementation;
import com.balugaq.jeg.api.interfaces.NotDisplayInCheatMode;
import com.balugaq.jeg.api.interfaces.VanillaItemShade;
import com.balugaq.jeg.api.objects.annotations.CallTimeSensitive;
import com.balugaq.jeg.api.objects.enums.PatchScope;
import com.balugaq.jeg.api.objects.events.GuideEvents;
import com.balugaq.jeg.api.patches.JEGGuideSettings;
import com.balugaq.jeg.core.listeners.GuideListener;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.implementation.guide.SurvivalGuideImplementation;
import com.balugaq.jeg.utils.Debug;
import com.balugaq.jeg.utils.EventUtil;
import com.balugaq.jeg.utils.GuideUtil;
import com.balugaq.jeg.utils.ItemStackUtil;
import com.balugaq.jeg.utils.Lang;
import com.balugaq.jeg.utils.LocalHelper;
import com.balugaq.jeg.utils.ReflectionUtil;
import com.balugaq.jeg.utils.SlimefunOfficialSupporter;
import com.balugaq.jeg.utils.SpecialMenuProvider;
import com.balugaq.jeg.utils.clickhandler.BeginnerUtils;
import com.balugaq.jeg.utils.clickhandler.GroupLinker;
import com.balugaq.jeg.utils.clickhandler.NamePrinter;
import com.balugaq.jeg.utils.compatibility.Converter;
import com.balugaq.jeg.utils.compatibility.Sounds;
import com.balugaq.jeg.utils.formatter.Format;
import com.balugaq.jeg.utils.formatter.Formats;
import com.balugaq.jeg.utils.formatter.RecipeDisplayFormat;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.groups.FlexItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.groups.LockedItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.groups.NestedItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.groups.SeasonalItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.groups.SubItemGroup;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.api.researches.Research;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.core.guide.GuideHistory;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuide;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlock;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.guide.CheatSheetSlimefunGuide;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.AsyncRecipeChoiceTask;
import io.github.thebusybiscuit.slimefun4.libraries.dough.chat.ChatInput;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.libraries.dough.recipes.MinecraftRecipe;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.SlimefunGuideItem;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.Level;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Tag;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class CheatGuideImplementation
extends CheatSheetSlimefunGuide
implements JEGSlimefunGuideImplementation {
    @Deprecated
    public static final int MAX_ITEM_GROUPS = SurvivalGuideImplementation.MAX_ITEM_GROUPS;
    @Deprecated
    public static final int MAX_ITEMS = SurvivalGuideImplementation.MAX_ITEMS;
    @Deprecated
    public static final int RTS_SLOT = 6;
    @Deprecated
    public static final ItemStack RTS_ITEM = Lang.RTS_ITEM;
    @Deprecated
    public static final int SPECIAL_MENU_SLOT = 26;
    @Deprecated
    public static final ItemStack SPECIAL_MENU_ITEM = Lang.SPECIAL_MENU_ITEM;
    @Deprecated
    public final int[] recipeSlots = SurvivalGuideImplementation.recipeSlots;
    @NotNull
    private final ItemStack item;

    public CheatGuideImplementation() {
        ItemMeta meta = SlimefunGuide.getItem((SlimefunGuideMode)this.getMode()).getItemMeta();
        String name = "";
        if (meta != null) {
            name = meta.getDisplayName();
        }
        this.item = new SlimefunGuideItem((SlimefunGuideImplementation)this, name);
    }

    @Deprecated
    public CheatGuideImplementation(boolean v1, boolean v2) {
        ItemMeta meta = SlimefunGuide.getItem((SlimefunGuideMode)this.getMode()).getItemMeta();
        String name = "";
        if (meta != null) {
            name = meta.getDisplayName();
        }
        this.item = new SlimefunGuideItem((SlimefunGuideImplementation)this, name);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public static ItemStack getDisplayItem(Player p, boolean isSlimefunRecipe, ItemStack item) {
        if (isSlimefunRecipe) {
            SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)item);
            if (slimefunItem == null) {
                return item;
            }
            ItemGroup itemGroup = slimefunItem.getItemGroup();
            String lore = CheatGuideImplementation.hasPermission(p, slimefunItem) ? Lang.getGuideMessage("locked-item", "addon_name", LocalHelper.getAddonName(itemGroup, slimefunItem.getId()), "category_name", itemGroup.getDisplayName(p)) : Lang.getGuideMessage("no-permission");
            return ItemStackUtil.getCleanItem(slimefunItem.canUse(p, false) ? item : Converter.getItem(Material.BARRIER, ItemUtils.getItemName((ItemStack)item), "&4&l" + Slimefun.getLocalization().getMessage(p, "guide.locked"), "", lore));
        }
        return item;
    }

    @ParametersAreNonnullByDefault
    public static boolean hasPermission(Player p, SlimefunItem item) {
        return Slimefun.getPermissionsService().hasPermission((Permissible)p, item);
    }

    public static boolean isTaggedGroupType(@NotNull ItemGroup itemGroup) {
        Class<?> clazz = itemGroup.getClass();
        return clazz == ItemGroup.class || clazz == SubItemGroup.class || clazz == NestedItemGroup.class || clazz == LockedItemGroup.class || clazz == SeasonalItemGroup.class || clazz == SearchGroup.class || itemGroup instanceof BookmarkRelocation || clazz.getName().equalsIgnoreCase("me.voper.slimeframe.implementation.groups.ChildGroup") || clazz.getName().endsWith("DummyItemGroup") || clazz.getName().endsWith("SubGroup");
    }

    @NotNull
    public SlimefunGuideMode getMode() {
        return SlimefunGuideMode.CHEAT_MODE;
    }

    @NotNull
    public ItemStack getItem() {
        return this.item;
    }

    @NotNull
    public List<ItemGroup> getVisibleItemGroups(@NotNull Player p, @NotNull PlayerProfile profile) {
        return this.getVisibleItemGroups(p, profile, false);
    }

    @CallTimeSensitive(value="After Slimefun loaded")
    @NotNull
    public List<ItemGroup> getVisibleItemGroups(@NotNull Player p, @NotNull PlayerProfile profile, boolean guideTierMode) {
        LinkedList<ItemGroup> groups = new LinkedList<ItemGroup>();
        LinkedList<ItemGroup> specialGroups = new LinkedList<ItemGroup>();
        for (ItemGroup group : Slimefun.getRegistry().getAllItemGroups()) {
            try {
                if (group.getClass().isAnnotationPresent(NotDisplayInCheatMode.class)) continue;
                if (group.getClass().isAnnotationPresent(DisplayInCheatMode.class)) {
                    groups.add(group);
                    continue;
                }
                if (!guideTierMode && GuideUtil.isForceHidden(group)) continue;
                if (DisplayInCheatMode.Checker.contains(group)) {
                    if (DisplayInCheatMode.Checker.isSpecial(group)) {
                        specialGroups.add(group);
                        continue;
                    }
                    groups.add(group);
                    continue;
                }
                if (NotDisplayInCheatMode.Checker.contains(group)) continue;
                if (group instanceof SeasonalItemGroup) {
                    specialGroups.add(group);
                    continue;
                }
                if (!group.isHidden(p)) {
                    groups.add(group);
                    continue;
                }
                specialGroups.add(group);
            }
            catch (Exception | LinkageError x) {
                SlimefunAddon addon = group.getAddon();
                if (addon != null) {
                    addon.getLogger().log(Level.SEVERE, x, () -> Lang.getError("could-not-display-item-group", "group", group));
                    continue;
                }
                JustEnoughGuide.getInstance().getLogger().log(Level.SEVERE, x, () -> Lang.getError("could-not-display-item-group", "group", group));
            }
        }
        GroupResorter.sort(groups);
        groups.addAll(specialGroups);
        return groups;
    }

    public void openMainMenu(@NotNull PlayerProfile profile, int page) {
        int pages;
        Player p = profile.getPlayer();
        if (p == null) {
            return;
        }
        GuideHistory history = profile.getGuideHistory();
        history.clear();
        history.setMainMenuPage(page);
        ChestMenu menu = this.create0(p);
        List<ItemGroup> itemGroups = this.getVisibleItemGroups(p, profile, GroupResorter.isSelecting(p));
        this.createHeader(p, profile, menu, Formats.main);
        int target = SurvivalGuideImplementation.MAX_ITEM_GROUPS * (page - 1) - 1;
        int n = pages = target == itemGroups.size() - 1 ? page : (itemGroups.size() - 1) / SurvivalGuideImplementation.MAX_ITEM_GROUPS + 1;
        if (page > pages) {
            page = pages;
        }
        List<Integer> indexes = Formats.main.getChars('G');
        for (int index = 0; target < itemGroups.size() - 1 && index < SurvivalGuideImplementation.MAX_ITEM_GROUPS; ++index) {
            ItemGroup group = itemGroups.get(++target);
            this.showItemGroup0(menu, p, profile, group, indexes.get(index), page);
        }
        for (int s : Formats.main.getChars('P')) {
            menu.addItem(s, PatchScope.PreviousPage.patch(p, ChestMenuUtils.getPreviousButton((Player)p, (int)page, (int)pages)));
            int finalPage1 = page;
            menu.addMenuClickHandler(s, (pl, slot, item, action) -> {
                int previous = finalPage1 - 1;
                if (previous > 0) {
                    this.openMainMenu(profile, previous);
                }
                return false;
            });
        }
        for (int s : Formats.main.getChars('N')) {
            menu.addItem(s, PatchScope.NextPage.patch(p, ChestMenuUtils.getNextButton((Player)p, (int)page, (int)pages)));
            int finalPage = page;
            menu.addMenuClickHandler(s, (pl, slot, item, action) -> {
                int next = finalPage + 1;
                if (next <= pages) {
                    this.openMainMenu(profile, next);
                }
                return false;
            });
        }
        GuideListener.guideModeMap.put(p, this.getMode());
        menu.open(new Player[]{p});
    }

    @Override
    public void showItemGroup0(@NotNull ChestMenu menu, @NotNull Player p, @NotNull PlayerProfile profile, @NotNull ItemGroup group, int index) {
        this.showItemGroup0(menu, p, profile, group, index, 1);
    }

    public void showItemGroup0(@NotNull ChestMenu menu, @NotNull Player p, @NotNull PlayerProfile profile, @NotNull ItemGroup group, int index, int page) {
        if (!(group instanceof LockedItemGroup) || !this.isSurvivalMode() || ((LockedItemGroup)group).hasUnlocked(p, profile)) {
            menu.addItem(index, PatchScope.ItemGroup.patch(p, group.getItem(p)));
            menu.addMenuClickHandler(index, (pl, slot, item, action) -> {
                if (action.isRightClicked() && GroupResorter.isSelecting(pl)) {
                    ItemGroup selected = GroupResorter.getSelectedGroup(pl);
                    if (selected == null) {
                        GroupResorter.setSelectedGroup(pl, group);
                        pl.sendMessage(ChatColors.color((String)("&aSelected group: &e" + group.getDisplayName(pl))));
                    } else {
                        GroupResorter.swap(selected, group);
                        GroupResorter.setSelectedGroup(pl, null);
                        pl.sendMessage(ChatColors.color((String)("&aSwapped: &e" + selected.getDisplayName(pl) + " &7<-> &e" + group.getDisplayName(pl))));
                        this.openMainMenu(profile, page);
                    }
                    return false;
                }
                this.openItemGroup(profile, group, 1);
                return false;
            });
        } else {
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add("");
            for (String line : Slimefun.getLocalization().getMessages(p, "guide.locked-itemgroup")) {
                lore.add(String.valueOf(ChatColor.WHITE) + line);
            }
            lore.add("");
            for (ItemGroup parent : ((LockedItemGroup)group).getParents()) {
                ItemMeta meta = parent.getItem(p).getItemMeta();
                if (meta == null) continue;
                lore.add(meta.getDisplayName());
            }
            ItemMeta meta = group.getItem(p).getItemMeta();
            if (meta == null) {
                return;
            }
            menu.addItem(index, PatchScope.LockedItemGroup.patch(p, Converter.getItem(Material.BARRIER, "&4" + Slimefun.getLocalization().getMessage(p, "guide.locked") + " &7- &f" + meta.getDisplayName(), lore.toArray(new String[0]))));
            menu.addMenuClickHandler(index, ChestMenuUtils.getEmptyClickHandler());
        }
    }

    @ParametersAreNonnullByDefault
    public void openItemGroup(PlayerProfile profile, ItemGroup itemGroup, int page) {
        int target;
        Player p = profile.getPlayer();
        if (p == null) {
            return;
        }
        if (itemGroup instanceof NestedItemGroup) {
            NestedItemGroup nested = (NestedItemGroup)itemGroup;
            if (itemGroup.getClass() == NestedItemGroup.class) {
                this.openNestedItemGroup(p, profile, nested, page);
                return;
            }
        }
        if (itemGroup instanceof FlexItemGroup) {
            FlexItemGroup flexItemGroup = (FlexItemGroup)itemGroup;
            flexItemGroup.open(p, profile, this.getMode());
            return;
        }
        if (this.isSurvivalMode()) {
            profile.getGuideHistory().add(itemGroup, page);
        }
        ChestMenu menu = this.create0(p);
        this.createHeader(p, profile, menu, Formats.sub);
        int pages = (itemGroup.getItems().size() - 1) / SurvivalGuideImplementation.MAX_ITEMS + 1;
        for (int s : Formats.sub.getChars('P')) {
            menu.addItem(s, PatchScope.PreviousPage.patch(p, ChestMenuUtils.getPreviousButton((Player)p, (int)page, (int)pages)));
            menu.addMenuClickHandler(s, (pl, slot, item, action) -> EventUtil.callEvent(new GuideEvents.PreviousButtonClickEvent(pl, item, slot, action, menu, this)).ifSuccess(() -> {
                int previous = page - 1;
                if (previous > 0) {
                    this.openItemGroup(profile, itemGroup, previous);
                }
                return false;
            }));
        }
        for (int s : Formats.sub.getChars('N')) {
            menu.addItem(s, PatchScope.NextPage.patch(p, ChestMenuUtils.getNextButton((Player)p, (int)page, (int)pages)));
            menu.addMenuClickHandler(s, (pl, slot, item, action) -> EventUtil.callEvent(new GuideEvents.NextButtonClickEvent(pl, item, slot, action, menu, this)).ifSuccess(() -> {
                int next = page + 1;
                if (next <= pages) {
                    this.openItemGroup(profile, itemGroup, next);
                }
                return false;
            }));
        }
        List<Integer> indexes = Formats.sub.getChars('i');
        int itemGroupIndex = SurvivalGuideImplementation.MAX_ITEMS * (page - 1);
        for (int i = 0; i < SurvivalGuideImplementation.MAX_ITEMS && (target = itemGroupIndex + i) < itemGroup.getItems().size(); ++i) {
            SlimefunItem sfitem = (SlimefunItem)itemGroup.getItems().get(target);
            if (sfitem.isDisabledIn(p.getWorld())) continue;
            this.displaySlimefunItem0(menu, itemGroup, p, profile, sfitem, page, indexes.get(i));
        }
        GuideUtil.addRTSButton(menu, p, profile, Formats.sub, this.getMode(), this);
        GuideUtil.addBookMarkButton(menu, p, profile, Formats.sub, this, itemGroup);
        GuideUtil.addItemMarkButton(menu, p, profile, Formats.sub, this, itemGroup);
        menu.open(new Player[]{p});
    }

    @Override
    public void openNestedItemGroup(@NotNull Player p, @NotNull PlayerProfile profile, @NotNull NestedItemGroup nested, int page) {
        GuideHistory history = profile.getGuideHistory();
        history.add((ItemGroup)nested, page);
        ChestMenu menu = new ChestMenu(Slimefun.getLocalization().getMessage(p, "guide.title.main"));
        menu.setEmptySlotsClickable(false);
        menu.addMenuOpeningHandler(p2 -> {
            try {
                Sounds.playFor(p2, Sounds.GUIDE_BUTTON_CLICK_SOUND);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.createHeader(p, profile, menu, Formats.nested);
        List<Integer> ss = Formats.nested.getChars('G');
        int groupsPerPage = ss.size();
        try {
            List subGroups = (List)ReflectionUtil.getValue(nested, "subGroups");
            if (subGroups == null) {
                return;
            }
            int t = 0;
            int target = groupsPerPage * (page - 1) - 1;
            for (int i = 0; i < subGroups.size() && t < groupsPerPage && (target = groupsPerPage * (page - 1) + i) < subGroups.size(); ++i) {
                SubItemGroup subGroup = (SubItemGroup)subGroups.get(target);
                if (!subGroup.isVisibleInNested(p)) continue;
                menu.addItem(ss.get(t).intValue(), PatchScope.ItemGroup.patch(p, subGroup.getItem(p)));
                menu.addMenuClickHandler(ss.get(t).intValue(), (pl, slot, item, action) -> EventUtil.callEvent(new GuideEvents.ItemGroupButtonClickEvent(pl, item, slot, action, menu, this)).ifSuccess(() -> {
                    if (GroupResorter.isSelecting(pl)) {
                        ItemGroup selected = GroupResorter.getSelectedGroup(pl);
                        if (selected == null) {
                            GroupResorter.setSelectedGroup(pl, (ItemGroup)subGroup);
                            pl.sendMessage(ChatColors.color((String)("&aSelected group: &e" + subGroup.getDisplayName(pl))));
                        } else {
                            GroupResorter.swap(selected, (ItemGroup)subGroup);
                            GroupResorter.setSelectedGroup(pl, null);
                            pl.sendMessage(ChatColors.color((String)("&aSwapped: &e" + selected.getDisplayName(pl) + " &7<-> &e" + subGroup.getDisplayName(pl))));
                            this.openMainMenu(profile, page);
                        }
                        return false;
                    }
                    SlimefunGuide.openItemGroup((PlayerProfile)profile, (ItemGroup)subGroup, (SlimefunGuideMode)this.getMode(), (int)1);
                    return false;
                }));
                ++t;
            }
            int pages = target == subGroups.size() - 1 ? page : (subGroups.size() - 1) / groupsPerPage + 1;
            for (int s : Formats.nested.getChars('P')) {
                menu.addItem(s, PatchScope.PreviousPage.patch(p, ChestMenuUtils.getPreviousButton((Player)p, (int)page, (int)pages)));
                menu.addMenuClickHandler(s, (pl, slot, item, action) -> EventUtil.callEvent(new GuideEvents.PreviousButtonClickEvent(pl, item, slot, action, menu, this)).ifSuccess(() -> {
                    int next = page - 1;
                    if (next > 0) {
                        this.openNestedItemGroup(p, profile, nested, next);
                    }
                    return false;
                }));
            }
            for (int s : Formats.nested.getChars('N')) {
                menu.addItem(s, PatchScope.NextPage.patch(p, ChestMenuUtils.getNextButton((Player)p, (int)page, (int)pages)));
                menu.addMenuClickHandler(s, (pl, slot, item, action) -> EventUtil.callEvent(new GuideEvents.NextButtonClickEvent(pl, item, slot, action, menu, this)).ifSuccess(() -> {
                    int next = page + 1;
                    if (next <= pages) {
                        this.openNestedItemGroup(p, profile, nested, next);
                    }
                    return false;
                }));
            }
            menu.open(new Player[]{p});
        }
        catch (Exception e) {
            Debug.trace(e);
        }
    }

    @Override
    public void displaySlimefunItem0(@NotNull ChestMenu menu, @NotNull ItemGroup itemGroup, @NotNull Player p, @NotNull PlayerProfile profile, @NotNull SlimefunItem sfitem, int page, int index) {
        Research research = sfitem.getResearch();
        if (this.isSurvivalMode() && !CheatGuideImplementation.hasPermission(p, sfitem)) {
            List message = Slimefun.getPermissionsService().getLore(sfitem);
            menu.addItem(index, PatchScope.NoPermission.patch(p, Converter.getItem(ChestMenuUtils.getNoPermissionItem(), SlimefunOfficialSupporter.getTranslatedItemName(p, sfitem), message.toArray(new String[0]))));
            menu.addMenuClickHandler(index, ChestMenuUtils.getEmptyClickHandler());
        } else if (this.isSurvivalMode() && research != null && !profile.hasUnlocked(research)) {
            menu.addItem(index, PatchScope.LockedItem.patch(p, Converter.getItem(ChestMenuUtils.getNoPermissionItem(), "&f" + SlimefunOfficialSupporter.getTranslatedItemName(p, sfitem), "&7" + sfitem.getId(), "&4&l" + Slimefun.getLocalization().getMessage(p, "guide.locked"), "", Lang.getGuideMessage("click-to-unlock"), "", Lang.getGuideMessage("cost", "cost", research.getCost()))));
            menu.addMenuClickHandler(index, (pl, slot, item, action) -> EventUtil.callEvent(new GuideEvents.ResearchItemEvent(pl, item, slot, action, menu, this)).ifSuccess(() -> {
                research.unlockFromGuide((SlimefunGuideImplementation)this, p, profile, sfitem, itemGroup, page);
                return false;
            }));
        } else {
            if (sfitem instanceof CustomIconDisplay) {
                CustomIconDisplay cid = (CustomIconDisplay)sfitem;
                menu.addItem(index, PatchScope.SlimefunItem.patch(p, cid.getCustomIcon()));
            } else {
                menu.addItem(index, PatchScope.SlimefunItem.patch(p, sfitem.getItem()));
            }
            menu.addMenuClickHandler(index, (pl, slot, item, action) -> EventUtil.callEvent(new GuideEvents.ItemButtonClickEvent(pl, item, slot, action, menu, this)).ifSuccess(() -> {
                try {
                    if (this.isSurvivalMode()) {
                        this.displayItem(profile, sfitem, true);
                    } else if (pl.isOp() || pl.hasPermission("slimefun.cheat.items")) {
                        if (sfitem instanceof MultiBlockMachine) {
                            Slimefun.getLocalization().sendMessage((CommandSender)pl, "guide.cheat.no-multiblocks");
                        } else {
                            ItemStack clonedItem = sfitem.getItem().clone();
                            if (action.isShiftClicked()) {
                                clonedItem.setAmount(clonedItem.getMaxStackSize());
                            }
                            pl.getInventory().addItem(new ItemStack[]{clonedItem});
                        }
                    } else {
                        Slimefun.getLocalization().sendMessage((CommandSender)pl, "messages.no-permission", true);
                    }
                }
                catch (Exception | LinkageError x) {
                    this.printErrorMessage0(pl, sfitem, x);
                }
                return false;
            }));
        }
    }

    @ParametersAreNonnullByDefault
    public void openSearch(PlayerProfile profile, String input, boolean addToHistory) {
        this.openSearch(profile, input, 0, addToHistory);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void openSearch(PlayerProfile profile, String input, int page, boolean addToHistory) {
        Player p = profile.getPlayer();
        if (p == null) {
            return;
        }
        String searchTerm = ChatColor.stripColor((String)input.toLowerCase(Locale.ROOT));
        SearchGroup.searchTerms.put(p.getUniqueId(), searchTerm);
        SearchGroup group = new SearchGroup(this, p, searchTerm, false, true);
        group.open(p, profile, this.getMode());
    }

    @ParametersAreNonnullByDefault
    private boolean isItemGroupAccessible(Player p, SlimefunItem slimefunItem) {
        return SlimefunOfficialSupporter.isShowHiddenItemGroups() || slimefunItem.getItemGroup().isAccessible(p);
    }

    @ParametersAreNonnullByDefault
    private boolean isSearchFilterApplicable(SlimefunItem slimefunItem, String searchTerm, boolean pinyin) {
        String itemName = ChatColor.stripColor((String)slimefunItem.getItemName()).toLowerCase(Locale.ROOT);
        if (itemName.isEmpty()) {
            return false;
        }
        return itemName.contains(searchTerm);
    }

    @ParametersAreNonnullByDefault
    public void displayItem(PlayerProfile profile, ItemStack item, int index, boolean addToHistory) {
        Player p = profile.getPlayer();
        if (p == null || item == null || item.getType() == Material.AIR) {
            return;
        }
        SlimefunItem sfItem = SlimefunItem.getByItem((ItemStack)item);
        if (sfItem != null && !(sfItem instanceof VanillaItemShade)) {
            this.displayItem(profile, sfItem, addToHistory);
            return;
        }
        if (!SlimefunOfficialSupporter.isShowVanillaRecipes()) {
            return;
        }
        Recipe[] recipes = Slimefun.getMinecraftRecipeService().getRecipesFor(item);
        if (recipes.length == 0) {
            return;
        }
        this.showMinecraftRecipe0(recipes, index, item, profile, p, addToHistory);
    }

    @Override
    public void showMinecraftRecipe0(Recipe @NotNull [] recipes, int index, @NotNull ItemStack item, @NotNull PlayerProfile profile, @NotNull Player p, boolean addToHistory) {
        Recipe recipe = recipes[index];
        ItemStack[] recipeItems = new ItemStack[9];
        RecipeType recipeType = RecipeType.NULL;
        ItemStack result = null;
        Optional optional = MinecraftRecipe.of((Recipe)recipe);
        AsyncRecipeChoiceTask task = new AsyncRecipeChoiceTask();
        if (optional.isPresent()) {
            this.showRecipeChoices0(recipe, recipeItems, task);
            recipeType = new RecipeType((MinecraftRecipe)optional.get());
            result = recipe.getResult();
        } else {
            recipeItems = new ItemStack[]{null, null, null, null, ItemStackUtil.getCleanItem(Converter.getItem(Material.BARRIER, Lang.getError("unknown-recipe"), new String[0])), null, null, null, null};
        }
        ChestMenu menu = this.create0(p);
        if (addToHistory) {
            profile.getGuideHistory().add(item, index);
        }
        this.displayItem(menu, profile, p, item, result, recipeType, recipeItems, task, Formats.recipe_vanilla);
        if (recipes.length > 1) {
            for (int s : Formats.recipe_vanilla.getChars('B')) {
                menu.addItem(s, PatchScope.Background.patch(p, ChestMenuUtils.getBackground()), ChestMenuUtils.getEmptyClickHandler());
            }
            for (int s : Formats.recipe_vanilla.getChars('P')) {
                menu.addItem(s, PatchScope.PreviousPage.patch(p, ChestMenuUtils.getPreviousButton((Player)p, (int)(index + 1), (int)recipes.length)), (pl, slot, stack, action) -> EventUtil.callEvent(new GuideEvents.PreviousButtonClickEvent(pl, stack, slot, action, menu, this)).ifSuccess(() -> {
                    if (index > 0) {
                        this.showMinecraftRecipe0(recipes, index - 1, item, profile, p, true);
                    }
                    return false;
                }));
            }
            for (int s : Formats.recipe_vanilla.getChars('N')) {
                menu.addItem(s, PatchScope.NextPage.patch(p, ChestMenuUtils.getNextButton((Player)p, (int)(index + 1), (int)recipes.length)), (pl, slot, stack, action) -> EventUtil.callEvent(new GuideEvents.NextButtonClickEvent(pl, stack, slot, action, menu, this)).ifSuccess(() -> {
                    if (index < recipes.length - 1) {
                        this.showMinecraftRecipe0(recipes, index + 1, item, profile, p, true);
                    }
                    return false;
                }));
            }
        }
        Formats.recipe_vanilla.renderCustom(menu);
        menu.open(new Player[]{p});
        if (!task.isEmpty()) {
            task.start(menu.toInventory());
        }
    }

    @Override
    public <T extends Recipe> void showRecipeChoices0(@NotNull T recipe, ItemStack[] recipeItems, @NotNull AsyncRecipeChoiceTask task) {
        RecipeChoice recipeChoice;
        RecipeChoice[] choices = Slimefun.getMinecraftRecipeService().getRecipeShape(recipe);
        List<Integer> recipeSlots = Formats.recipe_vanilla.getChars('r');
        if (choices.length == 1 && (recipeChoice = choices[0]) instanceof RecipeChoice.MaterialChoice) {
            RecipeChoice.MaterialChoice materialChoice = (RecipeChoice.MaterialChoice)recipeChoice;
            recipeItems[4] = new ItemStack((Material)materialChoice.getChoices().get(0));
            if (materialChoice.getChoices().size() > 1) {
                task.add(recipeSlots.get(4).intValue(), materialChoice);
            }
        } else {
            for (int i = 0; i < choices.length; ++i) {
                RecipeChoice recipeChoice2 = choices[i];
                if (!(recipeChoice2 instanceof RecipeChoice.MaterialChoice)) continue;
                RecipeChoice.MaterialChoice materialChoice = (RecipeChoice.MaterialChoice)recipeChoice2;
                recipeItems[i] = new ItemStack((Material)materialChoice.getChoices().get(0));
                if (materialChoice.getChoices().size() <= 1) continue;
                task.add(recipeSlots.get(i).intValue(), materialChoice);
            }
        }
    }

    @ParametersAreNonnullByDefault
    public void displayItem(PlayerProfile profile, SlimefunItem item, boolean addToHistory) {
        this.displayItem(profile, item, addToHistory, true);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void displayItem(PlayerProfile profile, SlimefunItem item, boolean addToHistory, boolean maybeSpecial) {
        this.displayItem(profile, item, addToHistory, maybeSpecial, item instanceof RecipeDisplayItem ? Formats.recipe_display : Formats.recipe);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void displayItem(PlayerProfile profile, SlimefunItem item, boolean addToHistory, boolean maybeSpecial, Format format) {
        Player p = profile.getPlayer();
        if (p == null) {
            return;
        }
        ChestMenu menu = this.create0(p);
        Optional wiki = item.getWikipage();
        if (wiki.isPresent()) {
            for (int s : format.getChars('w')) {
                menu.addItem(s, PatchScope.ItemWiki.patch(p, Converter.getItem(Material.KNOWLEDGE_BOOK, String.valueOf(ChatColor.WHITE) + Slimefun.getLocalization().getMessage(p, "guide.tooltips.wiki"), "", String.valueOf(ChatColor.GRAY) + "\u21e8 " + String.valueOf(ChatColor.GREEN) + Slimefun.getLocalization().getMessage(p, "guide.tooltips.open-itemgroup"))));
                menu.addMenuClickHandler(s, (pl, slot, itemstack, action) -> EventUtil.callEvent(new GuideEvents.WikiButtonClickEvent(pl, itemstack, slot, action, menu, this)).ifSuccess(() -> {
                    pl.closeInventory();
                    ChatUtils.sendURL((CommandSender)pl, (String)((String)wiki.get()));
                    return false;
                }));
            }
        }
        AsyncRecipeChoiceTask task = new AsyncRecipeChoiceTask();
        if (addToHistory) {
            profile.getGuideHistory().add(item);
        }
        ItemStack result = item.getRecipeOutput();
        RecipeType recipeType = item.getRecipeType();
        ItemStack[] recipe = item.getRecipe();
        this.displayItem(menu, profile, p, item, result, recipeType, recipe, task, format);
        if (item instanceof RecipeDisplayItem) {
            RecipeDisplayItem recipeDisplayItem = (RecipeDisplayItem)item;
            this.displayRecipes0(p, profile, menu, recipeDisplayItem, 0);
        }
        if (maybeSpecial && SpecialMenuProvider.isSpecialItem(item)) {
            for (int s : format.getChars('E')) {
                menu.addItem(s, PatchScope.BigRecipe.patch(p, Lang.SPECIAL_MENU_ITEM), (pl, slot, itemstack, action) -> EventUtil.callEvent(new GuideEvents.BigRecipeButtonClickEvent(pl, itemstack, slot, action, menu, this)).ifSuccess(() -> {
                    try {
                        SpecialMenuProvider.open(profile.getPlayer(), profile, this.getMode(), item);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        Debug.trace(e);
                    }
                    return false;
                }));
            }
        }
        format.renderCustom(menu);
        GuideUtil.addCerButton(menu, p, profile, item, this, format);
        menu.open(new Player[]{p});
        if (!task.isEmpty()) {
            task.start(menu.toInventory());
        }
    }

    @Override
    public void displayItem0(@NotNull ChestMenu menu, @NotNull PlayerProfile profile, @NotNull Player p, Object item, ItemStack output, @NotNull RecipeType recipeType, ItemStack[] recipe, @NotNull AsyncRecipeChoiceTask task) {
        this.displayItem(menu, profile, p, item, output, recipeType, recipe, task, Formats.recipe);
    }

    @Override
    public void displayItem(@NotNull ChestMenu menu, @NotNull PlayerProfile profile, @NotNull Player p, Object item, ItemStack output, @NotNull RecipeType recipeType, ItemStack[] recipe, @NotNull AsyncRecipeChoiceTask task, @NotNull Format format) {
        for (int s : format.getChars('b')) {
            this.addBackButton0(menu, s, p, profile);
        }
        ChestMenu.MenuClickHandler clickHandler = (pl, slot, itemstack, action) -> EventUtil.callEvent(new GuideEvents.ItemButtonClickEvent(pl, itemstack, slot, action, menu, this)).ifSuccess(() -> {
            try {
                if (itemstack != null && itemstack.getType() != Material.BARRIER) {
                    this.displayItem(profile, itemstack, 0, true);
                }
            }
            catch (Exception | LinkageError x) {
                this.printErrorMessage0(pl, x);
            }
            return false;
        });
        boolean isSlimefunRecipe = item instanceof SlimefunItem && !(item instanceof VanillaItemShade);
        List<Integer> recipeSlots = format.getChars('r');
        block1: for (int i = 0; i < 9; ++i) {
            ItemStack recipeItem = CheatGuideImplementation.getDisplayItem(p, isSlimefunRecipe, recipe[i]);
            menu.addItem(recipeSlots.get(i).intValue(), PatchScope.ItemRecipeIngredient.patch(p, recipeItem), clickHandler);
            BeginnerUtils.applyWith(this, menu, recipeSlots.get(i));
            GroupLinker.applyWith(this, menu, recipeSlots.get(i));
            NamePrinter.applyWith(this, menu, recipeSlots.get(i));
            if (recipeItem == null || !(item instanceof MultiBlockMachine)) continue;
            for (Tag tag : MultiBlock.getSupportedTags()) {
                if (!tag.isTagged((Keyed)recipeItem.getType())) continue;
                task.add(recipeSlots.get(i).intValue(), tag);
                continue block1;
            }
        }
        for (int s : format.getChars('t')) {
            menu.addItem(s, PatchScope.ItemRecipeType.patch(p, recipeType.getItem(p)), (pl, slot, itemStack, action) -> EventUtil.callEvent(new GuideEvents.RecipeTypeButtonClickEvent(pl, itemStack, slot, action, menu, this)).ifSuccess(false));
            BeginnerUtils.applyWith(this, menu, s);
            GroupLinker.applyWith(this, menu, s);
            NamePrinter.applyWith(this, menu, s);
        }
        for (int s : format.getChars('i')) {
            menu.addItem(s, PatchScope.ItemRecipeOut.patch(p, output), (pl, slot, itemStack, action) -> EventUtil.callEvent(new GuideEvents.ItemButtonClickEvent(pl, itemStack, slot, action, menu, this)).ifSuccess(false));
            BeginnerUtils.applyWith(this, menu, s);
            GroupLinker.applyWith(this, menu, s);
            NamePrinter.applyWith(this, menu, s);
        }
    }

    @ParametersAreNonnullByDefault
    public void createHeader(Player p, PlayerProfile profile, ChestMenu menu) {
        this.createHeader(p, profile, menu, Formats.main);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void createHeader(Player p, PlayerProfile profile, ChestMenu menu, Format format) {
        for (int s : format.getChars('B')) {
            menu.addItem(s, PatchScope.Background.patch(p, ChestMenuUtils.getBackground()), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int s : format.getChars('b')) {
            this.addBackButton0(menu, s, p, profile);
        }
        for (int s : format.getChars('T')) {
            menu.addItem(s, PatchScope.Settings.patch(p, ChestMenuUtils.getMenuButton((Player)p)));
            menu.addMenuClickHandler(s, (pl, slot, item, action) -> EventUtil.callEvent(new GuideEvents.SettingsButtonClickEvent(pl, item, slot, action, menu, this)).ifSuccess(() -> {
                JEGGuideSettings.openSettings(pl, pl.getInventory().getItemInMainHand());
                return false;
            }));
        }
        for (int s : format.getChars('S')) {
            menu.addItem(s, PatchScope.Search.patch(p, ChestMenuUtils.getSearchButton((Player)p)));
            menu.addMenuClickHandler(s, (pl, slot, item, action) -> EventUtil.callEvent(new GuideEvents.SearchButtonClickEvent(pl, item, slot, action, menu, this)).ifSuccess(() -> {
                pl.closeInventory();
                Slimefun.getLocalization().sendMessage((CommandSender)pl, "guide.search.message");
                ChatInput.waitForPlayer((Plugin)JustEnoughGuide.getInstance(), (Player)pl, msg -> this.openSearch(profile, (String)msg, this.isSurvivalMode()));
                return false;
            }));
        }
        GuideUtil.addRTSButton(menu, p, profile, format, this.getMode(), this);
        GuideUtil.addBookMarkButton(menu, p, profile, format, this, null);
        GuideUtil.addItemMarkButton(menu, p, profile, format, this, null);
        format.renderCustom(menu);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void createHeader(Player p, PlayerProfile profile, ChestMenu menu, ItemGroup itemGroup) {
        for (int s : Formats.main.getChars('B')) {
            menu.addItem(s, PatchScope.Background.patch(p, ChestMenuUtils.getBackground()), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int s : Formats.main.getChars('T')) {
            menu.addItem(s, PatchScope.Settings.patch(p, ChestMenuUtils.getMenuButton((Player)p)));
            menu.addMenuClickHandler(s, (pl, slot, item, action) -> EventUtil.callEvent(new GuideEvents.SettingsButtonClickEvent(pl, item, slot, action, menu, this)).ifSuccess(() -> {
                JEGGuideSettings.openSettings(pl, pl.getInventory().getItemInMainHand());
                return false;
            }));
        }
        for (int s : Formats.main.getChars('S')) {
            menu.addItem(s, PatchScope.Search.patch(p, ChestMenuUtils.getSearchButton((Player)p)));
            menu.addMenuClickHandler(s, (pl, slot, item, action) -> EventUtil.callEvent(new GuideEvents.SearchButtonClickEvent(pl, item, slot, action, menu, this)).ifSuccess(() -> {
                pl.closeInventory();
                Slimefun.getLocalization().sendMessage((CommandSender)pl, "guide.search.message");
                ChatInput.waitForPlayer((Plugin)JustEnoughGuide.getInstance(), (Player)pl, msg -> this.openSearch(profile, (String)msg, this.isSurvivalMode()));
                return false;
            }));
        }
        GuideUtil.addRTSButton(menu, p, profile, Formats.main, this.getMode(), this);
        GuideUtil.addBookMarkButton(menu, p, profile, Formats.main, this, itemGroup);
        GuideUtil.addItemMarkButton(menu, p, profile, Formats.main, this, itemGroup);
    }

    @Override
    public void addBackButton0(@NotNull ChestMenu menu, int slot, @NotNull Player p, @NotNull PlayerProfile profile) {
        GuideHistory history = profile.getGuideHistory();
        if (this.isSurvivalMode() && history.size() > 1) {
            menu.addItem(slot, PatchScope.Back.patch(p, SlimefunOfficialSupporter.getBackButton(p)));
            menu.addMenuClickHandler(slot, (pl, s, is, action) -> EventUtil.callEvent(new GuideEvents.BackButtonClickEvent(pl, is, s, action, menu, this)).ifSuccess(() -> {
                if (action.isShiftClicked()) {
                    this.openMainMenu(profile, profile.getGuideHistory().getMainMenuPage());
                } else {
                    history.goBack((SlimefunGuideImplementation)this);
                }
                return false;
            }));
        } else {
            menu.addItem(slot, PatchScope.Back.patch(p, ChestMenuUtils.getBackButton((Player)p, (String[])new String[]{"", String.valueOf(ChatColor.GRAY) + Slimefun.getLocalization().getMessage(p, "guide.back.guide")})));
            menu.addMenuClickHandler(slot, (pl, s, is, action) -> EventUtil.callEvent(new GuideEvents.BackButtonClickEvent(pl, is, s, action, menu, this)).ifSuccess(() -> {
                this.openMainMenu(profile, profile.getGuideHistory().getMainMenuPage());
                return false;
            }));
        }
    }

    @Override
    @ParametersAreNonnullByDefault
    public void displayRecipes0(Player p, PlayerProfile profile, ChestMenu menu, RecipeDisplayItem sfItem, int page) {
        List recipes = sfItem.getDisplayRecipes();
        if (!recipes.isEmpty()) {
            menu.addItem(Formats.recipe_display.getSize() - 1, ItemStackUtil.getCleanItem(null));
            if (page == 0) {
                for (int s : Formats.recipe_display.getChars('B')) {
                    menu.replaceExistingItem(s, PatchScope.Background.patch(p, Converter.getItem(ChestMenuUtils.getBackground(), sfItem.getRecipeSectionLabel(p), new String[0])));
                    menu.addMenuClickHandler(s, ChestMenuUtils.getEmptyClickHandler());
                }
            }
            List<Integer> ds = Formats.recipe_display.getChars('d');
            int length = ds.size();
            int pages = (recipes.size() - 1) / length + 1;
            for (int s : Formats.recipe_display.getChars('P')) {
                menu.replaceExistingItem(s, PatchScope.PreviousPage.patch(p, ChestMenuUtils.getPreviousButton((Player)p, (int)(page + 1), (int)pages)));
                menu.addMenuClickHandler(s, (pl, slot, itemstack, action) -> EventUtil.callEvent(new GuideEvents.PreviousButtonClickEvent(pl, itemstack, slot, action, menu, this)).ifSuccess(() -> {
                    if (page > 0) {
                        this.displayRecipes0(pl, profile, menu, sfItem, page - 1);
                        Sounds.playFor(pl, Sounds.GUIDE_BUTTON_CLICK_SOUND);
                    }
                    return false;
                }));
            }
            for (int s : Formats.recipe_display.getChars('N')) {
                menu.replaceExistingItem(s, PatchScope.NextPage.patch(p, ChestMenuUtils.getNextButton((Player)p, (int)(page + 1), (int)pages)));
                menu.addMenuClickHandler(s, (pl, slot, itemstack, action) -> EventUtil.callEvent(new GuideEvents.NextButtonClickEvent(pl, itemstack, slot, action, menu, this)).ifSuccess(() -> {
                    if (recipes.size() > length * (page + 1)) {
                        this.displayRecipes0(pl, profile, menu, sfItem, page + 1);
                        Sounds.playFor(pl, Sounds.GUIDE_BUTTON_CLICK_SOUND);
                    }
                    return false;
                }));
            }
            List<Integer> fds = RecipeDisplayFormat.fenceShuffle(ds);
            for (int index = 0; index < length; ++index) {
                this.addDisplayRecipe0(menu, profile, recipes, fds.get(index), index, page);
            }
        }
    }

    @Override
    public void addDisplayRecipe0(@NotNull ChestMenu menu, @NotNull PlayerProfile profile, @NotNull List<ItemStack> recipes, int slot, int index, int page) {
        int l = Formats.recipe_display.getChars('d').size();
        if (index + page * l < recipes.size()) {
            ItemStack displayItem = recipes.get(index + page * l);
            if (displayItem != null) {
                displayItem = Converter.getItem(ItemStackUtil.getCleanItem(displayItem)).clone();
            }
            menu.replaceExistingItem(slot, PatchScope.RecipeDisplay.patch(profile, displayItem));
            if (page == 0) {
                menu.addMenuClickHandler(slot, (pl, s, itemstack, action) -> EventUtil.callEvent(new GuideEvents.ItemButtonClickEvent(pl, itemstack, s, action, menu, this)).ifSuccess(() -> {
                    this.displayItem(profile, itemstack, 0, true);
                    return false;
                }));
                BeginnerUtils.applyWith(this, menu, slot);
                GroupLinker.applyWith(this, menu, slot);
                NamePrinter.applyWith(this, menu, slot);
            }
        } else {
            menu.replaceExistingItem(slot, PatchScope.RecipeDisplay.patch(profile, ItemStackUtil.getCleanItem(null)));
            menu.addMenuClickHandler(slot, ChestMenuUtils.getEmptyClickHandler());
        }
    }

    @Override
    @NotNull
    public ChestMenu create0(@NotNull Player p) {
        ChestMenu menu = new ChestMenu(JustEnoughGuide.getConfigManager().getCheatGuideTitle());
        menu.setEmptySlotsClickable(false);
        menu.addMenuOpeningHandler(pl -> Sounds.playFor(pl, Sounds.GUIDE_BUTTON_CLICK_SOUND));
        return menu;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void printErrorMessage0(Player p, Throwable x) {
        p.sendMessage(Lang.getError("internal-error"));
        JustEnoughGuide.getInstance().getLogger().log(Level.SEVERE, Lang.getError("error-occurred"), x);
        JustEnoughGuide.getInstance().getLogger().warning(Lang.getError("trying-fix-guide", "player_name", p.getName()));
        PlayerProfile profile = PlayerProfile.find((OfflinePlayer)p).orElse(null);
        if (profile == null) {
            return;
        }
        GuideUtil.removeLastEntry(profile.getGuideHistory());
    }

    @Override
    @ParametersAreNonnullByDefault
    public void printErrorMessage0(Player p, SlimefunItem item, Throwable x) {
        p.sendMessage(Lang.getError("internal-error"));
        item.error(Lang.getError("item-error"), x);
        PlayerProfile profile = PlayerProfile.find((OfflinePlayer)p).orElse(null);
        if (profile == null) {
            return;
        }
        GuideUtil.removeLastEntry(profile.getGuideHistory());
    }
}

