/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.implementation;

import com.balugaq.jeg.api.objects.annotations.CallTimeSensitive;
import com.balugaq.jeg.core.managers.IntegrationManager;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.utils.Debug;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;

public class ThirdPartyWarnings {
    @CallTimeSensitive(value="After Integrations loaded")
    public static void check() {
        IntegrationManager.scheduleRun(ThirdPartyWarnings::checkInternal);
    }

    @ApiStatus.Internal
    private static void checkInternal() {
        Plugin netex;
        if (!PaperLib.isPaper()) {
            PaperLib.suggestPaper((Plugin)JustEnoughGuide.getInstance());
            return;
        }
        if (JustEnoughGuide.getIntegrationManager().isEnabledNetworksExpansion() && JustEnoughGuide.getIntegrationManager().isEnabledLogiTech() && (netex = Bukkit.getPluginManager().getPlugin("Networks")) != null && netex.isEnabled() && netex.getPluginMeta().getPluginSoftDependencies().contains(JustEnoughGuide.getInstance().getName())) {
            Debug.warn("Potential dependency cycle detected: Logitech -> Networks -> JustEnoughGuide -> Logitech");
            Debug.warn("1. This may cause SpecialMenuProvider module load incorrectly, which will break the Big Recipe module");
            Debug.warn("2. This may cause incorrect load order where Logitech loads AFTER Networks and InfinityExpansion");
            Debug.warn("Consequences of incorrect load order:");
            Debug.warn("- Logitech will fail to load DependencyNetwork module");
            Debug.warn("- Logitech will fail to load DependencyInfinity module");
            Debug.warn("Impact:");
            Debug.warn("- Without DependencyNetwork: Network Quantum Storage won't be recognized, and Networks Fast Machine won't load (may break some Logitech machines)");
            Debug.warn("- Without DependencyInfinity: Infinity Fast Machines won't load (may break some Logitech machines)");
            Debug.warn("Solution: Update NetworksExpansion to the latest version");
        }
    }
}

