/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.core.managers;

import com.balugaq.jeg.api.managers.AbstractManager;
import com.balugaq.jeg.core.listeners.CerPatchListener;
import com.balugaq.jeg.core.listeners.GroupTierEditorListener;
import com.balugaq.jeg.core.listeners.GuideGUIFixListener;
import com.balugaq.jeg.core.listeners.GuideListener;
import com.balugaq.jeg.core.listeners.RTSListener;
import com.balugaq.jeg.core.listeners.RecipeCompletableListener;
import com.balugaq.jeg.core.listeners.SpecialMenuFixListener;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ListenerManager
extends AbstractManager {
    @NotNull
    private final List<Listener> listeners = new ArrayList<Listener>();
    @NotNull
    private final JavaPlugin plugin;
    private RegisteredListener slimefunGuideListener;

    public ListenerManager(@NotNull JavaPlugin plugin) {
        this.plugin = plugin;
        this.listeners.add(new GuideListener());
        this.listeners.add(new SpecialMenuFixListener());
        this.listeners.add(new RTSListener());
        this.listeners.add(new GroupTierEditorListener());
        this.listeners.add(new GuideGUIFixListener());
        this.listeners.add(new CerPatchListener());
        if (JustEnoughGuide.getConfigManager().isRecipeComplete()) {
            this.listeners.add(new RecipeCompletableListener());
        }
    }

    public void registerListener(@NotNull Listener listener) {
        this.listeners.add(listener);
        Bukkit.getServer().getPluginManager().registerEvents(listener, (Plugin)this.plugin);
    }

    private void registerListeners() {
        for (Listener listener : this.listeners) {
            Bukkit.getServer().getPluginManager().registerEvents(listener, (Plugin)this.plugin);
        }
    }

    private void unregisterListeners() {
        for (Listener listener : this.listeners) {
            HandlerList.unregisterAll((Listener)listener);
        }
    }

    @Override
    public void load() {
        this.registerListeners();
        for (RegisteredListener rl : PlayerRightClickEvent.getHandlerList().getRegisteredListeners()) {
            if (!rl.getListener().getClass().getName().equals("io.github.thebusybiscuit.slimefun4.implementation.listeners.SlimefunGuideListener")) continue;
            this.slimefunGuideListener = rl;
            PlayerRightClickEvent.getHandlerList().unregister(rl);
            PlayerRightClickEvent.getHandlerList().bake();
            break;
        }
    }

    @Override
    public void unload() {
        this.unregisterListeners();
        PlayerRightClickEvent.getHandlerList().register(this.slimefunGuideListener);
    }

    @NotNull
    @Generated
    public List<Listener> getListeners() {
        return this.listeners;
    }

    @NotNull
    @Generated
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public RegisteredListener getSlimefunGuideListener() {
        return this.slimefunGuideListener;
    }
}

