/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.core.integrations.claytech;

import com.balugaq.jeg.api.recipe_complete.RecipeCompletableRegistry;
import com.balugaq.jeg.core.integrations.Integration;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ClayTechIntegrationMain
implements Integration {
    public static final int[] CLAYTECH_FUSION_MACHINE_INPUT_SLOTS = new int[]{19, 20, 21, 28, 29, 30, 37, 38, 39};
    public static final int[] CLAYTECH_ROCKET_ASSEMBLING_MACHINE_INPUT_SLOTS = new int[]{19, 20, 21, 28, 29, 30, 37, 38, 39};
    public static final int[] CLAYTECH_ROCKET_FUEL_GENERATOR_INPUT_SLOTS = new int[]{19, 20, 21, 28, 29, 30, 37, 38, 39};
    public static final int[] CLAYTECH_FOOD_CAULDRON_INPUT_SLOTS = new int[]{19, 20, 21, 28, 29, 30, 37, 38, 39};
    public static final List<SlimefunItem> handledSlimefunItems = new ArrayList<SlimefunItem>();

    public static void rrc(@NotNull String id, int @NotNull [] slots, boolean unordered) {
        SlimefunItem slimefunItem = SlimefunItem.getById((String)id);
        if (slimefunItem != null) {
            ClayTechIntegrationMain.rrc(slimefunItem, slots, unordered);
        }
    }

    public static void rrc(@NotNull SlimefunItem slimefunItem, int @NotNull [] slots, boolean unordered) {
        handledSlimefunItems.add(slimefunItem);
        RecipeCompletableRegistry.registerRecipeCompletable(slimefunItem, slots, unordered);
    }

    @Override
    @NotNull
    public String getHookPlugin() {
        return "ClayTech";
    }

    @Override
    public void onEnable() {
        ClayTechIntegrationMain.rrc("CLAYTECH_CRAFTING_TABLE", CLAYTECH_FUSION_MACHINE_INPUT_SLOTS, false);
        ClayTechIntegrationMain.rrc("CLAYTECH_ROCKET_ASSEMBLING_MACHINE", CLAYTECH_ROCKET_ASSEMBLING_MACHINE_INPUT_SLOTS, false);
        ClayTechIntegrationMain.rrc("CLAYTECH_ROCKET_FUEL_GENERATOR", CLAYTECH_ROCKET_FUEL_GENERATOR_INPUT_SLOTS, false);
        ClayTechIntegrationMain.rrc("CLAYTECH_FOOD_CAULDRON", CLAYTECH_FOOD_CAULDRON_INPUT_SLOTS, false);
    }

    @Override
    public void onDisable() {
        for (SlimefunItem slimefunItem : handledSlimefunItems) {
            RecipeCompletableRegistry.unregisterRecipeCompletable(slimefunItem);
        }
    }
}

