/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.cost;

import com.balugaq.jeg.api.objects.annotations.CallTimeSensitive;
import com.balugaq.jeg.core.managers.IntegrationManager;
import com.balugaq.jeg.utils.StackUtils;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingRecipe;
import org.bukkit.inventory.StonecuttingRecipe;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class ValueTable {
    private static final int THRESHOLD = 128;
    private static final HashMap<Integer, Double> valueMap = new HashMap();

    public static void load() {
        IntegrationManager.scheduleRunAsync(ValueTable::loadInternal);
    }

    @CallTimeSensitive(value="After Slimefun loaded")
    @ApiStatus.Internal
    private static void loadInternal() {
        ValueTable.addBaseValues();
        for (SlimefunItem sf : Slimefun.getRegistry().getEnabledSlimefunItems()) {
            ValueTable.getItemValueSlimefun(sf, 0);
        }
        for (Material material : Material.values()) {
            if (!material.isItem() || material.isLegacy() || material.isAir()) continue;
            ValueTable.getItemValueVanilla(new ItemStack(material), 0);
        }
    }

    public static double getValue(SlimefunItem sf) {
        return ValueTable.getValue(sf.getItem());
    }

    public static double getValue(ItemStack itemStack, int amount) {
        if (itemStack == null) {
            return 0.0;
        }
        int hash = itemStack.hashCode();
        if (valueMap.containsKey(hash)) {
            return valueMap.get(hash) * (double)amount;
        }
        SlimefunItem sf = SlimefunItem.getByItem((ItemStack)itemStack);
        double v = sf != null ? ValueTable.getItemValueSlimefun(sf, 0) : ValueTable.getItemValueVanilla(itemStack, 0);
        return v;
    }

    private static void setValue(ItemStack itemStack, double value) {
        if (StackUtils.itemsMatch(itemStack, new ItemStack(itemStack.getType()), true, false)) {
            valueMap.put(itemStack.getType().hashCode(), value);
        } else {
            valueMap.put(itemStack.hashCode(), value);
        }
    }

    private static void setValue(int key, double value) {
        valueMap.put(key, value);
    }

    public static double getValue(ItemStack itemStack) {
        return ValueTable.getValue(StackUtils.getAsQuantity(itemStack, 1), itemStack.getAmount());
    }

    public static double getValue(ItemStack[] itemStacks) {
        double v = 0.0;
        for (ItemStack itemStack : itemStacks) {
            v += ValueTable.getValue(itemStack);
        }
        return v;
    }

    public static double getValue(Material material) {
        return ValueTable.getValue(new ItemStack(material));
    }

    public static double getTemplateValue(ItemStack itemStack) {
        return ValueTable.getValue(itemStack) / 10000.0;
    }

    private static void addBaseValues() {
        ValueTable.setValue(new ItemStack(Material.GRASS_BLOCK), 1.0);
        ValueTable.setValue(new ItemStack(Material.MOSS_BLOCK), 1.0);
        ValueTable.setValue(new ItemStack(Material.DIRT), 1.0);
        ValueTable.setValue(new ItemStack(Material.PODZOL), 1.0);
        ValueTable.setValue(new ItemStack(Material.CRIMSON_NYLIUM), 1.0);
        ValueTable.setValue(new ItemStack(Material.WARPED_NYLIUM), 1.0);
        ValueTable.setValue(new ItemStack(Material.COBBLESTONE), 1.0);
        ValueTable.setValue(new ItemStack(Material.DIORITE), 1.0);
        ValueTable.setValue(new ItemStack(Material.ANDESITE), 1.0);
        ValueTable.setValue(new ItemStack(Material.GRANITE), 1.0);
        ValueTable.setValue(new ItemStack(Material.OAK_SAPLING), 2.0);
        ValueTable.setValue(new ItemStack(Material.SPRUCE_SAPLING), 2.0);
        ValueTable.setValue(new ItemStack(Material.BIRCH_SAPLING), 2.0);
        ValueTable.setValue(new ItemStack(Material.JUNGLE_SAPLING), 2.0);
        ValueTable.setValue(new ItemStack(Material.ACACIA_SAPLING), 2.0);
        ValueTable.setValue(new ItemStack(Material.DARK_OAK_SAPLING), 2.0);
        ValueTable.setValue(new ItemStack(Material.MANGROVE_PROPAGULE), 2.0);
        ValueTable.setValue(new ItemStack(Material.SAND), 1.0);
        ValueTable.setValue(new ItemStack(Material.RED_SAND), 1.0);
        ValueTable.setValue(new ItemStack(Material.GRAVEL), 1.0);
        ValueTable.setValue(new ItemStack(Material.GOLD_ORE), 0.0);
        ValueTable.setValue(new ItemStack(Material.IRON_ORE), 0.0);
        ValueTable.setValue(new ItemStack(Material.COAL_ORE), 0.0);
        ValueTable.setValue(new ItemStack(Material.DEEPSLATE_GOLD_ORE), 0.0);
        ValueTable.setValue(new ItemStack(Material.DEEPSLATE_IRON_ORE), 0.0);
        ValueTable.setValue(new ItemStack(Material.DEEPSLATE_COAL_ORE), 0.0);
        ValueTable.setValue(new ItemStack(Material.NETHER_GOLD_ORE), 0.0);
        ValueTable.setValue(new ItemStack(Material.OAK_LOG), 4.0);
        ValueTable.setValue(new ItemStack(Material.SPRUCE_LOG), 4.0);
        ValueTable.setValue(new ItemStack(Material.BIRCH_LOG), 4.0);
        ValueTable.setValue(new ItemStack(Material.JUNGLE_LOG), 4.0);
        ValueTable.setValue(new ItemStack(Material.ACACIA_LOG), 4.0);
        ValueTable.setValue(new ItemStack(Material.DARK_OAK_LOG), 4.0);
        ValueTable.setValue(new ItemStack(Material.CRIMSON_STEM), 4.0);
        ValueTable.setValue(new ItemStack(Material.WARPED_STEM), 4.0);
        ValueTable.setValue(new ItemStack(Material.MANGROVE_LOG), 4.0);
        ValueTable.setValue(new ItemStack(Material.STRIPPED_OAK_LOG), 4.0);
        ValueTable.setValue(new ItemStack(Material.STRIPPED_SPRUCE_LOG), 4.0);
        ValueTable.setValue(new ItemStack(Material.STRIPPED_BIRCH_LOG), 4.0);
        ValueTable.setValue(new ItemStack(Material.STRIPPED_JUNGLE_LOG), 4.0);
        ValueTable.setValue(new ItemStack(Material.STRIPPED_ACACIA_LOG), 4.0);
        ValueTable.setValue(new ItemStack(Material.STRIPPED_DARK_OAK_LOG), 4.0);
        ValueTable.setValue(new ItemStack(Material.STRIPPED_CRIMSON_STEM), 4.0);
        ValueTable.setValue(new ItemStack(Material.STRIPPED_WARPED_STEM), 4.0);
        ValueTable.setValue(new ItemStack(Material.STRIPPED_MANGROVE_LOG), 4.0);
        ValueTable.setValue(new ItemStack(Material.STRIPPED_OAK_WOOD), 4.0);
        ValueTable.setValue(new ItemStack(Material.STRIPPED_SPRUCE_WOOD), 4.0);
        ValueTable.setValue(new ItemStack(Material.STRIPPED_BIRCH_WOOD), 4.0);
        ValueTable.setValue(new ItemStack(Material.STRIPPED_JUNGLE_WOOD), 4.0);
        ValueTable.setValue(new ItemStack(Material.STRIPPED_ACACIA_WOOD), 4.0);
        ValueTable.setValue(new ItemStack(Material.STRIPPED_DARK_OAK_WOOD), 4.0);
        ValueTable.setValue(new ItemStack(Material.STRIPPED_CRIMSON_HYPHAE), 4.0);
        ValueTable.setValue(new ItemStack(Material.STRIPPED_WARPED_HYPHAE), 4.0);
        ValueTable.setValue(new ItemStack(Material.STRIPPED_MANGROVE_WOOD), 4.0);
        ValueTable.setValue(new ItemStack(Material.OAK_WOOD), 4.0);
        ValueTable.setValue(new ItemStack(Material.SPRUCE_WOOD), 4.0);
        ValueTable.setValue(new ItemStack(Material.BIRCH_WOOD), 4.0);
        ValueTable.setValue(new ItemStack(Material.JUNGLE_WOOD), 4.0);
        ValueTable.setValue(new ItemStack(Material.ACACIA_WOOD), 4.0);
        ValueTable.setValue(new ItemStack(Material.DARK_OAK_WOOD), 4.0);
        ValueTable.setValue(new ItemStack(Material.CRIMSON_HYPHAE), 4.0);
        ValueTable.setValue(new ItemStack(Material.WARPED_HYPHAE), 4.0);
        ValueTable.setValue(new ItemStack(Material.MANGROVE_WOOD), 4.0);
        ValueTable.setValue(new ItemStack(Material.OAK_LEAVES), 1.0);
        ValueTable.setValue(new ItemStack(Material.SPRUCE_LEAVES), 1.0);
        ValueTable.setValue(new ItemStack(Material.BIRCH_LEAVES), 1.0);
        ValueTable.setValue(new ItemStack(Material.JUNGLE_LEAVES), 1.0);
        ValueTable.setValue(new ItemStack(Material.ACACIA_LEAVES), 1.0);
        ValueTable.setValue(new ItemStack(Material.DARK_OAK_LEAVES), 1.0);
        ValueTable.setValue(new ItemStack(Material.AZALEA_LEAVES), 1.0);
        ValueTable.setValue(new ItemStack(Material.FLOWERING_AZALEA_LEAVES), 1.0);
        ValueTable.setValue(new ItemStack(Material.MANGROVE_LEAVES), 1.0);
        ValueTable.setValue(new ItemStack(Material.AZALEA), 8.0);
        ValueTable.setValue(new ItemStack(Material.WET_SPONGE), 16.0);
        ValueTable.setValue(new ItemStack(Material.LAPIS_ORE), 0.0);
        ValueTable.setValue(new ItemStack(Material.DEEPSLATE_LAPIS_ORE), 0.0);
        ValueTable.setValue(new ItemStack(Material.COBWEB), 4.0);
        ValueTable.setValue(new ItemStack(Material.FERN), 1.0);
        ValueTable.setValue(new ItemStack(Material.DEAD_BUSH), 1.0);
        ValueTable.setValue(new ItemStack(Material.SEAGRASS), 1.0);
        ValueTable.setValue(new ItemStack(Material.SEA_PICKLE), 4.0);
        ValueTable.setValue(new ItemStack(Material.DANDELION), 2.0);
        ValueTable.setValue(new ItemStack(Material.POPPY), 2.0);
        ValueTable.setValue(new ItemStack(Material.BLUE_ORCHID), 2.0);
        ValueTable.setValue(new ItemStack(Material.ALLIUM), 2.0);
        ValueTable.setValue(new ItemStack(Material.AZURE_BLUET), 2.0);
        ValueTable.setValue(new ItemStack(Material.RED_TULIP), 2.0);
        ValueTable.setValue(new ItemStack(Material.ORANGE_TULIP), 2.0);
        ValueTable.setValue(new ItemStack(Material.WHITE_TULIP), 2.0);
        ValueTable.setValue(new ItemStack(Material.PINK_TULIP), 2.0);
        ValueTable.setValue(new ItemStack(Material.OXEYE_DAISY), 2.0);
        ValueTable.setValue(new ItemStack(Material.CORNFLOWER), 2.0);
        ValueTable.setValue(new ItemStack(Material.LILY_OF_THE_VALLEY), 2.0);
        ValueTable.setValue(new ItemStack(Material.WITHER_ROSE), 32.0);
        ValueTable.setValue(new ItemStack(Material.BROWN_MUSHROOM), 4.0);
        ValueTable.setValue(new ItemStack(Material.RED_MUSHROOM), 4.0);
        ValueTable.setValue(new ItemStack(Material.CRIMSON_FUNGUS), 4.0);
        ValueTable.setValue(new ItemStack(Material.WARPED_FUNGUS), 4.0);
        ValueTable.setValue(new ItemStack(Material.CRIMSON_ROOTS), 2.0);
        ValueTable.setValue(new ItemStack(Material.WARPED_ROOTS), 2.0);
        ValueTable.setValue(new ItemStack(Material.WEEPING_VINES), 2.0);
        ValueTable.setValue(new ItemStack(Material.TWISTING_VINES), 2.0);
        ValueTable.setValue(new ItemStack(Material.MANGROVE_ROOTS), 4.0);
        ValueTable.setValue(new ItemStack(Material.MUD), 8.0);
        ValueTable.setValue(new ItemStack(Material.SCULK_SHRIEKER), 1024.0);
        ValueTable.setValue(new ItemStack(Material.SCULK_VEIN), 16.0);
        ValueTable.setValue(new ItemStack(Material.SUGAR_CANE), 2.0);
        ValueTable.setValue(new ItemStack(Material.KELP), 1.0);
        ValueTable.setValue(new ItemStack(Material.BAMBOO), 1.0);
        ValueTable.setValue(new ItemStack(Material.OBSIDIAN), 16.0);
        ValueTable.setValue(new ItemStack(Material.CHORUS_FLOWER), 8.0);
        ValueTable.setValue(new ItemStack(Material.DIAMOND_ORE), 0.0);
        ValueTable.setValue(new ItemStack(Material.REDSTONE_ORE), 0.0);
        ValueTable.setValue(new ItemStack(Material.DEEPSLATE_DIAMOND_ORE), 0.0);
        ValueTable.setValue(new ItemStack(Material.DEEPSLATE_REDSTONE_ORE), 0.0);
        ValueTable.setValue(new ItemStack(Material.ICE), 1.0);
        ValueTable.setValue(new ItemStack(Material.CACTUS), 1.0);
        ValueTable.setValue(new ItemStack(Material.PUMPKIN), 4.0);
        ValueTable.setValue(new ItemStack(Material.CARVED_PUMPKIN), 4.0);
        ValueTable.setValue(new ItemStack(Material.NETHERRACK), 1.0);
        ValueTable.setValue(new ItemStack(Material.SOUL_SAND), 2.0);
        ValueTable.setValue(new ItemStack(Material.SOUL_SOIL), 2.0);
        ValueTable.setValue(new ItemStack(Material.BASALT), 1.0);
        ValueTable.setValue(new ItemStack(Material.BROWN_MUSHROOM_BLOCK), 4.0);
        ValueTable.setValue(new ItemStack(Material.RED_MUSHROOM_BLOCK), 4.0);
        ValueTable.setValue(new ItemStack(Material.MUSHROOM_STEM), 4.0);
        ValueTable.setValue(new ItemStack(Material.VINE), 2.0);
        ValueTable.setValue(new ItemStack(Material.MYCELIUM), 8.0);
        ValueTable.setValue(new ItemStack(Material.LILY_PAD), 8.0);
        ValueTable.setValue(new ItemStack(Material.END_STONE), 2.0);
        ValueTable.setValue(new ItemStack(Material.DRAGON_EGG), 32768.0);
        ValueTable.setValue(new ItemStack(Material.EMERALD_ORE), 0.0);
        ValueTable.setValue(new ItemStack(Material.DEEPSLATE_EMERALD_ORE), 0.0);
        ValueTable.setValue(new ItemStack(Material.NETHER_QUARTZ_ORE), 0.0);
        ValueTable.setValue(new ItemStack(Material.SUNFLOWER), 2.0);
        ValueTable.setValue(new ItemStack(Material.LILAC), 2.0);
        ValueTable.setValue(new ItemStack(Material.ROSE_BUSH), 2.0);
        ValueTable.setValue(new ItemStack(Material.PEONY), 2.0);
        ValueTable.setValue(new ItemStack(Material.TALL_GRASS), 1.0);
        ValueTable.setValue(new ItemStack(Material.LARGE_FERN), 1.0);
        ValueTable.setValue(new ItemStack(Material.TURTLE_EGG), 64.0);
        ValueTable.setValue(new ItemStack(Material.DEAD_TUBE_CORAL_BLOCK), 8.0);
        ValueTable.setValue(new ItemStack(Material.DEAD_BRAIN_CORAL_BLOCK), 8.0);
        ValueTable.setValue(new ItemStack(Material.DEAD_BUBBLE_CORAL_BLOCK), 8.0);
        ValueTable.setValue(new ItemStack(Material.DEAD_FIRE_CORAL_BLOCK), 8.0);
        ValueTable.setValue(new ItemStack(Material.DEAD_HORN_CORAL_BLOCK), 8.0);
        ValueTable.setValue(new ItemStack(Material.TUBE_CORAL_BLOCK), 8.0);
        ValueTable.setValue(new ItemStack(Material.BRAIN_CORAL_BLOCK), 8.0);
        ValueTable.setValue(new ItemStack(Material.BUBBLE_CORAL_BLOCK), 8.0);
        ValueTable.setValue(new ItemStack(Material.FIRE_CORAL_BLOCK), 8.0);
        ValueTable.setValue(new ItemStack(Material.HORN_CORAL_BLOCK), 8.0);
        ValueTable.setValue(new ItemStack(Material.TUBE_CORAL), 8.0);
        ValueTable.setValue(new ItemStack(Material.BRAIN_CORAL), 8.0);
        ValueTable.setValue(new ItemStack(Material.BUBBLE_CORAL), 8.0);
        ValueTable.setValue(new ItemStack(Material.FIRE_CORAL), 8.0);
        ValueTable.setValue(new ItemStack(Material.HORN_CORAL), 8.0);
        ValueTable.setValue(new ItemStack(Material.DEAD_TUBE_CORAL), 8.0);
        ValueTable.setValue(new ItemStack(Material.DEAD_BRAIN_CORAL), 8.0);
        ValueTable.setValue(new ItemStack(Material.DEAD_BUBBLE_CORAL), 8.0);
        ValueTable.setValue(new ItemStack(Material.DEAD_FIRE_CORAL), 8.0);
        ValueTable.setValue(new ItemStack(Material.DEAD_HORN_CORAL), 8.0);
        ValueTable.setValue(new ItemStack(Material.TUBE_CORAL_FAN), 8.0);
        ValueTable.setValue(new ItemStack(Material.BRAIN_CORAL_FAN), 8.0);
        ValueTable.setValue(new ItemStack(Material.BUBBLE_CORAL_FAN), 8.0);
        ValueTable.setValue(new ItemStack(Material.FIRE_CORAL_FAN), 8.0);
        ValueTable.setValue(new ItemStack(Material.HORN_CORAL_FAN), 8.0);
        ValueTable.setValue(new ItemStack(Material.DEAD_TUBE_CORAL_FAN), 8.0);
        ValueTable.setValue(new ItemStack(Material.DEAD_BRAIN_CORAL_FAN), 8.0);
        ValueTable.setValue(new ItemStack(Material.DEAD_BUBBLE_CORAL_FAN), 8.0);
        ValueTable.setValue(new ItemStack(Material.DEAD_FIRE_CORAL_FAN), 8.0);
        ValueTable.setValue(new ItemStack(Material.DEAD_HORN_CORAL_FAN), 8.0);
        ValueTable.setValue(new ItemStack(Material.APPLE), 8.0);
        ValueTable.setValue(new ItemStack(Material.DIAMOND), 1028.0);
        ValueTable.setValue(new ItemStack(Material.IRON_INGOT), 32.0);
        ValueTable.setValue(new ItemStack(Material.GOLD_INGOT), 32.0);
        ValueTable.setValue(new ItemStack(Material.NETHERITE_SCRAP), 4096.0);
        ValueTable.setValue(new ItemStack(Material.NETHERITE_INGOT), 16512.0);
        ValueTable.setValue(new ItemStack(Material.STRING), 4.0);
        ValueTable.setValue(new ItemStack(Material.FEATHER), 2.0);
        ValueTable.setValue(new ItemStack(Material.GUNPOWDER), 8.0);
        ValueTable.setValue(new ItemStack(Material.WHEAT_SEEDS), 2.0);
        ValueTable.setValue(new ItemStack(Material.WHEAT), 2.0);
        ValueTable.setValue(new ItemStack(Material.FLINT), 1.0);
        ValueTable.setValue(new ItemStack(Material.PORKCHOP), 4.0);
        ValueTable.setValue(new ItemStack(Material.WATER_BUCKET), 128.0);
        ValueTable.setValue(new ItemStack(Material.LAVA_BUCKET), 256.0);
        ValueTable.setValue(new ItemStack(Material.SADDLE), 256.0);
        ValueTable.setValue(new ItemStack(Material.REDSTONE), 16.0);
        ValueTable.setValue(new ItemStack(Material.COAL), 16.0);
        ValueTable.setValue(new ItemStack(Material.SNOWBALL), 2.0);
        ValueTable.setValue(new ItemStack(Material.MILK_BUCKET), 256.0);
        ValueTable.setValue(new ItemStack(Material.CLAY_BALL), 8.0);
        ValueTable.setValue(new ItemStack(Material.SLIME_BALL), 8.0);
        ValueTable.setValue(new ItemStack(Material.EGG), 4.0);
        ValueTable.setValue(new ItemStack(Material.GLOWSTONE_DUST), 8.0);
        ValueTable.setValue(new ItemStack(Material.COD), 64.0);
        ValueTable.setValue(new ItemStack(Material.SALMON), 64.0);
        ValueTable.setValue(new ItemStack(Material.TROPICAL_FISH), 128.0);
        ValueTable.setValue(new ItemStack(Material.PUFFERFISH), 64.0);
        ValueTable.setValue(new ItemStack(Material.INK_SAC), 16.0);
        ValueTable.setValue(new ItemStack(Material.COCOA_BEANS), 16.0);
        ValueTable.setValue(new ItemStack(Material.LAPIS_LAZULI), 16.0);
        ValueTable.setValue(new ItemStack(Material.BONE), 4.0);
        ValueTable.setValue(new ItemStack(Material.MELON_SLICE), 2.0);
        ValueTable.setValue(new ItemStack(Material.BEEF), 4.0);
        ValueTable.setValue(new ItemStack(Material.CHICKEN), 4.0);
        ValueTable.setValue(new ItemStack(Material.ROTTEN_FLESH), 4.0);
        ValueTable.setValue(new ItemStack(Material.ENDER_PEARL), 8.0);
        ValueTable.setValue(new ItemStack(Material.BLAZE_ROD), 8.0);
        ValueTable.setValue(new ItemStack(Material.GHAST_TEAR), 16.0);
        ValueTable.setValue(new ItemStack(Material.NETHER_WART), 8.0);
        ValueTable.setValue(new ItemStack(Material.SPIDER_EYE), 4.0);
        ValueTable.setValue(new ItemStack(Material.EMERALD), 128.0);
        ValueTable.setValue(new ItemStack(Material.CARROT), 2.0);
        ValueTable.setValue(new ItemStack(Material.POTATO), 2.0);
        ValueTable.setValue(new ItemStack(Material.POISONOUS_POTATO), 8.0);
        ValueTable.setValue(new ItemStack(Material.SKELETON_SKULL), 128.0);
        ValueTable.setValue(new ItemStack(Material.WITHER_SKELETON_SKULL), 1024.0);
        ValueTable.setValue(new ItemStack(Material.ZOMBIE_HEAD), 128.0);
        ValueTable.setValue(new ItemStack(Material.CREEPER_HEAD), 128.0);
        ValueTable.setValue(new ItemStack(Material.DRAGON_HEAD), 24576.0);
        ValueTable.setValue(new ItemStack(Material.NETHER_STAR), 16384.0);
        ValueTable.setValue(new ItemStack(Material.QUARTZ), 32.0);
        ValueTable.setValue(new ItemStack(Material.PRISMARINE_SHARD), 8.0);
        ValueTable.setValue(new ItemStack(Material.PRISMARINE_CRYSTALS), 16.0);
        ValueTable.setValue(new ItemStack(Material.RABBIT), 2.0);
        ValueTable.setValue(new ItemStack(Material.RABBIT_FOOT), 16.0);
        ValueTable.setValue(new ItemStack(Material.RABBIT_HIDE), 2.0);
        ValueTable.setValue(new ItemStack(Material.NAME_TAG), 256.0);
        ValueTable.setValue(new ItemStack(Material.MUTTON), 2.0);
        ValueTable.setValue(new ItemStack(Material.CHORUS_FRUIT), 4.0);
        ValueTable.setValue(new ItemStack(Material.BEETROOT), 2.0);
        ValueTable.setValue(new ItemStack(Material.BEETROOT_SEEDS), 2.0);
        ValueTable.setValue(new ItemStack(Material.DRAGON_BREATH), 512.0);
        ValueTable.setValue(new ItemStack(Material.ELYTRA), 0.0);
        ValueTable.setValue(new ItemStack(Material.SHULKER_SHELL), 32.0);
        ValueTable.setValue(new ItemStack(Material.PHANTOM_MEMBRANE), 16.0);
        ValueTable.setValue(new ItemStack(Material.NAUTILUS_SHELL), 128.0);
        ValueTable.setValue(new ItemStack(Material.HEART_OF_THE_SEA), 8192.0);
        ValueTable.setValue(new ItemStack(Material.BELL), 128.0);
        ValueTable.setValue(new ItemStack(Material.SWEET_BERRIES), 2.0);
        ValueTable.setValue(new ItemStack(Material.SHROOMLIGHT), 4.0);
        ValueTable.setValue(new ItemStack(Material.HONEYCOMB), 1.0);
        ValueTable.setValue(new ItemStack(Material.CRYING_OBSIDIAN), 64.0);
        ValueTable.setValue(new ItemStack(Material.BLACKSTONE), 2.0);
        ValueTable.setValue(new ItemStack(Material.GILDED_BLACKSTONE), 16.0);
        ValueTable.setValue(new ItemStack(Material.HONEY_BOTTLE), 1.0);
        ValueTable.setValue(new ItemStack(Material.PLAYER_HEAD), 0.0);
        ValueTable.setValue(new ItemStack(Material.RAW_IRON), 32.0);
        ValueTable.setValue(new ItemStack(Material.RAW_GOLD), 32.0);
        ValueTable.setValue(new ItemStack(Material.RAW_COPPER), 32.0);
        ValueTable.setValue(new ItemStack(Material.COPPER_INGOT), 32.0);
        ValueTable.setValue(new ItemStack(Material.DEEPSLATE), 1.0);
        ValueTable.setValue(new ItemStack(Material.AMETHYST_SHARD), 16.0);
        ValueTable.setValue(new ItemStack(Material.ECHO_SHARD), 32.0);
        ValueTable.setValue(new ItemStack(Material.COBBLED_DEEPSLATE), 1.0);
        ValueTable.setValue(new ItemStack(Material.FROGSPAWN), 64.0);
        ValueTable.setValue(SlimefunItem.getById((String)"COPPER_DUST").getItem(), 32.0);
        ValueTable.setValue(SlimefunItem.getById((String)"IRON_DUST").getItem(), 32.0);
        ValueTable.setValue(SlimefunItem.getById((String)"GOLD_DUST").getItem(), 32.0);
        ValueTable.setValue(SlimefunItem.getById((String)"TIN_DUST").getItem(), 32.0);
        ValueTable.setValue(SlimefunItem.getById((String)"MAGNESIUM_DUST").getItem(), 32.0);
        ValueTable.setValue(SlimefunItem.getById((String)"ZINC_DUST").getItem(), 32.0);
        ValueTable.setValue(SlimefunItem.getById((String)"LEAD_DUST").getItem(), 32.0);
        ValueTable.setValue(SlimefunItem.getById((String)"SILVER_DUST").getItem(), 32.0);
        ValueTable.setValue(SlimefunItem.getById((String)"ALUMINUM_DUST").getItem(), 32.0);
        ValueTable.setValue(SlimefunItem.getById((String)"NETHER_ICE").getItem(), 128.0);
        ValueTable.setValue(SlimefunItem.getById((String)"BUCKET_OF_OIL").getItem(), 512.0);
        ValueTable.setValue(SlimefunItem.getById((String)"SIFTED_ORE").getItem(), 32.0);
        ValueTable.setValue(SlimefunItem.getById((String)"STONE_CHUNK").getItem(), 1.0);
        ValueTable.setValue(SlimefunItem.getById((String)"BASIC_CIRCUIT_BOARD").getItem(), 1024.0);
    }

    private static double getItemValueVanilla(@NotNull ItemStack itemStack, int depth) {
        if (depth > 128) {
            return 128.0;
        }
        Double storedValue = valueMap.get(itemStack.getType().hashCode());
        if (storedValue != null) {
            return storedValue;
        }
        double value = 0.0;
        List recipeList = Bukkit.getRecipesFor((ItemStack)itemStack);
        if (recipeList.isEmpty()) {
            return 0.0;
        }
        for (Recipe recipe : recipeList) {
            double recipeValue = ValueTable.handleRecipeVanilla(recipe, depth + 1);
            if (!(recipeValue > 0.0)) continue;
            recipeValue = (double)Math.round(recipeValue * 100.0) / 100.0;
            if (value == 0.0) {
                value = recipeValue;
                continue;
            }
            if (!(recipeValue < value)) continue;
            value = recipeValue;
        }
        ValueTable.setValue(itemStack, value);
        return value;
    }

    private static double handleRecipeVanilla(@NotNull Recipe recipe, int depth) {
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            return ValueTable.handleShapedRecipe(shapedRecipe, depth);
        }
        if (recipe instanceof ShapelessRecipe) {
            ShapelessRecipe shapelessRecipe = (ShapelessRecipe)recipe;
            return ValueTable.handleShapelessRecipe(shapelessRecipe, depth);
        }
        if (recipe instanceof CookingRecipe) {
            CookingRecipe cookingRecipe = (CookingRecipe)recipe;
            return ValueTable.handleCookingRecipe(cookingRecipe, depth);
        }
        if (recipe instanceof SmithingRecipe) {
            SmithingRecipe smithingRecipe = (SmithingRecipe)recipe;
            return ValueTable.handleSmithingRecipe(smithingRecipe, depth);
        }
        if (recipe instanceof StonecuttingRecipe) {
            StonecuttingRecipe stonecuttingRecipe = (StonecuttingRecipe)recipe;
            return ValueTable.handleStonecuttingRecipe(stonecuttingRecipe, depth);
        }
        return 0.0;
    }

    private static double handleShapedRecipe(@NotNull ShapedRecipe shapedRecipe, int depth) {
        double value = 0.0;
        HashMap<Character, Double> valueMap = new HashMap<Character, Double>();
        for (Map.Entry entry : shapedRecipe.getIngredientMap().entrySet()) {
            if (entry.getValue() == null) continue;
            double entryValue = ValueTable.getItemValueVanilla((ItemStack)entry.getValue(), depth);
            if (entryValue == 0.0) {
                return 0.0;
            }
            valueMap.put((Character)entry.getKey(), entryValue);
        }
        for (String string : shapedRecipe.getShape()) {
            for (char character : string.toCharArray()) {
                Double charValue = (Double)valueMap.get(Character.valueOf(character));
                if (charValue == null) continue;
                value += ((Double)valueMap.get(Character.valueOf(character))).doubleValue();
            }
        }
        return value /= (double)shapedRecipe.getResult().getAmount();
    }

    private static double handleShapelessRecipe(@NotNull ShapelessRecipe shapelessRecipe, int depth) {
        double value = 0.0;
        for (ItemStack itemStack : shapelessRecipe.getIngredientList()) {
            double itemValue = ValueTable.getItemValueVanilla(itemStack, depth);
            if (itemValue == 0.0) {
                return 0.0;
            }
            value += itemValue;
        }
        return value /= (double)shapelessRecipe.getResult().getAmount();
    }

    private static double handleCookingRecipe(@NotNull CookingRecipe<?> cookingRecipe, int depth) {
        double value = ValueTable.getItemValueVanilla(cookingRecipe.getInput(), depth);
        return value /= (double)cookingRecipe.getResult().getAmount();
    }

    private static double handleSmithingRecipe(@NotNull SmithingRecipe smithingRecipe, int depth) {
        double baseValue = ValueTable.getItemValueVanilla(smithingRecipe.getBase().getItemStack(), depth);
        double additionValue = ValueTable.getItemValueVanilla(smithingRecipe.getAddition().getItemStack(), depth);
        double value = baseValue + additionValue;
        return value /= (double)smithingRecipe.getResult().getAmount();
    }

    private static double handleStonecuttingRecipe(@NotNull StonecuttingRecipe stonecuttingRecipe, int depth) {
        double value = ValueTable.getItemValueVanilla(stonecuttingRecipe.getInput(), depth);
        return value /= (double)stonecuttingRecipe.getResult().getAmount();
    }

    private static double getItemValueSlimefun(@NotNull SlimefunItem slimefunItem, int depth) {
        if (depth > 128) {
            return 128.0;
        }
        Double storedValue = valueMap.get(slimefunItem.getId().hashCode());
        if (storedValue != null) {
            return storedValue;
        }
        if (slimefunItem.isDisabled()) {
            return 0.0;
        }
        double value = 0.0;
        double recipeValue = ValueTable.handleRecipeSlimefun(slimefunItem.getRecipe(), slimefunItem.getRecipeOutput().getAmount() + 1, depth + 1);
        if (recipeValue > 0.0) {
            value = recipeValue = (double)Math.round(recipeValue * 100.0) / 100.0;
        }
        ValueTable.setValue(slimefunItem.getId().hashCode(), value);
        return value;
    }

    private static double handleRecipeSlimefun(@NotNull ItemStack[] recipe, int outputAmount, int depth) {
        double value = 0.0;
        for (ItemStack itemStack : recipe) {
            if (itemStack == null) continue;
            SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)itemStack);
            double itemValue = slimefunItem != null ? ValueTable.getItemValueSlimefun(slimefunItem, depth) * (double)itemStack.getAmount() : ValueTable.getItemValueVanilla(itemStack, depth) * (double)itemStack.getAmount();
            value += itemValue;
        }
        return value / (double)outputAmount;
    }
}

