/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.core.listeners;

import com.balugaq.jeg.api.objects.collection.Pair;
import com.balugaq.jeg.api.objects.enums.PatchScope;
import com.balugaq.jeg.api.objects.events.GuideEvents;
import com.balugaq.jeg.api.objects.events.PatchEvent;
import com.balugaq.jeg.api.recipe_complete.source.base.RecipeCompleteProvider;
import com.balugaq.jeg.api.recipe_complete.source.base.SlimefunSource;
import com.balugaq.jeg.api.recipe_complete.source.base.VanillaSource;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.implementation.items.ItemsSetup;
import com.balugaq.jeg.utils.KeyUtil;
import com.balugaq.jeg.utils.Lang;
import com.balugaq.jeg.utils.ReflectionUtil;
import com.balugaq.jeg.utils.StackUtils;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.GuideHistory;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import net.guizhanss.guizhanlib.minecraft.helper.inventory.ItemStackHelper;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.Dispenser;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipeCompletableListener
implements Listener {
    public static final int[] DISPENSER_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    public static final ConcurrentHashMap<UUID, GuideEvents.ItemButtonClickEvent> LAST_EVENTS = new ConcurrentHashMap();
    public static final ConcurrentHashMap<UUID, GuideHistory> GUIDE_HISTORY = new ConcurrentHashMap();
    public static final ConcurrentHashMap<UUID, BiConsumer<GuideEvents.ItemButtonClickEvent, PlayerProfile>> PROFILE_CALLBACKS = new ConcurrentHashMap();
    public static final Set<UUID> listening = ConcurrentHashMap.newKeySet();
    public static final ConcurrentHashMap<SlimefunItem, Pair<int[], Boolean>> INGREDIENT_SLOTS = new ConcurrentHashMap();
    public static final ArrayList<SlimefunItem> NOT_APPLICABLE_ITEMS = new ArrayList();
    public static final ConcurrentHashMap<UUID, Location> DISPENSER_LISTENING = new ConcurrentHashMap();
    public static final NamespacedKey LAST_RECIPE_COMPLETE_KEY = KeyUtil.newKey("last_recipe_complete");
    public static final ConcurrentHashMap<UUID, ArrayList<ItemStack>> missingMaterials = new ConcurrentHashMap();
    private static ItemStack RECIPE_COMPLETABLE_BOOK_ITEM = null;

    public static void addNotApplicableItem(SlimefunItem slimefunItem) {
        NOT_APPLICABLE_ITEMS.add(slimefunItem);
    }

    public static void removeNotApplicableItem(SlimefunItem slimefunItem) {
        NOT_APPLICABLE_ITEMS.remove(slimefunItem);
    }

    public static void registerRecipeCompletable(SlimefunItem slimefunItem, int @NotNull [] slots) {
        RecipeCompletableListener.registerRecipeCompletable(slimefunItem, slots, false);
    }

    public static void registerRecipeCompletable(SlimefunItem slimefunItem, int @NotNull [] slots, boolean unordered) {
        INGREDIENT_SLOTS.put(slimefunItem, new Pair<int[], Boolean>(slots, unordered));
    }

    public static void unregisterRecipeCompletable(SlimefunItem slimefunItem) {
        INGREDIENT_SLOTS.remove(slimefunItem);
    }

    private static void tryAddClickHandler(@NotNull BlockMenu blockMenu) {
        SlimefunItem sf = blockMenu.getPreset().getSlimefunItem();
        if (!RecipeCompletableListener.isApplicable(sf)) {
            return;
        }
        if (!RecipeCompletableListener.hasIngredientSlots(sf)) {
            return;
        }
        ChestMenu.MenuClickHandler old = blockMenu.getPlayerInventoryClickHandler();
        if (old instanceof TaggedRecipeCompletable) {
            return;
        }
        blockMenu.addPlayerInventoryClickHandler((player, slot, itemStack, clickAction) -> {
            if (StackUtils.itemsMatch(itemStack, RecipeCompletableListener.getRecipeCompletableBookItem(), false, false, false, false) && blockMenu.isPlayerInventoryClickable()) {
                if (RecipeCompletableListener.isSelectingItemStackToRecipeComplete(player)) {
                    return false;
                }
                RecipeCompletableListener.enterSelectingItemStackToRecipeComplete(player);
                int[] slots = RecipeCompletableListener.getIngredientSlots(sf);
                boolean unordered = RecipeCompletableListener.isUnordered(sf);
                for (SlimefunSource source : RecipeCompleteProvider.getSlimefunSources()) {
                    if (!source.handleable(blockMenu, player, clickAction, slots, unordered, 1)) continue;
                    source.openGuide(blockMenu, player, clickAction, slots, unordered, 1, () -> RecipeCompletableListener.exitSelectingItemStackToRecipeComplete(player));
                    break;
                }
                return false;
            }
            if (old != null) {
                return old.onClick(player, slot, itemStack, clickAction);
            }
            return true;
        });
    }

    public static boolean hasIngredientSlots(@NotNull SlimefunItem slimefunItem) {
        return INGREDIENT_SLOTS.containsKey(slimefunItem);
    }

    public static int @NotNull [] getIngredientSlots(@NotNull SlimefunItem slimefunItem) {
        return Optional.ofNullable(INGREDIENT_SLOTS.get(slimefunItem)).orElse(new Pair<int[], Boolean>(new int[0], false)).first();
    }

    public static boolean isUnordered(@NotNull SlimefunItem slimefunItem) {
        return Optional.ofNullable(INGREDIENT_SLOTS.get(slimefunItem)).orElse(new Pair<int[], Boolean>(new int[0], false)).second();
    }

    public static boolean isApplicable(@NotNull SlimefunItem slimefunItem) {
        if (slimefunItem instanceof NotApplicable) {
            return false;
        }
        return !NOT_APPLICABLE_ITEMS.contains(slimefunItem);
    }

    @NotNull
    public static ItemStack getRecipeCompletableBookItem() {
        if (RECIPE_COMPLETABLE_BOOK_ITEM == null) {
            RECIPE_COMPLETABLE_BOOK_ITEM = ItemsSetup.RECIPE_COMPLETE_GUIDE.getItem().clone();
        }
        return RECIPE_COMPLETABLE_BOOK_ITEM;
    }

    public static void addCallback(@NotNull UUID uuid, @NotNull BiConsumer<GuideEvents.ItemButtonClickEvent, PlayerProfile> callback) {
        PROFILE_CALLBACKS.put(uuid, callback);
    }

    public static void removeCallback(@NotNull UUID uuid) {
        PROFILE_CALLBACKS.remove(uuid);
    }

    @NotNull
    public static PlayerProfile getPlayerProfile(@NotNull OfflinePlayer player) {
        return (PlayerProfile)PlayerProfile.find((OfflinePlayer)player).orElseThrow(() -> new RuntimeException("PlayerProfile not found"));
    }

    public static void tagGuideOpen(@NotNull Player player) {
        if (!PROFILE_CALLBACKS.containsKey(player.getUniqueId())) {
            return;
        }
        PlayerProfile profile = RecipeCompletableListener.getPlayerProfile((OfflinePlayer)player);
        RecipeCompletableListener.saveOriginGuideHistory(profile);
        RecipeCompletableListener.clearGuideHistory(profile);
    }

    public static void saveOriginGuideHistory(@NotNull PlayerProfile profile) {
        GuideHistory oldHistory = profile.getGuideHistory();
        GuideHistory newHistory = new GuideHistory(profile);
        ReflectionUtil.setValue(newHistory, "mainMenuPage", oldHistory.getMainMenuPage());
        LinkedList queue = ReflectionUtil.getValue(oldHistory, "queue", LinkedList.class);
        ReflectionUtil.setValue(newHistory, "queue", queue != null ? queue.clone() : new LinkedList());
        GUIDE_HISTORY.put(profile.getUUID(), newHistory);
    }

    public static void clearGuideHistory(@NotNull PlayerProfile profile) {
        ReflectionUtil.setValue(profile, "guideHistory", new GuideHistory(profile));
    }

    @Nullable
    public static GuideEvents.ItemButtonClickEvent getLastEvent(@NotNull UUID playerUUID) {
        return LAST_EVENTS.get(playerUUID);
    }

    public static void clearLastEvent(@NotNull UUID playerUUID) {
        LAST_EVENTS.remove(playerUUID);
    }

    @ParametersAreNonnullByDefault
    public static void addDispenserListening(UUID uuid, Location location) {
        DISPENSER_LISTENING.put(uuid, location);
    }

    @ParametersAreNonnullByDefault
    public static boolean isOpeningDispenser(UUID uuid) {
        return DISPENSER_LISTENING.containsKey(uuid);
    }

    @ParametersAreNonnullByDefault
    public static void removeDispenserListening(UUID uuid) {
        DISPENSER_LISTENING.remove(uuid);
    }

    @ParametersAreNonnullByDefault
    private static void tryAddVanillaListen(InventoryOpenEvent event, Block block, Inventory inventory) {
        RecipeCompletableListener.addDispenserListening(event.getPlayer().getUniqueId(), block.getLocation());
    }

    public static void rollbackGuideHistory(@NotNull PlayerProfile profile) {
        GuideHistory originHistory = GUIDE_HISTORY.get(profile.getUUID());
        if (originHistory == null) {
            return;
        }
        ReflectionUtil.setValue(profile, "guideHistory", originHistory);
    }

    private static void tryPatchRecipeCompleteBook(@NotNull Player player, @NotNull ItemStack clickedItemStack) {
        for (ItemStack itemStack : player.getInventory()) {
            ItemMeta meta;
            if (!StackUtils.itemsMatch(itemStack, RecipeCompletableListener.getRecipeCompletableBookItem(), false, false, false, false) || (meta = itemStack.getItemMeta()) == null) continue;
            ArrayList<String> lore = meta.getLore();
            if (lore == null) {
                lore = new ArrayList<String>();
            }
            boolean applied = meta.getPersistentDataContainer().has(LAST_RECIPE_COMPLETE_KEY);
            if (lore.size() >= 7 && applied) {
                if (lore.size() >= 7) {
                    lore.remove(lore.size() - 1);
                }
                if (lore.size() >= 6) {
                    lore.remove(lore.size() - 1);
                }
            }
            String itemName = ItemUtils.getItemName((ItemStack)clickedItemStack);
            lore.add("");
            lore.add(ChatColors.color((String)(Lang.getMessage("guide.recipe-complete-last-completed") + itemName)));
            if (!applied) {
                meta.getPersistentDataContainer().set(LAST_RECIPE_COMPLETE_KEY, PersistentDataType.BOOLEAN, (Object)true);
            }
            meta.setLore(lore);
            itemStack.setItemMeta(meta);
            return;
        }
    }

    private static void tryRemoveRecipeCompleteBookLastRecipeCompleteLore(@NotNull Player player) {
        for (ItemStack itemStack : player.getInventory()) {
            List lore;
            ItemMeta meta;
            if (!StackUtils.itemsMatch(itemStack, RecipeCompletableListener.getRecipeCompletableBookItem(), false, false, false, false) || (meta = itemStack.getItemMeta()) == null || (lore = meta.getLore()) == null) continue;
            boolean applied = meta.getPersistentDataContainer().has(LAST_RECIPE_COMPLETE_KEY);
            if (lore.size() >= 2 && applied) {
                if (lore.size() >= 2) {
                    lore.remove(lore.size() - 1);
                }
                if (lore.size() >= 1) {
                    lore.remove(lore.size() - 1);
                }
            }
            meta.getPersistentDataContainer().set(LAST_RECIPE_COMPLETE_KEY, PersistentDataType.BOOLEAN, (Object)false);
            meta.setLore(lore);
            itemStack.setItemMeta(meta);
        }
    }

    public static boolean isSelectingItemStackToRecipeComplete(@NotNull Player player) {
        return listening.contains(player.getUniqueId());
    }

    public static void enterSelectingItemStackToRecipeComplete(@NotNull Player player) {
        listening.add(player.getUniqueId());
    }

    public static void exitSelectingItemStackToRecipeComplete(@NotNull Player player) {
        listening.remove(player.getUniqueId());
    }

    @EventHandler
    public void prepare(@NotNull InventoryOpenEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (inventoryHolder instanceof BlockMenu) {
            BlockMenu blockMenu = (BlockMenu)inventoryHolder;
            RecipeCompletableListener.tryAddClickHandler(blockMenu);
        }
        if ((inventoryHolder = event.getInventory().getHolder()) instanceof Dispenser) {
            Dispenser dispenser = (Dispenser)inventoryHolder;
            RecipeCompletableListener.tryAddVanillaListen(event, dispenser.getBlock(), event.getInventory());
        }
    }

    @EventHandler
    public void clickVanilla(@NotNull InventoryClickEvent event) {
        Inventory inventory = event.getInventory();
        if (event.getRawSlot() < inventory.getSize()) {
            return;
        }
        InventoryHolder inventoryHolder = inventory.getHolder();
        if (!(inventoryHolder instanceof Dispenser)) {
            return;
        }
        Dispenser dispenser = (Dispenser)inventoryHolder;
        Player player = (Player)event.getWhoClicked();
        if (!RecipeCompletableListener.isOpeningDispenser(player.getUniqueId())) {
            return;
        }
        if (!StackUtils.itemsMatch(event.getCurrentItem(), RecipeCompletableListener.getRecipeCompletableBookItem(), false, false, false, false)) {
            return;
        }
        Block block = dispenser.getBlock();
        ClickAction clickAction = new ClickAction(event.isRightClick(), event.isShiftClick());
        for (VanillaSource source : RecipeCompleteProvider.getVanillaSources()) {
            if (!source.handleable(block, inventory, player, clickAction, DISPENSER_SLOTS, false, 1)) continue;
            source.openGuide(block, inventory, player, clickAction, DISPENSER_SLOTS, false, 1, null);
            break;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void exitVanilla(@NotNull InventoryOpenEvent event) {
        RecipeCompletableListener.removeDispenserListening(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onJEGItemClick( @NotNull GuideEvents.ItemButtonClickEvent event) {
        Player player = event.getPlayer();
        if (!PROFILE_CALLBACKS.containsKey(player.getUniqueId())) {
            return;
        }
        PlayerProfile profile = RecipeCompletableListener.getPlayerProfile((OfflinePlayer)player);
        RecipeCompletableListener.rollbackGuideHistory(profile);
        PROFILE_CALLBACKS.get(player.getUniqueId()).accept(event, profile);
        PROFILE_CALLBACKS.remove(player.getUniqueId());
        LAST_EVENTS.put(player.getUniqueId(), event);
        ItemStack clickedItemStack = event.getClickedItem();
        if (clickedItemStack != null) {
            RecipeCompletableListener.tryPatchRecipeCompleteBook(player, clickedItemStack);
        }
    }

    @EventHandler
    public void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        RecipeCompletableListener.tryRemoveRecipeCompleteBookLastRecipeCompleteLore(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void patchItem(@NotNull PatchEvent event) {
        PatchScope scope = event.getPatchScope();
        if (scope != PatchScope.SlimefunItem && scope != PatchScope.SearchItem) {
            return;
        }
        if (RecipeCompletableListener.isSelectingItemStackToRecipeComplete(event.getPlayer())) {
            ItemStack old = event.getItemStack();
            if (old == null || old.getType() == Material.AIR) {
                return;
            }
            ItemMeta meta = old.getItemMeta();
            if (meta == null) {
                return;
            }
            ArrayList<String> lore = meta.getLore();
            if (lore == null) {
                lore = new ArrayList<String>();
            }
            lore.add("");
            lore.add(ChatColors.color((String)Lang.getMessage("guide.recipe-complete-left-click")));
            lore.add(ChatColors.color((String)Lang.getMessage("guide.recipe-complete-right-click")));
            meta.setLore(lore);
            old.setItemMeta(meta);
            event.setItemStack(old);
        }
    }

    static {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)JustEnoughGuide.getInstance(), () -> {
            for (UUID uuid : missingMaterials.keySet()) {
                ArrayList<ItemStack> clone;
                ArrayList<ItemStack> v;
                Player player = Bukkit.getPlayer((UUID)uuid);
                if (player == null) continue;
                ArrayList<ItemStack> arrayList = v = missingMaterials.get(uuid);
                synchronized (arrayList) {
                    clone = new ArrayList<ItemStack>(v);
                    v.clear();
                }
                HashMap<ItemStack, Integer> map = new HashMap<ItemStack, Integer>();
                for (ItemStack itemStack : clone) {
                    map.merge(StackUtils.getAsQuantity(itemStack, 1), itemStack.getAmount(), Integer::sum);
                }
                for (Map.Entry entry : map.entrySet()) {
                    player.sendMessage(ChatColors.color((String)("&cMissing &7" + ItemStackHelper.getDisplayName((ItemStack)((ItemStack)entry.getKey())) + "&ax" + String.valueOf(entry.getValue()))));
                }
            }
        }, 1L, 20L);
    }

    public static interface TaggedRecipeCompletable {
    }

    @FunctionalInterface
    public static interface RecipeCompletableClickHandler
    extends ChestMenu.MenuClickHandler,
    TaggedRecipeCompletable {
    }

    public static interface NotApplicable {
    }
}

