/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.groups;

import com.balugaq.jeg.api.interfaces.JEGSlimefunGuideImplementation;
import com.balugaq.jeg.api.interfaces.NotDisplayInCheatMode;
import com.balugaq.jeg.api.interfaces.VanillaItemShade;
import com.balugaq.jeg.api.objects.enums.PatchScope;
import com.balugaq.jeg.api.objects.events.GuideEvents;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.implementation.items.GroupSetup;
import com.balugaq.jeg.utils.Debug;
import com.balugaq.jeg.utils.EventUtil;
import com.balugaq.jeg.utils.GuideUtil;
import com.balugaq.jeg.utils.SlimefunOfficialSupporter;
import com.balugaq.jeg.utils.compatibility.Sounds;
import com.balugaq.jeg.utils.formatter.Formats;
import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.items.groups.FlexItemGroup;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.guide.GuideHistory;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuide;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.chat.ChatInput;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@NotDisplayInCheatMode
public class VanillaItemsGroup
extends FlexItemGroup {
    public static final List<SlimefunItem> slimefunItems = new ArrayList<SlimefunItem>();
    @Deprecated
    @NotNull
    private static final Set<Player> displayableFor = ConcurrentHashMap.newKeySet();
    private static final JavaPlugin JAVA_PLUGIN = JustEnoughGuide.getInstance();
    private final int page;
    private Map<Integer, VanillaItemsGroup> pageMap = new LinkedHashMap<Integer, VanillaItemsGroup>();

    @ParametersAreNonnullByDefault
    public VanillaItemsGroup(NamespacedKey key, ItemStack icon) {
        super(key, icon, Integer.MAX_VALUE);
        this.page = 1;
        this.pageMap.put(1, this);
    }

    protected VanillaItemsGroup(@NotNull VanillaItemsGroup hiddenItemsGroup, int page) {
        super(hiddenItemsGroup.key, new ItemStack(Material.BARRIER));
        this.page = page;
        this.pageMap.put(page, this);
    }

    @Deprecated
    public static void displayableFor(@NotNull Player player, boolean displayable) {
        if (displayable) {
            displayableFor.add(player);
        } else {
            displayableFor.remove(player);
        }
    }

    @Deprecated
    public static boolean isDisplayableFor(@NotNull Player player) {
        return displayableFor.contains(player);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    private static VanillaItem createSlimefunItem(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"The material cannot be null.");
        Preconditions.checkArgument((!material.isAir() ? 1 : 0) != 0, (Object)"The material cannot be air.");
        Preconditions.checkArgument((boolean)material.isItem(), (Object)"The material must be an item.");
        Preconditions.checkArgument((!material.isLegacy() ? 1 : 0) != 0, (Object)"The material cannot be legacy.");
        VanillaItem vi = VanillaItem.create(material);
        vi.register(JustEnoughGuide.getInstance());
        return vi;
    }

    public boolean isVisible(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        return true;
    }

    public void open(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        playerProfile.getGuideHistory().add((ItemGroup)this, this.page);
        this.generateMenu(player, playerProfile, slimefunGuideMode).open(new Player[]{player});
    }

    public void refresh(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        GuideUtil.removeLastEntry(playerProfile.getGuideHistory());
        this.open(player, playerProfile, slimefunGuideMode);
    }

    @NotNull
    private ChestMenu generateMenu(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        ChestMenu chestMenu = new ChestMenu("Vanilla Items");
        chestMenu.setEmptySlotsClickable(false);
        chestMenu.addMenuOpeningHandler(pl -> pl.playSound(pl.getLocation(), Sounds.GUIDE_BUTTON_CLICK_SOUND, 1.0f, 1.0f));
        SlimefunGuideImplementation implementation = Slimefun.getRegistry().getSlimefunGuide(slimefunGuideMode);
        for (int ss : Formats.sub.getChars('b')) {
            chestMenu.addItem(ss, PatchScope.Back.patch(player, ChestMenuUtils.getBackButton((Player)player, (String[])new String[0])));
            chestMenu.addMenuClickHandler(ss, (pl, s, is, action) -> EventUtil.callEvent(new GuideEvents.BackButtonClickEvent(pl, is, s, action, chestMenu, implementation)).ifSuccess(() -> {
                GuideHistory guideHistory = playerProfile.getGuideHistory();
                if (action.isShiftClicked()) {
                    SlimefunGuide.openMainMenu((PlayerProfile)playerProfile, (SlimefunGuideMode)slimefunGuideMode, (int)guideHistory.getMainMenuPage());
                } else {
                    guideHistory.goBack(Slimefun.getRegistry().getSlimefunGuide(slimefunGuideMode));
                }
                return false;
            }));
        }
        for (int ss : Formats.sub.getChars('S')) {
            chestMenu.addItem(ss, PatchScope.Search.patch(player, ChestMenuUtils.getSearchButton((Player)player)));
            chestMenu.addMenuClickHandler(ss, (pl, slot, item, action) -> EventUtil.callEvent(new GuideEvents.SearchButtonClickEvent(pl, item, slot, action, chestMenu, implementation)).ifSuccess(() -> {
                pl.closeInventory();
                Slimefun.getLocalization().sendMessage((CommandSender)pl, "guide.search.message");
                ChatInput.waitForPlayer((Plugin)JAVA_PLUGIN, (Player)pl, msg -> implementation.openSearch(playerProfile, msg, implementation.getMode() == SlimefunGuideMode.SURVIVAL_MODE));
                return false;
            }));
        }
        for (int ss : Formats.sub.getChars('P')) {
            chestMenu.addItem(ss, PatchScope.PreviousPage.patch(player, ChestMenuUtils.getPreviousButton((Player)player, (int)this.page, (int)((slimefunItems.size() - 1) / Formats.sub.getChars('i').size() + 1))));
            chestMenu.addMenuClickHandler(ss, (p, slot, item, action) -> EventUtil.callEvent(new GuideEvents.PreviousButtonClickEvent(p, item, slot, action, chestMenu, implementation)).ifSuccess(() -> {
                GuideUtil.removeLastEntry(playerProfile.getGuideHistory());
                VanillaItemsGroup hiddenItemsGroup = this.getByPage(Math.max(this.page - 1, 1));
                hiddenItemsGroup.open(player, playerProfile, slimefunGuideMode);
                return false;
            }));
        }
        for (int ss : Formats.sub.getChars('N')) {
            chestMenu.addItem(ss, PatchScope.NextPage.patch(player, ChestMenuUtils.getNextButton((Player)player, (int)this.page, (int)((slimefunItems.size() - 1) / Formats.sub.getChars('i').size() + 1))));
            chestMenu.addMenuClickHandler(ss, (p, slot, item, action) -> EventUtil.callEvent(new GuideEvents.NextButtonClickEvent(p, item, slot, action, chestMenu, implementation)).ifSuccess(() -> {
                GuideUtil.removeLastEntry(playerProfile.getGuideHistory());
                VanillaItemsGroup hiddenItemsGroup = this.getByPage(Math.min(this.page + 1, (slimefunItems.size() - 1) / Formats.sub.getChars('i').size() + 1));
                hiddenItemsGroup.open(player, playerProfile, slimefunGuideMode);
                return false;
            }));
        }
        for (int ss : Formats.sub.getChars('B')) {
            chestMenu.addItem(ss, PatchScope.Background.patch(player, ChestMenuUtils.getBackground()));
            chestMenu.addMenuClickHandler(ss, ChestMenuUtils.getEmptyClickHandler());
        }
        List<Integer> contentSlots = Formats.sub.getChars('i');
        for (int i = 0; i < contentSlots.size(); ++i) {
            ItemStack itemStack;
            int index = i + this.page * contentSlots.size() - contentSlots.size();
            if (index >= slimefunItems.size()) continue;
            SlimefunItem slimefunItem = slimefunItems.get(index);
            if (slimefunItem instanceof VanillaItemShade) {
                VanillaItemShade vis = (VanillaItemShade)slimefunItem;
                itemStack = vis.getCustomIcon();
            } else {
                itemStack = slimefunItem.getItem();
            }
            chestMenu.addItem(contentSlots.get(i).intValue(), PatchScope.SlimefunItem.patch(player, itemStack), (pl, slot, itm, action) -> EventUtil.callEvent(new GuideEvents.ItemButtonClickEvent(pl, itm, slot, action, chestMenu, implementation)).ifSuccess(() -> {
                try {
                    if (implementation.getMode() != SlimefunGuideMode.SURVIVAL_MODE && (pl.isOp() || pl.hasPermission("slimefun.cheat.items"))) {
                        pl.getInventory().addItem(new ItemStack[]{itemStack.clone()});
                    } else {
                        implementation.displayItem(playerProfile, slimefunItem, true);
                    }
                }
                catch (Exception | LinkageError x) {
                    this.printErrorMessage(pl, slimefunItem, x);
                }
                return false;
            }));
        }
        GuideUtil.addRTSButton(chestMenu, player, playerProfile, Formats.sub, slimefunGuideMode, implementation);
        if (implementation instanceof JEGSlimefunGuideImplementation) {
            JEGSlimefunGuideImplementation jeg = (JEGSlimefunGuideImplementation)implementation;
            GuideUtil.addBookMarkButton(chestMenu, player, playerProfile, Formats.sub, jeg, (ItemGroup)this);
            GuideUtil.addItemMarkButton(chestMenu, player, playerProfile, Formats.sub, jeg, (ItemGroup)this);
        }
        Formats.sub.renderCustom(chestMenu);
        return chestMenu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private VanillaItemsGroup getByPage(int page) {
        if (this.pageMap.containsKey(page)) {
            return this.pageMap.get(page);
        }
        VanillaItemsGroup vanillaItemsGroup = this.pageMap.get(1);
        synchronized (vanillaItemsGroup) {
            if (this.pageMap.containsKey(page)) {
                return this.pageMap.get(page);
            }
            VanillaItemsGroup hiddenItemsGroup = new VanillaItemsGroup(this, page);
            hiddenItemsGroup.pageMap = this.pageMap;
            this.pageMap.put(page, hiddenItemsGroup);
            return hiddenItemsGroup;
        }
    }

    @ParametersAreNonnullByDefault
    private boolean isItemGroupAccessible(@NotNull Player p, @NotNull SlimefunItem slimefunItem) {
        return SlimefunOfficialSupporter.isShowHiddenItemGroups() || slimefunItem.getItemGroup().isAccessible(p);
    }

    @ParametersAreNonnullByDefault
    private void printErrorMessage(@NotNull Player p, @NotNull SlimefunItem item, @NotNull Throwable x) {
        p.sendMessage(String.valueOf(ChatColor.DARK_RED) + "An internal server error has occurred. Please inform an admin, check the console for further info.");
        item.error("This item has caused an error message to be thrown while viewing it in the Slimefun guide.", x);
    }

    public int getTier() {
        return Integer.MAX_VALUE;
    }

    static {
        Bukkit.getScheduler().runTaskLater((Plugin)JAVA_PLUGIN, () -> {
            boolean before = JustEnoughGuide.disableAutomaticallyLoadItems();
            try {
                for (Material material : Material.values()) {
                    if (material.isAir() || !material.isItem() || material.isLegacy()) continue;
                    slimefunItems.add(VanillaItemsGroup.createSlimefunItem(material));
                }
            }
            catch (Exception e) {
                Debug.trace(e);
            }
            finally {
                JustEnoughGuide.setAutomaticallyLoadItems(before);
            }
        }, 1L);
    }

    public static class VanillaItem
    extends SlimefunItem
    implements VanillaItemShade {
        @NotNull
        private final ItemStack customIcon;

        public VanillaItem(@NotNull SlimefunItemStack item, @NotNull ItemStack customIcon) {
            super((ItemGroup)GroupSetup.vanillaItemsGroup, item, RecipeType.NULL, new ItemStack[0], customIcon);
            this.customIcon = customIcon.clone();
        }

        @NotNull
        public static VanillaItem create(@NotNull Material material) {
            ItemStack icon = new ItemStack(material);
            return new VanillaItem(new SlimefunItemStack("JEG_VANILLA_" + material.name(), icon.clone()), icon);
        }

        @Override
        @NotNull
        @Generated
        public ItemStack getCustomIcon() {
            return this.customIcon;
        }
    }
}

