/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.objects.collection.cooldown;

import com.balugaq.jeg.api.objects.collection.cooldown.CooldownPool;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class FrequencyWatcher<Key> {
    private final TimeUnit periodUnit;
    private final long maxFrequencyPerPeriod;
    private final Map<Key, Long> frequencyMap = new ConcurrentHashMap<Key, Long>();
    private final Map<Key, Long> lastUpdateTime = new ConcurrentHashMap<Key, Long>();
    @NotNull
    private final CooldownPool<Key> pool;
    private int periods;

    public FrequencyWatcher(int periods, TimeUnit periodUnit, long maxFrequencyPerPeriod, long cooldownMillis) {
        this.periods = periods;
        this.periodUnit = periodUnit;
        this.maxFrequencyPerPeriod = maxFrequencyPerPeriod;
        this.pool = new CooldownPool(cooldownMillis);
    }

    @NotNull
    public Result checkCooldown(Key key) {
        this.updateFrequency(key);
        long currentFrequency = this.frequencyMap.getOrDefault(key, 0L);
        if (currentFrequency >= this.maxFrequencyPerPeriod) {
            return Result.TOO_FREQUENT;
        }
        this.frequencyMap.put(key, currentFrequency + 1L);
        if (!this.pool.checkCooldown(key)) {
            return Result.CANCEL;
        }
        return Result.SUCCESS;
    }

    public void updateFrequency(Key key) {
        long now = System.currentTimeMillis();
        if (now - this.lastUpdateTime.getOrDefault(key, 0L) > this.periodUnit.toMillis(1L)) {
            this.frequencyMap.clear();
            this.lastUpdateTime.put(key, now);
        }
    }

    @Generated
    public TimeUnit getPeriodUnit() {
        return this.periodUnit;
    }

    @Generated
    public long getMaxFrequencyPerPeriod() {
        return this.maxFrequencyPerPeriod;
    }

    @Generated
    public Map<Key, Long> getFrequencyMap() {
        return this.frequencyMap;
    }

    @Generated
    public Map<Key, Long> getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @NotNull
    @Generated
    public CooldownPool<Key> getPool() {
        return this.pool;
    }

    @Generated
    public int getPeriods() {
        return this.periods;
    }

    @Generated
    public void setPeriods(int periods) {
        this.periods = periods;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FrequencyWatcher)) {
            return false;
        }
        FrequencyWatcher other = (FrequencyWatcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxFrequencyPerPeriod() != other.getMaxFrequencyPerPeriod()) {
            return false;
        }
        if (this.getPeriods() != other.getPeriods()) {
            return false;
        }
        TimeUnit this$periodUnit = this.getPeriodUnit();
        TimeUnit other$periodUnit = other.getPeriodUnit();
        if (this$periodUnit == null ? other$periodUnit != null : !((Object)((Object)this$periodUnit)).equals((Object)other$periodUnit)) {
            return false;
        }
        Map<Key, Long> this$frequencyMap = this.getFrequencyMap();
        Map<Key, Long> other$frequencyMap = other.getFrequencyMap();
        if (this$frequencyMap == null ? other$frequencyMap != null : !((Object)this$frequencyMap).equals(other$frequencyMap)) {
            return false;
        }
        Map<Key, Long> this$lastUpdateTime = this.getLastUpdateTime();
        Map<Key, Long> other$lastUpdateTime = other.getLastUpdateTime();
        if (this$lastUpdateTime == null ? other$lastUpdateTime != null : !((Object)this$lastUpdateTime).equals(other$lastUpdateTime)) {
            return false;
        }
        CooldownPool<Key> this$pool = this.getPool();
        CooldownPool<Key> other$pool = other.getPool();
        return !(this$pool == null ? other$pool != null : !((Object)this$pool).equals(other$pool));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FrequencyWatcher;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maxFrequencyPerPeriod = this.getMaxFrequencyPerPeriod();
        result = result * 59 + (int)($maxFrequencyPerPeriod >>> 32 ^ $maxFrequencyPerPeriod);
        result = result * 59 + this.getPeriods();
        TimeUnit $periodUnit = this.getPeriodUnit();
        result = result * 59 + ($periodUnit == null ? 43 : ((Object)((Object)$periodUnit)).hashCode());
        Map<Key, Long> $frequencyMap = this.getFrequencyMap();
        result = result * 59 + ($frequencyMap == null ? 43 : ((Object)$frequencyMap).hashCode());
        Map<Key, Long> $lastUpdateTime = this.getLastUpdateTime();
        result = result * 59 + ($lastUpdateTime == null ? 43 : ((Object)$lastUpdateTime).hashCode());
        CooldownPool<Key> $pool = this.getPool();
        result = result * 59 + ($pool == null ? 43 : ((Object)$pool).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FrequencyWatcher(periodUnit=" + String.valueOf((Object)this.getPeriodUnit()) + ", maxFrequencyPerPeriod=" + this.getMaxFrequencyPerPeriod() + ", frequencyMap=" + String.valueOf(this.getFrequencyMap()) + ", lastUpdateTime=" + String.valueOf(this.getLastUpdateTime()) + ", pool=" + String.valueOf(this.getPool()) + ", periods=" + this.getPeriods() + ")";
    }

    public static enum Result {
        TOO_FREQUENT,
        CANCEL,
        SUCCESS;

    }
}

