/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.groups;

import com.balugaq.jeg.api.interfaces.JEGSlimefunGuideImplementation;
import com.balugaq.jeg.api.interfaces.NotDisplayInCheatMode;
import com.balugaq.jeg.api.interfaces.NotDisplayInSurvivalMode;
import com.balugaq.jeg.api.objects.enums.PatchScope;
import com.balugaq.jeg.api.objects.events.GuideEvents;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.utils.EventUtil;
import com.balugaq.jeg.utils.GuideUtil;
import com.balugaq.jeg.utils.ItemStackUtil;
import com.balugaq.jeg.utils.JEGVersionedItemFlag;
import com.balugaq.jeg.utils.Lang;
import com.balugaq.jeg.utils.LocalHelper;
import com.balugaq.jeg.utils.SlimefunOfficialSupporter;
import com.balugaq.jeg.utils.compatibility.Converter;
import com.balugaq.jeg.utils.compatibility.Sounds;
import com.balugaq.jeg.utils.formatter.Formats;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.groups.FlexItemGroup;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.api.researches.Research;
import io.github.thebusybiscuit.slimefun4.core.guide.GuideHistory;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuide;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.chat.ChatInput;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@NotDisplayInSurvivalMode
@NotDisplayInCheatMode
public class BookmarkGroup
extends FlexItemGroup {
    @Deprecated
    private static final int BACK_SLOT = 1;
    @Deprecated
    private static final int SEARCH_SLOT = 7;
    @Deprecated
    private static final int PREVIOUS_SLOT = 46;
    @Deprecated
    private static final int NEXT_SLOT = 52;
    @Deprecated
    private static final int[] BORDER = new int[]{0, 2, 3, 4, 5, 6, 8, 45, 47, 48, 49, 50, 51, 53};
    @Deprecated
    private static final int[] MAIN_CONTENT = new int[]{9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44};
    private static final JavaPlugin JAVA_PLUGIN = JustEnoughGuide.getInstance();
    private final SlimefunGuideImplementation implementation;
    private final Player player;
    private final int page;
    private final List<SlimefunItem> slimefunItemList;
    private Map<Integer, BookmarkGroup> pageMap = new LinkedHashMap<Integer, BookmarkGroup>();

    @ParametersAreNonnullByDefault
    public BookmarkGroup(@NotNull SlimefunGuideImplementation implementation, @NotNull Player player, @NotNull List<SlimefunItem> slimefunItemList) {
        super(new NamespacedKey((Plugin)JAVA_PLUGIN, "jeg_bookmark_group_" + String.valueOf(UUID.randomUUID())), new ItemStack(Material.BARRIER));
        this.page = 1;
        this.player = player;
        this.implementation = implementation;
        this.slimefunItemList = slimefunItemList;
        this.pageMap.put(1, this);
    }

    protected BookmarkGroup(@NotNull BookmarkGroup bookmarkGroup, int page) {
        super(bookmarkGroup.key, new ItemStack(Material.BARRIER));
        this.page = page;
        this.player = bookmarkGroup.player;
        this.implementation = bookmarkGroup.implementation;
        this.slimefunItemList = bookmarkGroup.slimefunItemList;
        this.pageMap.put(page, this);
    }

    public boolean isVisible(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        return false;
    }

    public void open(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        playerProfile.getGuideHistory().add((ItemGroup)this, this.page);
        this.generateMenu(player, playerProfile, slimefunGuideMode).open(new Player[]{player});
    }

    public void refresh(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        GuideUtil.removeLastEntry(playerProfile.getGuideHistory());
        this.open(player, playerProfile, slimefunGuideMode);
    }

    @NotNull
    private ChestMenu generateMenu(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        ChestMenu chestMenu = new ChestMenu("\u6536\u85cf\u9875 - JEG");
        chestMenu.setEmptySlotsClickable(false);
        chestMenu.addMenuOpeningHandler(pl -> pl.playSound(pl.getLocation(), Sounds.GUIDE_BUTTON_CLICK_SOUND, 1.0f, 1.0f));
        for (int ss : Formats.sub.getChars('b')) {
            chestMenu.addItem(ss, PatchScope.Back.patch(playerProfile, ChestMenuUtils.getBackButton((Player)player, (String[])new String[0])));
            chestMenu.addMenuClickHandler(ss, (pl, s, is, action) -> EventUtil.callEvent(new GuideEvents.BackButtonClickEvent(pl, is, s, action, chestMenu, this.implementation)).ifSuccess(() -> {
                GuideHistory guideHistory = playerProfile.getGuideHistory();
                if (action.isShiftClicked()) {
                    SlimefunGuide.openMainMenu((PlayerProfile)playerProfile, (SlimefunGuideMode)slimefunGuideMode, (int)guideHistory.getMainMenuPage());
                } else {
                    guideHistory.goBack(Slimefun.getRegistry().getSlimefunGuide(slimefunGuideMode));
                }
                return false;
            }));
        }
        for (int ss : Formats.sub.getChars('S')) {
            chestMenu.addItem(ss, PatchScope.Search.patch(playerProfile, ChestMenuUtils.getSearchButton((Player)player)));
            chestMenu.addMenuClickHandler(ss, (pl, slot, item, action) -> EventUtil.callEvent(new GuideEvents.SearchButtonClickEvent(pl, item, slot, action, chestMenu, this.implementation)).ifSuccess(() -> {
                pl.closeInventory();
                Slimefun.getLocalization().sendMessage((CommandSender)pl, "guide.search.message");
                ChatInput.waitForPlayer((Plugin)JAVA_PLUGIN, (Player)pl, msg -> this.implementation.openSearch(playerProfile, msg, this.implementation.getMode() == SlimefunGuideMode.SURVIVAL_MODE));
                return false;
            }));
        }
        for (int ss : Formats.sub.getChars('P')) {
            chestMenu.addItem(ss, PatchScope.PreviousPage.patch(playerProfile, ChestMenuUtils.getPreviousButton((Player)player, (int)this.page, (int)((this.slimefunItemList.size() - 1) / Formats.sub.getChars('i').size() + 1))));
            chestMenu.addMenuClickHandler(ss, (p, slot, item, action) -> EventUtil.callEvent(new GuideEvents.PreviousButtonClickEvent(p, item, slot, action, chestMenu, this.implementation)).ifSuccess(() -> {
                GuideUtil.removeLastEntry(playerProfile.getGuideHistory());
                BookmarkGroup bookMarkGroup = this.getByPage(Math.max(this.page - 1, 1));
                bookMarkGroup.open(player, playerProfile, slimefunGuideMode);
                return false;
            }));
        }
        for (int ss : Formats.sub.getChars('N')) {
            chestMenu.addItem(ss, PatchScope.NextPage.patch(playerProfile, ChestMenuUtils.getNextButton((Player)player, (int)this.page, (int)((this.slimefunItemList.size() - 1) / Formats.sub.getChars('i').size() + 1))));
            chestMenu.addMenuClickHandler(ss, (p, slot, item, action) -> EventUtil.callEvent(new GuideEvents.NextButtonClickEvent(p, item, slot, action, chestMenu, this.implementation)).ifSuccess(() -> {
                GuideUtil.removeLastEntry(playerProfile.getGuideHistory());
                BookmarkGroup bookMarkGroup = this.getByPage(Math.min(this.page + 1, (this.slimefunItemList.size() - 1) / Formats.sub.getChars('i').size() + 1));
                bookMarkGroup.open(player, playerProfile, slimefunGuideMode);
                return false;
            }));
        }
        for (int ss : Formats.sub.getChars('B')) {
            chestMenu.addItem(ss, PatchScope.Background.patch(playerProfile, ChestMenuUtils.getBackground()));
            chestMenu.addMenuClickHandler(ss, ChestMenuUtils.getEmptyClickHandler());
        }
        List<Integer> contentSlots = Formats.sub.getChars('i');
        for (int i = 0; i < contentSlots.size(); ++i) {
            ChestMenu.MenuClickHandler handler;
            ItemStack itemstack;
            int index = i + this.page * contentSlots.size() - contentSlots.size();
            if (index >= this.slimefunItemList.size()) continue;
            SlimefunItem slimefunItem = this.slimefunItemList.get(index);
            Research research = slimefunItem.getResearch();
            if (this.implementation.getMode() == SlimefunGuideMode.SURVIVAL_MODE && research != null && !playerProfile.hasUnlocked(research)) {
                itemstack = ItemStackUtil.getCleanItem(Converter.getItem(ChestMenuUtils.getNoPermissionItem(), "&f" + ItemUtils.getItemName((ItemStack)slimefunItem.getItem()), "&7" + slimefunItem.getId(), "&4&l" + Slimefun.getLocalization().getMessage(player, "guide.locked"), "", Lang.getGuideMessage("click-to-unlock"), "", Lang.getGuideMessage("cost", "cost", research.getCost())));
                handler = (pl, slot, item, action) -> EventUtil.callEvent(new GuideEvents.ResearchItemEvent(pl, item, slot, action, chestMenu, this.implementation)).ifSuccess(() -> {
                    research.unlockFromGuide(this.implementation, pl, playerProfile, slimefunItem, slimefunItem.getItemGroup(), this.page);
                    return false;
                });
            } else {
                itemstack = ItemStackUtil.getCleanItem(Converter.getItem(slimefunItem.getItem(), meta -> {
                    ItemGroup itemGroup = slimefunItem.getItemGroup();
                    List<String> additionLore = List.of("", Lang.getGuideMessage("addon", "symbol_block", "\u21e8", "addon_name", LocalHelper.getAddonName(itemGroup, slimefunItem.getId()), "category_name", itemGroup.getDisplayName(player)), Lang.getGuideMessage("unmark"));
                    if (meta.hasLore() && meta.getLore() != null) {
                        List lore = meta.getLore();
                        lore.addAll(additionLore);
                        meta.setLore(lore);
                    } else {
                        meta.setLore(additionLore);
                    }
                    meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS, JEGVersionedItemFlag.HIDE_ADDITIONAL_TOOLTIP});
                }));
                handler = (pl, slot, itm, action) -> EventUtil.callEvent(new GuideEvents.ItemButtonClickEvent(pl, itm, slot, action, chestMenu, this.implementation)).ifSuccess(() -> {
                    try {
                        if (action.isRightClicked()) {
                            GuideUtil.removeLastEntry(playerProfile.getGuideHistory());
                            JustEnoughGuide.getBookmarkManager().removeBookmark(player, slimefunItem);
                            List<SlimefunItem> items = JustEnoughGuide.getBookmarkManager().getBookmarkedItems(player);
                            if (items == null || items.isEmpty()) {
                                pl.closeInventory();
                                return false;
                            }
                            new BookmarkGroup(this.implementation, this.player, items).open(player, playerProfile, slimefunGuideMode);
                        } else if (this.implementation.getMode() != SlimefunGuideMode.SURVIVAL_MODE && (pl.isOp() || pl.hasPermission("slimefun.cheat.items"))) {
                            pl.getInventory().addItem(new ItemStack[]{slimefunItem.getItem().clone()});
                        } else {
                            this.implementation.displayItem(playerProfile, slimefunItem, true);
                        }
                    }
                    catch (Exception | LinkageError x) {
                        this.printErrorMessage(pl, slimefunItem, x);
                    }
                    return false;
                });
            }
            chestMenu.addItem(contentSlots.get(i).intValue(), PatchScope.BookMarkItem.patch(player, itemstack), handler);
        }
        GuideUtil.addRTSButton(chestMenu, player, playerProfile, Formats.sub, slimefunGuideMode, this.implementation);
        SlimefunGuideImplementation slimefunGuideImplementation = this.implementation;
        if (slimefunGuideImplementation instanceof JEGSlimefunGuideImplementation) {
            JEGSlimefunGuideImplementation jeg = (JEGSlimefunGuideImplementation)slimefunGuideImplementation;
            GuideUtil.addBookMarkButton(chestMenu, player, playerProfile, Formats.sub, jeg, (ItemGroup)this);
            GuideUtil.addItemMarkButton(chestMenu, player, playerProfile, Formats.sub, jeg, (ItemGroup)this);
        }
        Formats.sub.renderCustom(chestMenu);
        return chestMenu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private BookmarkGroup getByPage(int page) {
        if (this.pageMap.containsKey(page)) {
            return this.pageMap.get(page);
        }
        BookmarkGroup bookmarkGroup = this.pageMap.get(1);
        synchronized (bookmarkGroup) {
            if (this.pageMap.containsKey(page)) {
                return this.pageMap.get(page);
            }
            BookmarkGroup bookMarkGroup = new BookmarkGroup(this, page);
            bookMarkGroup.pageMap = this.pageMap;
            this.pageMap.put(page, bookMarkGroup);
            return bookMarkGroup;
        }
    }

    @ParametersAreNonnullByDefault
    private boolean isItemGroupAccessible(@NotNull Player p, @NotNull SlimefunItem slimefunItem) {
        return SlimefunOfficialSupporter.isShowHiddenItemGroups() || slimefunItem.getItemGroup().isAccessible(p);
    }

    @ParametersAreNonnullByDefault
    private void printErrorMessage(Player p, Throwable x) {
        p.sendMessage(Lang.getError("internal-error"));
        JustEnoughGuide.getInstance().getLogger().log(Level.SEVERE, Lang.getError("error-occurred"), x);
        JustEnoughGuide.getInstance().getLogger().warning(Lang.getError("trying-fix-guide", "player_name", p.getName()));
        PlayerProfile profile = PlayerProfile.find((OfflinePlayer)p).orElse(null);
        if (profile == null) {
            return;
        }
        GuideUtil.removeLastEntry(profile.getGuideHistory());
    }

    @ParametersAreNonnullByDefault
    private void printErrorMessage(Player p, SlimefunItem item, Throwable x) {
        p.sendMessage(Lang.getError("internal-error"));
        item.error(Lang.getError("item-error"), x);
        JustEnoughGuide.getInstance().getLogger().warning(Lang.getError("trying-fix-guide", "player_name", p.getName()));
        PlayerProfile profile = PlayerProfile.find((OfflinePlayer)p).orElse(null);
        if (profile == null) {
            return;
        }
        GuideUtil.removeLastEntry(profile.getGuideHistory());
    }
}

