/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.core.listeners;

import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.utils.Debug;
import com.balugaq.jeg.utils.GuideUtil;
import io.github.thebusybiscuit.slimefun4.api.events.SlimefunGuideOpenEvent;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class GuideListener
implements Listener {
    public static final int OPEN_GUIDE_DEFAULT_FATAL_ERROR_CODE = 12208;
    public static final int OPEN_GUIDE_ASYNC_FATAL_ERROR_CODE = 12209;
    public static final int OPEN_GUIDE_SYNC_FATAL_ERROR_CODE = 12210;
    public static final Map<Player, SlimefunGuideMode> guideModeMap = new ConcurrentHashMap<Player, SlimefunGuideMode>();

    @EventHandler(priority=EventPriority.LOW)
    public void onGuideOpen(@NotNull SlimefunGuideOpenEvent e) {
        if (!e.isCancelled()) {
            e.setCancelled(true);
            Player p = e.getPlayer();
            SlimefunGuideMode mode = e.getGuideLayout();
            try {
                this.openGuide(p, mode);
            }
            catch (Throwable ex) {
                try {
                    this.openGuideAsync(p, mode);
                }
                catch (Throwable ex2) {
                    try {
                        this.openGuideSync(p, mode);
                    }
                    catch (Throwable ex3) {
                        Debug.traceExactly(ex, "opening guide", 12208);
                        Debug.traceExactly(ex2, "opening guide asynchronously", 12209);
                        Debug.traceExactly(ex3, "opening guide synchronously", 12210);
                        PlayerProfile.find((OfflinePlayer)e.getPlayer()).ifPresent(profile -> GuideUtil.removeLastEntry(profile.getGuideHistory()));
                    }
                }
            }
        }
    }

    public void openGuide(@NotNull Player player, @NotNull SlimefunGuideMode mode) {
        Optional optional = PlayerProfile.find((OfflinePlayer)player);
        if (optional.isPresent()) {
            PlayerProfile profile = (PlayerProfile)optional.get();
            SlimefunGuideImplementation guide = GuideUtil.getGuide(player, mode);
            SlimefunGuideMode lastMode = guideModeMap.get(player);
            guideModeMap.put(player, mode);
            if (lastMode != mode) {
                GuideUtil.openMainMenu(player, profile, mode, 1);
            } else {
                profile.getGuideHistory().openLastEntry(guide);
            }
        } else {
            GuideUtil.openMainMenuAsync(player, mode, 1);
        }
    }

    public void openGuideAsync(@NotNull Player player, @NotNull SlimefunGuideMode mode) {
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)JustEnoughGuide.getInstance(), () -> {
            Optional optional = PlayerProfile.find((OfflinePlayer)player);
            if (optional.isPresent()) {
                PlayerProfile profile = (PlayerProfile)optional.get();
                SlimefunGuideImplementation guide = GuideUtil.getGuide(player, mode);
                SlimefunGuideMode lastMode = guideModeMap.get(player);
                guideModeMap.put(player, mode);
                if (lastMode != mode) {
                    GuideUtil.openMainMenu(player, profile, mode, 1);
                } else {
                    profile.getGuideHistory().openLastEntry(guide);
                }
            } else {
                GuideUtil.openMainMenuAsync(player, mode, 1);
            }
        }, 1L);
    }

    public void openGuideSync(@NotNull Player player, @NotNull SlimefunGuideMode mode) {
        Bukkit.getScheduler().runTaskLater((Plugin)JustEnoughGuide.getInstance(), () -> {
            Optional optional = PlayerProfile.find((OfflinePlayer)player);
            if (optional.isPresent()) {
                PlayerProfile profile = (PlayerProfile)optional.get();
                SlimefunGuideImplementation guide = GuideUtil.getGuide(player, mode);
                SlimefunGuideMode lastMode = guideModeMap.get(player);
                guideModeMap.put(player, mode);
                if (lastMode != mode) {
                    GuideUtil.openMainMenu(player, profile, mode, 1);
                } else {
                    profile.getGuideHistory().openLastEntry(guide);
                }
            } else {
                GuideUtil.openMainMenuAsync(player, mode, 1);
            }
        }, 1L);
    }
}

