/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.groups;

import com.balugaq.jeg.api.interfaces.DisplayInCheatMode;
import com.balugaq.jeg.api.interfaces.JEGSlimefunGuideImplementation;
import com.balugaq.jeg.api.interfaces.NotDisplayInSurvivalMode;
import com.balugaq.jeg.api.objects.annotations.CallTimeSensitive;
import com.balugaq.jeg.api.objects.enums.PatchScope;
import com.balugaq.jeg.api.objects.events.GuideEvents;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.utils.EventUtil;
import com.balugaq.jeg.utils.GuideUtil;
import com.balugaq.jeg.utils.ItemStackUtil;
import com.balugaq.jeg.utils.JEGVersionedItemFlag;
import com.balugaq.jeg.utils.Lang;
import com.balugaq.jeg.utils.SlimefunOfficialSupporter;
import com.balugaq.jeg.utils.compatibility.Converter;
import com.balugaq.jeg.utils.compatibility.Sounds;
import com.balugaq.jeg.utils.formatter.Formats;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.groups.FlexItemGroup;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.api.researches.Research;
import io.github.thebusybiscuit.slimefun4.core.guide.GuideHistory;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuide;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.chat.ChatInput;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@DisplayInCheatMode
@NotDisplayInSurvivalMode
public class NexcavateItemsGroup
extends FlexItemGroup {
    private static final List<SlimefunItem> ALL_SLIMEFUN_ITEMS = Slimefun.getRegistry().getAllSlimefunItems();
    @Deprecated
    private static final int BACK_SLOT = 1;
    @Deprecated
    private static final int SEARCH_SLOT = 7;
    @Deprecated
    private static final int PREVIOUS_SLOT = 46;
    @Deprecated
    private static final int NEXT_SLOT = 52;
    @Deprecated
    private static final int[] BORDER = new int[]{0, 2, 3, 4, 5, 6, 8, 45, 47, 48, 49, 50, 51, 53};
    @Deprecated
    private static final int[] MAIN_CONTENT = new int[]{9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44};
    private static final JavaPlugin JAVA_PLUGIN = JustEnoughGuide.getInstance();
    private final int page;
    private final List<SlimefunItem> slimefunItemList;
    private Map<Integer, NexcavateItemsGroup> pageMap = new LinkedHashMap<Integer, NexcavateItemsGroup>();

    @CallTimeSensitive(value="After Slimefun loaded")
    @ParametersAreNonnullByDefault
    public NexcavateItemsGroup(NamespacedKey key, ItemStack icon) {
        super(key, icon);
        this.page = 1;
        ArrayList<SlimefunItem> slimefunItemList = new ArrayList<SlimefunItem>();
        for (SlimefunItem item : ALL_SLIMEFUN_ITEMS) {
            if (!"nexcavate".equalsIgnoreCase(item.getAddon().getName())) continue;
            slimefunItemList.add(item);
        }
        this.slimefunItemList = slimefunItemList;
        this.pageMap.put(1, this);
    }

    protected NexcavateItemsGroup(@NotNull NexcavateItemsGroup nexcavateItemsGroup, int page) {
        super(nexcavateItemsGroup.key, Lang.NEXCAVATE_ITEMS_GROUP_ITEM);
        this.page = page;
        this.slimefunItemList = nexcavateItemsGroup.slimefunItemList;
        this.pageMap.put(page, this);
    }

    public boolean isVisible(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        return true;
    }

    public void open(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        playerProfile.getGuideHistory().add((ItemGroup)this, this.page);
        this.generateMenu(player, playerProfile, slimefunGuideMode).open(new Player[]{player});
    }

    public void refresh(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        GuideUtil.removeLastEntry(playerProfile.getGuideHistory());
        this.open(player, playerProfile, slimefunGuideMode);
    }

    @NotNull
    private ChestMenu generateMenu(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        ChestMenu chestMenu = new ChestMenu("\u6587\u660e\u590d\u5174\u7269\u54c1");
        chestMenu.setEmptySlotsClickable(false);
        chestMenu.addMenuOpeningHandler(pl -> pl.playSound(pl.getLocation(), Sounds.GUIDE_BUTTON_CLICK_SOUND, 1.0f, 1.0f));
        SlimefunGuideImplementation implementation = Slimefun.getRegistry().getSlimefunGuide(slimefunGuideMode);
        for (int ss : Formats.sub.getChars('b')) {
            chestMenu.addItem(ss, PatchScope.Back.patch(player, ChestMenuUtils.getBackButton((Player)player, (String[])new String[0])));
            chestMenu.addMenuClickHandler(ss, (pl, s, is, action) -> EventUtil.callEvent(new GuideEvents.BackButtonClickEvent(pl, is, s, action, chestMenu, implementation)).ifSuccess(() -> {
                GuideHistory guideHistory = playerProfile.getGuideHistory();
                if (action.isShiftClicked()) {
                    SlimefunGuide.openMainMenu((PlayerProfile)playerProfile, (SlimefunGuideMode)slimefunGuideMode, (int)guideHistory.getMainMenuPage());
                } else {
                    guideHistory.goBack(Slimefun.getRegistry().getSlimefunGuide(slimefunGuideMode));
                }
                return false;
            }));
        }
        for (int ss : Formats.sub.getChars('S')) {
            chestMenu.addItem(ss, PatchScope.Search.patch(player, ChestMenuUtils.getSearchButton((Player)player)));
            chestMenu.addMenuClickHandler(ss, (pl, slot, item, action) -> EventUtil.callEvent(new GuideEvents.SearchButtonClickEvent(pl, item, slot, action, chestMenu, implementation)).ifSuccess(() -> {
                pl.closeInventory();
                Slimefun.getLocalization().sendMessage((CommandSender)pl, "guide.search.message");
                ChatInput.waitForPlayer((Plugin)JAVA_PLUGIN, (Player)pl, msg -> implementation.openSearch(playerProfile, msg, implementation.getMode() == SlimefunGuideMode.SURVIVAL_MODE));
                return false;
            }));
        }
        for (int ss : Formats.sub.getChars('P')) {
            chestMenu.addItem(ss, PatchScope.PreviousPage.patch(player, ChestMenuUtils.getPreviousButton((Player)player, (int)this.page, (int)((this.slimefunItemList.size() - 1) / Formats.sub.getChars('i').size() + 1))));
            chestMenu.addMenuClickHandler(ss, (p, slot, item, action) -> EventUtil.callEvent(new GuideEvents.PreviousButtonClickEvent(p, item, slot, action, chestMenu, implementation)).ifSuccess(() -> {
                GuideUtil.removeLastEntry(playerProfile.getGuideHistory());
                NexcavateItemsGroup nexcavateItemsGroup = this.getByPage(Math.max(this.page - 1, 1));
                nexcavateItemsGroup.open(player, playerProfile, slimefunGuideMode);
                return false;
            }));
        }
        for (int ss : Formats.sub.getChars('N')) {
            chestMenu.addItem(ss, PatchScope.NextPage.patch(player, ChestMenuUtils.getNextButton((Player)player, (int)this.page, (int)((this.slimefunItemList.size() - 1) / Formats.sub.getChars('i').size() + 1))));
            chestMenu.addMenuClickHandler(ss, (p, slot, item, action) -> EventUtil.callEvent(new GuideEvents.NextButtonClickEvent(p, item, slot, action, chestMenu, implementation)).ifSuccess(() -> {
                GuideUtil.removeLastEntry(playerProfile.getGuideHistory());
                NexcavateItemsGroup nexcavateItemsGroup = this.getByPage(Math.min(this.page + 1, (this.slimefunItemList.size() - 1) / Formats.sub.getChars('i').size() + 1));
                nexcavateItemsGroup.open(player, playerProfile, slimefunGuideMode);
                return false;
            }));
        }
        for (int ss : Formats.sub.getChars('B')) {
            chestMenu.addItem(ss, PatchScope.Background.patch(player, ChestMenuUtils.getBackground()));
            chestMenu.addMenuClickHandler(ss, ChestMenuUtils.getEmptyClickHandler());
        }
        List<Integer> contentSlots = Formats.sub.getChars('i');
        for (int i = 0; i < contentSlots.size(); ++i) {
            ChestMenu.MenuClickHandler handler;
            ItemStack itemstack;
            int index = i + this.page * contentSlots.size() - contentSlots.size();
            if (index >= this.slimefunItemList.size()) continue;
            SlimefunItem slimefunItem = this.slimefunItemList.get(index);
            Research research = slimefunItem.getResearch();
            if (implementation.getMode() == SlimefunGuideMode.SURVIVAL_MODE && research != null && !playerProfile.hasUnlocked(research)) {
                itemstack = ItemStackUtil.getCleanItem(Converter.getItem(ChestMenuUtils.getNoPermissionItem(), "&f" + ItemUtils.getItemName((ItemStack)slimefunItem.getItem()), "&7" + slimefunItem.getId(), "&4&l" + Slimefun.getLocalization().getMessage(player, "guide.locked"), "", Lang.getGuideMessage("click-to-unlock"), "", Lang.getGuideMessage("cost", "cost", research.getCost())));
                handler = (pl, slot, item, action) -> EventUtil.callEvent(new GuideEvents.ItemButtonClickEvent(pl, item, slot, action, chestMenu, implementation)).ifSuccess(() -> {
                    research.unlockFromGuide(implementation, pl, playerProfile, slimefunItem, slimefunItem.getItemGroup(), this.page);
                    return false;
                });
            } else {
                itemstack = ItemStackUtil.getCleanItem(Converter.getItem(slimefunItem.getItem(), meta -> {
                    ItemGroup itemGroup = slimefunItem.getItemGroup();
                    if (meta.hasLore() && meta.getLore() != null) {
                        List lore = meta.getLore();
                        meta.setLore(lore);
                    }
                    meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS, JEGVersionedItemFlag.HIDE_ADDITIONAL_TOOLTIP});
                }));
                handler = (pl, slot, itm, action) -> EventUtil.callEvent(new GuideEvents.ItemButtonClickEvent(pl, itm, slot, action, chestMenu, implementation)).ifSuccess(() -> {
                    try {
                        if (implementation.getMode() != SlimefunGuideMode.SURVIVAL_MODE && (pl.isOp() || pl.hasPermission("slimefun.cheat.items"))) {
                            pl.getInventory().addItem(new ItemStack[]{slimefunItem.getItem().clone()});
                        } else {
                            implementation.displayItem(playerProfile, slimefunItem, true);
                        }
                    }
                    catch (Exception | LinkageError x) {
                        this.printErrorMessage(pl, slimefunItem, x);
                    }
                    return false;
                });
            }
            chestMenu.addItem(contentSlots.get(i).intValue(), PatchScope.SlimefunItem.patch(player, itemstack), handler);
        }
        GuideUtil.addRTSButton(chestMenu, player, playerProfile, Formats.sub, slimefunGuideMode, implementation);
        if (implementation instanceof JEGSlimefunGuideImplementation) {
            JEGSlimefunGuideImplementation jeg = (JEGSlimefunGuideImplementation)implementation;
            GuideUtil.addBookMarkButton(chestMenu, player, playerProfile, Formats.sub, jeg, (ItemGroup)this);
            GuideUtil.addItemMarkButton(chestMenu, player, playerProfile, Formats.sub, jeg, (ItemGroup)this);
        }
        Formats.sub.renderCustom(chestMenu);
        return chestMenu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private NexcavateItemsGroup getByPage(int page) {
        if (this.pageMap.containsKey(page)) {
            return this.pageMap.get(page);
        }
        NexcavateItemsGroup nexcavateItemsGroup = this.pageMap.get(1);
        synchronized (nexcavateItemsGroup) {
            if (this.pageMap.containsKey(page)) {
                return this.pageMap.get(page);
            }
            NexcavateItemsGroup nexcavateItemsGroup2 = new NexcavateItemsGroup(this, page);
            nexcavateItemsGroup2.pageMap = this.pageMap;
            this.pageMap.put(page, nexcavateItemsGroup2);
            return nexcavateItemsGroup2;
        }
    }

    @ParametersAreNonnullByDefault
    private boolean isItemGroupAccessible(@NotNull Player p, @NotNull SlimefunItem slimefunItem) {
        return SlimefunOfficialSupporter.isShowHiddenItemGroups() || slimefunItem.getItemGroup().isAccessible(p);
    }

    @ParametersAreNonnullByDefault
    private void printErrorMessage(Player p, Throwable x) {
        p.sendMessage(Lang.getError("internal-error"));
        JustEnoughGuide.getInstance().getLogger().log(Level.SEVERE, Lang.getError("error-occurred"), x);
        JustEnoughGuide.getInstance().getLogger().warning(Lang.getError("trying-fix-guide", "player_name", p.getName()));
        PlayerProfile profile = PlayerProfile.find((OfflinePlayer)p).orElse(null);
        if (profile == null) {
            return;
        }
        GuideUtil.removeLastEntry(profile.getGuideHistory());
    }

    @ParametersAreNonnullByDefault
    private void printErrorMessage(Player p, SlimefunItem item, Throwable x) {
        p.sendMessage(Lang.getError("internal-error"));
        item.error(Lang.getError("item-error"), x);
        JustEnoughGuide.getInstance().getLogger().warning(Lang.getError("trying-fix-guide", "player_name", p.getName()));
        PlayerProfile profile = PlayerProfile.find((OfflinePlayer)p).orElse(null);
        if (profile == null) {
            return;
        }
        GuideUtil.removeLastEntry(profile.getGuideHistory());
    }

    public boolean isCrossAddonItemGroup() {
        return true;
    }

    public int getTier() {
        return Integer.MAX_VALUE;
    }
}

