/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.utils;

import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClipboardUtil {
    @ParametersAreNonnullByDefault
    public static void send(Player player, String display, String hover, String text) {
        player.spigot().sendMessage((BaseComponent)ClipboardUtil.makeComponent(display, hover, text));
    }

    @ParametersAreNonnullByDefault
    public static void send(Player player, TextComponent component) {
        player.spigot().sendMessage((BaseComponent)component);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public static TextComponent makeComponent(String display, String hover, String text) {
        return ClipboardUtil.makeComponent(display, hover, text, null);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public static TextComponent makeComponent(String display, String hover, String text, @Nullable Consumer<TextComponent> consumer) {
        TextComponent msg = new TextComponent(ChatColors.color((String)display));
        msg.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(ChatColors.color((String)hover))}));
        msg.setClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, ChatColors.color((String)text)));
        if (consumer != null) {
            consumer.accept(msg);
        }
        return msg;
    }

    @Generated
    private ClipboardUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

