/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.groups;

import com.balugaq.jeg.api.interfaces.JEGSlimefunGuideImplementation;
import com.balugaq.jeg.api.interfaces.NotDisplayInCheatMode;
import com.balugaq.jeg.api.interfaces.NotDisplayInSurvivalMode;
import com.balugaq.jeg.api.objects.Timer;
import com.balugaq.jeg.api.objects.annotaions.Warn;
import com.balugaq.jeg.api.objects.enums.FilterType;
import com.balugaq.jeg.api.objects.enums.PatchScope;
import com.balugaq.jeg.api.objects.events.GuideEvents;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.utils.Debug;
import com.balugaq.jeg.utils.EventUtil;
import com.balugaq.jeg.utils.GuideUtil;
import com.balugaq.jeg.utils.ItemStackUtil;
import com.balugaq.jeg.utils.JEGVersionedItemFlag;
import com.balugaq.jeg.utils.Lang;
import com.balugaq.jeg.utils.LocalHelper;
import com.balugaq.jeg.utils.ReflectionUtil;
import com.balugaq.jeg.utils.SlimefunOfficialSupporter;
import com.balugaq.jeg.utils.SpecialMenuProvider;
import com.balugaq.jeg.utils.clickhandler.BeginnerUtils;
import com.balugaq.jeg.utils.clickhandler.GroupLinker;
import com.balugaq.jeg.utils.clickhandler.NamePrinter;
import com.balugaq.jeg.utils.compatibility.Converter;
import com.balugaq.jeg.utils.compatibility.Sounds;
import com.balugaq.jeg.utils.formatter.Formats;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.items.groups.FlexItemGroup;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.core.guide.GuideHistory;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuide;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.libraries.dough.chat.ChatInput;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.RandomizedSet;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.invoke.CallSite;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@NotDisplayInSurvivalMode
@NotDisplayInCheatMode
public class SearchGroup
extends FlexItemGroup {
    @Deprecated
    public static final Integer ACONTAINER_OFFSET = 50000;
    public static final Integer EN_THRESHOLD = 2;
    public static final Integer MAX_FIX_TIMES = 3;
    public static final String SPLIT = " ";
    @Deprecated
    @Warn(reason="No longer using it in EN version")
    public static final Char2ObjectOpenHashMap<Reference<Set<SlimefunItem>>> CACHE = new Char2ObjectOpenHashMap();
    @Deprecated
    @Warn(reason="No longer using it in EN version")
    public static final Char2ObjectOpenHashMap<Reference<Set<SlimefunItem>>> CACHE2 = new Char2ObjectOpenHashMap();
    public static final ObjectArrayList<String> EN_WORDS = new ObjectArrayList(50000);
    public static final Object2ObjectOpenHashMap<String, List<String>> EN_CACHE_ROLLBACK = new Object2ObjectOpenHashMap();
    public static final Object2ObjectOpenHashMap<String, Reference<Set<String>>> SPECIAL_CACHE = new Object2ObjectOpenHashMap();
    @Deprecated
    @Warn(reason="No longer using it in EN version")
    public static final ObjectOpenHashSet<String> SHARED_CHARS = new ObjectOpenHashSet();
    public static final Object2ObjectOpenHashMap<String, Reference<Set<SlimefunItem>>> EN_CACHE = new Object2ObjectOpenHashMap();
    public static final Object2ObjectOpenHashMap<String, Reference<Set<SlimefunItem>>> EN_CACHE2 = new Object2ObjectOpenHashMap();
    @Deprecated
    @Warn(reason="No longer using it in EN version")
    public static final ObjectOpenHashSet<String> BLACKLIST = new ObjectOpenHashSet();
    public static final ObjectOpenHashSet<String[]> SHARED_WORDS = new ObjectOpenHashSet();
    public static final Boolean SHOW_HIDDEN_ITEM_GROUPS = SlimefunOfficialSupporter.isShowHiddenItemGroups();
    public static final Integer DEFAULT_HASH_SIZE = 5000;
    public static final Object2IntOpenHashMap<SlimefunItem> ENABLED_ITEMS = new Object2IntOpenHashMap(DEFAULT_HASH_SIZE.intValue());
    public static final ObjectOpenHashSet<SlimefunItem> AVAILABLE_ITEMS = new ObjectOpenHashSet(DEFAULT_HASH_SIZE.intValue());
    @Deprecated
    public static final Integer[] BORDER = new Integer[]{0, 2, 3, 4, 5, 6, 8, 45, 47, 48, 49, 50, 51, 53};
    @Deprecated
    public static final Integer[] MAIN_CONTENT = new Integer[]{9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44};
    public static final JavaPlugin JAVA_PLUGIN = JustEnoughGuide.getInstance();
    @Deprecated
    private static final int BACK_SLOT = 1;
    @Deprecated
    private static final int SEARCH_SLOT = 7;
    @Deprecated
    private static final int PREVIOUS_SLOT = 46;
    @Deprecated
    private static final int NEXT_SLOT = 52;
    @NotNull
    public static Boolean LOADED = false;
    public final SlimefunGuideImplementation implementation;
    public final Player player;
    public final String searchTerm;
    public final Boolean pinyin;
    @NotNull
    public final Integer page;
    public final List<SlimefunItem> slimefunItemList;
    public final boolean re_search_when_cache_failed;
    public Map<Integer, SearchGroup> pageMap = new LinkedHashMap<Integer, SearchGroup>();

    public SearchGroup(SlimefunGuideImplementation implementation, @NotNull Player player, @NotNull String searchTerm, boolean pinyin) {
        this(implementation, player, searchTerm, pinyin, true);
    }

    public SearchGroup(SlimefunGuideImplementation implementation, @NotNull Player player, @NotNull String searchTerm, boolean pinyin, boolean re_search_when_cache_failed) {
        super(new NamespacedKey((Plugin)JAVA_PLUGIN, "jeg_search_group_" + String.valueOf(UUID.randomUUID())), new ItemStack(Material.BARRIER));
        if (!LOADED.booleanValue()) {
            SearchGroup.init();
        }
        this.page = 1;
        this.searchTerm = searchTerm;
        this.pinyin = pinyin;
        this.player = player;
        this.re_search_when_cache_failed = re_search_when_cache_failed;
        this.implementation = implementation;
        this.slimefunItemList = this.filterItems(player, searchTerm, pinyin);
        this.pageMap.put(1, this);
    }

    protected SearchGroup(@NotNull SearchGroup searchGroup, int page) {
        super(searchGroup.key, new ItemStack(Material.BARRIER));
        this.page = page;
        this.searchTerm = searchGroup.searchTerm;
        this.pinyin = searchGroup.pinyin;
        this.player = searchGroup.player;
        this.re_search_when_cache_failed = searchGroup.re_search_when_cache_failed;
        this.implementation = searchGroup.implementation;
        this.slimefunItemList = searchGroup.slimefunItemList;
        this.pageMap.put(page, this);
    }

    @ParametersAreNonnullByDefault
    public static boolean isSearchFilterApplicable(Player player, SlimefunItem slimefunItem, String searchTerm, boolean pinyin) {
        if (slimefunItem == null) {
            return false;
        }
        String itemName = ChatColor.stripColor((String)SlimefunOfficialSupporter.getTranslatedItemName(player, slimefunItem)).toLowerCase(Locale.ROOT);
        return SearchGroup.isSearchFilterApplicable(itemName, searchTerm.toLowerCase(), pinyin);
    }

    @ParametersAreNonnullByDefault
    public static boolean isSearchFilterApplicable(Player player, ItemStack itemStack, String searchTerm, boolean pinyin) {
        if (itemStack == null) {
            return false;
        }
        String itemName = ChatColor.stripColor((String)ItemUtils.getItemName((ItemStack)SlimefunOfficialSupporter.translateItem(player, itemStack))).toLowerCase(Locale.ROOT);
        return SearchGroup.isSearchFilterApplicable(itemName, searchTerm.toLowerCase(), pinyin);
    }

    @ParametersAreNonnullByDefault
    public static boolean isSearchFilterApplicable(String itemName, String searchTerm, boolean pinyin) {
        if (itemName.isEmpty()) {
            return false;
        }
        boolean result = itemName.contains(searchTerm);
        return result;
    }

    @NotNull
    public static List<SlimefunItem> filterItems(Player player, @NotNull FilterType filterType, @NotNull String filterValue, boolean pinyin, @NotNull List<SlimefunItem> items) {
        String lowerFilterValue = filterValue.toLowerCase();
        return items.stream().filter(item -> filterType.getFilter().apply(player, (SlimefunItem)item, lowerFilterValue, pinyin)).toList();
    }

    @NotNull
    public static Set<SlimefunItem> filterItems(Player player, @NotNull FilterType filterType, @NotNull String filterValue, boolean pinyin, @NotNull Set<SlimefunItem> items) {
        String lowerFilterValue = filterValue.toLowerCase();
        return items.stream().filter(item -> filterType.getFilter().apply(player, (SlimefunItem)item, lowerFilterValue, pinyin)).collect(Collectors.toSet());
    }

    public static void init() {
        if (!LOADED.booleanValue()) {
            LOADED = true;
            Debug.debug("Initializing Search Group...");
            Timer.start();
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)JAVA_PLUGIN, () -> {
                String s;
                BLACKLIST.add((Object)"Fast Machines");
                Object2ObjectOpenHashMap<String, List<String>> object2ObjectOpenHashMap = EN_CACHE_ROLLBACK;
                synchronized (object2ObjectOpenHashMap) {
                    EN_CACHE_ROLLBACK.clear();
                }
                int i = 0;
                for (SlimefunItem item : Slimefun.getRegistry().getEnabledSlimefunItems()) {
                    try {
                        Object r;
                        ENABLED_ITEMS.put((Object)item, i);
                        ++i;
                        if (item.isHidden() && !SHOW_HIDDEN_ITEM_GROUPS.booleanValue() || (r = item.getRecipe()) == null || item.isDisabled()) continue;
                        AVAILABLE_ITEMS.add((Object)item);
                        try {
                            List recipes;
                            String s2;
                            String id = item.getId();
                            if (SPECIAL_CACHE.containsKey((Object)id)) continue;
                            HashSet<String> cache = new HashSet<String>();
                            Object Orecipes = ReflectionUtil.getValue(item, "recipes");
                            if (Orecipes == null) {
                                Object Omaterial = ReflectionUtil.getValue(item, "material");
                                if (Omaterial == null) {
                                    Object ORECIPE_LIST = ReflectionUtil.getValue(item, "RECIPE_LIST");
                                    if (ORECIPE_LIST == null) {
                                        Object Ooutputs = ReflectionUtil.getValue(item, "outputs");
                                        if (Ooutputs == null) {
                                            ItemStack[] output;
                                            Object OOUTPUTS = ReflectionUtil.getValue(item, "OUTPUTS");
                                            if (OOUTPUTS == null) {
                                                String s3;
                                                Object Ooutput = ReflectionUtil.getValue(item, "output");
                                                if (Ooutput == null) {
                                                    Object Ogeneration = ReflectionUtil.getValue(item, "generation");
                                                    if (Ogeneration == null) {
                                                        Iterator Otemplates = ReflectionUtil.getValue(item, "templates");
                                                        if (Otemplates == null) continue;
                                                        if (Otemplates instanceof List) {
                                                            List templates = (List)((Object)Otemplates);
                                                            for (Object template : templates) {
                                                                Method method;
                                                                Object _Orecipes = ReflectionUtil.getValue(template, "recipes");
                                                                if (_Orecipes == null && (method = ReflectionUtil.getMethod(template.getClass(), "recipes")) != null) {
                                                                    try {
                                                                        method.setAccessible(true);
                                                                        _Orecipes = method.invoke(template, new Object[0]);
                                                                    }
                                                                    catch (Exception exception) {
                                                                        // empty catch block
                                                                    }
                                                                }
                                                                if (!(_Orecipes instanceof List)) continue;
                                                                List _recipes = (List)_Orecipes;
                                                                for (Object _recipe : _recipes) {
                                                                    ItemStack[] _output;
                                                                    if (!(_recipe instanceof MachineRecipe)) continue;
                                                                    MachineRecipe machineRecipe = (MachineRecipe)_recipe;
                                                                    for (ItemStack __output : _output = machineRecipe.getOutput()) {
                                                                        String s4 = ItemUtils.getItemName((ItemStack)__output);
                                                                        if (SearchGroup.inBanlist(s4)) continue;
                                                                        cache.add(s4);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    } else if (Ogeneration instanceof List) {
                                                        List generation = (List)Ogeneration;
                                                        for (Object g : generation) {
                                                            ItemStack itemStack;
                                                            String s5;
                                                            if (!(g instanceof ItemStack) || SearchGroup.inBanlist(s5 = ItemUtils.getItemName((ItemStack)(itemStack = (ItemStack)g)))) continue;
                                                            cache.add(s5);
                                                        }
                                                    }
                                                } else if (Ooutput instanceof ItemStack && !SearchGroup.inBanlist(s3 = ItemUtils.getItemName((ItemStack)(output = (ItemStack[])Ooutput)))) {
                                                    cache.add(s3);
                                                }
                                            }
                                            if (OOUTPUTS instanceof ItemStack[]) {
                                                ItemStack[] outputs = (ItemStack[])OOUTPUTS;
                                                if (!SearchGroup.isInstance(item, "StrainerBase")) continue;
                                                output = outputs;
                                                int s3 = output.length;
                                                for (int generation = 0; generation < s3; ++generation) {
                                                    ItemStack output2 = output[generation];
                                                    s2 = ItemUtils.getItemName((ItemStack)output2);
                                                    if (SearchGroup.inBanlist(s2)) continue;
                                                    cache.add(s2);
                                                }
                                            }
                                        } else if (Ooutputs instanceof Material[]) {
                                            Material[] outputs = (Material[])Ooutputs;
                                            if (!SearchGroup.isInstance(item, "Quarry")) continue;
                                            for (Material material : outputs) {
                                                String s6 = ItemUtils.getItemName((ItemStack)new ItemStack(material));
                                                if (SearchGroup.inBanlist(s6)) continue;
                                                cache.add(s6);
                                            }
                                        }
                                    } else if (ORECIPE_LIST instanceof List) {
                                        recipes = (List)ORECIPE_LIST;
                                        if (!SearchGroup.isInstance(item, "SingularityConstructor")) continue;
                                        for (Object recipe : recipes) {
                                            String s7;
                                            SlimefunItem slimefunItem;
                                            SlimefunItemStack output;
                                            String s8;
                                            ItemStack input = (ItemStack)ReflectionUtil.getValue(recipe, "input");
                                            if (input != null && !SearchGroup.inBanlist(s8 = ItemUtils.getItemName((ItemStack)input))) {
                                                cache.add(s8);
                                            }
                                            if ((output = (SlimefunItemStack)ReflectionUtil.getValue(recipe, "output")) == null || (slimefunItem = output.getItem()) == null || SearchGroup.inBanlist(s7 = slimefunItem.getItemName())) continue;
                                            cache.add(s7);
                                        }
                                    }
                                } else {
                                    if (!SearchGroup.isInstance(item, "MaterialGenerator")) continue;
                                    String s9 = ItemUtils.getItemName((ItemStack)new ItemStack((Material)Omaterial));
                                    if (!SearchGroup.inBanlist(s9)) {
                                        cache.add(s9);
                                    }
                                }
                            }
                            if (Orecipes instanceof SlimefunItemStack[]) {
                                Object[] recipes2 = (SlimefunItemStack[])Orecipes;
                                if (!SearchGroup.isInstance(item, "ResourceSynthesizer")) continue;
                                for (SlimefunItemStack slimefunItemStack : recipes2) {
                                    String s10;
                                    SlimefunItem slimefunItem = slimefunItemStack.getItem();
                                    if (slimefunItem == null || SearchGroup.inBanlist(s10 = slimefunItem.getItemName())) continue;
                                    cache.add(s10);
                                }
                            } else if (Orecipes instanceof EnumMap) {
                                EnumMap recipes3 = (EnumMap)Orecipes;
                                if (!SearchGroup.isInstance(item, "GrowingMachine")) continue;
                                recipes3.values().forEach(obj -> {
                                    ItemStack[] items;
                                    for (ItemStack itemStack : items = (ItemStack[])obj) {
                                        String s = ItemUtils.getItemName((ItemStack)itemStack);
                                        if (SearchGroup.inBanlist(s)) continue;
                                        cache.add(s);
                                    }
                                });
                            } else if (Orecipes instanceof List) {
                                recipes = (List)Orecipes;
                                if (!SearchGroup.isInstance(item, "MachineBlock")) {
                                    if (!SearchGroup.isInstance(item, "AbstractElectricMachine")) continue;
                                    for (Object recipe : recipes) {
                                        String s11;
                                        if (!(recipe instanceof MachineRecipe)) continue;
                                        MachineRecipe machineRecipe = (MachineRecipe)recipe;
                                        for (ItemStack input : machineRecipe.getInput()) {
                                            s11 = ItemUtils.getItemName((ItemStack)input);
                                            if (SearchGroup.inBanlist(s11)) continue;
                                            cache.add(s11);
                                        }
                                        for (ItemStack output : machineRecipe.getOutput()) {
                                            s11 = ItemUtils.getItemName((ItemStack)output);
                                            if (SearchGroup.inBanlist(s11)) continue;
                                            cache.add(s11);
                                        }
                                    }
                                }
                                for (Object recipe : recipes) {
                                    String s12;
                                    String[] strings = (String[])ReflectionUtil.getValue(recipe, "strings");
                                    if (strings == null) continue;
                                    for (String string : strings) {
                                        String s13;
                                        SlimefunItem slimefunItem = SlimefunItem.getById((String)string);
                                        if (slimefunItem != null) {
                                            s2 = slimefunItem.getItemName();
                                            if (SearchGroup.inBanlist(s2)) continue;
                                            cache.add(s2);
                                            continue;
                                        }
                                        Material material = Material.getMaterial((String)string);
                                        if (material == null || SearchGroup.inBanlist(s13 = ItemUtils.getItemName((ItemStack)new ItemStack(material)))) continue;
                                        cache.add(s13);
                                    }
                                    ItemStack output = (ItemStack)ReflectionUtil.getValue(recipe, "output");
                                    if (output == null || SearchGroup.inBanlist(s12 = ItemUtils.getItemName((ItemStack)output))) continue;
                                    cache.add(s12);
                                }
                            }
                            if (cache.isEmpty()) continue;
                            SPECIAL_CACHE.put((Object)id, new SoftReference(cache));
                        }
                        catch (Exception id) {
                        }
                    }
                    catch (Exception r) {}
                }
                HashSet<Material> materials = new HashSet<Material>();
                materials.add(Material.COBBLESTONE);
                materials.add(Material.STONE);
                materials.add(Material.SAND);
                materials.add(Material.STONE_BRICKS);
                materials.add(Material.SMOOTH_STONE);
                materials.add(Material.GLASS);
                materials.add(Material.CRACKED_STONE_BRICKS);
                materials.add(Material.GRAVEL);
                materials.add(Material.GRANITE);
                materials.add(Material.DIORITE);
                materials.add(Material.ANDESITE);
                materials.add(Material.POLISHED_GRANITE);
                materials.add(Material.POLISHED_DIORITE);
                materials.add(Material.POLISHED_ANDESITE);
                materials.add(Material.SANDSTONE);
                HashSet<String> cache = new HashSet<String>();
                for (Material material : materials) {
                    s = ItemUtils.getItemName((ItemStack)new ItemStack(material));
                    if (SearchGroup.inBanlist(s)) continue;
                    cache.add(s);
                }
                SPECIAL_CACHE.put((Object)"STONEWORKS_FACTORY", new SoftReference(cache));
                SlimefunItem item2 = SlimefunItem.getById((String)"VOID_BIT");
                if (item2 != null) {
                    HashSet<String> cache2 = new HashSet<String>();
                    s = item2.getItemName();
                    if (!SearchGroup.inBanlist(s)) {
                        cache2.add(s);
                        SPECIAL_CACHE.put((Object)"VOID_HARVESTER", new SoftReference(cache2));
                        SPECIAL_CACHE.put((Object)"INFINITY_VOID_HARVESTER", new SoftReference(cache2));
                    }
                }
                try {
                    ObjectIterator MobDataCardClass = Class.forName("io.github.mooy1.infinityexpansion.items.mobdata.MobDataCard");
                    Map cards = (Map)ReflectionUtil.getStaticValue(MobDataCardClass, "CARDS");
                    if (cards != null) {
                        cards.values().forEach(card -> {
                            RandomizedSet drops = (RandomizedSet)ReflectionUtil.getValue(card, "drops");
                            if (drops == null) {
                                return;
                            }
                            HashSet<String> cache2 = new HashSet<String>();
                            for (ItemStack itemStack : drops.toMap().keySet()) {
                                String s = ItemUtils.getItemName((ItemStack)itemStack);
                                if (SearchGroup.inBanlist(s)) continue;
                                cache2.add(s);
                            }
                            SPECIAL_CACHE.put((Object)((SlimefunItem)card).getId(), new SoftReference(cache2));
                        });
                    }
                }
                catch (Throwable MobDataCardClass) {
                    // empty catch block
                }
                for (SlimefunItem slimefunItem : AVAILABLE_ITEMS) {
                    try {
                        Set cache2;
                        Reference ref2;
                        String id;
                        if (slimefunItem == null) continue;
                        String name = ChatColor.stripColor((String)slimefunItem.getItemName());
                        for (SlimefunItemStack s14 : name.split(SPLIT)) {
                            Set set;
                            String d = s14.toLowerCase(Locale.ROOT);
                            if (!EN_WORDS.contains((Object)d)) {
                                EN_WORDS.add((Object)d);
                            }
                            EN_CACHE.putIfAbsent((Object)s14, new SoftReference(new HashSet()));
                            Reference ref = (Reference)EN_CACHE.get((Object)d);
                            if (ref == null || (set = (Set)ref.get()) == null || SearchGroup.inBanlist(slimefunItem)) continue;
                            set.add(slimefunItem);
                        }
                        List displayRecipes = null;
                        if (slimefunItem instanceof AContainer) {
                            AContainer ac = (AContainer)slimefunItem;
                            displayRecipes = ac.getDisplayRecipes();
                        } else if (slimefunItem instanceof MultiBlockMachine) {
                            MultiBlockMachine mb = (MultiBlockMachine)slimefunItem;
                            try {
                                displayRecipes = mb.getDisplayRecipes();
                            }
                            catch (Throwable e) {
                                Debug.trace(e, "init searching");
                            }
                        } else if (SpecialMenuProvider.ENABLED_LogiTech && SpecialMenuProvider.classLogiTech_CustomSlimefunItem != null && SpecialMenuProvider.classLogiTech_CustomSlimefunItem.isInstance(slimefunItem) && slimefunItem instanceof RecipeDisplayItem) {
                            RecipeDisplayItem rdi = (RecipeDisplayItem)slimefunItem;
                            try {
                                displayRecipes = rdi.getDisplayRecipes();
                            }
                            catch (Throwable e) {
                                Debug.trace(e, "init searching");
                            }
                        }
                        if (displayRecipes != null) {
                            for (ItemStack itemStack : displayRecipes) {
                                if (itemStack == null) continue;
                                String name2 = ChatColor.stripColor((String)ItemUtils.getItemName((ItemStack)itemStack));
                                for (String s15 : name2.split(SPLIT)) {
                                    String d = s15.toLowerCase(Locale.ROOT);
                                    EN_CACHE2.putIfAbsent((Object)d, new SoftReference(new HashSet()));
                                    Reference ref = (Reference)EN_CACHE2.get((Object)d);
                                    if (ref != null) {
                                        HashSet<SlimefunItem> set = (HashSet<SlimefunItem>)ref.get();
                                        if (set == null) {
                                            set = new HashSet<SlimefunItem>();
                                            EN_CACHE2.put((Object)d, new SoftReference(set));
                                        }
                                        if (!SearchGroup.inBanlist(slimefunItem) && !SearchGroup.inBlacklist(slimefunItem)) {
                                            set.add(slimefunItem);
                                        }
                                    }
                                    if (EN_WORDS.contains((Object)s15)) continue;
                                    EN_WORDS.add((Object)s15);
                                }
                            }
                        }
                        if (!SPECIAL_CACHE.containsKey((Object)(id = slimefunItem.getId())) || (ref2 = (Reference)SPECIAL_CACHE.get((Object)id)) == null || (cache2 = (Set)ref2.get()) == null) continue;
                        for (String s16 : cache2) {
                            Set set;
                            String d = s16.toLowerCase(Locale.ROOT);
                            EN_CACHE2.putIfAbsent((Object)d, new SoftReference(new HashSet()));
                            Reference ref = (Reference)EN_CACHE2.get((Object)d);
                            if (ref == null || (set = (Set)ref.get()) == null || SearchGroup.inBanlist(slimefunItem)) continue;
                            set.add(slimefunItem);
                        }
                    }
                    catch (Throwable throwable) {
                    }
                }
                HashSet<SlimefunItemStack> ACCEPTED_ITEMS = new HashSet<SlimefunItemStack>(Arrays.asList(SlimefunItems.BILLON_INGOT, SlimefunItems.SOLDER_INGOT, SlimefunItems.NICKEL_INGOT, SlimefunItems.COBALT_INGOT, SlimefunItems.DURALUMIN_INGOT, SlimefunItems.BRONZE_INGOT, SlimefunItems.BRASS_INGOT, SlimefunItems.ALUMINUM_BRASS_INGOT, SlimefunItems.STEEL_INGOT, SlimefunItems.DAMASCUS_STEEL_INGOT, SlimefunItems.ALUMINUM_BRONZE_INGOT, SlimefunItems.CORINTHIAN_BRONZE_INGOT, SlimefunItems.GILDED_IRON, SlimefunItems.REDSTONE_ALLOY, SlimefunItems.HARDENED_METAL_INGOT, SlimefunItems.REINFORCED_ALLOY_INGOT, SlimefunItems.FERROSILICON, SlimefunItems.ELECTRO_MAGNET, SlimefunItems.ELECTRIC_MOTOR, SlimefunItems.HEATING_COIL, SlimefunItems.SYNTHETIC_EMERALD, SlimefunItems.GOLD_4K, SlimefunItems.GOLD_6K, SlimefunItems.GOLD_8K, SlimefunItems.GOLD_10K, SlimefunItems.GOLD_12K, SlimefunItems.GOLD_14K, SlimefunItems.GOLD_16K, SlimefunItems.GOLD_18K, SlimefunItems.GOLD_20K, SlimefunItems.GOLD_22K, SlimefunItems.GOLD_24K));
                HashSet<String> items = new HashSet<String>();
                for (SlimefunItemStack slimefunItemStack : ACCEPTED_ITEMS) {
                    String s17;
                    SlimefunItem slimefunItem = slimefunItemStack.getItem();
                    if (slimefunItem == null || SearchGroup.inBanlist(s17 = slimefunItem.getItemName())) continue;
                    items.add(s17);
                }
                SPECIAL_CACHE.put((Object)"SMART_FACTORY", new SoftReference(items));
                for (String sharedWords : JustEnoughGuide.getConfigManager().getSharedWords()) {
                    HashSet sharedItems = new HashSet();
                    for (String s18 : sharedWords.split(SPLIT)) {
                        Set ss;
                        Reference ref = (Reference)EN_CACHE.get((Object)s18);
                        if (ref == null || (ss = (Set)ref.get()) == null) continue;
                        sharedItems.addAll(ss);
                    }
                    for (String s18 : sharedWords.split(SPLIT)) {
                        EN_CACHE.put((Object)s18, new SoftReference(sharedItems));
                    }
                }
                Debug.debug("Cache initialized.");
                Timer.log();
                Debug.debug("Search Group initialized.");
                Debug.debug("Enabled items: " + ENABLED_ITEMS.size());
                Debug.debug("Available items: " + AVAILABLE_ITEMS.size());
                Debug.debug("Machine blocks cache: " + SPECIAL_CACHE.size());
                Debug.debug("Shared words: " + JustEnoughGuide.getConfigManager().getSharedWords().size());
                Debug.debug("EN Words: " + EN_WORDS.size());
                Debug.debug("EN Cache 1 (Keywords): " + EN_CACHE.size());
                Debug.debug("EN Cache 2 (Display Recipes): " + EN_CACHE2.size());
            });
        }
    }

    public static boolean isInstance(@NotNull SlimefunItem item, String classSimpleName) {
        for (Class<?> clazz = item.getClass(); clazz != SlimefunItem.class; clazz = clazz.getSuperclass()) {
            if (!clazz.getSimpleName().equals(classSimpleName)) continue;
            return true;
        }
        return false;
    }

    public static boolean inBanlist(@NotNull SlimefunItem slimefunItem) {
        return SearchGroup.inBanlist(slimefunItem.getItemName());
    }

    public static boolean inBanlist(String itemName) {
        for (String s : JustEnoughGuide.getConfigManager().getBanlist()) {
            if (!ChatColor.stripColor((String)itemName).contains(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean inBlacklist(@NotNull SlimefunItem slimefunItem) {
        return SearchGroup.inBlacklist(slimefunItem.getItemName());
    }

    public static boolean inBlacklist(String itemName) {
        for (String s : JustEnoughGuide.getConfigManager().getBlacklist()) {
            if (!ChatColor.stripColor((String)itemName).contains(s)) continue;
            return true;
        }
        return false;
    }

    public static int levenshteinDistance(@NotNull String s1, @NotNull String s2) {
        int i;
        if (s1.length() > s2.length()) {
            String temp = s1;
            s1 = s2;
            s2 = temp;
        }
        int[] distances = new int[s1.length() + 1];
        for (i = 0; i <= s1.length(); ++i) {
            distances[i] = i;
        }
        for (i = 1; i <= s2.length(); ++i) {
            int[] prevDistances = (int[])distances.clone();
            distances[0] = i;
            for (int j = 1; j <= s1.length(); ++j) {
                int cost = s1.charAt(j - 1) == s2.charAt(i - 1) ? 0 : 1;
                distances[j] = Math.min(Math.min(distances[j - 1] + 1, prevDistances[j] + 1), prevDistances[j - 1] + cost);
            }
        }
        return distances[s1.length()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> findMostSimilar(@NotNull String target, int threshold) {
        if (EN_CACHE_ROLLBACK.containsKey((Object)target)) {
            return (List)EN_CACHE_ROLLBACK.get((Object)target);
        }
        PriorityQueue<AbstractMap.SimpleEntry<String, Integer>> minHeap = new PriorityQueue<AbstractMap.SimpleEntry<String, Integer>>(5, (a, b) -> (Integer)b.getValue() - (Integer)a.getValue());
        for (String s : EN_WORDS) {
            int distance = SearchGroup.levenshteinDistance(s, target);
            if (distance == 0) {
                return List.of(s);
            }
            if (distance > threshold) continue;
            AbstractMap.SimpleEntry<String, Integer> entry = new AbstractMap.SimpleEntry<String, Integer>(s, distance);
            if (minHeap.size() < MAX_FIX_TIMES) {
                minHeap.offer(entry);
                continue;
            }
            if (distance >= (Integer)((Map.Entry)minHeap.peek()).getValue()) continue;
            minHeap.poll();
            minHeap.offer(entry);
        }
        ArrayList<String> mostSimilar = new ArrayList<String>();
        while (!minHeap.isEmpty()) {
            mostSimilar.add(0, (String)((Map.Entry)minHeap.poll()).getKey());
        }
        Object2ObjectOpenHashMap<String, List<String>> object2ObjectOpenHashMap = EN_CACHE_ROLLBACK;
        synchronized (object2ObjectOpenHashMap) {
            EN_CACHE_ROLLBACK.put((Object)target, mostSimilar);
        }
        return mostSimilar;
    }

    public static boolean isContinuousScriptLanguage(@NotNull String language) {
        return language.startsWith("zh") || language.startsWith("ja") || language.startsWith("ko") || language.startsWith("th") || language.startsWith("vi") || language.startsWith("he") || language.startsWith("fa");
    }

    public static int nameFit(@NotNull String name, @NotNull String searchTerm) {
        int distance = SearchGroup.levenshteinDistance(searchTerm.toLowerCase(Locale.ROOT), name.toLowerCase(Locale.ROOT));
        int maxLen = Math.max(searchTerm.length(), name.length());
        int matchScore = maxLen == 0 ? 100 : (int)(100.0 * (1.0 - (double)distance / (double)maxLen));
        return matchScore;
    }

    @NotNull
    public static List<SlimefunItem> sortByNameFit(@NotNull Set<SlimefunItem> origin, @NotNull String searchTerm) {
        return origin.stream().sorted(Comparator.comparingInt(item -> -SearchGroup.nameFit(ChatColor.stripColor((String)item.getItemName()), searchTerm))).toList();
    }

    public boolean isVisible(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        return false;
    }

    public void open(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        playerProfile.getGuideHistory().add((ItemGroup)this, this.page.intValue());
        this.generateMenu(player, playerProfile, slimefunGuideMode).open(new Player[]{player});
    }

    public void refresh(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        GuideUtil.removeLastEntry(playerProfile.getGuideHistory());
        this.open(player, playerProfile, slimefunGuideMode);
    }

    @NotNull
    private ChestMenu generateMenu(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        ChestMenu chestMenu = new ChestMenu(Lang.getGuideMessage("searching", "item_name", ChatUtils.crop((ChatColor)ChatColor.WHITE, (String)this.searchTerm)));
        chestMenu.setEmptySlotsClickable(false);
        chestMenu.addMenuOpeningHandler(pl -> pl.playSound(pl.getLocation(), Sounds.GUIDE_BUTTON_CLICK_SOUND, 1.0f, 1.0f));
        for (int ss : Formats.sub.getChars('b')) {
            chestMenu.addItem(ss, PatchScope.Back.patch(player, SlimefunOfficialSupporter.getBackButton(player)));
            chestMenu.addMenuClickHandler(ss, (pl, s, is, action) -> EventUtil.callEvent(new GuideEvents.BackButtonClickEvent(pl, is, s, action, chestMenu, this.implementation)).ifSuccess(() -> {
                GuideHistory guideHistory = playerProfile.getGuideHistory();
                if (action.isShiftClicked()) {
                    SlimefunGuide.openMainMenu((PlayerProfile)playerProfile, (SlimefunGuideMode)slimefunGuideMode, (int)guideHistory.getMainMenuPage());
                } else {
                    guideHistory.goBack(this.implementation);
                }
                return false;
            }));
        }
        for (int ss : Formats.sub.getChars('S')) {
            chestMenu.addItem(ss, PatchScope.Search.patch(player, ChestMenuUtils.getSearchButton((Player)player)));
            chestMenu.addMenuClickHandler(ss, (pl, slot, item, action) -> EventUtil.callEvent(new GuideEvents.SearchButtonClickEvent(pl, item, slot, action, chestMenu, this.implementation)).ifSuccess(() -> {
                pl.closeInventory();
                Slimefun.getLocalization().sendMessage((CommandSender)pl, "guide.search.message");
                ChatInput.waitForPlayer((Plugin)JAVA_PLUGIN, (Player)pl, msg -> this.implementation.openSearch(playerProfile, msg, this.implementation.getMode() == SlimefunGuideMode.SURVIVAL_MODE));
                return false;
            }));
        }
        for (int ss : Formats.sub.getChars('P')) {
            chestMenu.addItem(ss, PatchScope.PreviousPage.patch(player, ChestMenuUtils.getPreviousButton((Player)player, (int)this.page, (int)((this.slimefunItemList.size() - 1) / Formats.sub.getChars('i').size() + 1))));
            chestMenu.addMenuClickHandler(ss, (p, slot, item, action) -> EventUtil.callEvent(new GuideEvents.PreviousButtonClickEvent(p, item, slot, action, chestMenu, this.implementation)).ifSuccess(() -> {
                GuideUtil.removeLastEntry(playerProfile.getGuideHistory());
                SearchGroup searchGroup = this.getByPage(Math.max(this.page - 1, 1));
                searchGroup.open(player, playerProfile, slimefunGuideMode);
                return false;
            }));
        }
        for (int ss : Formats.sub.getChars('N')) {
            chestMenu.addItem(ss, PatchScope.NextPage.patch(player, ChestMenuUtils.getNextButton((Player)player, (int)this.page, (int)((this.slimefunItemList.size() - 1) / Formats.sub.getChars('i').size() + 1))));
            chestMenu.addMenuClickHandler(ss, (p, slot, item, action) -> EventUtil.callEvent(new GuideEvents.NextButtonClickEvent(p, item, slot, action, chestMenu, this.implementation)).ifSuccess(() -> {
                GuideUtil.removeLastEntry(playerProfile.getGuideHistory());
                SearchGroup searchGroup = this.getByPage(Math.min(this.page + 1, (this.slimefunItemList.size() - 1) / Formats.sub.getChars('i').size() + 1));
                searchGroup.open(player, playerProfile, slimefunGuideMode);
                return false;
            }));
        }
        for (int ss : Formats.sub.getChars('B')) {
            chestMenu.addItem(ss, PatchScope.Background.patch(player, ChestMenuUtils.getBackground()));
            chestMenu.addMenuClickHandler(ss, ChestMenuUtils.getEmptyClickHandler());
        }
        List<Integer> contentSlots = Formats.sub.getChars('i');
        for (int i = 0; i < contentSlots.size(); ++i) {
            int index = i + this.page * contentSlots.size() - contentSlots.size();
            if (index >= this.slimefunItemList.size()) continue;
            SlimefunItem slimefunItem = this.slimefunItemList.get(index);
            ItemStack itemstack = ItemStackUtil.getCleanItem(Converter.getItem(SlimefunOfficialSupporter.translateItem(player, slimefunItem.getItem()), meta -> {
                ItemGroup itemGroup = slimefunItem.getItemGroup();
                List<CallSite> additionLore = List.of("", String.valueOf(ChatColor.DARK_GRAY) + "\u21e8 " + String.valueOf(ChatColor.WHITE) + LocalHelper.getAddonName(itemGroup, slimefunItem.getId()) + String.valueOf(ChatColor.WHITE) + " - " + LocalHelper.getDisplayName(itemGroup, player));
                if (meta.hasLore() && meta.getLore() != null) {
                    List lore = meta.getLore();
                    lore.addAll(additionLore);
                    meta.setLore(lore);
                } else {
                    meta.setLore(additionLore);
                }
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS, JEGVersionedItemFlag.HIDE_ADDITIONAL_TOOLTIP});
            }));
            chestMenu.addItem(contentSlots.get(i).intValue(), PatchScope.SearchItem.patch(player, SlimefunOfficialSupporter.translateItem(player, itemstack)), (pl, slot, itm, action) -> EventUtil.callEvent(new GuideEvents.ItemButtonClickEvent(pl, itm, slot, action, chestMenu, this.implementation)).ifSuccess(() -> {
                try {
                    if (this.implementation.getMode() != SlimefunGuideMode.SURVIVAL_MODE && (pl.isOp() || pl.hasPermission("slimefun.cheat.items"))) {
                        pl.getInventory().addItem(new ItemStack[]{slimefunItem.getItem().clone()});
                    } else {
                        this.implementation.displayItem(playerProfile, slimefunItem, true);
                    }
                }
                catch (Exception | LinkageError x) {
                    this.printErrorMessage(pl, slimefunItem, x);
                }
                return false;
            }));
            BeginnerUtils.applyWith(this.implementation, chestMenu, contentSlots.get(i));
            GroupLinker.applyWith(this.implementation, chestMenu, contentSlots.get(i));
            NamePrinter.applyWith(this.implementation, chestMenu, contentSlots.get(i));
        }
        GuideUtil.addRTSButton(chestMenu, player, playerProfile, Formats.sub, slimefunGuideMode, this.implementation);
        SlimefunGuideImplementation slimefunGuideImplementation = this.implementation;
        if (slimefunGuideImplementation instanceof JEGSlimefunGuideImplementation) {
            JEGSlimefunGuideImplementation jeg = (JEGSlimefunGuideImplementation)slimefunGuideImplementation;
            GuideUtil.addBookMarkButton(chestMenu, player, playerProfile, Formats.sub, jeg, (ItemGroup)this);
            GuideUtil.addItemMarkButton(chestMenu, player, playerProfile, Formats.sub, jeg, (ItemGroup)this);
        }
        Formats.sub.renderCustom(chestMenu);
        return chestMenu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SearchGroup getByPage(int page) {
        if (this.pageMap.containsKey(page)) {
            return this.pageMap.get(page);
        }
        SearchGroup searchGroup = this.pageMap.get(1);
        synchronized (searchGroup) {
            if (this.pageMap.containsKey(page)) {
                return this.pageMap.get(page);
            }
            SearchGroup searchGroup2 = new SearchGroup(this, page);
            searchGroup2.pageMap = this.pageMap;
            this.pageMap.put(page, searchGroup2);
            return searchGroup2;
        }
    }

    @Deprecated
    @NotNull
    public List<SlimefunItem> getAllMatchedItems(@NotNull Player p, @NotNull String searchTerm, boolean pinyin) {
        return this.filterItems(p, searchTerm, pinyin);
    }

    @ParametersAreNonnullByDefault
    private void printErrorMessage(Player p, Throwable x) {
        p.sendMessage(Lang.getError("internal-error"));
        JustEnoughGuide.getInstance().getLogger().log(Level.SEVERE, Lang.getError("error-occurred"), x);
        JustEnoughGuide.getInstance().getLogger().warning(Lang.getError("trying-fix-guide", "player_name", p.getName()));
        PlayerProfile profile = PlayerProfile.find((OfflinePlayer)p).orElse(null);
        if (profile == null) {
            return;
        }
        GuideUtil.removeLastEntry(profile.getGuideHistory());
    }

    @ParametersAreNonnullByDefault
    private void printErrorMessage(Player p, SlimefunItem item, Throwable x) {
        p.sendMessage(Lang.getError("internal-error"));
        item.error(Lang.getError("item-error"), x);
        JustEnoughGuide.getInstance().getLogger().warning(Lang.getError("trying-fix-guide", "player_name", p.getName()));
        PlayerProfile profile = PlayerProfile.find((OfflinePlayer)p).orElse(null);
        if (profile == null) {
            return;
        }
        GuideUtil.removeLastEntry(profile.getGuideHistory());
    }

    @NotNull
    public List<SlimefunItem> filterItems(@NotNull Player player, @NotNull String searchTerm, boolean pinyin) {
        StringBuilder actualSearchTermBuilder = new StringBuilder();
        String[] split = searchTerm.split(SPLIT);
        HashMap<FilterType, String> filters = new HashMap<FilterType, String>();
        for (String s : split) {
            boolean isFilter = false;
            for (FilterType filterType : FilterType.values()) {
                if (!s.startsWith(filterType.getSymbol()) || s.length() <= filterType.getSymbol().length()) continue;
                isFilter = true;
                String filterValue = s.substring(filterType.getFlag().length()).replace(".", SPLIT);
                filters.put(filterType, filterValue);
                break;
            }
            if (isFilter) continue;
            actualSearchTermBuilder.append(s).append(SPLIT);
        }
        String actualSearchTerm = actualSearchTermBuilder.toString().trim();
        for (FilterType filterType : FilterType.values()) {
            String flag = filterType.getSymbol();
            actualSearchTerm = actualSearchTerm.replaceAll(Pattern.quote(flag), Matcher.quoteReplacement(flag));
        }
        HashSet<SlimefunItem> merge = new HashSet<SlimefunItem>(144);
        Set<SlimefunItem> items = new HashSet<SlimefunItem>(AVAILABLE_ITEMS.stream().filter(item -> item.getItemGroup().isAccessible(player)).toList());
        if (!actualSearchTerm.isBlank()) {
            int beforeSize = merge.size();
            Debug.debug("Search term: " + actualSearchTerm);
            String[] words = actualSearchTerm.split(SPLIT);
            HashSet<SlimefunItem> currentResults = new HashSet<SlimefunItem>(items);
            for (String word : words) {
                String language;
                Debug.debug("Word: " + word);
                List<String> fixedWords = words.length == 1 ? (SearchGroup.isContinuousScriptLanguage(language = Slimefun.getLocalization().getLanguage(player).getId()) ? List.of(word) : SearchGroup.findMostSimilar(word, EN_THRESHOLD)) : SearchGroup.findMostSimilar(word, EN_THRESHOLD);
                HashSet<SlimefunItem> wordMatches = new HashSet<SlimefunItem>();
                if (fixedWords.isEmpty()) {
                    Debug.debug("No fixed words found.");
                    if (this.re_search_when_cache_failed) {
                        wordMatches.addAll(this.filterItems(FilterType.BY_ITEM_NAME, word, false, new HashSet<SlimefunItem>(items)));
                        wordMatches.addAll(this.filterItems(FilterType.BY_DISPLAY_ITEM_NAME, word, false, new HashSet<SlimefunItem>(items)));
                    }
                } else {
                    Debug.debug("Fixed words: " + String.valueOf(fixedWords));
                    for (String candidate : fixedWords) {
                        wordMatches.addAll(this.filterItems(FilterType.BY_ITEM_NAME, candidate, false, new HashSet<SlimefunItem>(items)));
                        wordMatches.addAll(this.filterItems(FilterType.BY_DISPLAY_ITEM_NAME, candidate, false, new HashSet<SlimefunItem>(items)));
                    }
                }
                currentResults.retainAll(wordMatches);
            }
            merge.addAll(currentResults);
            int afterSize = merge.size();
            if (beforeSize == afterSize) {
                Debug.debug("Same size, fallback to search by name.");
                merge.addAll(this.filterItems(FilterType.BY_ITEM_NAME, actualSearchTerm, false, new HashSet<SlimefunItem>(items)));
                merge.addAll(this.filterItems(FilterType.BY_DISPLAY_ITEM_NAME, actualSearchTerm, false, new HashSet<SlimefunItem>(items)));
            }
            Debug.debug("Filtered items: " + merge.size());
        }
        if (!filters.isEmpty()) {
            for (Map.Entry entry : filters.entrySet()) {
                items = this.filterItems((FilterType)((Object)entry.getKey()), (String)entry.getValue(), pinyin, items);
            }
            merge.addAll(items);
        }
        return SearchGroup.sortByNameFit(merge, actualSearchTerm);
    }

    @NotNull
    public List<SlimefunItem> filterItems(@NotNull FilterType filterType, @NotNull String filterValue, boolean pinyin, @NotNull List<SlimefunItem> items) {
        return SearchGroup.filterItems(this.player, filterType, filterValue, pinyin, items);
    }

    @NotNull
    public Set<SlimefunItem> filterItems(@NotNull FilterType filterType, @NotNull String filterValue, boolean pinyin, @NotNull Set<SlimefunItem> items) {
        return SearchGroup.filterItems(this.player, filterType, filterValue, pinyin, items);
    }
}

