/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.recipe_complete.source.base;

import com.balugaq.jeg.api.recipe_complete.source.base.SlimefunSource;
import com.balugaq.jeg.api.recipe_complete.source.base.VanillaSource;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipeCompleteProvider {
    private static final List<SlimefunSource> slimefunSources = new ArrayList<SlimefunSource>();
    private static final List<VanillaSource> vanillaSources = new ArrayList<VanillaSource>();

    public static void addSource(@NotNull SlimefunSource source) {
        if (JustEnoughGuide.getConfigManager().isRecipeComplete()) {
            slimefunSources.add(source);
        }
    }

    public static void addSource(@NotNull VanillaSource source) {
        if (JustEnoughGuide.getConfigManager().isRecipeComplete()) {
            vanillaSources.add(source);
        }
    }

    @Nullable
    public static SlimefunSource removeSlimefunSource(@NotNull SlimefunSource source) {
        return slimefunSources.remove(source) ? source : null;
    }

    @Nullable
    public static SlimefunSource removeSlimefunSource(@NotNull JavaPlugin plugin) {
        for (SlimefunSource source : slimefunSources) {
            if (!source.plugin().equals((Object)plugin)) continue;
            return slimefunSources.remove(source) ? source : null;
        }
        return null;
    }

    @Nullable
    public static VanillaSource removeVanillaSource(@NotNull VanillaSource source) {
        return vanillaSources.remove(source) ? source : null;
    }

    @Nullable
    public static VanillaSource removeVanillaSource(@NotNull JavaPlugin plugin) {
        for (VanillaSource source : vanillaSources) {
            if (!source.plugin().equals((Object)plugin)) continue;
            return vanillaSources.remove(source) ? source : null;
        }
        return null;
    }

    public static void shutdown() {
        slimefunSources.clear();
        vanillaSources.clear();
    }

    @Generated
    public static List<SlimefunSource> getSlimefunSources() {
        return slimefunSources;
    }

    @Generated
    public static List<VanillaSource> getVanillaSources() {
        return vanillaSources;
    }
}

