/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.core.integrations.networksexpansion;

import com.balugaq.jeg.api.recipe_complete.RecipeCompletableRegistry;
import com.balugaq.jeg.api.recipe_complete.source.base.RecipeCompleteProvider;
import com.balugaq.jeg.core.integrations.Integration;
import com.balugaq.jeg.core.integrations.networksexpansion.NetworksExpansionRecipeCompleteSlimefunSource;
import com.balugaq.jeg.core.integrations.networksexpansion.NetworksExpansionRecipeCompleteVanillaSource;
import io.github.sefiraat.networks.NetworkStorage;
import io.github.sefiraat.networks.network.NetworkRoot;
import io.github.sefiraat.networks.network.NodeDefinition;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NetworksExpansionIntegrationMain
implements Integration {
    public static final int[] ENCODER_RECIPE_SLOTS = new int[]{12, 13, 14, 21, 22, 23, 30, 31, 32};
    public static final int[] CRAFTING_GRID_RECIPE_SLOTS = new int[]{6, 7, 8, 15, 16, 17, 24, 25, 26};
    public static final BlockFace[] VALID_FACES = new BlockFace[]{BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
    public static final List<SlimefunItem> handledSlimefunItems = new ArrayList<SlimefunItem>();
    @Nullable
    public static JavaPlugin plugin = null;

    @Nullable
    public static JavaPlugin getPlugin() {
        if (plugin == null) {
            plugin = (JavaPlugin)Bukkit.getPluginManager().getPlugin("Networks");
        }
        return plugin;
    }

    public static void rrc(@NotNull String id, int @NotNull [] slots, boolean unordered) {
        SlimefunItem slimefunItem = SlimefunItem.getById((String)id);
        if (slimefunItem != null) {
            NetworksExpansionIntegrationMain.rrc(slimefunItem, slots, unordered);
        }
    }

    public static void rrc(@NotNull SlimefunItem slimefunItem, int @NotNull [] slots, boolean unordered) {
        handledSlimefunItems.add(slimefunItem);
        RecipeCompletableRegistry.registerRecipeCompletable(slimefunItem, slots, unordered);
    }

    @Nullable
    public static NetworkRoot findNearbyNetworkRoot(@NotNull Location location) {
        NetworkRoot root = null;
        for (BlockFace blockFace : VALID_FACES) {
            Location clone = location.clone();
            switch (blockFace) {
                case NORTH: {
                    clone.set((double)clone.getBlockX(), (double)clone.getBlockY(), (double)(clone.getBlockZ() - 1));
                    break;
                }
                case EAST: {
                    clone.set((double)(clone.getBlockX() + 1), (double)clone.getBlockY(), (double)clone.getBlockZ());
                    break;
                }
                case SOUTH: {
                    clone.set((double)clone.getBlockX(), (double)clone.getBlockY(), (double)(clone.getBlockZ() + 1));
                    break;
                }
                case WEST: {
                    clone.set((double)(clone.getBlockX() - 1), (double)clone.getBlockY(), (double)clone.getBlockZ());
                    break;
                }
                case UP: {
                    clone.set((double)clone.getBlockX(), (double)(clone.getBlockY() + 1), (double)clone.getBlockZ());
                    break;
                }
                case DOWN: {
                    clone.set((double)clone.getBlockX(), (double)(clone.getBlockY() - 1), (double)clone.getBlockZ());
                }
            }
            NodeDefinition def2 = NetworkStorage.getNode((Location)clone);
            if (def2 == null || def2.getNode() == null) continue;
            root = def2.getNode().getRoot();
            break;
        }
        return root;
    }

    @Override
    @NotNull
    public String getHookPlugin() {
        return "NetworksExpansion";
    }

    @Override
    public void onEnable() {
        RecipeCompleteProvider.addSource(new NetworksExpansionRecipeCompleteSlimefunSource());
        RecipeCompleteProvider.addSource(new NetworksExpansionRecipeCompleteVanillaSource());
        NetworksExpansionIntegrationMain.rrc("NTW_EXPANSION_ANCIENT_ALTAR_RECIPE_ENCODER", ENCODER_RECIPE_SLOTS, false);
        NetworksExpansionIntegrationMain.rrc("NTW_EXPANSION_ARMOR_FORGE_RECIPE_ENCODER", CRAFTING_GRID_RECIPE_SLOTS, false);
        NetworksExpansionIntegrationMain.rrc("NTW_EXPANSION_COMPRESSOR_RECIPE_ENCODER", CRAFTING_GRID_RECIPE_SLOTS, false);
        NetworksExpansionIntegrationMain.rrc("NTW_EXPANSION_EXPANSION_WORKBENCH_RECIPE_ENCODER", CRAFTING_GRID_RECIPE_SLOTS, false);
        NetworksExpansionIntegrationMain.rrc("NTW_EXPANSION_GRIND_STONE_RECIPE_ENCODER", CRAFTING_GRID_RECIPE_SLOTS, false);
        NetworksExpansionIntegrationMain.rrc("NTW_EXPANSION_JUICER_RECIPE_ENCODER", CRAFTING_GRID_RECIPE_SLOTS, false);
        NetworksExpansionIntegrationMain.rrc("NTW_EXPANSION_AUTO_MAGIC_WORKBENCH", CRAFTING_GRID_RECIPE_SLOTS, false);
        NetworksExpansionIntegrationMain.rrc("NTW_EXPANSION_ORE_CRUSHER_RECIPE_ENCODER", CRAFTING_GRID_RECIPE_SLOTS, false);
        NetworksExpansionIntegrationMain.rrc("NTW_EXPANSION_PRESSURE_CHAMBER_RECIPE_ENCODER", CRAFTING_GRID_RECIPE_SLOTS, false);
        NetworksExpansionIntegrationMain.rrc("NTW_EXPANSION_QUANTUM_WORKBENCH_RECIPE_ENCODER", CRAFTING_GRID_RECIPE_SLOTS, false);
        NetworksExpansionIntegrationMain.rrc("NTW_EXPANSION_SMELTERY_RECIPE_ENCODER", CRAFTING_GRID_RECIPE_SLOTS, false);
        NetworksExpansionIntegrationMain.rrc("NTW_EXPANSION_CRAFTING_GRID_NEW_STYLE", CRAFTING_GRID_RECIPE_SLOTS, false);
    }

    @Override
    public void onDisable() {
        for (SlimefunItem slimefunItem : handledSlimefunItems) {
            RecipeCompletableRegistry.unregisterRecipeCompletable(slimefunItem);
        }
    }
}

