/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.core.commands;

import com.balugaq.jeg.api.interfaces.JEGCommand;
import com.balugaq.jeg.utils.ClipboardUtil;
import com.balugaq.jeg.utils.ItemStackUtil;
import com.balugaq.jeg.utils.compatibility.Converter;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class CategoriesCommand
implements JEGCommand {
    private final Plugin plugin;

    public CategoriesCommand(Plugin plugin) {
        this.plugin = plugin;
    }

    @ParametersAreNonnullByDefault
    private static void populateCategoryMenu(ChestMenu menu, List<ItemGroup> groups, @Range(from=1L, to=0x7FFFFFFFL) int page, Player p) {
        int i;
        for (i = 0; i < 54; ++i) {
            menu.addMenuClickHandler(i, ChestMenuUtils.getEmptyClickHandler());
        }
        for (i = 45; i < 54; ++i) {
            menu.replaceExistingItem(i, ChestMenuUtils.getBackground());
        }
        for (i = 0; i < 45; ++i) {
            int groupIndex = i + 1 + (page - 1) * 45;
            ItemGroup group = CategoriesCommand.getItemGroupOrNull(groups, groupIndex);
            if (group != null) {
                ItemStack catItem = group.getItem(p).clone();
                ItemMeta catMeta = catItem.getItemMeta();
                ArrayList<String> categoryLore = catMeta.getLore();
                String id = group.getKey().getNamespace() + ":" + group.getKey().getKey();
                String className = group.getClass().getName();
                if (categoryLore == null) {
                    categoryLore = new ArrayList<String>(2);
                }
                categoryLore.set(categoryLore.size() - 1, ChatColors.color((String)("&6ID: " + id)));
                categoryLore.add(ChatColors.color((String)("&6class: " + className)));
                categoryLore.add(ChatColors.color((String)"&a\u70b9\u51fb\u590d\u5236\u5230\u804a\u5929\u680f"));
                catMeta.setLore(categoryLore);
                catItem.setItemMeta(catMeta);
                menu.replaceExistingItem(i, catItem);
                menu.addMenuClickHandler(i, (p1, s1, i1, a1) -> {
                    ClipboardUtil.send(p1, "&d\u70b9\u51fb\u590d\u5236: " + id, "&d\u70b9\u51fb\u590d\u5236", id);
                    ClipboardUtil.send(p1, "&d\u70b9\u51fb\u590d\u5236: " + className, "&d\u70b9\u51fb\u590d\u5236", className);
                    return false;
                });
                continue;
            }
            menu.replaceExistingItem(i, Converter.getItem(ItemStackUtil.getCleanItem(null)));
        }
        if (page > 1) {
            menu.replaceExistingItem(46, Converter.getItem(Material.LIME_STAINED_GLASS_PANE, "&a\u4e0a\u4e00\u9875", new String[0]));
            menu.addMenuClickHandler(46, (pl, s, is, action) -> {
                CategoriesCommand.populateCategoryMenu(menu, groups, page - 1, p);
                return false;
            });
        }
        if (CategoriesCommand.getItemGroupOrNull(groups, 45 * page + 1) != null) {
            menu.replaceExistingItem(52, Converter.getItem(Material.LIME_STAINED_GLASS_PANE, "&a\u4e0b\u4e00\u9875", new String[0]));
            menu.addMenuClickHandler(52, (pl, s, is, action) -> {
                CategoriesCommand.populateCategoryMenu(menu, groups, page + 1, p);
                return false;
            });
        }
    }

    @Nullable
    private static ItemGroup getItemGroupOrNull(@NotNull List<ItemGroup> groups, int index) {
        return index < groups.size() ? groups.get(index) : null;
    }

    @Override
    @NotNull
    public List<String> onTabCompleteRaw(@NotNull CommandSender sender, @NotNull @NotNull String @NotNull [] args) {
        switch (args.length) {
            case 1: {
                return List.of("categories");
            }
        }
        return List.of();
    }

    @Override
    public boolean canCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        if (sender.isOp() && args.length == 1) {
            return "categories".equalsIgnoreCase(args[0]);
        }
        return false;
    }

    @Override
    public void onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            ChestMenu menu = new ChestMenu("&6\u7269\u54c1\u7ec4\u5927\u5168");
            menu.addItem(53, Converter.getItem(ItemStackUtil.getCleanItem(null)));
            CategoriesCommand.populateCategoryMenu(menu, Slimefun.getRegistry().getAllItemGroups(), 1, player);
            menu.setPlayerInventoryClickable(false);
            menu.open(new Player[]{player});
        } else {
            sender.sendMessage(Slimefun.getLocalization().getMessage("messages.only-players"));
        }
    }

    @Generated
    public Plugin getPlugin() {
        return this.plugin;
    }
}

