/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.interfaces;

import com.balugaq.jeg.api.groups.BookmarkGroup;
import com.balugaq.jeg.api.groups.ItemMarkGroup;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.utils.ItemStackUtil;
import com.balugaq.jeg.utils.Lang;
import com.balugaq.jeg.utils.LocalHelper;
import com.balugaq.jeg.utils.SlimefunOfficialSupporter;
import com.balugaq.jeg.utils.compatibility.Converter;
import com.balugaq.jeg.utils.compatibility.Sounds;
import com.balugaq.jeg.utils.formatter.Format;
import com.balugaq.jeg.utils.formatter.Formats;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.groups.NestedItemGroup;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.api.researches.Research;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.AsyncRecipeChoiceTask;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.permissions.Permissible;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public interface JEGSlimefunGuideImplementation
extends SlimefunGuideImplementation {
    public static final NamespacedKey UNLOCK_ITEM_KEY = new NamespacedKey((Plugin)JustEnoughGuide.getInstance(), "unlock_item");

    @ParametersAreNonnullByDefault
    @NotNull
    public static ItemStack getDisplayItem(Player p, boolean isSlimefunRecipe, ItemStack item) {
        if (isSlimefunRecipe) {
            SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)item);
            if (slimefunItem == null) {
                return item;
            }
            ItemGroup itemGroup = slimefunItem.getItemGroup();
            if (slimefunItem.isDisabledIn(p.getWorld())) {
                return ItemStackUtil.getCleanItem(Converter.getItem(Material.BARRIER, ItemUtils.getItemName((ItemStack)item), Lang.getGuideMessage("disabled-item")));
            }
            String lore = JEGSlimefunGuideImplementation.hasPermission0(p, slimefunItem) ? Lang.getGuideMessage("locked-item", "addon_name", LocalHelper.getAddonName(itemGroup, slimefunItem.getId()), "category_name", itemGroup.getDisplayName(p)) : Lang.getGuideMessage("no-permission");
            Research research = slimefunItem.getResearch();
            if (research == null) {
                return ItemStackUtil.getCleanItem(slimefunItem.canUse(p, false) ? item : Converter.getItem(Converter.getItem(Material.BARRIER, ItemUtils.getItemName((ItemStack)item), "&4&l" + Slimefun.getLocalization().getMessage(p, "guide.locked"), "", lore), meta -> meta.getPersistentDataContainer().set(UNLOCK_ITEM_KEY, PersistentDataType.STRING, (Object)slimefunItem.getId())));
            }
            return ItemStackUtil.getCleanItem(slimefunItem.canUse(p, false) ? item : Converter.getItem(Converter.getItem(Material.BARRIER, SlimefunOfficialSupporter.getTranslatedItemName(p, slimefunItem), "&4&l" + Slimefun.getLocalization().getMessage(p, "guide.locked"), "", lore, "", Lang.getGuideMessage("click-to-unlock"), "", Lang.getGuideMessage("cost", "cost", research.getCost())), meta -> meta.getPersistentDataContainer().set(UNLOCK_ITEM_KEY, PersistentDataType.STRING, (Object)slimefunItem.getId())));
        }
        return item;
    }

    @ParametersAreNonnullByDefault
    public static boolean hasPermission0(Player p, SlimefunItem item) {
        return Slimefun.getPermissionsService().hasPermission((Permissible)p, item);
    }

    @ParametersAreNonnullByDefault
    public void showItemGroup0(ChestMenu var1, Player var2, PlayerProfile var3, ItemGroup var4, int var5);

    @NotNull
    default public ChestMenu create0(@NotNull Player p) {
        ChestMenu menu = new ChestMenu(JustEnoughGuide.getConfigManager().getSurvivalGuideTitle());
        menu.setEmptySlotsClickable(false);
        menu.addMenuOpeningHandler(pl -> Sounds.playFor(pl, Sounds.GUIDE_BUTTON_CLICK_SOUND));
        return menu;
    }

    @ParametersAreNonnullByDefault
    default public void openBookMarkGroup(Player player, PlayerProfile profile) {
        List<SlimefunItem> items = JustEnoughGuide.getBookmarkManager().getBookmarkedItems(player);
        if (items == null || items.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You haven't collected any items yet!");
            return;
        }
        new BookmarkGroup(this, player, items).open(player, profile, this.getMode());
    }

    @ParametersAreNonnullByDefault
    default public void openItemMarkGroup(ItemGroup itemGroup, Player player, PlayerProfile profile) {
        new ItemMarkGroup(this, itemGroup, player).open(player, profile, this.getMode());
    }

    @ParametersAreNonnullByDefault
    public void openNestedItemGroup(Player var1, PlayerProfile var2, NestedItemGroup var3, int var4);

    @ParametersAreNonnullByDefault
    public void displaySlimefunItem0(ChestMenu var1, ItemGroup var2, Player var3, PlayerProfile var4, SlimefunItem var5, int var6, int var7);

    @ParametersAreNonnullByDefault
    public void openSearch(PlayerProfile var1, String var2, int var3, boolean var4);

    public void showMinecraftRecipe0(Recipe @NotNull [] var1, int var2, @NotNull ItemStack var3, @NotNull PlayerProfile var4, @NotNull Player var5, boolean var6);

    public <T extends Recipe> void showRecipeChoices0(@NotNull T var1, ItemStack[] var2, @NotNull AsyncRecipeChoiceTask var3);

    @ParametersAreNonnullByDefault
    default public void displayItem(PlayerProfile profile, SlimefunItem item, boolean addToHistory, boolean maybeSpecial) {
        this.displayItem(profile, item, addToHistory, maybeSpecial, item instanceof RecipeDisplayItem ? Formats.recipe_display : Formats.recipe);
    }

    @ParametersAreNonnullByDefault
    public void displayItem(PlayerProfile var1, SlimefunItem var2, boolean var3, boolean var4, Format var5);

    public void displayItem0(@NotNull ChestMenu var1, @NotNull PlayerProfile var2, @NotNull Player var3, Object var4, ItemStack var5, @NotNull RecipeType var6, ItemStack[] var7, @NotNull AsyncRecipeChoiceTask var8);

    public void displayItem(@NotNull ChestMenu var1, @NotNull PlayerProfile var2, @NotNull Player var3, Object var4, ItemStack var5, @NotNull RecipeType var6, ItemStack[] var7, @NotNull AsyncRecipeChoiceTask var8, Format var9);

    @ParametersAreNonnullByDefault
    public void createHeader(Player var1, PlayerProfile var2, ChestMenu var3, Format var4);

    @ParametersAreNonnullByDefault
    public void createHeader(Player var1, PlayerProfile var2, ChestMenu var3, ItemGroup var4);

    @ParametersAreNonnullByDefault
    public void addBackButton0(ChestMenu var1, @Range(from=0L, to=53L) int var2, Player var3, PlayerProfile var4);

    @ParametersAreNonnullByDefault
    public void displayRecipes0(Player var1, PlayerProfile var2, ChestMenu var3, RecipeDisplayItem var4, int var5);

    @ParametersAreNonnullByDefault
    public void addDisplayRecipe0(ChestMenu var1, PlayerProfile var2, List<ItemStack> var3, @Range(from=0L, to=53L) int var4, int var5, int var6);

    @ParametersAreNonnullByDefault
    public void printErrorMessage0(Player var1, Throwable var2);

    @ParametersAreNonnullByDefault
    public void printErrorMessage0(Player var1, SlimefunItem var2, Throwable var3);
}

