/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.utils;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.geo.GEOResource;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.core.attributes.Radioactive;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.KeyMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public final class SlimefunRegistryUtil {
    @NotNull
    public static SlimefunItem registerItem(@NotNull SlimefunItem item, @NotNull SlimefunAddon addon) {
        item.register(addon);
        return item;
    }

    public static void unregisterItems(@NotNull SlimefunAddon addon) {
        ArrayList copy = new ArrayList(Slimefun.getRegistry().getAllSlimefunItems());
        for (SlimefunItem item : copy) {
            if (!item.getAddon().equals((Object)addon)) continue;
            SlimefunRegistryUtil.unregisterItem(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterItem(@NotNull SlimefunItem item) {
        Object object;
        if (item == null) {
            return;
        }
        if (item instanceof Radioactive) {
            object = Slimefun.getRegistry().getRadioactiveItems();
            synchronized (object) {
                Slimefun.getRegistry().getRadioactiveItems().remove(item);
            }
        }
        if (item instanceof GEOResource) {
            GEOResource geor = (GEOResource)item;
            KeyMap keyMap = Slimefun.getRegistry().getGEOResources();
            synchronized (keyMap) {
                Slimefun.getRegistry().getGEOResources().remove((Object)geor.getKey());
            }
        }
        object = Slimefun.getRegistry().getTickerBlocks();
        synchronized (object) {
            Slimefun.getRegistry().getTickerBlocks().remove(item.getId());
        }
        object = Slimefun.getRegistry().getEnabledSlimefunItems();
        synchronized (object) {
            Slimefun.getRegistry().getEnabledSlimefunItems().remove(item);
        }
        object = Slimefun.getRegistry().getSlimefunItemIds();
        synchronized (object) {
            Slimefun.getRegistry().getSlimefunItemIds().remove(item.getId());
        }
        object = Slimefun.getRegistry().getAllSlimefunItems();
        synchronized (object) {
            Slimefun.getRegistry().getAllSlimefunItems().remove(item);
        }
        object = Slimefun.getRegistry().getMenuPresets();
        synchronized (object) {
            Slimefun.getRegistry().getMenuPresets().remove(item.getId());
        }
        object = Slimefun.getRegistry().getBarteringDrops();
        synchronized (object) {
            Slimefun.getRegistry().getBarteringDrops().remove(item.getItem());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterItemGroups(@NotNull SlimefunAddon addon) {
        ArrayList copy;
        List list = Slimefun.getRegistry().getAllItemGroups();
        synchronized (list) {
            copy = new ArrayList(Slimefun.getRegistry().getAllItemGroups());
        }
        for (ItemGroup itemGroup : copy) {
            if (!Objects.equals(itemGroup.getAddon(), addon)) continue;
            SlimefunRegistryUtil.unregisterItemGroup(itemGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterItemGroup(@NotNull ItemGroup itemGroup) {
        if (itemGroup == null) {
            return;
        }
        List list = Slimefun.getRegistry().getAllItemGroups();
        synchronized (list) {
            Slimefun.getRegistry().getAllItemGroups().remove(itemGroup);
        }
    }

    @Generated
    private SlimefunRegistryUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

