/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.core.commands;

import com.balugaq.jeg.api.groups.SearchGroup;
import com.balugaq.jeg.api.interfaces.JEGCommand;
import com.balugaq.jeg.utils.Debug;
import java.util.List;
import lombok.Generated;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class DisableCommand
implements JEGCommand {
    private final Plugin plugin;

    public DisableCommand(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public List<String> onTabCompleteRaw(@NotNull CommandSender sender, @NotNull @NotNull String @NotNull [] args) {
        switch (args.length) {
            case 1: {
                return List.of("disable");
            }
        }
        return List.of();
    }

    @Override
    public boolean canCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        if (sender.isOp() && args.length == 1) {
            return "disable".equalsIgnoreCase(args[0]);
        }
        return false;
    }

    @Override
    public void onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        this.onReload(sender);
    }

    private void onReload(@NotNull CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Disabling plugin...");
        try {
            if (this.plugin == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to disable plugin.");
                return;
            }
            this.plugin.onDisable();
            SearchGroup.LOADED = false;
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "plugin has been disabled.");
        }
        catch (Exception e) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to disable plugin.");
            Debug.trace(e);
        }
    }

    @Generated
    public Plugin getPlugin() {
        return this.plugin;
    }
}

