/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.objects;

import com.balugaq.jeg.api.cfgparse.annotations.IParsable;
import com.balugaq.jeg.api.cfgparse.annotations.Key;
import com.balugaq.jeg.api.cfgparse.annotations.Required;
import com.balugaq.jeg.api.objects.annotations.CallTimeSensitive;
import com.balugaq.jeg.utils.Debug;
import com.balugaq.jeg.utils.KeyUtil;
import com.balugaq.jeg.utils.compatibility.Converter;
import com.balugaq.jeg.utils.formatter.Format;
import com.balugaq.jeg.utils.formatter.Formats;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.skins.PlayerHead;
import io.github.thebusybiscuit.slimefun4.libraries.dough.skins.PlayerSkin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class CustomGroupConfiguration
implements IParsable {
    @Required
    @Key(value="enabled")
    boolean enabled;
    @Required
    @Key(value="tier")
    int tier;
    @Required
    @Key(value="id")
    String id;
    @Required
    @Key(value="display")
    Display display;
    @Required
    @Key(value="mode")
    Mode mode;
    @Required
    @Key(value="items")
    String[] items;
    @Required
    @Key(value="groups")
    String[] groups;
    @Required
    @Key(value="formats")
    String[] formats;
    private Format format;
    private List<Object> objects;

    public static String @NotNull [] fieldNames() {
        return IParsable.fieldNames(CustomGroupConfiguration.class);
    }

    public boolean enabled() {
        return this.enabled;
    }

    public @Range(from=-2147483648L, to=0x7FFFFFFFL) int tier() {
        return this.tier;
    }

    @NotNull
    public String id() {
        return this.id;
    }

    @NotNull
    public Display display() {
        return this.display;
    }

    @NotNull
    public Mode mode() {
        return this.mode;
    }

    @NotNull
    public @NotNull String @NotNull [] items() {
        return this.items;
    }

    @NotNull
    public @NotNull String @NotNull [] groups() {
        return this.groups;
    }

    @NotNull
    public @NotNull String @NotNull [] formats() {
        return this.formats;
    }

    @NotNull
    public Format format() {
        if (this.format != null) {
            return this.format;
        }
        this.format = new Format(){

            @Override
            public void loadMapping() {
                this.loadMapping(Arrays.stream(CustomGroupConfiguration.this.formats()).toList());
            }
        };
        Formats.addCustomFormat(this.id, this.format);
        return this.format;
    }

    @CallTimeSensitive(value="After Slimefun loaded")
    @NotNull
    public List<Object> objects() {
        if (this.objects != null) {
            return this.objects;
        }
        ArrayList<Object> objects = new ArrayList<Object>(Arrays.stream(this.groups).map(s -> {
            for (ItemGroup itemGroup : Slimefun.getRegistry().getAllItemGroups()) {
                if (!itemGroup.getKey().toString().equals(s)) continue;
                return itemGroup;
            }
            return null;
        }).filter(Objects::nonNull).map(s -> s).toList());
        objects.addAll(Arrays.stream(this.items).map(s -> SlimefunItem.getById((String)s.toUpperCase())).filter(Objects::nonNull).map(s -> s).toList());
        this.objects = objects;
        return objects;
    }

    @NotNull
    public NamespacedKey key() {
        return KeyUtil.newKey(this.id);
    }

    @NotNull
    public ItemStack item() {
        return this.display.item();
    }

    @Generated
    public CustomGroupConfiguration() {
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public int getTier() {
        return this.tier;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Display getDisplay() {
        return this.display;
    }

    @Generated
    public Mode getMode() {
        return this.mode;
    }

    @Generated
    public String[] getItems() {
        return this.items;
    }

    @Generated
    public String[] getGroups() {
        return this.groups;
    }

    @Generated
    public String[] getFormats() {
        return this.formats;
    }

    @Generated
    public Format getFormat() {
        return this.format;
    }

    @Generated
    public List<Object> getObjects() {
        return this.objects;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setTier(int tier) {
        this.tier = tier;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setDisplay(Display display) {
        this.display = display;
    }

    @Generated
    public void setMode(Mode mode) {
        this.mode = mode;
    }

    @Generated
    public void setItems(String[] items) {
        this.items = items;
    }

    @Generated
    public void setGroups(String[] groups) {
        this.groups = groups;
    }

    @Generated
    public void setFormats(String[] formats) {
        this.formats = formats;
    }

    @Generated
    public void setFormat(Format format) {
        this.format = format;
    }

    @Generated
    public void setObjects(List<Object> objects) {
        this.objects = objects;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomGroupConfiguration)) {
            return false;
        }
        CustomGroupConfiguration other = (CustomGroupConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getTier() != other.getTier()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Display this$display = this.getDisplay();
        Display other$display = other.getDisplay();
        if (this$display == null ? other$display != null : !((Object)this$display).equals(other$display)) {
            return false;
        }
        Mode this$mode = this.getMode();
        Mode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getItems(), other.getItems())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getGroups(), other.getGroups())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getFormats(), other.getFormats())) {
            return false;
        }
        Format this$format = this.getFormat();
        Format other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        List<Object> this$objects = this.getObjects();
        List<Object> other$objects = other.getObjects();
        return !(this$objects == null ? other$objects != null : !((Object)this$objects).equals(other$objects));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CustomGroupConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getTier();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Display $display = this.getDisplay();
        result = result * 59 + ($display == null ? 43 : ((Object)$display).hashCode());
        Mode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getItems());
        result = result * 59 + Arrays.deepHashCode(this.getGroups());
        result = result * 59 + Arrays.deepHashCode(this.getFormats());
        Format $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        List<Object> $objects = this.getObjects();
        result = result * 59 + ($objects == null ? 43 : ((Object)$objects).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CustomGroupConfiguration(enabled=" + this.isEnabled() + ", tier=" + this.getTier() + ", id=" + this.getId() + ", display=" + String.valueOf(this.getDisplay()) + ", mode=" + String.valueOf((Object)this.getMode()) + ", items=" + Arrays.deepToString(this.getItems()) + ", groups=" + Arrays.deepToString(this.getGroups()) + ", formats=" + Arrays.deepToString(this.getFormats()) + ", format=" + String.valueOf(this.getFormat()) + ", objects=" + String.valueOf(this.getObjects()) + ")";
    }

    public static class Display
    implements IParsable {
        @Required
        @Key(value="material")
        String material;
        @Required
        @Key(value="name")
        String name;
        @Nullable
        ItemStack itemStack;

        @NotNull
        public static @NotNull String @NotNull [] fieldNames() {
            return IParsable.fieldNames(Display.class);
        }

        @NotNull
        public final ItemStack item() {
            if (this.itemStack != null) {
                return this.itemStack;
            }
            this.itemStack = this.getHashLike(this.material);
            if (this.itemStack != null) {
                this.itemStack = Converter.getItem(this.itemStack, this.name, new String[0]);
                return this.itemStack;
            }
            this.itemStack = this.getBase64Like(this.material);
            if (this.itemStack != null) {
                this.itemStack = Converter.getItem(this.itemStack, this.name, new String[0]);
                return this.itemStack;
            }
            this.itemStack = this.getURLLike(this.material);
            if (this.itemStack != null) {
                this.itemStack = Converter.getItem(this.itemStack, this.name, new String[0]);
                return this.itemStack;
            }
            Material material = Material.getMaterial((String)this.material.toUpperCase());
            if (material == null || !material.isItem() || material.isLegacy()) {
                Debug.warn("\u81ea\u5b9a\u4e49\u7269\u54c1\u7ec4\u5b58\u5728\u65e0\u6548\u7684 material: " + this.material);
                this.itemStack = new ItemStack(Material.STONE);
                return this.itemStack;
            }
            this.itemStack = Converter.getItem(material, this.name, new String[0]);
            return this.itemStack;
        }

        public boolean isHashcodeLike(@NotNull String value) {
            return value.matches("^[a-fA-F0-9]{32,}$");
        }

        public boolean isBase64Like(@NotNull String value) {
            return value.length() > 32 && value.matches("^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$");
        }

        public boolean isURLLike(@NotNull String value) {
            return value.matches("^https?://(?:[-\\w]+\\.)?[-\\w]+(?:\\.[a-zA-Z]{2,5}|\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})(?::\\d{1,5})?(/[-\\w./]*)*(\\?[-\\w.&=]*)?(#[-\\w]*)?$");
        }

        @Nullable
        private ItemStack getHashLike(@NotNull String material) {
            if (!this.isHashcodeLike(material)) {
                return null;
            }
            try {
                return PlayerHead.getItemStack((PlayerSkin)PlayerSkin.fromHashCode((String)material));
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        @Nullable
        private ItemStack getBase64Like(@NotNull String material) {
            if (!this.isBase64Like(material)) {
                return null;
            }
            try {
                return PlayerHead.getItemStack((PlayerSkin)PlayerSkin.fromBase64((String)material));
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        @Nullable
        private ItemStack getURLLike(@NotNull String material) {
            if (!this.isURLLike(material)) {
                return null;
            }
            try {
                return PlayerHead.getItemStack((PlayerSkin)PlayerSkin.fromURL((String)material));
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        @Generated
        public Display() {
        }

        @Generated
        public String getMaterial() {
            return this.material;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Nullable
        @Generated
        public ItemStack getItemStack() {
            return this.itemStack;
        }

        @Generated
        public void setMaterial(String material) {
            this.material = material;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setItemStack(@Nullable ItemStack itemStack) {
            this.itemStack = itemStack;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Display)) {
                return false;
            }
            Display other = (Display)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$material = this.getMaterial();
            String other$material = other.getMaterial();
            if (this$material == null ? other$material != null : !this$material.equals(other$material)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            ItemStack this$itemStack = this.getItemStack();
            ItemStack other$itemStack = other.getItemStack();
            return !(this$itemStack == null ? other$itemStack != null : !this$itemStack.equals(other$itemStack));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Display;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $material = this.getMaterial();
            result = result * 59 + ($material == null ? 43 : $material.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            ItemStack $itemStack = this.getItemStack();
            result = result * 59 + ($itemStack == null ? 43 : $itemStack.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CustomGroupConfiguration.Display(material=" + this.getMaterial() + ", name=" + this.getName() + ", itemStack=" + String.valueOf(this.getItemStack()) + ")";
        }
    }

    public static enum Mode {
        TRANSFER,
        MERGE;

    }
}

