/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.core.integrations.slimeaeplugin;

import com.balugaq.jeg.api.objects.events.GuideEvents;
import com.balugaq.jeg.api.recipe_complete.source.base.VanillaSource;
import com.balugaq.jeg.core.integrations.networksexpansion.NetworksExpansionIntegrationMain;
import com.balugaq.jeg.core.integrations.slimeaeplugin.SlimeAEPluginIntegrationMain;
import com.balugaq.jeg.core.listeners.RecipeCompletableListener;
import com.balugaq.jeg.utils.GuideUtil;
import com.balugaq.jeg.utils.InventoryUtil;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import java.util.List;
import me.ddggdd135.guguslimefunlib.items.ItemKey;
import me.ddggdd135.slimeae.api.interfaces.IStorage;
import me.ddggdd135.slimeae.api.items.ItemRequest;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlimeAEPluginRecipeCompleteVanillaSource
implements VanillaSource {
    @Override
    public boolean handleable(@NotNull Block block, @NotNull Inventory inventory, @NotNull Player player, @NotNull ClickAction clickAction, int @NotNull [] ingredientSlots, boolean unordered) {
        return SlimeAEPluginIntegrationMain.findNearbyIStorage(block.getLocation()) != null;
    }

    @Override
    public boolean openGuide(@NotNull Block block, @NotNull Inventory inventory, @NotNull Player player, @NotNull ClickAction clickAction, int @NotNull [] ingredientSlots, boolean unordered, @Nullable Runnable callback) {
        GuideEvents.ItemButtonClickEvent lastEvent = RecipeCompletableListener.getLastEvent(player.getUniqueId());
        if (clickAction.isRightClicked() && lastEvent != null) {
            int times = 1;
            if (clickAction.isShiftClicked()) {
                times = 64;
            }
            for (int i = 0; i < times; ++i) {
                this.completeRecipeWithGuide(block, inventory, lastEvent, ingredientSlots, unordered);
            }
            if (callback != null) {
                callback.run();
            }
            return true;
        }
        GuideUtil.openMainMenuAsync(player, SlimefunGuideMode.SURVIVAL_MODE, 1);
        RecipeCompletableListener.addCallback(player.getUniqueId(), (event, profile) -> {
            int times = 1;
            if (event.getClickAction().isRightClicked()) {
                times = 64;
            }
            for (int i = 0; i < times; ++i) {
                this.completeRecipeWithGuide(block, inventory, (GuideEvents.ItemButtonClickEvent)((Object)event), ingredientSlots, unordered);
            }
            player.updateInventory();
            player.openInventory(inventory);
            if (callback != null) {
                callback.run();
            }
        });
        RecipeCompletableListener.tagGuideOpen(player);
        return true;
    }

    @Override
    public boolean completeRecipeWithGuide(@NotNull Block block, @NotNull Inventory inventory,  @NotNull GuideEvents.ItemButtonClickEvent event, int @NotNull [] ingredientSlots, boolean unordered) {
        IStorage root = SlimeAEPluginIntegrationMain.findNearbyIStorage(block.getLocation());
        if (root == null) {
            return false;
        }
        Player player = event.getPlayer();
        ItemStack clickedItem = event.getClickedItem();
        if (clickedItem == null) {
            return false;
        }
        List<RecipeChoice> choices = this.getRecipe(clickedItem);
        if (choices == null) {
            return false;
        }
        for (int i = 0; i < 9 && i < choices.size() && i < ingredientSlots.length; ++i) {
            ItemStack existing;
            RecipeChoice choice = choices.get(i);
            if (choice == null || !unordered && (existing = inventory.getItem(ingredientSlots[i])) != null && existing.getType() != Material.AIR && (existing.getAmount() >= existing.getMaxStackSize() || !choice.test(existing))) continue;
            if (choice instanceof RecipeChoice.MaterialChoice) {
                RecipeChoice.MaterialChoice materialChoice = (RecipeChoice.MaterialChoice)choice;
                List<ItemStack> itemStacks = materialChoice.getChoices().stream().map(ItemStack::new).toList();
                for (ItemStack itemStack : itemStacks) {
                    ItemStack received = this.getItemStack(root, player, itemStack);
                    if (received == null || received.getType() == Material.AIR) continue;
                    if (unordered) {
                        InventoryUtil.pushItem(inventory, received, ingredientSlots);
                        continue;
                    }
                    InventoryUtil.pushItem(inventory, received, ingredientSlots[i]);
                }
                continue;
            }
            if (!(choice instanceof RecipeChoice.ExactChoice)) continue;
            RecipeChoice.ExactChoice exactChoice = (RecipeChoice.ExactChoice)choice;
            for (ItemStack itemStack : exactChoice.getChoices()) {
                ItemStack received = this.getItemStack(root, player, itemStack);
                if (received == null || received.getType() == Material.AIR) continue;
                if (unordered) {
                    InventoryUtil.pushItem(inventory, received, ingredientSlots);
                    continue;
                }
                InventoryUtil.pushItem(inventory, received, ingredientSlots[i]);
            }
        }
        event.setCancelled(true);
        return true;
    }

    @Nullable
    private ItemStack getItemStack(@NotNull IStorage networkStorage, @NotNull Player player, @NotNull ItemStack itemStack) {
        ItemStack i1 = this.getItemStackFromPlayerInventory(player, itemStack);
        if (i1 != null) {
            return i1;
        }
        ItemStack[] gotten = networkStorage.takeItem(new ItemRequest(new ItemKey(itemStack), 1L)).toItemStacks();
        if (gotten.length != 0) {
            return gotten[0];
        }
        return null;
    }

    @Override
    public JavaPlugin plugin() {
        return NetworksExpansionIntegrationMain.getPlugin();
    }
}

