/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api;

import com.balugaq.jeg.api.cfgparse.parser.ConfigurationParser;
import com.balugaq.jeg.api.groups.CustomGroup;
import com.balugaq.jeg.api.objects.CustomGroupConfiguration;
import com.balugaq.jeg.api.objects.annotations.CallTimeSensitive;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.utils.Debug;
import com.balugaq.jeg.utils.formatter.Formats;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class CustomGroupConfigurations {
    public static final String FILE_NAME = "custom-groups.yml";
    public static final File fileCustomGroups = new File(JustEnoughGuide.getInstance().getDataFolder(), "custom-groups.yml");
    private static final List<CustomGroupConfiguration> configurations = new ArrayList<CustomGroupConfiguration>();
    private static final Map<String, CustomGroup> groups = new HashMap<String, CustomGroup>();

    @CallTimeSensitive(value="After Slimefun loaded")
    public static void load() {
        YamlConfiguration configuration;
        boolean enable;
        if (!fileCustomGroups.exists()) {
            JustEnoughGuide.getInstance().saveResource(FILE_NAME, false);
            JustEnoughGuide.getInstance().getLogger().info("Created custom-groups.yml");
        }
        if (!(enable = (configuration = YamlConfiguration.loadConfiguration((File)fileCustomGroups)).getBoolean("enabled", true))) {
            return;
        }
        ConfigurationSection groups = configuration.getConfigurationSection("groups");
        if (groups == null) {
            JustEnoughGuide.getInstance().getLogger().warning("No groups found in custom-groups.yml");
            return;
        }
        for (String key : groups.getKeys(false)) {
            ConfigurationSection section = groups.getConfigurationSection(key);
            if (section == null) continue;
            try {
                CustomGroupConfiguration parsed = ConfigurationParser.parse(section, CustomGroupConfiguration.class);
                configurations.add(parsed);
            }
            catch (Exception e) {
                Debug.trace(e);
            }
        }
        for (CustomGroupConfiguration ccg : configurations) {
            if (!ccg.enabled()) continue;
            CustomGroup group = new CustomGroup(ccg);
            if (group.objects.isEmpty()) continue;
            group.register(JustEnoughGuide.getInstance());
            CustomGroupConfigurations.groups.put(ccg.id(), group);
        }
    }

    public static void unload() {
        configurations.clear();
        groups.clear();
        Formats.unload();
    }

    public static CustomGroup getGroup(String id) {
        return groups.get(id);
    }

    @NotNull
    public static List<CustomGroup> getGroups() {
        return new ArrayList<CustomGroup>(groups.values());
    }

    @Generated
    public static List<CustomGroupConfiguration> getConfigurations() {
        return configurations;
    }
}

