/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.utils;

import com.balugaq.jeg.api.objects.annotations.Author;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.libraries.cmilib.Colors.CMIChatColor;
import com.balugaq.jeg.utils.Debug;
import com.balugaq.jeg.utils.compatibility.Converter;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.libraries.dough.skins.PlayerHead;
import io.github.thebusybiscuit.slimefun4.libraries.dough.skins.PlayerSkin;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemStackUtil {
    @Author(value="lijinhong11")
    private static final Map<String, String> materialMappings = Map.of("GRASS", "SHORT_GRASS", "SHORT_GRASS", "GRASS", "SCUTE", "TURTLE_SCUTE", "TURTLE_SCUTE", "SCUTE");

    @Author(value="lijinhong11")
    @NotNull
    public static ItemStack doGlow(@NotNull ItemStack item) {
        item.addUnsafeEnchantment(Enchantment.INFINITY, 1);
        item.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        return item;
    }

    @NotNull
    public static ItemStack getCleanItem(@Nullable ItemStack item) {
        if (item == null) {
            return new ItemStack(Material.AIR);
        }
        ItemStack cleanItem = new ItemStack(item.getType());
        cleanItem.setAmount(item.getAmount());
        if (item.hasItemMeta()) {
            cleanItem.setItemMeta(item.getItemMeta());
        }
        return cleanItem;
    }

    @NotNull
    public static ItemStack getAsQuantity(@Nullable ItemStack itemStack, int amount) {
        if (itemStack == null) {
            return new ItemStack(Material.AIR);
        }
        ItemStack clone = itemStack.clone();
        clone.setAmount(amount);
        return clone;
    }

    @Author(value="lijinhong11 & balugaq")
    @Nullable
    public static ItemStack readItem(char c, @Nullable ConfigurationSection section) {
        ArrayList<String> lore;
        if (section == null) {
            return null;
        }
        String type = section.getString("material_type", "mc");
        if (!type.equalsIgnoreCase("none") && !section.contains("material")) {
            Debug.severe("Icon Definition " + c + " missing material field");
            return null;
        }
        String material = section.getString("material", "");
        List rawLore = section.getStringList("lore");
        if (JustEnoughGuide.getIntegrationManager().isEnabledCMILib()) {
            lore = CMIChatColor.translate((List)rawLore);
        } else {
            lore = new ArrayList<String>();
            for (String loreLine : rawLore) {
                lore.add(ChatColors.color((String)loreLine));
            }
        }
        String rawName = section.getString("name", "");
        String name = JustEnoughGuide.getIntegrationManager().isEnabledCMILib() ? CMIChatColor.translate((String)rawName) : ChatColors.color((String)rawName);
        boolean glow = section.getBoolean("glow", false);
        boolean hasEnchantment = section.contains("enchantments") && section.isList("enchantments");
        int modelId = section.getInt("modelId");
        int amount = section.getInt("amount", 1);
        if (material.contains("|")) {
            String[] split;
            for (String mat : split = material.split("\\|")) {
                ItemStack item = ItemStackUtil.readItem(c, section, type, mat.trim(), name, lore, glow, hasEnchantment, modelId, amount, true);
                if (item == null) continue;
                return item;
            }
            Debug.severe("Icon Definition " + c + " unable to read, turned into stone");
            return null;
        }
        return ItemStackUtil.readItem(c, section, type, material.trim(), name, lore, glow, hasEnchantment, modelId, amount, false);
    }

    @Author(value="lijinhong11 & balugaq")
    @Nullable
    public static ItemStack readItem(char c, @NotNull ConfigurationSection section, String type, @NotNull String material, @NotNull String name, @NotNull List<String> lore, boolean glow, boolean hasEnchantment, int modelId, int amount, boolean isBranch) {
        ItemStack itemStack;
        if (material.startsWith("ey") || material.startsWith("ew")) {
            type = "skull";
        } else if (material.startsWith("http") || material.startsWith("https")) {
            type = "skull_url";
        } else if (material.matches("^[0-9A-Fa-f]{64}+$")) {
            type = "skull_hash";
        }
        switch (type.toLowerCase()) {
            case "none": {
                return new ItemStack(Material.AIR, 1);
            }
            case "skull_hash": {
                PlayerSkin playerSkin = PlayerSkin.fromHashCode((String)material);
                ItemStack head = PlayerHead.getItemStack((PlayerSkin)playerSkin);
                itemStack = Converter.getItem(head, name, lore);
                break;
            }
            case "skull_base64": 
            case "skull": {
                PlayerSkin playerSkin = PlayerSkin.fromBase64((String)material);
                ItemStack head = PlayerHead.getItemStack((PlayerSkin)playerSkin);
                itemStack = Converter.getItem(head, name, lore);
                break;
            }
            case "skull_url": {
                PlayerSkin playerSkin = PlayerSkin.fromURL((String)material);
                ItemStack head = PlayerHead.getItemStack((PlayerSkin)playerSkin);
                itemStack = Converter.getItem(head, name, lore);
                break;
            }
            case "slimefun": {
                SlimefunItem sfItem = SlimefunItem.getById((String)material.toUpperCase());
                if (sfItem != null) {
                    itemStack = Converter.getItem(sfItem.getItem().clone());
                    itemStack.editMeta(m -> {
                        if (!name.isBlank()) {
                            m.setDisplayName(name);
                        }
                        if (!lore.isEmpty()) {
                            m.setLore(lore);
                        }
                    });
                    break;
                }
                if (isBranch) {
                    return null;
                }
                Debug.severe("Icon Definition " + c + " unable to read, turned into stone");
                itemStack = Converter.getItem(Material.STONE, name, lore);
                break;
            }
            default: {
                Optional<Material> materialOptional = Optional.ofNullable(Material.matchMaterial((String)material));
                Material mat = Material.STONE;
                if (materialOptional.isPresent()) {
                    mat = materialOptional.get();
                } else if (SlimefunItem.getById((String)material) == null) {
                    if (materialMappings.containsKey(material)) {
                        materialOptional = Optional.ofNullable(Material.matchMaterial((String)materialMappings.get(material)));
                        if (materialOptional.isPresent()) {
                            mat = materialOptional.get();
                            Debug.warn("Icon Definition " + c + "'s material field " + material + " has been fixed into " + String.valueOf(mat));
                        } else {
                            if (isBranch) {
                                return null;
                            }
                            Debug.severe("Icon Definition " + c + " unable to read, turned into stone");
                        }
                    } else {
                        if (isBranch) {
                            return null;
                        }
                        Debug.severe("Icon Definition " + c + " unable to read, turned into stone");
                    }
                }
                if (!mat.isItem() || mat.isLegacy()) {
                    Debug.warn("Icon Definition exists invalid material: " + String.valueOf(mat) + ", turned into stone");
                    mat = Material.STONE;
                }
                itemStack = Converter.getItem(mat, name, lore);
            }
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (modelId > 0) {
            meta.setCustomModelData(Integer.valueOf(modelId));
        }
        if (amount > 100 || amount < -1) {
            Debug.severe("Icon Definition " + c + " unable to read filed amount caused by outrange value: must be -1 < amount <= 100");
            return null;
        }
        itemStack.setAmount(amount);
        itemStack.setItemMeta(meta);
        if (hasEnchantment) {
            List enchants = section.getStringList("enchantments");
            for (String enchant : enchants) {
                String[] s2 = enchant.split(" ");
                if (s2.length != 2) {
                    Debug.severe("Icon Definition " + c + " unable to read enchantment " + enchant + ", skip it.");
                    continue;
                }
                String enchantName = s2[0];
                int lvl = Integer.parseInt(s2[1]);
                Enchantment enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)enchantName.toLowerCase()));
                if (enchantment == null) {
                    Debug.severe("Icon Definition " + c + " unable to read enchantment " + enchant + ", skip it.");
                    continue;
                }
                itemStack.addUnsafeEnchantment(enchantment, lvl);
            }
        }
        return glow ? ItemStackUtil.doGlow(itemStack) : itemStack;
    }

    @Generated
    private ItemStackUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

