/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.objects.events;

import com.balugaq.jeg.api.objects.enums.PatchScope;
import com.balugaq.jeg.utils.Debug;
import com.balugaq.jeg.utils.ItemStackUtil;
import com.balugaq.jeg.utils.compatibility.Converter;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    @NotNull
    private final PatchScope patchScope;
    @NotNull
    private final Player player;
    @Nullable
    private ItemStack itemStack;

    public PatchEvent(@NotNull PatchScope patchScope, @NotNull Player player, @Nullable ItemStack itemStack) {
        super(!Bukkit.isPrimaryThread());
        this.patchScope = patchScope;
        this.player = player;
        this.itemStack = itemStack;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }

    @Nullable
    public static ItemStack patch(@NotNull PatchScope patchScope, @NotNull Player player, @Nullable ItemStack itemStack) {
        PatchEvent event = new PatchEvent(patchScope, player, Converter.getItem(ItemStackUtil.getCleanItem(itemStack)));
        try {
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        catch (Throwable e) {
            Debug.trace(e);
        }
        return event.itemStack;
    }

    @NotNull
    public final HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    @Generated
    public PatchScope getPatchScope() {
        return this.patchScope;
    }

    @NotNull
    @Generated
    public Player getPlayer() {
        return this.player;
    }

    @Nullable
    @Generated
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Generated
    public void setItemStack(@Nullable ItemStack itemStack) {
        this.itemStack = itemStack;
    }
}

