/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.patches;

import com.balugaq.jeg.api.objects.enums.PatchScope;
import com.balugaq.jeg.api.patches.JEGContributorsMenu;
import com.balugaq.jeg.utils.ReflectionUtil;
import com.balugaq.jeg.utils.compatibility.Converter;
import com.balugaq.jeg.utils.formatter.Formats;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuide;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.core.guide.options.SlimefunGuideOption;
import io.github.thebusybiscuit.slimefun4.core.guide.options.SlimefunGuideSettings;
import io.github.thebusybiscuit.slimefun4.core.services.LocalizationService;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubService;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class JEGGuideSettings {
    private static final List<SlimefunGuideOption<?>> patched = new ArrayList();

    @ParametersAreNonnullByDefault
    public static void openSettings(@NotNull Player p, @NotNull ItemStack guide) {
        JEGGuideSettings.openSettings(p, guide, 1);
    }

    @ParametersAreNonnullByDefault
    public static void openSettings(@NotNull Player p, @NotNull ItemStack guide, @Range(from=1L, to=0x7FFFFFFFL) int page) {
        ChestMenu menu = new ChestMenu(Slimefun.getLocalization().getMessage(p, "guide.title.settings"));
        menu.setEmptySlotsClickable(false);
        menu.addMenuOpeningHandler(arg_0 -> ((SoundEffect)SoundEffect.GUIDE_OPEN_SETTING_SOUND).playFor(arg_0));
        ChestMenuUtils.drawBackground((ChestMenu)menu, (int[])Formats.settings.getChars('B').stream().mapToInt(i -> i).toArray());
        JEGGuideSettings.addHeader(p, menu, guide);
        JEGGuideSettings.addConfigurableOptions(p, menu, guide, page);
        Formats.settings.renderCustom(menu);
        menu.open(new Player[]{p});
    }

    @ParametersAreNonnullByDefault
    private static void addHeader(@NotNull Player p, @NotNull ChestMenu menu, @NotNull ItemStack guide) {
        LocalizationService locale = Slimefun.getLocalization();
        ItemStack b = PatchScope.Background.patch(p, Converter.getItem(SlimefunGuide.getItem((SlimefunGuideMode)SlimefunGuideMode.SURVIVAL_MODE), "&e\u21e6 " + locale.getMessage(p, "guide.back.title"), "", "&7" + locale.getMessage(p, "guide.back.guide")));
        for (int ss : Formats.settings.getChars('b')) {
            menu.addItem(ss, b, (pl, slot, item, action) -> {
                SlimefunGuide.openGuide((Player)pl, (ItemStack)guide);
                return false;
            });
        }
        GitHubService github = Slimefun.getGitHubService();
        ArrayList<Object> contributorsLore = new ArrayList<Object>();
        contributorsLore.add("");
        contributorsLore.addAll(locale.getMessages(p, "guide.credits.description", msg -> msg.replace("%contributors%", String.valueOf(github.getContributors().size()))));
        contributorsLore.add("");
        contributorsLore.add("&7\u21e8 &e" + locale.getMessage(p, "guide.credits.open"));
        ItemStack s = PatchScope.SettingsContributors.patch(p, Converter.getItem(SlimefunUtils.getCustomHead((String)"e952d2b3f351a6b0487cc59db31bf5f2641133e5ba0006b18576e996a0293e52"), "&c" + locale.getMessage(p, "guide.title.credits"), contributorsLore.toArray(new String[0])));
        for (int ss : Formats.settings.getChars('s')) {
            menu.addItem(ss, s, (pl, slot, action, item) -> {
                JEGContributorsMenu.open(pl, 0);
                return false;
            });
        }
        ItemStack v = PatchScope.SlimefunVersion.patch(p, Converter.getItem(Material.WRITABLE_BOOK, String.valueOf(ChatColor.GREEN) + locale.getMessage(p, "guide.title.versions"), "&7&o" + locale.getMessage(p, "guide.tooltips.versions-notice"), "", "&f\u6c49\u5316 By StarWishsama", "&c\u8bf7\u4e0d\u8981\u5c06\u6b64\u7248\u672c\u4fe1\u606f\u622a\u56fe\u5230 Discord/GitHub \u53cd\u9988 Bug", "&c\u800c\u662f\u4f18\u5148\u5230\u6c49\u5316\u9875\u9762\u53cd\u9988", "", "&cTHIS BUILD IS UNOFFICIAL BUILD, DO NOT REPORT TO SLIMEFUN DEV", "", "&fMinecraft: &a" + Bukkit.getBukkitVersion(), "&fSlimefun: &a" + Slimefun.getVersion()));
        for (int ss : Formats.settings.getChars('v')) {
            menu.addItem(ss, v, ChestMenuUtils.getEmptyClickHandler());
        }
        ItemStack u = PatchScope.SlimefunSourceCode.patch(p, Converter.getItem(Material.COMPARATOR, "&e" + locale.getMessage(p, "guide.title.source"), "", "&7\u6700\u8fd1\u6d3b\u52a8\u4e8e: &a" + NumberUtils.getElapsedTime((LocalDateTime)github.getLastUpdate()) + " \u524d", "&7Forks: &e" + github.getForks(), "&7Stars: &e" + github.getStars(), "", "&7&oSlimefun 4 \u662f\u4e00\u4e2a\u7531\u793e\u533a\u53c2\u4e0e\u7684\u9879\u76ee,", "&7&o\u6e90\u4ee3\u7801\u53ef\u4ee5\u5728 GitHub \u4e0a\u627e\u5230", "&7&o\u5982\u679c\u4f60\u60f3\u8ba9\u8fd9\u4e2a\u9879\u76ee\u6301\u7eed\u4e0b\u53bb", "&7&o\u4f60\u53ef\u4ee5\u8003\u8651\u5bf9\u9879\u76ee\u505a\u51fa\u8d21\u732e", "", "&7\u21e8 &e\u70b9\u51fb\u524d\u5f80\u6c49\u5316\u7248 GitHub \u4ed3\u5e93"));
        for (int ss : Formats.settings.getChars('u')) {
            menu.addItem(ss, u, (pl, slot, item, action) -> {
                pl.closeInventory();
                ChatUtils.sendURL((CommandSender)pl, (String)"https://github.com/SlimefunGuguProject/Slimefun4");
                return false;
            });
        }
        ItemStack W = PatchScope.SlimefunWiki.patch(p, Converter.getItem(Material.KNOWLEDGE_BOOK, "&3" + locale.getMessage(p, "guide.title.wiki"), "", "&7\u4f60\u9700\u8981\u5bf9\u7269\u54c1\u6216\u673a\u5668\u65b9\u9762\u7684\u5e2e\u52a9\u5417?", "&7\u4f60\u4e0d\u77e5\u9053\u8981\u5e72\u4ec0\u4e48?", "&7\u67e5\u770b\u6211\u4eec\u7684\u7531\u793e\u533a\u7ef4\u62a4\u7684\u7ef4\u57fa", "&7\u5e76\u8003\u8651\u6210\u4e3a\u4e00\u540d\u7f16\u8f91\u8005!", "", "&7\u21e8 &e\u70b9\u51fb\u524d\u5f80\u975e\u5b98\u65b9\u4e2d\u6587 Wiki"));
        for (int ss : Formats.settings.getChars('W')) {
            menu.addItem(ss, W, (pl, slot, item, action) -> {
                pl.closeInventory();
                ChatUtils.sendURL((CommandSender)pl, (String)"https://slimefun-wiki.guizhanss.cn/");
                return false;
            });
        }
        ItemStack l = PatchScope.AddonCount.patch(p, Converter.getItem(Material.BOOKSHELF, "&3" + locale.getMessage(p, "guide.title.addons"), "", "&7Slimefun \u662f\u4e00\u4e2a\u5927\u578b\u9879\u76ee\uff0c\u4f46\u9644\u5c5e\u63d2\u4ef6\u7684\u5b58\u5728", "&7\u80fd\u8ba9 Slimefun \u771f\u6b63\u7684\u53d1\u5149\u53d1\u4eae", "&7\u770b\u4e00\u770b\u5b83\u4eec\uff0c\u4e5f\u8bb8\u4f60\u8981\u5bfb\u627e\u7684\u9644\u5c5e\u63d2\u4ef6\u5c31\u5728\u90a3\u91cc!", "", "&7\u8be5\u670d\u52a1\u5668\u5df2\u5b89\u88c5\u9644\u5c5e\u63d2\u4ef6: &b" + Slimefun.getInstalledAddons().size(), "", "&7\u21e8 &e\u70b9\u51fb\u67e5\u770b Slimefun4 \u53ef\u7528\u7684\u9644\u5c5e\u63d2\u4ef6"));
        for (int ss : Formats.settings.getChars('l')) {
            menu.addItem(ss, l, (pl, slot, item, action) -> {
                pl.closeInventory();
                ChatUtils.sendURL((CommandSender)pl, (String)"https://slimefun-wiki.guizhanss.cn/Addons");
                return false;
            });
        }
        for (int ss : Formats.settings.getChars('z')) {
            if (Slimefun.getUpdater().getBranch().isOfficial()) {
                menu.addItem(ss, PatchScope.UnofficialTips.patch(p, Converter.getItem(Material.REDSTONE_TORCH, "&4" + locale.getMessage(p, "guide.title.bugs"), "", "&7&oBug reports have to be made in English!", "", "&7Open Issues: &a" + github.getOpenIssues(), "&7Pending Pull Requests: &a" + github.getPendingPullRequests(), "", "&7\u21e8 &eClick to go to the Slimefun4 Bug Tracker")));
                menu.addMenuClickHandler(ss, (pl, slot, item, action) -> {
                    pl.closeInventory();
                    ChatUtils.sendURL((CommandSender)pl, (String)"https://github.com/SlimefunGuguProject/Slimefun4/issues");
                    return false;
                });
                continue;
            }
            menu.addItem(ss, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int ss : Formats.settings.getChars('U')) {
            menu.addItem(ss, PatchScope.UnknownFeature.patch(p, Converter.getItem(Material.TOTEM_OF_UNDYING, String.valueOf(ChatColor.RED) + locale.getMessage(p, "guide.work-in-progress"), new String[0])), (pl, slot, item, action) -> false);
        }
    }

    @ParametersAreNonnullByDefault
    private static void addConfigurableOptions(@NotNull Player p, @NotNull ChestMenu menu, @NotNull ItemStack guide, @Range(from=1L, to=0x7FFFFFFFL) int page) {
        List<Integer> slots = Formats.settings.getChars('o');
        List<SlimefunGuideOption<?>> options = JEGGuideSettings.getOptions();
        int maxPage = (int)Math.ceil((double)options.size() / (double)slots.size());
        List split = options.stream().skip((long)(page - 1) * (long)slots.size()).limit(slots.size()).toList();
        int fail = 0;
        for (int i = 0; i < split.size(); ++i) {
            SlimefunGuideOption option = (SlimefunGuideOption)split.get(i);
            if (fail > i) {
                fail = i;
            }
            int slot2 = slots.get(i - fail);
            Optional item2 = option.getDisplayItem(p, guide);
            if (item2.isPresent()) {
                menu.addItem(slot2, PatchScope.GuideOption.patch(p, (ItemStack)item2.get()));
                menu.addMenuClickHandler(slot2, (pl, s, stack, action) -> {
                    option.onClick(p, guide);
                    return false;
                });
                continue;
            }
            ++fail;
        }
        for (int ss : Formats.settings.getChars('P')) {
            menu.addItem(ss, ChestMenuUtils.getPreviousButton((Player)p, (int)page, (int)maxPage));
            menu.addMenuClickHandler(ss, (pl, slot, item, action) -> {
                if (page > 1) {
                    JEGGuideSettings.openSettings(pl, guide, page - 1);
                }
                return false;
            });
        }
        for (int ss : Formats.settings.getChars('N')) {
            menu.addItem(ss, ChestMenuUtils.getNextButton((Player)p, (int)page, (int)maxPage));
            menu.addMenuClickHandler(ss, (pl, slot, item, action) -> {
                if (page + 1 < maxPage) {
                    JEGGuideSettings.openSettings(pl, guide, page + 1);
                }
                return false;
            });
        }
    }

    @NotNull
    public static List<SlimefunGuideOption<?>> getOptions() {
        return ReflectionUtil.getStaticValue(SlimefunGuideSettings.class, "options", List.class);
    }

    @Generated
    public static List<SlimefunGuideOption<?>> getPatched() {
        return patched;
    }
}

