/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.utils.compatibility;

import com.balugaq.jeg.utils.ReflectionUtil;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Sounds {
    public static final Sound GUIDE_BUTTON_CLICK_SOUND = Sounds.byKeyOrDefault("item.book.page_turn", Sounds.byName("ITEM_BOOK_PAGE_TURN"));
    public static final Sound COLLECTED_ITEM = Sounds.byKeyOrDefault("entity.player.levelup", Sounds.byName("ENTITY_PLAYER_LEVELUP"));

    @Nullable
    public static Sound byName(@NotNull String name) {
        return ReflectionUtil.getStaticValue(Sound.class, name, Sound.class);
    }

    @Nullable
    public static Sound byKey(@NotNull String key) {
        Registry registry = Bukkit.getRegistry(Sound.class);
        if (registry == null) {
            return null;
        }
        return (Sound)registry.get(NamespacedKey.minecraft((String)key));
    }

    @Deprecated
    public static Sound byKeyOr(@NotNull String key, Sound def) {
        return Sounds.byKeyOrDefault(key, def);
    }

    public static Sound byKeyOrDefault(@NotNull String key, Sound def) {
        Sound sound = Sounds.byKey(key);
        return sound == null ? def : sound;
    }

    public static void playFor(@NotNull Player player, @Nullable Sound sound) {
        Sounds.playFor(player, sound, 1.0f, 1.0f);
    }

    public static void playFor(@NotNull Player player, @Nullable Sound sound, float volume, float pitch) {
        if (sound == null) {
            return;
        }
        player.playSound(player.getEyeLocation(), sound, SoundCategory.PLAYERS, volume, pitch);
    }
}

