/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.patches.slimefun;

import com.balugaq.jeg.api.patches.JEGGuideSettings;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.events.PlayerLanguageChangeEvent;
import io.github.thebusybiscuit.slimefun4.core.guide.options.SlimefunGuideOption;
import io.github.thebusybiscuit.slimefun4.core.services.localization.Language;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.HeadTexture;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.jetbrains.annotations.NotNull;

public class PlayerLanguageOption
implements SlimefunGuideOption<String> {
    @NotNull
    public SlimefunAddon getAddon() {
        return JustEnoughGuide.getInstance();
    }

    @NotNull
    public NamespacedKey getKey() {
        return Slimefun.getLocalization().getKey();
    }

    public Optional<ItemStack> getDisplayItem(Player p, ItemStack guide) {
        if (Slimefun.getLocalization().isEnabled()) {
            Language language = Slimefun.getLocalization().getLanguage(p);
            String languageName = language.isDefault() ? Slimefun.getLocalization().getMessage(p, "languages.default") + String.valueOf(ChatColor.DARK_GRAY) + " (" + language.getName(p) + ")" : Slimefun.getLocalization().getMessage(p, "languages." + language.getId());
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add("");
            lore.add("&e&o" + Slimefun.getLocalization().getMessage(p, "guide.work-in-progress"));
            lore.add("");
            lore.addAll(Slimefun.getLocalization().getMessages(p, "guide.languages.description", msg -> msg.replace("%contributors%", String.valueOf(Slimefun.getGitHubService().getContributors().size()))));
            lore.add("");
            lore.add("&7\u21e8 &e" + Slimefun.getLocalization().getMessage(p, "guide.languages.change"));
            CustomItemStack item = new CustomItemStack(language.getItem(), "&7" + Slimefun.getLocalization().getMessage(p, "guide.languages.selected-language") + " &a" + languageName, lore.toArray(new String[0]));
            return Optional.of(item);
        }
        return Optional.empty();
    }

    public void onClick(Player p, ItemStack guide) {
        this.openLanguageSelection(p, guide);
    }

    public Optional<String> getSelectedOption(Player p, ItemStack guide) {
        return Optional.of(Slimefun.getLocalization().getLanguage(p).getId());
    }

    public void setSelectedOption(Player p, ItemStack guide, String value) {
        if (value == null) {
            PersistentDataAPI.remove((PersistentDataHolder)p, (NamespacedKey)this.getKey());
        } else {
            PersistentDataAPI.setString((PersistentDataHolder)p, (NamespacedKey)this.getKey(), (String)value);
        }
    }

    private void openLanguageSelection(Player p, ItemStack guide) {
        ChestMenu menu = new ChestMenu(Slimefun.getLocalization().getMessage(p, "guide.title.languages"));
        menu.setEmptySlotsClickable(false);
        SoundEffect var10001 = SoundEffect.GUIDE_LANGUAGE_OPEN_SOUND;
        Objects.requireNonNull(var10001);
        menu.addMenuOpeningHandler(arg_0 -> ((SoundEffect)var10001).playFor(arg_0));
        for (int i2 = 0; i2 < 9; ++i2) {
            if (i2 == 1) {
                menu.addItem(1, ChestMenuUtils.getBackButton((Player)p, (String[])new String[]{"", "&7" + Slimefun.getLocalization().getMessage(p, "guide.back.settings")}), (pl, slotx, item, action) -> {
                    JEGGuideSettings.openSettings(pl, guide);
                    return false;
                });
                continue;
            }
            if (i2 == 7) {
                menu.addItem(7, (ItemStack)new CustomItemStack(SlimefunUtils.getCustomHead((String)HeadTexture.ADD_NEW_LANGUAGE.getTexture()), Slimefun.getLocalization().getMessage(p, "guide.languages.translations.name"), new String[]{"", "&7\u21e8 &e" + Slimefun.getLocalization().getMessage(p, "guide.languages.translations.lore")}), (pl, slotx, item, action) -> {
                    ChatUtils.sendURL((CommandSender)pl, (String)"https://slimefun-wiki.guizhanss.cn/Translating-Slimefun");
                    pl.closeInventory();
                    return false;
                });
                continue;
            }
            menu.addItem(i2, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        Language defaultLanguage = Slimefun.getLocalization().getDefaultLanguage();
        String defaultLanguageString = Slimefun.getLocalization().getMessage(p, "languages.default");
        menu.addItem(9, (ItemStack)new CustomItemStack(defaultLanguage.getItem(), String.valueOf(ChatColor.GRAY) + defaultLanguageString + String.valueOf(ChatColor.DARK_GRAY) + " (" + defaultLanguage.getName(p) + ")", new String[]{"", "&7\u21e8 &e" + Slimefun.getLocalization().getMessage(p, "guide.languages.select-default")}), (pl, i, item, action) -> {
            Slimefun.instance().getServer().getPluginManager().callEvent((Event)new PlayerLanguageChangeEvent(pl, Slimefun.getLocalization().getLanguage(pl), defaultLanguage));
            this.setSelectedOption(pl, guide, null);
            Slimefun.getLocalization().sendMessage((CommandSender)pl, "guide.languages.updated", msg -> msg.replace("%lang%", defaultLanguageString));
            JEGGuideSettings.openSettings(pl, guide);
            return false;
        });
        int slot = 10;
        for (Language language : Slimefun.getLocalization().getLanguages()) {
            menu.addItem(slot, (ItemStack)new CustomItemStack(language.getItem(), String.valueOf(ChatColor.GREEN) + language.getName(p), new String[]{"&b" + language.getTranslationProgress() + "%", "", "&7\u21e8 &e" + Slimefun.getLocalization().getMessage(p, "guide.languages.select")}), (pl, i, item, action) -> {
                Slimefun.instance().getServer().getPluginManager().callEvent((Event)new PlayerLanguageChangeEvent(pl, Slimefun.getLocalization().getLanguage(pl), language));
                this.setSelectedOption(pl, guide, language.getId());
                String name = language.getName(pl);
                Slimefun.getLocalization().sendMessage((CommandSender)pl, "guide.languages.updated", msg -> msg.replace("%lang%", name));
                JEGGuideSettings.openSettings(pl, guide);
                return false;
            });
            ++slot;
        }
        menu.open(new Player[]{p});
    }
}

