/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.patches.slimefun;

import com.balugaq.jeg.api.patches.JEGGuideSettings;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.utils.SlimefunOfficialSupporter;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.core.guide.options.SlimefunGuideOption;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import java.util.List;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class LearningAnimationOption
implements SlimefunGuideOption<Boolean> {
    @NotNull
    public SlimefunAddon getAddon() {
        return JustEnoughGuide.getInstance();
    }

    @NotNull
    public NamespacedKey getKey() {
        return new NamespacedKey((Plugin)Slimefun.instance(), "research_learning_animation");
    }

    @NotNull
    public Optional<ItemStack> getDisplayItem(@NotNull Player p, @NotNull ItemStack guide) {
        if (SlimefunOfficialSupporter.isResearchingEnabled() && !SlimefunOfficialSupporter.isLearningAnimationDisabled()) {
            boolean enabled = this.getSelectedOption(p, guide).orElse(true);
            String optionState = enabled ? "enabled" : "disabled";
            List lore = Slimefun.getLocalization().getMessages(p, "guide.options.learning-animation." + optionState + ".text");
            lore.add("");
            String var10001 = Slimefun.getLocalization().getMessage(p, "guide.options.learning-animation." + optionState + ".click");
            lore.add("&7\u21e8 " + var10001);
            CustomItemStack item = new CustomItemStack(enabled ? Material.MAP : Material.PAPER, lore);
            return Optional.of(item);
        }
        return Optional.empty();
    }

    public void onClick(@NotNull Player p, @NotNull ItemStack guide) {
        this.setSelectedOption(p, guide, this.getSelectedOption(p, guide).orElse(true) == false);
        JEGGuideSettings.openSettings(p, guide);
    }

    public Optional<Boolean> getSelectedOption(@NotNull Player p, @NotNull ItemStack guide) {
        NamespacedKey key = this.getKey();
        boolean value = !PersistentDataAPI.hasByte((PersistentDataHolder)p, (NamespacedKey)key) || PersistentDataAPI.getByte((PersistentDataHolder)p, (NamespacedKey)key) == 1;
        return Optional.of(value);
    }

    public void setSelectedOption(@NotNull Player p, @NotNull ItemStack guide, @NotNull Boolean value) {
        PersistentDataAPI.setByte((PersistentDataHolder)p, (NamespacedKey)this.getKey(), (byte)((byte)(value != false ? 1 : 0)));
    }
}

